/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.util;

import com.selima.framework.exception.BackendException;
import com.selima.framework.exception.ErrorType;
import com.selima.framework.exception.Severity;
import com.selima.framework.util.ArrayUtil;
import com.selima.framework.util.Interval;
import com.selima.framework.util.UniSeps;
import com.selima.framework.util.logging.LogAPI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;

public class Util {
    private static HashMap<Class, Class> boxTypesMap = new HashMap();
    private static final Random random;

    public static int[] sort(int[] numbers) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int number : numbers) {
            set.add(number);
        }
        int[] out = new int[set.size()];
        int i = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int number;
            number = (Integer)iterator.next();
            out[i++] = number;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyFile(File fromFile, String toDir) throws IOException {
        File toFile = new File(toDir + File.separatorChar + fromFile.getName());
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int read;
            fis = new FileInputStream(fromFile);
            fos = new FileOutputStream(toFile);
            byte[] buff = new byte[16384];
            do {
                if ((read = fis.read(buff)) <= 0) continue;
                fos.write(buff, 0, read);
            } while (read > 0);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] read(InputStream is) throws IOException {
        if (is == null) {
            return null;
        }
        try {
            int count;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            byte[] arr = new byte[1024];
            while ((count = is.read(arr)) != -1) {
                os.write(arr, 0, count);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static final byte[] read(File file) throws IOException {
        return Util.read(new FileInputStream(file));
    }

    public static final void deleteRecursively(File file) throws IOException {
        boolean deleted;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                Util.deleteRecursively(child);
            }
        }
        if (!(deleted = file.delete())) {
            throw new IOException("Can not delete the file: " + file.getAbsolutePath());
        }
    }

    public static final void robustDeleteRecursively(File file) throws IOException {
        boolean deleted;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                Util.robustDeleteRecursively(child);
            }
        }
        if (!(deleted = file.delete())) {
            file.deleteOnExit();
        }
    }

    public static final File[] listRecursively(File rootDir, FileFilter filter) throws BackendException {
        ArrayList<File> files = new ArrayList<File>();
        Util.listRecursively(rootDir, filter, files);
        return files.toArray(new File[0]);
    }

    public static final void listRecursively(File rootDir, FileFilter filter, List<File> files) throws BackendException {
        File[] subDirs;
        if (!rootDir.exists()) {
            throw new IllegalArgumentException("The file " + rootDir + " does not exist.");
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("The file " + rootDir + " is not a directory.");
        }
        File[] matchingFiles = rootDir.listFiles(filter);
        files.addAll(Arrays.asList(matchingFiles));
        for (File subDir : subDirs = rootDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) {
            Util.listRecursively(subDir, filter, files);
        }
    }

    public static final File getChild(File dir, String childName) {
        return new File(dir.getAbsolutePath() + File.separator + childName);
    }

    public static final File getChild(String dir, String childName) {
        if (Util.isEmpty(dir)) {
            return new File(childName);
        }
        String separator = dir.endsWith(File.separator) ? "" : File.separator;
        return new File(dir + separator + childName);
    }

    public static final boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static final boolean isEmpty(Object o) {
        return o == null || o.toString().trim().length() == 0;
    }

    public static final Class getBoxClass(Class clazz) {
        if (!clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz.getName() + " is not a primitive type.");
        }
        return boxTypesMap.get(clazz);
    }

    public static final int toInt(Object o) {
        return new Integer(o.toString());
    }

    public static final int toIntNull(Object o) {
        if (Util.isEmpty(o)) {
            return 0;
        }
        return Util.toInt(o);
    }

    public static final void normalizeDate(Calendar calendar) {
        Util.normalizeDate(calendar, false);
    }

    public static final void normalizeDate(Calendar calendar, boolean endOfDay) {
        calendar.set(11, endOfDay ? 23 : 0);
        calendar.set(12, endOfDay ? 59 : 0);
        calendar.set(13, endOfDay ? 59 : 0);
        calendar.set(14, endOfDay ? 999 : 0);
    }

    public static final void normalizeTime(Calendar calendar) {
        calendar.set(1, 0);
        calendar.set(2, 0);
        calendar.set(5, 0);
        calendar.set(14, 0);
    }

    public static final Date normalizeDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Util.normalizeDate(calendar);
        return calendar.getTime();
    }

    public static final Date normalizeTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Util.normalizeTime(calendar);
        return calendar.getTime();
    }

    public static final Date composeDateTime(Date date, Date time) {
        return Util.composeDateTime(date, time, false);
    }

    public static final Date composeDateTime(Date date, Date time, boolean defaultEndOfDay) {
        if (date == null) {
            return null;
        }
        Calendar dateTimeCal = Calendar.getInstance();
        dateTimeCal.setTime(date);
        if (time == null) {
            Util.normalizeDate(dateTimeCal, defaultEndOfDay);
        } else {
            Calendar timeCal = Calendar.getInstance();
            timeCal.setTime(time);
            dateTimeCal.set(11, timeCal.get(11));
            dateTimeCal.set(12, timeCal.get(12));
            dateTimeCal.set(13, timeCal.get(13));
            dateTimeCal.set(14, timeCal.get(14));
        }
        return dateTimeCal.getTime();
    }

    public static final String stackTracesToString(Map<Thread, StackTraceElement[]> stackTraces) {
        if (stackTraces != null) {
            StringBuffer sb = new StringBuffer();
            for (StackTraceElement[] stackTrace : stackTraces.values()) {
                sb.append(Util.stackTraceToString(stackTrace));
                sb.append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    public static final String stackTraceToString(StackTraceElement[] stackTrace) {
        StringBuffer sb = new StringBuffer();
        for (StackTraceElement element : stackTrace) {
            sb.append(element.toString() + "\n");
        }
        return sb.toString();
    }

    public static final boolean isEquivalent(String s1, String s2) {
        return (s1 == null || s1.length() == 0) && (s2 == null || s2.length() == 0) || s1 != null && s1.equals(s2);
    }

    public static final int count(String s, char c) {
        if (s == null) {
            return 0;
        }
        int cnt = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (s.charAt(i) != c) continue;
            ++cnt;
        }
        return cnt;
    }

    public static final BackendException processRemoteException(RemoteException e) throws BackendException {
        Throwable cause = e.getCause();
        if (cause instanceof BackendException) {
            return (BackendException)cause;
        }
        return new BackendException("Remote method invocation failed", Severity.TERMINAL, ErrorType.TECHNICAL, e);
    }

    public static final Integer getIntegerFromProperty(String propertyName, Properties properties, Integer defaultValue) {
        try {
            return new Integer(properties.getProperty(propertyName));
        }
        catch (NumberFormatException e) {
            LogAPI.logWarning(e);
            return defaultValue;
        }
    }

    public static final Boolean getBooleanFromProperty(String propertyName, Properties properties, boolean defaultValue) {
        return new Boolean(properties.getProperty(propertyName));
    }

    public static final int count(String container, String element) {
        int result = ArrayUtil.split(container, element).length - 1;
        if (result == -1) {
            result = 0;
        }
        return result;
    }

    public static final String getAttribute(String dynArray, int attrIndex) {
        return ArrayUtil.split(dynArray, UniSeps.sep0)[attrIndex];
    }

    public static final String[] getAttributeAsArray(String dynArray, int attrIndex) {
        String attribute = ArrayUtil.split(dynArray, UniSeps.sep0)[attrIndex];
        return ArrayUtil.split(attribute, UniSeps.sep1);
    }

    public static final List<Interval> getIntervals(List<Integer> indices) {
        ArrayList<Interval> result = new ArrayList<Interval>();
        Interval interval = null;
        for (int i = 0; i < indices.size(); ++i) {
            int index = indices.get(i);
            if (interval == null) {
                interval = new Interval(index, index);
            } else if (interval.getTo() == index - 1) {
                interval = interval.append(1);
            } else {
                result.add(interval);
                interval = new Interval(index, index);
            }
            if (i != indices.size() - 1) continue;
            result.add(interval);
        }
        return result;
    }

    public static final void write(String s, File f) throws IOException {
        try (FileWriter writer = null;){
            writer = new FileWriter(f);
            writer.write(s);
        }
    }

    public static final void write(InputStream is, File f) throws IOException {
        Util.write(new String(Util.read(is)), f);
    }

    public static Class<?>[] getInterfaces(Object original) {
        HashSet result = new HashSet(4);
        for (Class<?> type = original.getClass(); type != Object.class; type = type.getSuperclass()) {
            result.addAll(Arrays.asList(type.getInterfaces()));
        }
        return result.toArray(new Class[result.size()]);
    }

    public static final <T> ArrayList<T> toArrayList(List<T> list) {
        if (list == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(list);
    }

    public static final String repeat(char c, int count) {
        return Util.repeat(Character.toString(c), count);
    }

    public static final String repeat(String s, int count) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            result.append(s);
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String validateFilenamePart(String filenamePart) {
        if (filenamePart == null || filenamePart.length() == 0) {
            return "Empty string is not allowed";
        }
        File file = null;
        try {
            filenamePart = filenamePart + "xxx";
            file = File.createTempFile(filenamePart, "test");
            String string = null;
            return string;
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (Util.isEmpty(message)) {
                message = e.getClass().getName();
            }
            String string = message;
            return string;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    public static final String generateId(String prefix) {
        return prefix + ":" + Util.generateId();
    }

    public static final String generateId() {
        return System.currentTimeMillis() + ":" + random.nextLong() + ":" + System.nanoTime() + ":" + System.identityHashCode(new Object());
    }

    public static final void makeDir(File dir) throws IOException {
        if (dir.exists() && !dir.isDirectory()) {
            throw new IOException("Can not create directory " + dir.getAbsolutePath() + "\nIt already exists on the filesystem, but it is not a directory.");
        }
        dir.mkdir();
        if (!dir.exists()) {
            throw new IOException("Can not create directory " + dir.getAbsolutePath() + "\nIt may be an invalid file name or the process may have unsufficient permissions.");
        }
    }

    static {
        boxTypesMap.put(Character.TYPE, Character.class);
        boxTypesMap.put(Integer.TYPE, Integer.class);
        boxTypesMap.put(Short.TYPE, Short.class);
        boxTypesMap.put(Long.TYPE, Long.class);
        boxTypesMap.put(Float.TYPE, Float.class);
        boxTypesMap.put(Double.TYPE, Double.class);
        boxTypesMap.put(Boolean.TYPE, Boolean.class);
        random = new Random();
    }
}

