/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.threading;

import com.selima.framework.threading.EventBroadcast;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.Vector;

public class EventBroadcastFactory {
    public static <T> EventBroadcast<T> createEventBroadcast(Class<T> iface) {
        return EventBroadcastFactory.createEventBroadcast(iface, new EventBroadcastHandler());
    }

    public static <T> EventBroadcast<T> createEventBroadcast(Class<T> iface, EventBroadcastHandler<T> handler) {
        ClassLoader alternativeLoader = iface.getClassLoader();
        ClassLoader preferredLoader = handler.getClass().getClassLoader();
        for (ClassLoader l = alternativeLoader; l != null; l = l.getParent()) {
            if (l != preferredLoader) continue;
            preferredLoader = alternativeLoader;
            break;
        }
        EventBroadcast proxy = (EventBroadcast)Proxy.newProxyInstance(preferredLoader, new Class[]{iface, EventBroadcast.class}, handler);
        handler.setProxy(iface.cast(proxy));
        return proxy;
    }

    public static class EventBroadcastHandler<T>
    implements InvocationHandler,
    EventBroadcast<T> {
        private T proxy;
        private boolean checkReentrancy = true;
        private Stack callStack = new Stack();
        private Vector<T> list = new Vector(2);

        void setProxy(T proxy) {
            this.proxy = proxy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            try {
                if (method.getDeclaringClass() == EventBroadcast.class) {
                    result = method.invoke((Object)this, args);
                } else {
                    List copyOfList = (List)this.list.clone();
                    for (int i = 0; i < copyOfList.size(); ++i) {
                        Object listener = copyOfList.get(i);
                        if (this.checkReentrancy) {
                            StackPair newFrame = new StackPair(listener, method);
                            if (this.callStack.contains(newFrame)) {
                                throw new AssertionError((Object)("re-entrancy detected for " + listener + "." + method.getName() + " " + (args == null ? Collections.EMPTY_LIST : Arrays.asList(args))));
                            }
                            this.callStack.push(newFrame);
                            try {
                                result = method.invoke(listener, args);
                                continue;
                            }
                            finally {
                                Object frame = this.callStack.pop();
                                assert (frame == newFrame) : "Multithreaded access forbidden";
                            }
                        }
                        result = method.invoke(listener, args);
                    }
                }
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            return result;
        }

        @Override
        public void setCheckReentrancy(boolean state) {
            this.checkReentrancy = state;
        }

        @Override
        public void removeListener(T listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener is null");
            }
            this.list.remove(listener);
        }

        @Override
        public void removeAllListeners() {
            this.list.clear();
        }

        @Override
        public T[] getListeners(Class<T> type) {
            Object[] result = this.list.toArray((Object[])Array.newInstance(type, this.list.size()));
            return result;
        }

        @Override
        public void addListener(T listener) {
            if (listener == null) {
                throw new IllegalArgumentException("listener is null");
            }
            this.list.add(listener);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public T getListener() {
            return this.proxy;
        }

        private static class StackPair {
            private Object listener;
            private Method method;

            StackPair(Object listener, Method method) {
                this.listener = listener;
                this.method = method;
            }

            public int hashCode() {
                assert (false) : "Incorrect usage";
                return this.method.hashCode();
            }

            public boolean equals(Object o) {
                assert (o instanceof StackPair) : "Incorrect usage";
                StackPair other = (StackPair)o;
                return other.listener == this.listener && other.method.equals(this.method);
            }
        }
    }
}

