/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.threading;

import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.BatchCancelOperationHandle;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.SwingOperationHandle;
import java.util.ArrayList;
import java.util.List;

public class BatchCancelSubmitter
implements ISubmitter {
    private ISubmitter delegate;
    private List<BatchCancelOperationHandle> startedWorks;

    public BatchCancelSubmitter(ISubmitter delegate) {
        this.delegate = delegate;
        this.startedWorks = new ArrayList<BatchCancelOperationHandle>();
    }

    @Override
    public synchronized SwingOperationHandle submitWork(BackendWork work) {
        SwingOperationHandle handle = this.delegate.submitWork(work);
        BatchCancelOperationHandle wrappedHandle = new BatchCancelOperationHandle(handle, this);
        this.startedWorks.add(wrappedHandle);
        return wrappedHandle;
    }

    public synchronized void cancelAll() {
        for (BatchCancelOperationHandle handle : this.startedWorks) {
            if (handle.isFinished()) continue;
            handle.doCancel();
        }
    }
}

