/*
 * Decompiled with CFR 0.152.
 */
package com.selima.framework.exception;

import com.selima.framework.exception.ErrorType;
import com.selima.framework.exception.Severity;
import com.selima.framework.util.Path;
import com.selima.framework.util.Util;

public class ErrorItem {
    private String shortMessage;
    private String message;
    private Severity severity;
    private ErrorType errorType;
    private String propertyId;
    private Path path;

    public ErrorItem(String message, Severity severity, ErrorType errorType) {
        this(message, message, severity, errorType);
    }

    public ErrorItem(String shortMessage, String message, Severity severity, ErrorType errorType) {
        this(shortMessage, message, severity, errorType, null, null);
    }

    public ErrorItem(String message, Severity severity, ErrorType errorType, String propertyId, Path path) {
        this(message, message, severity, errorType, propertyId, path);
    }

    public ErrorItem(String shortMessage, String message, Severity severity, ErrorType errorType, String propertyId, Path path) {
        if (Util.isEmpty(shortMessage)) {
            shortMessage = message;
        }
        this.shortMessage = shortMessage;
        this.message = message;
        if (severity == null) {
            severity = Severity.TERMINAL;
        }
        this.severity = severity;
        if (errorType == null) {
            errorType = ErrorType.TECHNICAL;
        }
        this.errorType = errorType;
        this.propertyId = propertyId;
        this.path = path;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public String getMessage() {
        return this.message;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public ErrorType getType() {
        return this.errorType;
    }

    public boolean isBusinessRuleError() {
        return this.errorType == ErrorType.BUSINESS_RULE;
    }

    public boolean isConcurrencyError() {
        return this.errorType == ErrorType.CONCURRENCY;
    }

    public boolean isDataTypeError() {
        return this.errorType == ErrorType.DATA_TYPE;
    }

    public boolean isListOperationError() {
        return this.errorType == ErrorType.LIST_OPERATION;
    }

    public boolean isTechnicalError() {
        return this.errorType == ErrorType.TECHNICAL;
    }

    public boolean isSecurityError() {
        return this.errorType == ErrorType.SECURITY;
    }

    public boolean isAlert() {
        return this.severity == Severity.ALERT;
    }

    public boolean isRejection() {
        return this.severity == Severity.REJECTION;
    }

    public boolean isTerminal() {
        return this.severity == Severity.TERMINAL;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.message + ", " + (Object)((Object)this.severity) + ", " + (Object)((Object)this.errorType) + ", " + this.propertyId + ", " + this.path + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof ErrorItem)) {
            return false;
        }
        ErrorItem other = (ErrorItem)o;
        return Util.equals(this.message, other.message) && this.severity == other.severity && this.errorType == this.errorType && Util.equals(this.propertyId, other.propertyId) && Util.equals(this.path, other.path);
    }

    public int hashCode() {
        return this.message == null ? 0 : this.message.hashCode();
    }
}

