/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.encryption.CipherData;
import org.apache.xml.security.encryption.CipherReference;
import org.apache.xml.security.encryption.EncryptedType;
import org.apache.xml.security.encryption.Transforms;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;

public class XMLCipherInput {
    private static Log logger = LogFactory.getLog((String)(class$org$apache$xml$security$encryption$XMLCipher == null ? (class$org$apache$xml$security$encryption$XMLCipher = XMLCipherInput.class$("org.apache.xml.security.encryption.XMLCipher")) : class$org$apache$xml$security$encryption$XMLCipher).getName());
    private CipherData _cipherData;
    private int _mode;
    static /* synthetic */ Class class$org$apache$xml$security$encryption$XMLCipher;

    public XMLCipherInput(CipherData data) throws XMLEncryptionException {
        this._cipherData = data;
        this._mode = 2;
        if (this._cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public XMLCipherInput(EncryptedType input) throws XMLEncryptionException {
        this._cipherData = input == null ? null : input.getCipherData();
        this._mode = 2;
        if (this._cipherData == null) {
            throw new XMLEncryptionException("CipherData is null");
        }
    }

    public byte[] getBytes() throws XMLEncryptionException {
        if (this._mode == 2) {
            return this.getDecryptBytes();
        }
        return null;
    }

    private byte[] getDecryptBytes() throws XMLEncryptionException {
        String base64EncodedEncryptedOctets = null;
        if (this._cipherData.getDataType() == 2) {
            logger.debug((Object)"Found a reference type CipherData");
            CipherReference cr = this._cipherData.getCipherReference();
            Attr uriAttr = cr.getURIAsAttr();
            XMLSignatureInput input = null;
            try {
                ResourceResolver resolver = ResourceResolver.getInstance(uriAttr, null);
                input = resolver.resolve(uriAttr, null);
            }
            catch (ResourceResolverException ex) {
                throw new XMLEncryptionException("empty", ex);
            }
            if (input != null) {
                logger.debug((Object)("Managed to resolve URI \"" + cr.getURI() + "\""));
            } else {
                logger.debug((Object)("Failed to resolve URI \"" + cr.getURI() + "\""));
            }
            Transforms transforms = cr.getTransforms();
            if (transforms != null) {
                logger.debug((Object)"Have transforms in cipher reference");
                try {
                    org.apache.xml.security.transforms.Transforms dsTransforms = transforms.getDSTransforms();
                    input = dsTransforms.performTransforms(input);
                }
                catch (TransformationException ex) {
                    throw new XMLEncryptionException("empty", ex);
                }
            }
            try {
                return input.getBytes();
            }
            catch (IOException ex) {
                throw new XMLEncryptionException("empty", ex);
            }
            catch (CanonicalizationException ex) {
                throw new XMLEncryptionException("empty", ex);
            }
        }
        if (this._cipherData.getDataType() != 1) {
            throw new XMLEncryptionException("CipherData.getDataType() returned unexpected value");
        }
        base64EncodedEncryptedOctets = this._cipherData.getCipherValue().getValue();
        logger.debug((Object)("Encrypted octets:\n" + base64EncodedEncryptedOctets));
        byte[] encryptedBytes = null;
        try {
            encryptedBytes = Base64.decode(base64EncodedEncryptedOctets);
        }
        catch (Base64DecodingException bde) {
            throw new XMLEncryptionException("empty", bde);
        }
        return encryptedBytes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

