/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms;

import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.Algorithm;
import org.apache.xml.security.algorithms.SignatureAlgorithmSpi;
import org.apache.xml.security.algorithms.implementations.IntegrityHmac;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithm
extends Algorithm {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$algorithms$SignatureAlgorithm == null ? (class$org$apache$xml$security$algorithms$SignatureAlgorithm = SignatureAlgorithm.class$("org.apache.xml.security.algorithms.SignatureAlgorithm")) : class$org$apache$xml$security$algorithms$SignatureAlgorithm).getName());
    static boolean _alreadyInitialized = false;
    static HashMap _algorithmHash = null;
    static ThreadLocal instancesSigning = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static ThreadLocal instancesVerify = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static ThreadLocal keysSigning = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    static ThreadLocal keysVerify = new ThreadLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };
    protected SignatureAlgorithmSpi _signatureAlgorithm = null;
    private String algorithmURI;
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$SignatureAlgorithm;

    public SignatureAlgorithm(Document doc, String algorithmURI) throws XMLSecurityException {
        super(doc, algorithmURI);
        this.algorithmURI = algorithmURI;
    }

    private void initializeAlgorithm(boolean isForSigning) throws XMLSignatureException {
        if (this._signatureAlgorithm != null) {
            return;
        }
        this._signatureAlgorithm = isForSigning ? SignatureAlgorithm.getInstanceForSigning(this.algorithmURI) : SignatureAlgorithm.getInstanceForVerify(this.algorithmURI);
        this._signatureAlgorithm.engineGetContextFromElement(this._constructionElement);
    }

    private static SignatureAlgorithmSpi getInstanceForSigning(String algorithmURI) throws XMLSignatureException {
        SignatureAlgorithmSpi result = (SignatureAlgorithmSpi)((Map)instancesSigning.get()).get(algorithmURI);
        if (result != null) {
            result.reset();
            return result;
        }
        result = SignatureAlgorithm.buildSigner(algorithmURI, result);
        ((Map)instancesSigning.get()).put(algorithmURI, result);
        return result;
    }

    private static SignatureAlgorithmSpi getInstanceForVerify(String algorithmURI) throws XMLSignatureException {
        SignatureAlgorithmSpi result = (SignatureAlgorithmSpi)((Map)instancesVerify.get()).get(algorithmURI);
        if (result != null) {
            result.reset();
            return result;
        }
        result = SignatureAlgorithm.buildSigner(algorithmURI, result);
        ((Map)instancesVerify.get()).put(algorithmURI, result);
        return result;
    }

    private static SignatureAlgorithmSpi buildSigner(String algorithmURI, SignatureAlgorithmSpi result) throws XMLSignatureException {
        try {
            Class implementingClass = SignatureAlgorithm.getImplementingClass(algorithmURI);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create URI \"" + algorithmURI + "\" class \"" + implementingClass + "\""));
            }
            result = (SignatureAlgorithmSpi)implementingClass.newInstance();
            return result;
        }
        catch (IllegalAccessException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (InstantiationException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (NullPointerException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ((Throwable)ex).getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
    }

    public SignatureAlgorithm(Document doc, String algorithmURI, int HMACOutputLength) throws XMLSecurityException {
        this(doc, algorithmURI);
        this.algorithmURI = algorithmURI;
        this.initializeAlgorithm(true);
        this._signatureAlgorithm.engineSetHMACOutputLength(HMACOutputLength);
        ((IntegrityHmac)this._signatureAlgorithm).engineAddContextToElement(this._constructionElement);
    }

    public SignatureAlgorithm(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
        this.algorithmURI = this.getURI();
    }

    public byte[] sign() throws XMLSignatureException {
        return this._signatureAlgorithm.engineSign();
    }

    public String getJCEAlgorithmString() {
        try {
            return SignatureAlgorithm.getInstanceForVerify(this.algorithmURI).engineGetJCEAlgorithmString();
        }
        catch (XMLSignatureException e) {
            return null;
        }
    }

    public String getJCEProviderName() {
        try {
            return SignatureAlgorithm.getInstanceForVerify(this.algorithmURI).engineGetJCEProviderName();
        }
        catch (XMLSignatureException e) {
            return null;
        }
    }

    public void update(byte[] input) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(input);
    }

    public void update(byte input) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(input);
    }

    public void update(byte[] buf, int offset, int len) throws XMLSignatureException {
        this._signatureAlgorithm.engineUpdate(buf, offset, len);
    }

    public void initSign(Key signingKey) throws XMLSignatureException {
        this.initializeAlgorithm(true);
        Map map = (Map)keysSigning.get();
        if (map.get(this.algorithmURI) == signingKey) {
            return;
        }
        map.put(this.algorithmURI, signingKey);
        this._signatureAlgorithm.engineInitSign(signingKey);
    }

    public void initSign(Key signingKey, SecureRandom secureRandom) throws XMLSignatureException {
        this.initializeAlgorithm(true);
        this._signatureAlgorithm.engineInitSign(signingKey, secureRandom);
    }

    public void initSign(Key signingKey, AlgorithmParameterSpec algorithmParameterSpec) throws XMLSignatureException {
        this.initializeAlgorithm(true);
        this._signatureAlgorithm.engineInitSign(signingKey, algorithmParameterSpec);
    }

    public void setParameter(AlgorithmParameterSpec params) throws XMLSignatureException {
        this._signatureAlgorithm.engineSetParameter(params);
    }

    public void initVerify(Key verificationKey) throws XMLSignatureException {
        this.initializeAlgorithm(false);
        Map map = (Map)keysVerify.get();
        if (map.get(this.algorithmURI) == verificationKey) {
            return;
        }
        map.put(this.algorithmURI, verificationKey);
        this._signatureAlgorithm.engineInitVerify(verificationKey);
    }

    public boolean verify(byte[] signature) throws XMLSignatureException {
        return this._signatureAlgorithm.engineVerify(signature);
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public static void providerInit() {
        if (log == null) {
            log = LogFactory.getLog((String)(class$org$apache$xml$security$algorithms$SignatureAlgorithm == null ? (class$org$apache$xml$security$algorithms$SignatureAlgorithm = SignatureAlgorithm.class$("org.apache.xml.security.algorithms.SignatureAlgorithm")) : class$org$apache$xml$security$algorithms$SignatureAlgorithm).getName());
        }
        log.debug((Object)"Init() called");
        if (!_alreadyInitialized) {
            _algorithmHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String algorithmURI, String implementingClass) throws AlgorithmAlreadyRegisteredException, XMLSignatureException {
        String registeredClass;
        Class registeredClassClass;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Try to register " + algorithmURI + " " + implementingClass));
        }
        if ((registeredClassClass = SignatureAlgorithm.getImplementingClass(algorithmURI)) != null && (registeredClass = registeredClassClass.getName()) != null && registeredClass.length() != 0) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        try {
            _algorithmHash.put(algorithmURI, Class.forName(implementingClass));
        }
        catch (ClassNotFoundException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ex.getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
        catch (NullPointerException ex) {
            Object[] exArgs = new Object[]{algorithmURI, ((Throwable)ex).getMessage()};
            throw new XMLSignatureException("algorithms.NoSuchAlgorithm", exArgs, ex);
        }
    }

    private static Class getImplementingClass(String URI2) {
        if (_algorithmHash == null) {
            return null;
        }
        return (Class)_algorithmHash.get(URI2);
    }

    public String getBaseNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getBaseLocalName() {
        return "SignatureMethod";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

