/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class JCEMapper {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$algorithms$JCEMapper == null ? (class$org$apache$xml$security$algorithms$JCEMapper = JCEMapper.class$("org.apache.xml.security.algorithms.JCEMapper")) : class$org$apache$xml$security$algorithms$JCEMapper).getName());
    private static Map uriToJCEName;
    private static Map algorithmsMap;
    private static String providerName;
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$JCEMapper;

    public static void init(Element mappingElement) throws Exception {
        JCEMapper.loadAlgorithms((Element)mappingElement.getElementsByTagName("Algorithms").item(0));
    }

    static void loadAlgorithms(Element algorithmsEl) {
        Element[] algorithms = XMLUtils.selectNodes(algorithmsEl.getFirstChild(), "http://www.xmlsecurity.org/NS/#configuration", "Algorithm");
        uriToJCEName = new HashMap(algorithms.length * 2);
        algorithmsMap = new HashMap(algorithms.length * 2);
        for (int i = 0; i < algorithms.length; ++i) {
            Element el = algorithms[i];
            String id = el.getAttribute("URI");
            String jceName = el.getAttribute("JCEName");
            uriToJCEName.put(id, jceName);
            algorithmsMap.put(id, new Algorithm(el));
        }
    }

    static Algorithm getAlgorithmMapping(String algoURI) {
        return (Algorithm)algorithmsMap.get(algoURI);
    }

    public static String translateURItoJCEID(String AlgorithmURI) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request for URI " + AlgorithmURI));
        }
        String jceName = (String)uriToJCEName.get(AlgorithmURI);
        return jceName;
    }

    public static String getAlgorithmClassFromURI(String AlgorithmURI) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Request for URI " + AlgorithmURI));
        }
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)AlgorithmURI)).algorithmClass;
    }

    public static int getKeyLengthFromURI(String AlgorithmURI) {
        return Integer.parseInt(((Algorithm)JCEMapper.algorithmsMap.get((Object)AlgorithmURI)).keyLength);
    }

    public static String getJCEKeyAlgorithmFromURI(String AlgorithmURI) {
        return ((Algorithm)JCEMapper.algorithmsMap.get((Object)AlgorithmURI)).requiredKey;
    }

    public static String getProviderId() {
        return providerName;
    }

    public static void setProviderId(String provider) {
        providerName = provider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        providerName = null;
    }

    public static class Algorithm {
        String algorithmClass;
        String keyLength;
        String requiredKey;

        public Algorithm(Element el) {
            this.algorithmClass = el.getAttribute("AlgorithmClass");
            this.keyLength = el.getAttribute("KeyLength");
            this.requiredKey = el.getAttribute("RequiredKey");
        }
    }
}

