/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.provider;

import java.security.SecureRandom;
import org.apache.commons.codec.binary.Hex;
import org.opensaml.SAMLException;
import org.opensaml.SAMLIdentifier;

public class SecureRandomIDProvider
implements SAMLIdentifier {
    private static SecureRandom random = new SecureRandom();

    public synchronized String getIdentifier() throws SAMLException {
        byte[] buf = new byte[16];
        random.nextBytes(buf);
        return "_".concat(new String(Hex.encodeHex((byte[])buf)));
    }

    public byte[] generateRandomBytes(SecureRandom random, int n) {
        byte[] bytes = new byte[n];
        random.nextBytes(bytes);
        return bytes;
    }

    public synchronized byte[] generateRandomBytes(int n) {
        return this.generateRandomBytes(random, n);
    }
}

