/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.provider;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.opensaml.ReplayCache;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.w3c.dom.Element;

public class MemoryReplayCacheProvider
implements ReplayCache {
    private TreeMap replayExpMap = new TreeMap();
    private HashSet replayCache = new HashSet();
    private int skew = 1000 * SAMLConfig.instance().getIntProperty("org.opensaml.clock-skew");

    public MemoryReplayCacheProvider(Element e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean check(String key, Date expires) throws SAMLException {
        MemoryReplayCacheProvider memoryReplayCacheProvider = this;
        synchronized (memoryReplayCacheProvider) {
            Set<Long> trash = this.replayExpMap.headMap(new Long(expires.getTime() - (long)this.skew)).keySet();
            Iterator<Long> i = trash.iterator();
            while (i.hasNext()) {
                this.replayCache.remove(this.replayExpMap.get(i.next()));
            }
            trash.clear();
            if (!this.replayCache.add(key)) {
                return false;
            }
            long stamp = expires.getTime() + (long)this.skew;
            while (this.replayExpMap.containsKey(new Long(stamp))) {
                ++stamp;
            }
            this.replayExpMap.put(new Long(stamp), key);
            return true;
        }
    }
}

