/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.artifact;

import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.opensaml.SAMLConfig;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParseException;
import org.opensaml.artifact.SAMLArtifact;
import org.opensaml.artifact.URI;
import org.opensaml.artifact.Util;

public class SAMLArtifactType0002
extends SAMLArtifact {
    public static final Artifact.TypeCode TYPE_CODE = new SAMLArtifact.TypeCode(0, 2);

    public SAMLArtifactType0002(URI sourceLocation) {
        SAMLArtifactType0002.checkNullArg(sourceLocation);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = new RemainingArtifact(sourceLocation);
    }

    public SAMLArtifactType0002(byte[] assertionHandle, URI sourceLocation) {
        SAMLArtifactType0002.checkHandleArg(assertionHandle);
        SAMLArtifactType0002.checkNullArg(sourceLocation);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = new RemainingArtifact(assertionHandle, sourceLocation);
    }

    public SAMLArtifactType0002(Artifact.RemainingArtifact remainingArtifact) {
        SAMLArtifactType0002.checkNullArg(remainingArtifact);
        this.typeCode = TYPE_CODE;
        this.remainingArtifact = remainingArtifact;
    }

    public byte[] getAssertionHandle() {
        return ((RemainingArtifact)this.remainingArtifact).getAssertionHandle();
    }

    public URI getSourceLocation() {
        return ((RemainingArtifact)this.remainingArtifact).getSourceLocation();
    }

    public static final class Parser
    implements Artifact.Parser {
        public Artifact parse(String s) throws ArtifactParseException {
            URI uri;
            int minLength;
            byte[] bytes = Base64.decodeBase64((byte[])s.getBytes());
            if (bytes.length < (minLength = 22)) {
                throw new ArtifactParseException(bytes.length, minLength);
            }
            SAMLArtifact.TypeCode typeCode = new SAMLArtifact.TypeCode(bytes[0], bytes[1]);
            if (!typeCode.equals(TYPE_CODE)) {
                throw new ArtifactParseException(typeCode, TYPE_CODE);
            }
            byte[] assertionHandle = new byte[20];
            System.arraycopy(bytes, 2, assertionHandle, 0, 20);
            int length = bytes.length - minLength;
            byte[] remainingBytes = new byte[length];
            System.arraycopy(bytes, minLength, remainingBytes, 0, length);
            try {
                uri = new URI(remainingBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ArtifactParseException("UTF-8 unsupported string format, can not create artifact URI");
            }
            return new SAMLArtifactType0002(assertionHandle, uri);
        }
    }

    public static final class RemainingArtifact
    extends SAMLArtifact.RemainingArtifact {
        private byte[] assertionHandle;
        private URI sourceLocation;
        private byte[] sourceLocationBytes;

        public RemainingArtifact(URI sourceLocation) {
            byte[] assertionHandle = SAMLConfig.instance().getDefaultIDProvider().generateRandomBytes(20);
            RemainingArtifact ra = new RemainingArtifact(assertionHandle, sourceLocation);
            this.assertionHandle = ra.assertionHandle;
            this.sourceLocation = ra.sourceLocation;
            this.sourceLocationBytes = ra.sourceLocationBytes;
        }

        public RemainingArtifact(byte[] assertionHandle, URI sourceLocation) {
            SAMLArtifact.checkHandleArg(assertionHandle);
            SAMLArtifact.checkNullArg(sourceLocation);
            this.assertionHandle = assertionHandle;
            this.sourceLocation = sourceLocation;
            this.sourceLocationBytes = sourceLocation.toBytes();
        }

        public byte[] getAssertionHandle() {
            return this.assertionHandle;
        }

        public URI getSourceLocation() {
            return this.sourceLocation;
        }

        public int size() {
            return this.assertionHandle.length + this.sourceLocationBytes.length;
        }

        public byte[] getBytes() {
            byte[] bytes0 = this.assertionHandle;
            byte[] bytes1 = this.sourceLocationBytes;
            return Util.concat(bytes0, bytes1);
        }

        public int hashCode() {
            return this.assertionHandle.hashCode() & this.sourceLocationBytes.hashCode();
        }
    }
}

