/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.opensaml.BindingException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSOAPBinding;
import org.opensaml.SOAPException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class SOAPBinding
implements SAMLSOAPBinding {
    private static SAMLConfig config = SAMLConfig.instance();
    private Logger log = Logger.getLogger((String)SOAPBinding.class.getName());
    private Map soapHooks = Collections.synchronizedMap(new HashMap(4));

    public void addHook(SAMLSOAPBinding.SOAPHook h) {
        this.addHook(h, null);
    }

    public void addHook(SAMLSOAPBinding.SOAPHook h, Object globalCtx) {
        this.soapHooks.put(h, globalCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element sendRequest(SAMLRequest request, Object callCtx) throws SAMLException {
        NDC.push((String)"sendRequest");
        try {
            Document doc = request.toDOM().getOwnerDocument();
            Element e = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Envelope");
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.xmlsoap.org/soap/envelope/");
            Element body = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            e.appendChild(body);
            body.appendChild(request.toDOM());
            if (doc.getDocumentElement() == null) {
                doc.appendChild(e);
            } else {
                doc.replaceChild(e, doc.getDocumentElement());
            }
            Iterator hooks = this.soapHooks.entrySet().iterator();
            while (hooks.hasNext()) {
                Map.Entry h = hooks.next();
                if (((SAMLSOAPBinding.SOAPHook)h.getKey()).outgoing(e, h.getValue(), callCtx)) continue;
                body.removeChild(request.toDOM());
                this.log.warn((Object)"SOAP processing hook returned false, aborting outgoing request");
                throw new BindingException(SAMLException.REQUESTER, "SOAPBinding.sendRequest() SOAP processing hook returned false, aborted outgoing request");
            }
            Element element = e;
            return element;
        }
        finally {
            NDC.pop();
        }
    }

    public SAMLResponse recvResponse(Element envelope, Object callCtx) throws SAMLException {
        NDC.push((String)"recvResponse");
        try {
            if (!XML.isElementNamed(envelope, "http://schemas.xmlsoap.org/soap/envelope/", "Envelope")) {
                throw new BindingException("SOAPBinding.recvResponse() detected an incompatible or missing SOAP envelope");
            }
            Iterator hooks = this.soapHooks.entrySet().iterator();
            while (hooks.hasNext()) {
                Map.Entry h = hooks.next();
                if (((SAMLSOAPBinding.SOAPHook)h.getKey()).incoming(envelope, h.getValue(), callCtx)) continue;
                this.log.warn((Object)"SOAP processing hook returned false, aborting incoming response");
                throw new BindingException(SAMLException.REQUESTER, "SOAPBinding.recvResponse() SOAP processing hook returned false, aborted incoming response");
            }
            Element n = XML.getFirstChildElement(envelope);
            if (XML.isElementNamed(n, "http://schemas.xmlsoap.org/soap/envelope/", "Header")) {
                if (this.soapHooks.isEmpty()) {
                    Element header = XML.getFirstChildElement(n);
                    while (header != null) {
                        if (header.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand") != null && header.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand").equals("1")) {
                            throw new SOAPException(SOAPException.MUSTUNDERSTAND, "SOAPBinding.recvResponse() detected a mandatory SOAP header");
                        }
                        header = XML.getNextSiblingElement(header);
                    }
                }
                n = XML.getNextSiblingElement(n);
            }
            if (n != null && (n = XML.getFirstChildElement(n)) != null) {
                if (XML.isElementNamed(n, "http://schemas.xmlsoap.org/soap/envelope/", "Fault")) {
                    NodeList nlist = n.getElementsByTagNameNS(null, "faultstring");
                    String msg = nlist != null && nlist.getLength() > 0 ? nlist.item(0).getFirstChild().getNodeValue() : "SAMLSOAPBinding.recvResponse() detected a SOAP fault";
                    nlist = n.getElementsByTagNameNS(null, "faultstring");
                    if (nlist != null && nlist.getLength() > 0) {
                        throw new SOAPException(XML.getQNameTextNode((Text)nlist.item(0).getFirstChild()), msg);
                    }
                    throw new SOAPException(SOAPException.SERVER, msg);
                }
                SAMLResponse sAMLResponse = new SAMLResponse(n);
                return sAMLResponse;
            }
            throw new SOAPException(SOAPException.SERVER, "SOAPBinding.recvResponse() unable to find a SAML response or fault in SOAP body");
        }
        finally {
            NDC.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAMLRequest recvRequest(Element envelope, Object callCtx) throws SAMLException {
        NDC.push((String)"recvRequest");
        try {
            if (!XML.isElementNamed(envelope, "http://schemas.xmlsoap.org/soap/envelope/", "Envelope")) {
                throw new SOAPException(SOAPException.VERSION, "SOAPBinding.recvRequest() detected an incompatible or missing SOAP envelope");
            }
            Iterator hooks = this.soapHooks.entrySet().iterator();
            while (hooks.hasNext()) {
                Map.Entry h = hooks.next();
                if (((SAMLSOAPBinding.SOAPHook)h.getKey()).incoming(envelope, h.getValue(), callCtx)) continue;
                this.log.warn((Object)"SOAP processing hook returned false, aborting incoming request");
                throw new BindingException(SAMLException.REQUESTER, "SOAPBinding.recvRequest() SOAP processing hook returned false, aborted incoming request");
            }
            Element child = XML.getFirstChildElement(envelope);
            if (XML.isElementNamed(child, "http://schemas.xmlsoap.org/soap/envelope/", "Header")) {
                if (this.soapHooks.isEmpty()) {
                    Element header = XML.getFirstChildElement(child);
                    while (header != null) {
                        if (header.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand").equals("1")) {
                            throw new SOAPException(SOAPException.MUSTUNDERSTAND, "SOAPBinding.recvRequest() detected a mandatory SOAP header");
                        }
                        header = XML.getNextSiblingElement(header);
                    }
                }
                child = XML.getNextSiblingElement(child);
            }
            if (child != null) {
                child = XML.getFirstChildElement(child);
            }
            SAMLRequest sAMLRequest = new SAMLRequest(child);
            return sAMLRequest;
        }
        finally {
            NDC.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element sendResponse(SAMLResponse response, SAMLException e, Object callCtx) throws SAMLException {
        NDC.push((String)"sendResponse");
        try {
            Document doc = e == null ? response.toDOM().getOwnerDocument() : XML.parserPool.newDocument();
            Element env = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Envelope");
            env.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:soap", "http://schemas.xmlsoap.org/soap/envelope/");
            env.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            env.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (doc.getDocumentElement() == null) {
                doc.appendChild(env);
            } else {
                doc.replaceChild(env, doc.getDocumentElement());
            }
            Element body = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Body");
            env.appendChild(body);
            if (e != null) {
                Element fault = doc.createElementNS("http://schemas.xmlsoap.org/soap/envelope/", "soap:Fault");
                body.appendChild(fault);
                Element elem = doc.createElementNS(null, "faultcode");
                if (e instanceof SOAPException) {
                    Iterator codes = e.getCodes();
                    if (codes.hasNext()) {
                        elem.appendChild(doc.createTextNode("soap:" + ((QName)codes.next()).getLocalPart()));
                    } else {
                        elem.appendChild(doc.createTextNode("soap:" + SOAPException.SERVER.getLocalPart()));
                    }
                } else {
                    elem.appendChild(doc.createTextNode("soap:" + SOAPException.SERVER.getLocalPart()));
                }
                fault.appendChild(elem);
                elem = doc.createElementNS(null, "faultstring");
                fault.appendChild(elem).appendChild(doc.createTextNode(e.getMessage()));
            } else {
                body.appendChild(response.toDOM());
            }
            Iterator hooks = this.soapHooks.entrySet().iterator();
            while (hooks.hasNext()) {
                Map.Entry h = hooks.next();
                if (((SAMLSOAPBinding.SOAPHook)h.getKey()).outgoing(env, h.getValue(), callCtx)) continue;
                body.removeChild(response.toDOM());
                this.log.warn((Object)"SOAP processing hook returned false, aborting outgoing response");
                throw new BindingException("SOAPBinding.sendResponse() SOAP processing hook returned false, aborted outgoing response");
            }
            Element element = env;
            return element;
        }
        finally {
            NDC.pop();
        }
    }
}

