/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.opensaml.InvalidCryptoException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class SAMLSignedObject
extends SAMLObject
implements Cloneable {
    private XMLSignature sig = null;
    private boolean sig_from_parse = false;

    public Object getNativeSignature() {
        return this.sig;
    }

    public abstract String getId();

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        Element n = XML.getFirstChildElement(e, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (n != null) {
            try {
                this.sig = new XMLSignature(n, "");
                this.sig_from_parse = true;
            }
            catch (XMLSecurityException ex) {
                throw new InvalidCryptoException("SAMLSignedObject.fromDOM() detected an XML security exception: " + ex.getMessage(), (Exception)((Object)ex));
            }
        }
    }

    public Node toDOM(boolean xmlns) throws SAMLException {
        if (this.root == null && this.sig != null) {
            return this.toDOM(this.sig.getDocument(), xmlns);
        }
        return super.toDOM(xmlns);
    }

    protected abstract void insertSignature() throws SAMLException;

    protected Element getSignatureElement() {
        return this.sig != null ? this.sig.getElement() : null;
    }

    protected void setDirty(boolean flag) {
        if (flag) {
            this.unsign();
        }
        super.setDirty(flag);
    }

    public void unsign() {
        if (this.sig != null && this.sig.getElement().getParentNode() != null) {
            this.sig.getElement().getParentNode().removeChild(this.sig.getElement());
        }
        this.sig = null;
    }

    public void sign(String sigalg, Key k, Collection certs) throws SAMLException {
        this.sign(sigalg, null, k, certs);
    }

    public void sign(String sigalg, String digalg, Key k, Collection certs) throws SAMLException {
        this.unsign();
        this.toDOM();
        this.plantRoot();
        try {
            this.sig = new XMLSignature(this.root.getOwnerDocument(), "", sigalg, "http://www.w3.org/2001/10/xml-exc-c14n#");
            this.insertSignature();
            Transforms transforms = new Transforms(this.sig.getDocument());
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            transforms.item(1).getElement().appendChild(new InclusiveNamespaces(this.root.getOwnerDocument(), this.config.getProperty("org.opensaml.inclusive-namespace-prefixes")).getElement());
            if (this.config.getBooleanProperty("org.opensaml.compatibility-mode")) {
                this.sig.addDocument("", transforms, digalg != null ? digalg : "http://www.w3.org/2000/09/xmldsig#sha1");
            } else {
                this.sig.addDocument("#" + this.getId(), transforms, digalg != null ? digalg : "http://www.w3.org/2000/09/xmldsig#sha1");
            }
            X509Data x509 = new X509Data(this.root.getOwnerDocument());
            if (certs != null) {
                int count = 0;
                Iterator i = certs.iterator();
                while (i.hasNext()) {
                    Object cert = i.next();
                    if (cert instanceof X509Certificate) {
                        if (!i.hasNext() && count > 0 && ((Object)((X509Certificate)cert).getSubjectDN()).equals(((X509Certificate)cert).getIssuerDN())) break;
                        x509.addCertificate((X509Certificate)cert);
                    }
                    ++count;
                }
            }
            if (x509.lengthCertificate() > 0) {
                KeyInfo keyinfo = new KeyInfo(this.root.getOwnerDocument());
                keyinfo.add(x509);
                this.sig.getElement().appendChild(keyinfo.getElement());
            }
            this.sig.sign(k);
        }
        catch (XMLSecurityException e) {
            this.unsign();
            throw new InvalidCryptoException("SAMLSignedObject.sign() detected an XML security exception: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public void verify() throws SAMLException {
        this.verify((Key)null);
    }

    public void verify(Certificate cert) throws SAMLException {
        this.verify(cert.getPublicKey());
    }

    public void verify(Key k) throws SAMLException {
        if (!this.isSigned()) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() can't verify unsigned object");
        }
        try {
            Reference ref;
            boolean valid = false;
            SignedInfo si = this.sig.getSignedInfo();
            if (si.getLength() == 1 && ((ref = si.item(0)).getURI() == null || ref.getURI().equals("") || ref.getURI().equals("#" + this.getId()))) {
                Transforms trans = ref.getTransforms();
                for (int i = 0; i < trans.getLength(); ++i) {
                    if (trans.item(i).getURI().equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
                        valid = true;
                        continue;
                    }
                    if (trans.item(i).getURI().equals("http://www.w3.org/2001/10/xml-exc-c14n#")) continue;
                    valid = false;
                    break;
                }
            }
            if (!valid) {
                throw new InvalidCryptoException("SAMLSignedObject.verify() detected an invalid signature profile");
            }
            if (k == null) {
                if (this.sig_from_parse) {
                    k = this.sig.getKeyInfo().getPublicKey();
                } else {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Canonicalizer c = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                    out.write(c.canonicalizeSubtree(this.sig.getElement().getLastChild()));
                    ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                    KeyInfo temp = new KeyInfo(XML.parserPool.parse(in).getDocumentElement(), "");
                    k = temp.getPublicKey();
                }
            }
            if (!this.sig.checkSignatureValue(k)) {
                throw new InvalidCryptoException("SAMLSignedObject.verify() failed to validate signature value");
            }
        }
        catch (XMLSecurityException e) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() detected an XML security exception: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() detected an I/O exception: " + e.getMessage(), (Exception)e);
        }
        catch (SAXException e) {
            throw new InvalidCryptoException("SAMLSignedObject.verify() detected a XML parsing exception: " + e.getMessage(), (Exception)e);
        }
    }

    public Iterator getX509Certificates() throws SAMLException {
        if (this.isSigned()) {
            KeyInfo ki = this.sig.getKeyInfo();
            if (ki != null && ki.containsX509Data()) {
                try {
                    for (int i = 0; i < ki.lengthX509Data(); ++i) {
                        X509Data x509 = ki.itemX509Data(i);
                        if (!x509.containsCertificate()) continue;
                        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(x509.lengthCertificate());
                        for (int j = 0; j < x509.lengthCertificate(); ++j) {
                            certs.add(x509.itemCertificate(j).getX509Certificate());
                        }
                        return certs.iterator();
                    }
                }
                catch (XMLSecurityException e) {
                    throw new InvalidCryptoException("SAMLSignedObject.getX509Certificates() detected an XML security exception: " + e.getMessage(), (Exception)((Object)e));
                }
            }
            throw new InvalidCryptoException("SAMLSignedObject.getX509Certificates() can't find any X.509 certificates in signature");
        }
        throw new InvalidCryptoException("SAMLSignedObject.getX509Certificates() can't examine unsigned object");
    }

    public String getSignatureAlgorithm() throws SAMLException {
        if (this.isSigned()) {
            return this.sig.getSignedInfo().getSignatureMethodURI();
        }
        throw new InvalidCryptoException("SAMLSignedObject.getSignatureAlgorithm() can't examine unsigned object");
    }

    public String getDigestAlgorithm() throws SAMLException {
        SignedInfo si;
        if (this.isSigned() && (si = this.sig.getSignedInfo()).getLength() == 1) {
            try {
                Reference ref = si.item(0);
                return ref.getMessageDigestAlgorithm().getAlgorithmURI();
            }
            catch (XMLSecurityException e) {
                throw new InvalidCryptoException("SAMLSignedObject.getDigestAlgorithm() detected an XML security exception: " + e.getMessage(), (Exception)((Object)e));
            }
        }
        throw new InvalidCryptoException("SAMLSignedObject.getDigestAlgorithm() can't examine unsigned or improperly signed object");
    }

    public boolean isSigned() {
        return this.sig != null;
    }

    protected Object clone() throws CloneNotSupportedException {
        SAMLSignedObject dup = (SAMLSignedObject)super.clone();
        dup.sig = null;
        return dup;
    }
}

