/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import org.opensaml.NoSuchProviderException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLIdentifier;
import org.opensaml.provider.SecureRandomIDProvider;

public class SAMLIdentifierFactory {
    public static SAMLIdentifier getInstance() {
        try {
            return SAMLIdentifierFactory.getInstance(SAMLConfig.instance().getProperty("org.opensaml.provider.id"));
        }
        catch (NoSuchProviderException e) {
            return new SecureRandomIDProvider();
        }
    }

    public static SAMLIdentifier getInstance(String provider) throws NoSuchProviderException {
        try {
            return (SAMLIdentifier)Class.forName(provider).newInstance();
        }
        catch (Exception e) {
            throw new NoSuchProviderException("getInstance() unable to build instance of ID provider (" + provider + "): " + e.getMessage(), e);
        }
    }
}

