/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.lang.reflect.Constructor;
import org.opensaml.NoSuchProviderException;
import org.opensaml.SAMLBrowserProfile;
import org.opensaml.SAMLConfig;
import org.w3c.dom.Element;

public class SAMLBrowserProfileFactory {
    public static SAMLBrowserProfile getInstance() throws NoSuchProviderException {
        return SAMLBrowserProfileFactory.getInstance(null, SAMLConfig.instance().getProperty("org.opensaml.provider.browserprofile"));
    }

    public static SAMLBrowserProfile getInstance(String provider) throws NoSuchProviderException {
        return SAMLBrowserProfileFactory.getInstance(null, provider);
    }

    public static SAMLBrowserProfile getInstance(Element e) throws NoSuchProviderException {
        return SAMLBrowserProfileFactory.getInstance(e, SAMLConfig.instance().getProperty("org.opensaml.provider.browserprofile"));
    }

    public static SAMLBrowserProfile getInstance(Element e, String provider) throws NoSuchProviderException {
        try {
            Class<?> implementation = Class.forName(provider);
            Class[] paramtypes = new Class[]{Element.class};
            Object[] params = new Object[]{e};
            Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
            return (SAMLBrowserProfile)ctor.newInstance(params);
        }
        catch (Exception ex) {
            throw new NoSuchProviderException("getInstance() unable to build instance of profile provider (" + provider + "): " + ex.getMessage(), ex);
        }
    }
}

