/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLException;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAudienceRestrictionCondition
extends SAMLCondition
implements Cloneable {
    protected ArrayList audiences = new ArrayList();

    public SAMLAudienceRestrictionCondition() {
    }

    public SAMLAudienceRestrictionCondition(Collection audiences) throws SAMLException {
        if (audiences != null) {
            this.audiences.addAll(audiences);
        }
    }

    public SAMLAudienceRestrictionCondition(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAudienceRestrictionCondition(InputStream in) throws SAMLException {
        this.fromDOM(SAMLAudienceRestrictionCondition.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition")) {
            QName q = XML.getQNameAttribute(e, "http://www.w3.org/2001/XMLSchema-instance", "type");
            if (!(XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Condition") && q != null && "urn:oasis:names:tc:SAML:1.0:assertion".equals(q.getNamespaceURI()) && "AudienceRestrictionConditionType".equals(q.getLocalPart()))) {
                throw new MalformedException(SAMLException.RESPONDER, "SAMLAudienceRestrictionCondition() requires saml:AudienceRestrictionCondition at root");
            }
        }
        Element aud = XML.getFirstChildElement(e);
        while (aud != null) {
            if (aud.hasChildNodes()) {
                this.audiences.add(aud.getFirstChild().getNodeValue());
            }
            aud = XML.getNextSiblingElement(aud);
        }
        this.checkValidity();
    }

    public Iterator getAudiences() {
        return this.audiences.iterator();
    }

    public void setAudiences(Collection audiences) {
        this.audiences.clear();
        if (audiences != null) {
            this.audiences.addAll(audiences);
        }
        this.setDirty(true);
    }

    public void addAudience(String audience) {
        if (XML.isEmpty(audience)) {
            throw new IllegalArgumentException("audience cannot be null or empty");
        }
        this.audiences.add(audience);
        this.setDirty(true);
    }

    public void removeAudience(int index) {
        this.audiences.remove(index);
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element c = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AudienceRestrictionCondition");
        if (xmlns) {
            c.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return c;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element condition = (Element)this.root;
        if (this.dirty) {
            Iterator i = this.audiences.iterator();
            while (i.hasNext()) {
                String s = (String)i.next();
                if (XML.isEmpty(s)) continue;
                condition.appendChild(doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Audience")).appendChild(doc.createTextNode(s));
            }
            this.setDirty(false);
        } else if (xmlns) {
            condition.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        return this.root;
    }

    public boolean eval(Collection audiences) {
        if (audiences == null || audiences.size() == 0) {
            return false;
        }
        Iterator i = audiences.iterator();
        while (i.hasNext()) {
            if (!this.audiences.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public void checkValidity() throws SAMLException {
        if (this.audiences == null || this.audiences.size() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "AudienceRestrictionCondition is invalid, requires at least one audience");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAudienceRestrictionCondition dup = (SAMLAudienceRestrictionCondition)super.clone();
        dup.audiences = (ArrayList)this.audiences.clone();
        return dup;
    }
}

