/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.log4j.Category;
import org.apache.log4j.NDC;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLAttribute
extends SAMLObject
implements Cloneable {
    private static String factoryClass = null;
    protected String name = null;
    protected String namespace = null;
    protected QName type = null;
    protected long lifetime = 0L;
    protected ArrayList values = new ArrayList();

    public static synchronized String setFactory(String className) {
        String temp = factoryClass;
        factoryClass = className;
        return temp;
    }

    public static synchronized String getFactory() {
        return factoryClass;
    }

    public static SAMLAttribute getInstance(Element e) throws SAMLException {
        if (e == null) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAttribute.getInstance() given an empty DOM");
        }
        String className = SAMLAttribute.getFactory();
        if (className == null) {
            return new SAMLAttribute(e);
        }
        try {
            Class<?> implementation = Class.forName(className);
            Class[] paramtypes = new Class[]{Element.class};
            Object[] params = new Object[]{e};
            Constructor<?> ctor = implementation.getDeclaredConstructor(paramtypes);
            return (SAMLAttribute)ctor.newInstance(params);
        }
        catch (ClassNotFoundException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to locate attribute factory class (" + className + ")", (Exception)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to bind to constructor for attribute", (Exception)ex);
        }
        catch (InstantiationException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to build implementation object for attribute", (Exception)ex);
        }
        catch (IllegalAccessException ex) {
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() unable to access attribute factory", (Exception)ex);
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
            Throwable e2 = ex.getTargetException();
            if (e2 instanceof SAMLException) {
                throw (SAMLException)e2;
            }
            throw new SAMLException(SAMLException.REQUESTER, "SAMLAttribute.getInstance() caught unknown exception while building attribute object: " + e2.getMessage());
        }
    }

    public static SAMLAttribute getInstance(InputStream in) throws SAMLException {
        try {
            Document doc = XML.parserPool.parse(in);
            return SAMLAttribute.getInstance(doc.getDocumentElement());
        }
        catch (SAXException e) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLAttribute").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLAttribute.getInstance() caught exception while parsing a stream", (Exception)e);
        }
        catch (IOException e) {
            NDC.push((String)"getInstance");
            Category.getInstance((String)"SAMLAttribute").error((Object)("caught an exception while parsing a stream:\n" + e.getMessage()));
            NDC.pop();
            throw new MalformedException("SAMLAttribute.getInstance() caught exception while parsing a stream", (Exception)e);
        }
    }

    public SAMLAttribute() {
    }

    public SAMLAttribute(String name, String namespace, QName type, long lifetime, Collection values) throws SAMLException {
        this.name = XML.assign(name);
        this.namespace = XML.assign(namespace);
        this.type = type;
        this.lifetime = lifetime;
        if (values != null) {
            this.values.addAll(values);
        }
    }

    public SAMLAttribute(Element e) throws SAMLException {
        this.fromDOM(e);
    }

    public SAMLAttribute(InputStream in) throws SAMLException {
        this.fromDOM(SAMLAttribute.fromStream(in));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Attribute")) {
            throw new MalformedException("SAMLAttribute.fromDOM() requires saml:Attribute at root");
        }
        this.name = XML.assign(e.getAttributeNS(null, "AttributeName"));
        this.namespace = XML.assign(e.getAttributeNS(null, "AttributeNamespace"));
        Element n = XML.getFirstChildElement(e, "urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue");
        while (n != null) {
            if (this.type == null) {
                this.type = XML.getQNameAttribute(n, "http://www.w3.org/2001/XMLSchema-instance", "type");
            }
            this.valueFromDOM(n);
            n = XML.getNextSiblingElement(n);
        }
        this.checkValidity();
    }

    protected void valueFromDOM(Element e) throws SAMLException {
        Node val = e.getFirstChild();
        if (val != null && val.getNodeType() == 3) {
            this.values.add(val.getNodeValue());
        } else if (val == null) {
            this.values.add("");
        } else {
            this.values.add("");
            this.log.warn((Object)"skipping AttributeValue element without a simple text node");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (XML.isEmpty(name)) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.setDirty(true);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        if (XML.isEmpty(namespace)) {
            throw new IllegalArgumentException("namespace cannot be null");
        }
        this.namespace = namespace;
        this.setDirty(true);
    }

    public QName getType() {
        return this.type;
    }

    public void setType(QName type) {
        this.type = type;
        this.setDirty(true);
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long lifetime) {
        this.lifetime = lifetime;
    }

    public Iterator getValues() {
        return this.values.iterator();
    }

    public NodeList getValueElements() {
        return !this.dirty && this.root != null ? ((Element)this.root).getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue") : null;
    }

    public void setValues(Collection values) throws SAMLException {
        this.values.clear();
        if (values != null) {
            this.values.addAll(values);
        }
        this.setDirty(true);
    }

    public void addValue(Object value) throws SAMLException {
        if (value != null) {
            this.values.add(value);
        } else {
            this.values.add("");
        }
        this.setDirty(true);
    }

    public void removeValue(int index) throws IndexOutOfBoundsException {
        this.values.remove(index);
        this.setDirty(true);
    }

    protected String computeTypeDecl(Element e) {
        String xsitype = null;
        e.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typens");
        if (this.type != null) {
            String prefix;
            if ("http://www.w3.org/2001/XMLSchema".equals(this.type.getNamespaceURI())) {
                prefix = "xsd";
            } else {
                e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:typens", this.type.getNamespaceURI());
                prefix = "typens";
            }
            xsitype = prefix + ":" + this.type.getLocalPart();
        }
        return xsitype;
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element a = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Attribute");
        if (xmlns) {
            a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        }
        a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        return a;
    }

    protected void valueToDOM(int index, Element e) throws SAMLException {
        String val = this.values.get(index).toString();
        if (!XML.isEmpty(val)) {
            e.appendChild(e.getOwnerDocument().createTextNode(val));
        }
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element a = (Element)this.root;
        if (this.dirty) {
            a.setAttributeNS(null, "AttributeName", this.name);
            a.setAttributeNS(null, "AttributeNamespace", this.namespace);
            String xsitype = this.computeTypeDecl(a);
            for (int i = 0; i < this.values.size(); ++i) {
                Element v = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeValue");
                if (xsitype != null) {
                    v.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", xsitype);
                }
                this.valueToDOM(i, v);
                a.appendChild(v);
            }
            this.setDirty(false);
        } else if (xmlns) {
            a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.name) || XML.isEmpty(this.namespace) || this.values.size() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "Attribute invalid, requires name and namespace, and at least one value");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAttribute dup = (SAMLAttribute)super.clone();
        dup.values = (ArrayList)this.values.clone();
        return dup;
    }
}

