/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import org.opensaml.MalformedException;
import org.opensaml.SAMLCondition;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSignedObject;
import org.opensaml.SAMLStatement;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLAssertion
extends SAMLSignedObject
implements Cloneable {
    protected int minor;
    protected String assertionId;
    protected String issuer;
    protected Date issueInstant;
    protected Date notBefore;
    protected Date notOnOrAfter;
    protected ArrayList conditions;
    protected ArrayList advice;
    protected ArrayList statements;

    protected void insertSignature() throws SAMLException {
        this.root.appendChild(this.getSignatureElement());
    }

    public SAMLAssertion() {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.assertionId = null;
        this.issuer = null;
        this.issueInstant = null;
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.conditions = new ArrayList();
        this.advice = new ArrayList();
        this.statements = new ArrayList();
    }

    public SAMLAssertion(String issuer, Date notBefore, Date notOnOrAfter, Collection conditions, Collection advice, Collection statements) throws SAMLException {
        this(SAMLConfig.instance().getDefaultIDProvider().getIdentifier(), new Date(), issuer, notBefore, notOnOrAfter, conditions, advice, statements);
    }

    public SAMLAssertion(String assertionId, Date issueInstant, String issuer, Date notBefore, Date notOnOrAfter, Collection conditions, Collection advice, Collection statements) throws SAMLException {
        Iterator i;
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.assertionId = null;
        this.issuer = null;
        this.issueInstant = null;
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.conditions = new ArrayList();
        this.advice = new ArrayList();
        this.statements = new ArrayList();
        this.assertionId = XML.assign(assertionId);
        this.issueInstant = issueInstant;
        this.issuer = XML.assign(issuer);
        this.notBefore = notBefore;
        this.notOnOrAfter = notOnOrAfter;
        if (conditions != null) {
            i = conditions.iterator();
            while (i.hasNext()) {
                this.conditions.add(((SAMLCondition)i.next()).setParent(this));
            }
        }
        if (advice != null) {
            i = advice.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (obj instanceof String && ((String)obj).length() > 0) {
                    this.advice.add(obj);
                    continue;
                }
                if (obj instanceof SAMLAssertion) {
                    this.advice.add(((SAMLAssertion)obj).setParent(this));
                    continue;
                }
                if (obj instanceof Element && ((Element)obj).getParentNode() == null && !((Element)obj).getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                    this.advice.add(obj);
                    continue;
                }
                throw new IllegalArgumentException("SAMLAssertion() can only process advice Strings, SAMLAssertions, or DOM elements from a non-saml namespace");
            }
        }
        if (statements != null) {
            i = statements.iterator();
            while (i.hasNext()) {
                this.statements.add(((SAMLStatement)i.next()).setParent(this));
            }
        }
    }

    public SAMLAssertion(Element e) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.assertionId = null;
        this.issuer = null;
        this.issueInstant = null;
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.conditions = new ArrayList();
        this.advice = new ArrayList();
        this.statements = new ArrayList();
        this.fromDOM(e);
    }

    public SAMLAssertion(InputStream in) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.assertionId = null;
        this.issuer = null;
        this.issueInstant = null;
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.conditions = new ArrayList();
        this.advice = new ArrayList();
        this.statements = new ArrayList();
        this.fromDOM(SAMLAssertion.fromStream(in));
    }

    public SAMLAssertion(InputStream in, int minor) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.assertionId = null;
        this.issuer = null;
        this.issueInstant = null;
        this.notBefore = null;
        this.notOnOrAfter = null;
        this.conditions = new ArrayList();
        this.advice = new ArrayList();
        this.statements = new ArrayList();
        this.fromDOM(SAMLAssertion.fromStream(in, minor));
    }

    public void fromDOM(Element e) throws SAMLException {
        super.fromDOM(e);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(e, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAssertion.fromDOM() requires saml:Assertion at root");
        }
        if (Integer.parseInt(e.getAttributeNS(null, "MajorVersion")) != 1) {
            throw new MalformedException(SAMLException.VERSION, "SAMLAssertion.fromDOM() detected incompatible assertion major version of " + e.getAttributeNS(null, "MajorVersion"));
        }
        this.minor = Integer.parseInt(e.getAttributeNS(null, "MinorVersion"));
        this.issuer = XML.assign(e.getAttributeNS(null, "Issuer"));
        this.assertionId = XML.assign(e.getAttributeNS(null, "AssertionID"));
        if (this.minor > 0) {
            e.setIdAttributeNode(e.getAttributeNodeNS(null, "AssertionID"), true);
        }
        try {
            SimpleDateFormat formatter = null;
            String dateTime = e.getAttributeNS(null, "IssueInstant");
            formatter = dateTime.indexOf(46) > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.issueInstant = formatter.parse(dateTime);
            Element n = XML.getFirstChildElement(e);
            while (n != null) {
                if (XML.isElementNamed(n, "urn:oasis:names:tc:SAML:1.0:assertion", "Conditions")) {
                    if (n.hasAttributeNS(null, "NotBefore")) {
                        this.notBefore = formatter.parse(n.getAttributeNS(null, "NotBefore"));
                    }
                    if (n.hasAttributeNS(null, "NotOnOrAfter")) {
                        this.notOnOrAfter = formatter.parse(n.getAttributeNS(null, "NotOnOrAfter"));
                    }
                    Element cond = XML.getFirstChildElement(n);
                    while (cond != null) {
                        this.conditions.add(SAMLCondition.getInstance(cond).setParent(this));
                        cond = XML.getNextSiblingElement(cond);
                    }
                } else if (XML.isElementNamed(n, "urn:oasis:names:tc:SAML:1.0:assertion", "Advice")) {
                    Element child = XML.getFirstChildElement(n);
                    while (child != null) {
                        if (XML.isElementNamed(child, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference") && child.hasChildNodes()) {
                            this.advice.add(child.getFirstChild().getNodeValue());
                        } else if (XML.isElementNamed(child, "urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) {
                            this.advice.add(new SAMLAssertion(child).setParent(this));
                        } else {
                            this.advice.add(child);
                        }
                        child = XML.getNextSiblingElement(child);
                    }
                } else if (!XML.isElementNamed(n, "http://www.w3.org/2000/09/xmldsig#", "Signature")) {
                    this.statements.add(SAMLStatement.getInstance(n).setParent(this));
                }
                n = XML.getNextSiblingElement(n);
            }
        }
        catch (ParseException ex) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLAssertion.fromDOM() detected an invalid datetime while parsing assertion", (Exception)ex);
        }
        this.checkValidity();
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(int minor) {
        this.minor = minor;
        this.setDirty(true);
    }

    public String getId() {
        return this.assertionId;
    }

    public void setId(String id) {
        if (XML.isEmpty(id)) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.assertionId = id;
        this.setDirty(true);
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        if (XML.isEmpty(issuer)) {
            throw new IllegalArgumentException("issuer cannot be null");
        }
        this.issuer = issuer;
        this.setDirty(true);
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date issueInstant) {
        if (issueInstant == null) {
            throw new IllegalArgumentException("issueInstant cannot be null");
        }
        this.issueInstant = issueInstant;
        this.setDirty(true);
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(Date notBefore) {
        this.notBefore = notBefore;
        this.setDirty(true);
    }

    public Date getNotOnOrAfter() {
        return this.notOnOrAfter;
    }

    public void setNotOnOrAfter(Date notOnOrAfter) {
        this.notOnOrAfter = notOnOrAfter;
        this.setDirty(true);
    }

    public Iterator getConditions() {
        return this.conditions.iterator();
    }

    public void setConditions(Collection conditions) throws SAMLException {
        this.conditions.clear();
        if (conditions != null) {
            Iterator i = conditions.iterator();
            while (i.hasNext()) {
                this.conditions.add(((SAMLCondition)i.next()).setParent(this));
            }
        }
        this.setDirty(true);
    }

    public void addCondition(SAMLCondition c) throws SAMLException {
        if (c == null) {
            throw new IllegalArgumentException("c cannot be null");
        }
        this.conditions.add(c.setParent(this));
        this.setDirty(true);
    }

    public void removeCondition(int index) throws IndexOutOfBoundsException {
        this.conditions.remove(index);
        this.setDirty(true);
    }

    public Iterator getAdvice() {
        return this.advice.iterator();
    }

    public void setAdvice(Collection advice) throws SAMLException {
        this.advice.clear();
        this.setDirty(true);
        if (advice != null) {
            Iterator i = advice.iterator();
            while (i.hasNext()) {
                this.addAdvice(i.next());
            }
        }
    }

    public void addAdvice(Object advice) throws SAMLException {
        if (advice != null && (advice instanceof String || advice instanceof SAMLAssertion || advice instanceof Element && !((Element)advice).getNamespaceURI().equals("urn:oasis:names:tc:SAML:1.0:assertion"))) {
            if (advice instanceof SAMLAssertion) {
                ((SAMLAssertion)advice).setParent(this);
            }
        } else {
            throw new IllegalArgumentException("SAMLAssertion.addAdvice() can only process Strings, SAMLAssertions, or DOM elements from a non-saml namespace");
        }
        this.advice.add(advice);
        this.setDirty(true);
    }

    public void removeAdvice(int index) throws IndexOutOfBoundsException {
        this.advice.remove(index);
        this.setDirty(true);
    }

    public Iterator getStatements() {
        return this.statements.iterator();
    }

    public void setStatements(Collection statements) throws SAMLException {
        this.statements.clear();
        this.setDirty(true);
        if (statements != null) {
            Iterator i = statements.iterator();
            while (i.hasNext()) {
                this.statements.add(((SAMLStatement)i.next()).setParent(this));
            }
        }
    }

    public void addStatement(SAMLStatement s) throws SAMLException {
        if (s == null) {
            throw new IllegalArgumentException("s cannot be null");
        }
        this.statements.add(s.setParent(this));
        this.setDirty(true);
    }

    public void removeStatement(int index) throws IndexOutOfBoundsException {
        this.statements.remove(index);
        this.setDirty(true);
    }

    protected Element buildRoot(Document doc, boolean xmlns) {
        Element a = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion");
        a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
        a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
        a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
        if (xmlns) {
            a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            a.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        return a;
    }

    public Node toDOM(Document doc, boolean xmlns) throws SAMLException {
        super.toDOM(doc, xmlns);
        Element assertion = (Element)this.root;
        if (this.dirty) {
            Iterator i;
            if (this.assertionId == null) {
                this.assertionId = this.config.getDefaultIDProvider().getIdentifier();
            }
            if (this.issueInstant == null) {
                this.issueInstant = new Date();
            }
            assertion.setAttributeNS(null, "MajorVersion", "1");
            assertion.setAttributeNS(null, "MinorVersion", String.valueOf(this.minor));
            assertion.setAttributeNS(null, "AssertionID", this.assertionId);
            if (this.minor > 0) {
                assertion.setIdAttributeNS(null, "AssertionID", true);
            }
            assertion.setAttributeNS(null, "Issuer", this.issuer);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            assertion.setAttributeNS(null, "IssueInstant", formatter.format(this.issueInstant));
            if (this.conditions.size() > 0 || this.notBefore != null || this.notOnOrAfter != null) {
                Element conds = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Conditions");
                if (this.notBefore != null) {
                    conds.setAttributeNS(null, "NotBefore", formatter.format(this.notBefore));
                }
                if (this.notOnOrAfter != null) {
                    conds.setAttributeNS(null, "NotOnOrAfter", formatter.format(this.notOnOrAfter));
                }
                assertion.appendChild(conds);
                i = this.conditions.iterator();
                while (i.hasNext()) {
                    conds.appendChild(((SAMLCondition)i.next()).toDOM(doc, false));
                }
            }
            if (this.advice.size() > 0) {
                Element a = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "Advice");
                i = this.advice.iterator();
                while (i.hasNext()) {
                    Object obj = i.next();
                    if (obj instanceof String && !XML.isEmpty((String)obj)) {
                        Element ref = doc.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
                        ref.appendChild(doc.createTextNode((String)obj));
                        a.appendChild(ref);
                        continue;
                    }
                    if (obj instanceof SAMLAssertion) {
                        a.appendChild(((SAMLAssertion)obj).toDOM(doc, false));
                        continue;
                    }
                    if (!(obj instanceof Element)) continue;
                    a.appendChild(doc.adoptNode((Element)obj));
                }
                assertion.appendChild(a);
            }
            Iterator i2 = this.statements.iterator();
            while (i2.hasNext()) {
                assertion.appendChild(((SAMLStatement)i2.next()).toDOM(doc, false));
            }
            this.setDirty(false);
        } else if (xmlns) {
            assertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:assertion");
            assertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            assertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            assertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
            assertion.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (XML.isEmpty(this.issuer) || this.statements.size() == 0) {
            throw new MalformedException("Assertion is invalid, must have Issuer, and at least one Statement");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SAMLAssertion dup = (SAMLAssertion)super.clone();
        try {
            dup.conditions = new ArrayList();
            Iterator i = this.conditions.iterator();
            while (i.hasNext()) {
                dup.conditions.add(((SAMLCondition)((SAMLCondition)i.next()).clone()).setParent(dup));
            }
            dup.advice = new ArrayList();
            i = this.advice.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (obj instanceof String) {
                    dup.advice.add(obj);
                    continue;
                }
                if (obj instanceof SAMLAssertion) {
                    dup.advice.add(((SAMLAssertion)((SAMLAssertion)i.next()).clone()).setParent(dup));
                    continue;
                }
                dup.advice.add(((Element)obj).cloneNode(true));
            }
            dup.statements = new ArrayList();
            i = this.statements.iterator();
            while (i.hasNext()) {
                dup.statements.add(((SAMLStatement)((SAMLStatement)i.next()).clone()).setParent(dup));
            }
        }
        catch (SAMLException e) {
            throw new CloneNotSupportedException(e.getMessage());
        }
        return dup;
    }
}

