<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:wnu="http://www.govtalk.gov.uk/taxation/WNU"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext"						  							  
							  xmlns:xalan="http://xml.apache.org/xalan"
							  exclude-result-prefixes="xalan"
							  >
<ext:annotation
	metadata="WNU(Anthony).metadata.xsl"	
/>							  							  							 							  
							  
<xsl:output method="html" encoding="UTF-8"/>	
<!-- These should be supplied by external stylesheet user-->
<xsl:param name="page">1</xsl:param>
<xsl:param name="issueDate.day">30</xsl:param>
<xsl:param name="issueDate.month">03</xsl:param>
<xsl:param name="issueDate.year">2006</xsl:param>

<xsl:template match="/">
<xsl:variable name="pageType">
<xsl:choose>
	<xsl:when test="$page = 1">title page</xsl:when>
	<xsl:when test="$page mod 2 = 0">cont. sheet 1</xsl:when>
	<xsl:otherwise>cont. sheet 2</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="employees">
<xsl:choose>
<xsl:when test="$pageType='title page'">
	<xsl:copy-of select="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employee[ position() &lt; 25 ]"/>
</xsl:when>
<xsl:when test="$pageType='cont. sheet 1'">
	<xsl:variable name="first_wnu" select="floor(($page - 2) div 2) * 66 + 25"/>
	<xsl:copy-of select="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employee[ position() &gt;= $first_wnu and position() &lt; $first_wnu + 32]"/>	
</xsl:when>
<xsl:otherwise>
	<xsl:variable name="first_wnu" select="floor(($page - 2) div 2) * 66 + 57"/>
	<xsl:copy-of select="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employee[ position() &gt;= $first_wnu and position() &lt; $first_wnu + 34]"/>	
</xsl:otherwise>
</xsl:choose>
</xsl:variable>
<xsl:variable name="employer" select="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employer"/>
<html>
	<head>
		<title>WNU(Anthony)</title>
		<style type="text/css">
				body {
					margin: 0px;
					padding: 0px;
					color: blue;
					font: normal normal bold 11pt monospace;				
				}
					
				div {
					background: transparent none no-repeat scroll top left;
				}
				
				body * div {
					position: absolute;
					border: 1px dotted transparent;					
				}
				
				div.checkbox {
					font-family:sans-serif;text-align:center
				}
				
				div.large-text {
					font-size: 32pt
				}			
		</style>	
	</head>
	<body>
		<xsl:choose>
		<xsl:when test="$pageType = 'title page'">
		<div style="background-image: url(images/wnu_Anthony_p1a.png);width:794px;height:1130px">
			<div style="width:794px;height:1130px">
				
			<xsl:comment> WNU Works Number Update for</xsl:comment>
			
			<div style="left: 465px;top: 88px;width: 150px;text-align: left">
				<xsl:value-of select="//wnu:IRenvelope/wnu:IRheader/wnu:Keys/wnu:Key[@Type='TaxOfficeNumber']"/>
				/
				<xsl:value-of select="//wnu:IRenvelope/wnu:IRheader/wnu:Keys/wnu:Key[@Type='TaxOfficeReference']"/>				
			</div>
			<div style="left: 435px;top: 110px;width: 290px;text-align: left">
				<xsl:choose>
					<xsl:when test="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employer/wnu:Name">
						<xsl:value-of select="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employer/wnu:Name"/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 435px;top: 135px;width: 290px;text-align: left">
				<xsl:choose>
					<xsl:when test="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employer/wnu:Address/wnu:Line">
						<xsl:for-each select="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employer/wnu:Address/wnu:Line">
							<xsl:value-of select="."/><br/>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			<div style="left: 435px;top: 210px;width: 290px;text-align: left">				
				<xsl:value-of select="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employer/wnu:Address/wnu:PostCode"/>
				&#160;
				<xsl:value-of select="//wnu:IRenvelope/wnu:WorksNumberUpdate/wnu:Employer/wnu:Address/wnu:Country"/>				
			</div>			
			
			<xsl:for-each select="xalan:nodeset($employees)/wnu:Employee">
				<xsl:variable name="y" select="380 + position()*26.25"/>
				<div style="left: 75px;top: {$y}px;width: 292px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:Name">
							<xsl:for-each select="wnu:Name/*"><xsl:value-of select="."/>&#160;</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>	
				<div style="left: 388px;top: {$y}px;width: 85px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:NINO">
							<xsl:value-of select="wnu:NINO"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>
				<div style="left: 506px;top: {$y}px;width: 85px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:OldWorksNumber">
							<xsl:value-of select="wnu:OldWorksNumber"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>	
				<div style="left: 622px;top: {$y}px;width: 85px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:NewWorksNumber">
							<xsl:value-of select="wnu:NewWorksNumber"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>					
			</xsl:for-each>							
			</div>
		</div>
		
		</xsl:when>
		<xsl:when test="$pageType = 'cont. sheet 1'">
		<div style="background-image: url(images/wnu_Anthony_cs_p1.png);width:794px;height:1130px">
			<div style="width:794px;height:1123px">
			
			<xsl:for-each select="xalan:nodeset($employees)/wnu:Employee">
				<xsl:variable name="y" select="164 + position()*26.6"/>
				<div style="left: 59px;top: {$y}px;width: 300px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:Name">
							<xsl:for-each select="wnu:Name/*"><xsl:value-of select="."/>&#160;</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>	
				<div style="left: 391px;top: {$y}px;width: 90px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:NINO">
							<xsl:value-of select="wnu:NINO"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>
				<div style="left: 513px;top: {$y}px;width: 94px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:OldWorksNumber">
							<xsl:value-of select="wnu:OldWorksNumber"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>	
				<div style="left: 635px;top: {$y}px;width: 94px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:NewWorksNumber">
							<xsl:value-of select="wnu:NewWorksNumber"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>					
			</xsl:for-each>									
			</div>
		</div>			
		</xsl:when>
		<xsl:otherwise>
		<div style="background-image: url(images/wnu_Anthony_cs_p2.png);width:794px;height:1131px">
			<div style="width:794px;height:1123px">
			
			<xsl:for-each select="xalan:nodeset($employees)/wnu:Employee">
				<xsl:variable name="y" select="140 + position()*26.6"/>
				<div style="left: 59px;top: {$y}px;width: 300px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:Name">
							<xsl:for-each select="wnu:Name/*"><xsl:value-of select="."/>&#160;</xsl:for-each>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>	
				<div style="left: 391px;top: {$y}px;width: 90px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:NINO">
							<xsl:value-of select="wnu:NINO"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>
				<div style="left: 513px;top: {$y}px;width: 94px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:OldWorksNumber">
							<xsl:value-of select="wnu:OldWorksNumber"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>	
				<div style="left: 635px;top: {$y}px;width: 94px;text-align: left">
					<xsl:choose>
						<xsl:when test="wnu:NewWorksNumber">
							<xsl:value-of select="wnu:NewWorksNumber"/>
						</xsl:when>
						<xsl:otherwise>&#160;</xsl:otherwise>
					</xsl:choose>
				</div>					
			</xsl:for-each>				
			</div>
		</div>		
		</xsl:otherwise>
		</xsl:choose>		
	</body>
</html>	
</xsl:template>			  
</xsl:stylesheet>
