<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:mov="selima:FBI Rendering"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext">
<ext:cuttingRules>
	<rules>
		<exclude path="/IRenvelope/IRheader"/>		
		<exclude path="/IRenvelope/InYearMovements/*">
			<exception path="/IRenvelope/InYearMovements/P45Part3"/>
		</exclude>
		<exclude path="/IRenvelope/InYearMovements/P45Part3/*">
			<exception path="/IRenvelope/InYearMovements/P45Part3/Name"/>
			<exception path="/IRenvelope/InYearMovements/P45Part3/NINO"/>
			<exception path="/IRenvelope/InYearMovements/P45Part3/WorksNumber"/>			
		</exclude>
	</rules>
</ext:cuttingRules>

<xsl:output method="xml" encoding="UTF-8"/>	

<xsl:template match="/">
<pages>
	<xsl:for-each select="//mov:IRenvelope/mov:InYearMovements/mov:P45Part3">
		<page id="{position()}">
			<keys>
				<key name="Name" default="true"><xsl:value-of select="mov:Name/mov:Sur"/> 
					<xsl:for-each select="mov:Name/mov:Fore">
							<xsl:if test="position() != 1">,</xsl:if>
							<xsl:value-of select="concat(' ',string(.))"/>
					</xsl:for-each>
				</key>
				<key name="NINO"><xsl:value-of select="mov:NINO"/></key>
				<key name="WorksNumber"><xsl:value-of select="mov:WorksNumber"/></key>
			</keys>				
			<rules>
				<exclude path='/IRenvelope/InYearMovements/P45Part3[position() &gt;= {position() + 1}]'>
					<exception path='/IRenvelope/InYearMovements/P45Part3[{position()}]'/>
				</exclude>
				<exclude path='/IRenvelope/InYearMovements/P45Part3/*'>
					<exception path='/IRenvelope/InYearMovements/P45Part3[{position()}]/*'/>
				</exclude>							
			</rules>				
		</page>	
	</xsl:for-each>
</pages>
</xsl:template>			  
</xsl:stylesheet>
