<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
                              xmlns:mov="selima:FBI Rendering"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext">							  
<ext:annotation
	metadata="P45Part1(base).metadata.xsl"
	rewrite_from_ns="http://www.govtalk.gov.uk/taxation/MOV"
    rewrite_to_ns="selima:FBI Rendering"	
/>								  
<xsl:output method="html" encoding="UTF-8"/>	
<!-- These should be supplied by external stylesheet user-->
<xsl:param name="page">1</xsl:param>
<xsl:param name="issueDate.day">30</xsl:param>
<xsl:param name="issueDate.month">3</xsl:param>
<xsl:param name="issueDate.year">2006</xsl:param>

<xsl:template match="/">
<xsl:variable name="p45Part1" select="//mov:IRenvelope/mov:InYearMovements/mov:P45Part1[position() = $page]"/>
<xsl:variable name="employer" select="//mov:IRenvelope/mov:InYearMovements/mov:Employer"/>
<html>
	<head>
		<title>P45Part1(2006)</title>
		<style type="text/css">
				body {
					margin: 0px;
					padding: 0px;
					color: blue;
					font: normal normal bold 11pt monospace;				
				}
					
				div {
					background: transparent none no-repeat scroll top left;
				}
				
				body * div {
					border: 1px dotted transparent;
					position: absolute;				
				}
				
				div.checkbox {
					font-family:sans-serif;text-align:center
				}
				
				div.large-text {
					font-size: 32pt
				}			
		</style>		
	</head>
	<body>
		<div style="background-image: url(images/p45_2006_p1.png);width:791px;height:1179px">
			<div style="width:791px;height:1179px">

			<xsl:comment> 1 PAYE Reference </xsl:comment>
			<xsl:comment> Office number </xsl:comment>
			<div style="left: 447px;top: 105px;width: 80px;text-align: right">
				&#160;	
				<xsl:value-of select="//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeNumber']"/>			
			</div>
			
			<xsl:comment> Reference number </xsl:comment>
			<div style="left: 550px;top: 105px;width: 220px;">			
				<xsl:value-of select="//mov:IRenvelope/mov:IRheader/mov:Keys/mov:Key[@Type='TaxOfficeReference']"/>								
			</div>				
			
			<xsl:comment> 2 Employee's National Insurance number </xsl:comment>
			<div style="left: 450px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:NINO">
					<xsl:value-of select="substring($p45Part1/mov:NINO,1,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			<xsl:comment> NINO </xsl:comment>
			<div style="left: 450px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:NINO">
					<xsl:value-of select="substring($p45Part1/mov:NINO,1,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			<div style="left: 511px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:NINO">
					<xsl:value-of select="substring($p45Part1/mov:NINO,3,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			<div style="left: 570px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:NINO">
					<xsl:value-of select="substring($p45Part1/mov:NINO,5,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			<div style="left: 629px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:NINO">
					<xsl:value-of select="substring($p45Part1/mov:NINO,7,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 690px;top: 155px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:NINO">
					<xsl:value-of select="substring($p45Part1/mov:NINO,9,1)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			<xsl:comment> 3 Surname (in CAPITALS) </xsl:comment>
			<div style="left: 220px;top: 205px;width: 442px;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:Name/mov:Sur">
					<xsl:value-of select="$p45Part1/mov:Name/mov:Sur"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment> Mr Mrs Miss Ms Other </xsl:comment>
			<div style="left: 674px;top: 205px;width: 96px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:Name/mov:Ttl">
					<xsl:value-of select="$p45Part1/mov:Name/mov:Ttl"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			<xsl:comment> First name(s) (in CAPITALS) </xsl:comment>
			<div style="left: 220px;top: 252px;width: 548px;text-transform:uppercase">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:Name/mov:Fore">
					<xsl:value-of select="$p45Part1/mov:Name/mov:Fore[position()=1]"/>
					<xsl:for-each select="$p45Part1/mov:Name/mov:Fore[position()>1]
					">,&#160;<xsl:value-of select="."/>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			<xsl:comment> 4 Leaving date (in figures) </xsl:comment>
			<xsl:comment> Day </xsl:comment>
			<div style="left: 220px;top: 302px;width: 87px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:LeavingDate">
					<xsl:value-of select="substring($p45Part1/mov:LeavingDate,9,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<xsl:comment> Month </xsl:comment>
			<div style="left: 318px;top: 302px;width: 76px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:LeavingDate">
					<xsl:value-of select="substring($p45Part1/mov:LeavingDate,6,2)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			<xsl:comment> Year </xsl:comment>
			<div style="left: 405px;top: 302px;width: 136px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:LeavingDate">
					<xsl:value-of select="substring($p45Part1/mov:LeavingDate,1,4)"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				

			<xsl:comment> 5 Continue Student Loan Deductions(Y)</xsl:comment>
			<div style="left: 715px;top: 302px;width: 50px;text-align:center;text-transform:uppercase">
				?
			</div>				
			
			<xsl:comment> 6 Tax Code at leaving date. If Week 1 or Month 1 basis
						applies, write 'X' in the box marked Week 1 or Month 1.
			</xsl:comment>
			<xsl:comment> Code </xsl:comment>
			<div style="left: 446px;top: 352px;width: 180px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:TaxCodeAtLeaving">
					<xsl:value-of select="$p45Part1/mov:TaxCodeAtLeaving"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			<xsl:comment> Week 1 or Month1 </xsl:comment>
			<div style="left: 636px;top: 352px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:TaxCodeAtLeaving/@Week1Month1Indicator = 'week'">
					X
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			<div style="left: 690px;top: 352px;width: 50px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:TaxCodeAtLeaving/@Week1Month1Indicator = 'month'">
					X
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment> 7 Last entries on Deductions Working Sheet (P11).
						Complete only if Tax Code is cumulative.
						Make no entry here if Week 1 or Month 1 basis applies.
						Go to item 8.			
			</xsl:comment>
			<xsl:comment> Week or month number </xsl:comment>
			<xsl:comment> Week </xsl:comment>
			<div style="left: 446px;top: 400px;width: 136px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:LastEntries/mov:Period/@Type='week'">
					<xsl:value-of select="$p45Part1/mov:LastEntries/mov:Period"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>		
			<xsl:comment> Month </xsl:comment>
			<div style="left: 594px;top: 400px;width: 175px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:LastEntries/mov:Period/@Type='month'">
					<xsl:value-of select="$p45Part1/mov:LastEntries/mov:Period"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			
			<xsl:comment> Total pay to date </xsl:comment>
			<div style="left: 462px;top: 450px;width: 120px;text-align:right">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:LastEntries/mov:TotalPayToDate">
					<xsl:value-of select="format-number(floor($p45Part1/mov:LastEntries/mov:TotalPayToDate),'#0')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 594px;top: 450px;width: 70px;text-align:left">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:LastEntries/mov:TotalPayToDate">
					<xsl:value-of select="substring-after(format-number($p45Part1/mov:LastEntries/mov:TotalPayToDate,'#.00'),'.')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>			
			
			<xsl:comment> Total tax to date </xsl:comment>
			<div style="left: 462px;top: 498px;width: 120px;text-align:right">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:LastEntries/mov:TotalTaxToDate">
					<xsl:value-of select="format-number(floor($p45Part1/mov:LastEntries/mov:TotalTaxToDate),'#0')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 594px;top: 498px;width: 70px;text-align:left">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:LastEntries/mov:TotalTaxToDate">
					<xsl:value-of select="substring-after(format-number($p45Part1/mov:LastEntries/mov:TotalTaxToDate,'#.00'),'.')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				
			
			<xsl:comment> 8 This employment pay and tax. 
						No entry is needed if Tax Code is cumulative and amounts are 
						the same as item 7 entry.
			</xsl:comment>
			
			<xsl:comment> Total pay in this employment </xsl:comment>
			<div style="left: 462px;top: 546px;width: 120px;text-align:right">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:ThisEmployment/mov:TotalPay">
					<xsl:value-of select="format-number(floor($p45Part1/mov:ThisEmployment/mov:TotalPay),'#0')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 594px;top: 546px;width: 70px;text-align:left">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:ThisEmployment/mov:TotalPay">
					<xsl:value-of select="substring-after(format-number($p45Part1/mov:ThisEmployment/mov:TotalPay,'#.00'),'.')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>				

			<xsl:comment> Total tax in this employment </xsl:comment>
			<div style="left: 462px;top: 596px;width: 120px;text-align:right">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:ThisEmployment/mov:TotalTax">
					<xsl:value-of select="format-number(floor($p45Part1/mov:ThisEmployment/mov:TotalTax),'#0')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			<div style="left: 594px;top: 596px;width: 70px;text-align:left">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:ThisEmployment/mov:TotalTax">
					<xsl:value-of select="substring-after(format-number($p45Part1/mov:ThisEmployment/mov:TotalTax,'#.00'),'.')"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>	
			
			<xsl:comment> 9 Works number/Payroll number </xsl:comment>
			<div style="left: 220px;top: 640px;width: 202px;text-align:center">
				<xsl:choose>
				<xsl:when test="$p45Part1/mov:WorksNumber">
					<xsl:value-of select="$p45Part1/mov:WorksNumber"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>

			<xsl:comment> 10 Department or branch, if any</xsl:comment>
			<div style="left: 593px;top: 640px;width: 175px;text-align:center">
				NOT APPLICABLE
			</div>
			
			<xsl:comment> 11 Employee's private address and Postcode </xsl:comment>
			<div style="left: 220px;top: 685px;width: 548px;text-align:left">
				<xsl:for-each select="$p45Part1/mov:Address/mov:Line">
					<xsl:value-of select="."/><br/>
				</xsl:for-each>
				<xsl:value-of select="$p45Part1/mov:Address/mov:PostCode"/>
				<xsl:choose>
					<xsl:when test="count($p45Part1/mov:Address/mov:Line)&lt;4">
						<br/>
					</xsl:when>
					<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>				
				<xsl:value-of select="$p45Part1/mov:Address/mov:Country"/>				
			</div>

			<xsl:comment> 12 I certify that the details entered above in items 1 to 10 are correct. </xsl:comment>
			<xsl:comment> Employer's name, address and Postcode</xsl:comment>
			<div style="left: 220px;top: 810px;width: 548px;text-align:left">
				<xsl:value-of select="$employer/mov:Name"/><br/>			
				<xsl:for-each select="$employer/mov:Address/mov:Line">
					<xsl:value-of select="."/><br/>
				</xsl:for-each>
				<xsl:value-of select="$employer/mov:Address/mov:PostCode"/>
				<xsl:choose>
					<xsl:when test="count($employer/mov:Address/mov:Line) &lt; 3">
					<br/> 						
					</xsl:when>
					<xsl:otherwise>
					&#160;
					</xsl:otherwise>
				</xsl:choose>				
				<xsl:value-of select="$employer/mov:Address/mov:Country"/>				
			</div>

			<xsl:comment> Date </xsl:comment>
			<div style="left:218px;top: 917px;width: 548px;text-align:left">
				<xsl:choose>
				<xsl:when test="$issueDate.day != '&#160;'">			
					<xsl:value-of select="$issueDate.day"/>/<xsl:value-of select="$issueDate.month"/>/<xsl:value-of select="$issueDate.year"/>
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>
			</div>
			
			<xsl:comment> If the employee has died,	write 'D' in this box and
						send all four parts of this form (unseparated) to your
						Inland Revenue office immediately.
			</xsl:comment>
			<div style="left:543px;top: 1055px;width: 60px;text-align:center;padding-top: 20px" class="large-text">
				<xsl:choose>
				<xsl:when test="$p45Part1/@DeceasedIndicator">
					D
				</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
				</xsl:choose>				
			</div>			
			</div>
		</div>	
	</body>
</html>	
</xsl:template>			  
</xsl:stylesheet>
