<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext"							  
                              xmlns:eoy="selima:FBI Rendering">							  
<ext:cuttingRules>
	<rules>
		<exclude path="/IRenvelope/EndOfYearReturn/*">
			<exception path="/IRenvelope/EndOfYearReturn/P14"/>
		</exclude>
		<exclude path="/IRenvelope/EndOfYearReturn/P14/*"/>
		<exclude path="/IRenvelope/IRheader"/>
	</rules>
</ext:cuttingRules>

<xsl:output method="xml" encoding="UTF-8"/>

<xsl:template match="eoy:IRenvelope">
	<pages>
		<page id="1">
			<keys>
				<key name="Name" default="true">Page 1</key>
			</keys>
			<rules>
				<exclude path="/IRenvelope/*">
					<exception path="/IRenvelope/IRheader"/>
				</exclude>
				<exclude path="/IRenvelope/IRheader/*">
					<exception path="/IRenvelope/IRheader/TestMessage"/>
					<exception path="/IRenvelope/IRheader/Keys"/>
				</exclude>
			</rules>			
		</page>
		<page id="2-3" >
			<keys>
				<key name="Name" default="true">Pages 2 and 3</key>
			</keys>			
			<rules>
				<exclude path="/IRenvelope/EndOfYearReturn/P14/*">
					<exception path="/IRenvelope/EndOfYearReturn/P14/NICs"/>
					<exception path="/IRenvelope/EndOfYearReturn/P14/PayAndTax"/>
					<exception path="/IRenvelope/EndOfYearReturn/P14[position() &gt;= 1 and position() &lt;= 10]/Name"/>			
				</exclude>
				<exclude path="/IRenvelope/EndOfYearReturn/P14/NICs/*">
					<exception path="/IRenvelope/EndOfYearReturn/P14/NICs/Both"/>			
				</exclude>
				<exclude path="/IRenvelope/EndOfYearReturn/P14/PayAndTax/*">
					<exception path="/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp"/>
				</exclude>
				<exclude path="/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/*">
					<exception path="/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/Tax"/>
				</exclude>
				<exclude path="/IRenvelope/IRheader/*">
					<exception path="/IRenvelope/IRheader/TestMessage"/>
				</exclude>	
			</rules>
		</page>
		<page id="4">
			<keys>
				<key name="Name" default="true">Page 4</key>
			</keys>
			<rules>
				<exclude path="/IRenvelope/EndOfYearReturn/P14"/>
			</rules>			
		</page>
	<xsl:for-each select="//eoy:IRenvelope/eoy:EndOfYearReturn/eoy:P14[position()>10]">		
		<xsl:if test="position() mod 25 = 1">
		<xsl:variable name="page" select="(position()-1) div 25 + 5"/>
		
		<page id="{$page}">
			<keys>
				<key name="name" default="true">Continuation Sheet <xsl:value-of select="$page - 4"/></key>
			</keys>
			<rules>
			<exclude path="/IRenvelope/IRheader/*">
				<exception path="/IRenvelope/IRheader/TestMessage"/>
			</exclude>
			<exclude path="/IRenvelope/EndOfYearReturn/P35"/>
			<exclude path="/IRenvelope/EndOfYearReturn/P14[position() &gt;= {($page - 4)*25+11}]"/>
			<exclude path="/IRenvelope/EndOfYearReturn/P14/*">
				<exception path="/IRenvelope/EndOfYearReturn/P14[position() &gt;= {($page - 5)*25+11} and position() &lt;= {($page - 4)*25+10}]/Name"/>
				<exception path="/IRenvelope/EndOfYearReturn/P14[position() &gt;= {($page - 5)*25+11} and position() &lt;= {($page - 4)*25+10}]/NICs"/>
				<exception path="/IRenvelope/EndOfYearReturn/P14[position() &gt;= {($page - 5)*25+11} and position() &lt;= {($page - 4)*25+10}]/PayAndTax"/>
			</exclude>
			<exclude path="/IRenvelope/EndOfYearReturn/P14/NICs/*">
				<exception path="/IRenvelope/EndOfYearReturn/P14/NICs/Both"/>
			</exclude>	
			<exclude path="/IRenvelope/EndOfYearReturn/P14/PayAndTax/*">
				<exception path="/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp"/>
			</exclude>		
			<exclude path="/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/*">
				<exception path="/IRenvelope/EndOfYearReturn/P14/PayAndTax/ThisEmp/Tax"/>
			</exclude>
			</rules>
		</page>
		</xsl:if>
	</xsl:for-each>	
	</pages>
</xsl:template>

</xsl:stylesheet>
