<xsl:stylesheet version="1.1" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext"							  
                              xmlns:eoy="selima:FBI Rendering">							  
<ext:annotation
	rewrite_from_ns="http://www.govtalk.gov.uk/taxation/EOY/08-09/1"
    rewrite_to_ns="selima:FBI Rendering"	
	metadata="P35(base).metadata.xsl"	
/>
<!-- Import -->
<xsl:import href="P35(base).xsl"/>
							  
<!-- Import dependencies -->							  
<xsl:variable name="taxYear">2009</xsl:variable>
<xsl:variable name="page1Size">width: 792px; height: 1123px;</xsl:variable>
<xsl:variable name="page2-3Size">width: 1124px;height: 1587px;</xsl:variable>
<xsl:variable name="page4Size">width: 794px;height: 1124px;</xsl:variable>
<xsl:variable name="csPageSize">width: 793px;height: 1124px;</xsl:variable>							  
						
<!-- Outer dependencies -->
<xsl:param name="url">../P14/2008-eoy-p14part-selfcreated.xml?</xsl:param>
<xsl:param name="issueDate.day">30</xsl:param>
<xsl:param name="issueDate.month">3</xsl:param>
<xsl:param name="issueDate.year">2009</xsl:param>

<!-- Helpers -->
<xsl:variable name="iRenvelope" select="//eoy:IRenvelope"/>
<xsl:variable name="p35" select="$iRenvelope/eoy:EndOfYearReturn/eoy:P35"/>
<xsl:variable name="p14s" select="$iRenvelope/eoy:EndOfYearReturn/eoy:P14"/>

<xsl:template name="page1">
		<xsl:comment> Please return to</xsl:comment>
		<div style="left: 152px;top: 144px;width: 150px">
		Known by HMRC
		</div>	

		<xsl:comment> Employer PAYE reference</xsl:comment>
		<div style="left: 194px;top: 315px;width: 50px;text-align: right">
			&#160;	
			<xsl:value-of select="$iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeNumber']"/>			
		</div>		
		<div style="left: 256px;top: 315px;width: 90px;">			
			<xsl:value-of select="$iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeReference']"/>
			&#160;				
		</div>	
		
		<xsl:comment> HMRC office phone number</xsl:comment>
		<div style="left: 220px;top: 338px;width: 150px">
		Known by HMRC
		</div>			
		
		<xsl:comment> Your reference</xsl:comment>
		<div style="left: 547px;top: 317px;width: 150px">
			Not Applicable
		</div>			
				
		<xsl:comment>Accounts Office reference</xsl:comment>
		<div style="left: 547px;top: 340px;width: 150px">
		Known by HMRC 
		</div>					
</xsl:template>

<xsl:template name="page2-3Employee">
	<xsl:variable name="y-offset" select="234+(position()-1)*22.3"/> 
	<xsl:comment>Employee name</xsl:comment>
	<xsl:comment>Put an asterisk (*) by the name if the person is a director</xsl:comment>
	<div style="left:60px;top: {$y-offset}px;width:260px">			
		<a href="{concat($url,'&amp;transformation=/templates/PAYE/P14(2009).xsl&amp;page=', position())}"> 					
			<xsl:value-of select="eoy:Name/eoy:Sur"/>
			<xsl:for-each select="eoy:Name/eoy:Fore">&#160;<xsl:value-of select="."/></xsl:for-each>
		</a>			
	</div>
	<xsl:comment>National Insurance contributions (NICs)</xsl:comment>
	<xsl:comment>Enter the total NICs from column 1d on form P11. 
				 Write 'R' beside any minus amounts</xsl:comment>
	<div style="left:420px;top: {$y-offset}px;width:105px;text-align:right">						
		<xsl:value-of select="format-number(sum(eoy:NICs/eoy:Both),'#0.00')"/>
	</div>
	<div style="left:530px;top: {$y-offset}px;width:12px">								
		<xsl:choose>
			<xsl:when test="sum(eoy:NICs/eoy:Both) &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>
	<xsl:comment>Income Tax deducted or refunded</xsl:comment>
	<xsl:comment>in this employment. Write 'R' beside an amount to show a net refund</xsl:comment>
	<div style="left:722px;top: {$y-offset}px;width:104px;text-align:right">						
		<xsl:value-of select="eoy:PayAndTax/eoy:ThisEmp/eoy:Tax"/>
	</div>		
	<div style="left:832px;top: {$y-offset}px;width:12px">								
		<xsl:choose>
			<xsl:when test="eoy:PayAndTax/eoy:ThisEmp/eoy:Tax &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>
</xsl:template>

<xsl:template name="page2-3">
  	<xsl:processing-instruction name="printing-details">
    	<xsl:text>mode=two-page-landscape divider=796</xsl:text>
  	</xsl:processing-instruction>	

	<xsl:comment>(1) Total NIC shown above </xsl:comment>
	<div style="left:421px;top: 484px;width:74px;text-align:right">
		<xsl:value-of select="substring-before(format-number(sum($p14s[position() &lt;= 10]/eoy:NICs/eoy:Both),'0.00'),'.')"/>
	</div>
	<div style="left:500px;top: 484px;width:25px;text-align:right">						
		<xsl:value-of select="substring-after(format-number(sum($p14s[position() &lt;= 10]/eoy:NICs/eoy:Both),'0.00'),'.')"/>
	</div>									
	<div style="left:531px;top: 484px;width:12px">								
		<xsl:choose>
			<xsl:when test="sum($p14s[position() &lt;= 10]/eoy:NICs/eoy:Both) &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>	
	<xsl:comment>(2) Totals from P35(CS) </xsl:comment>
	<div style="left:420px;top: 524px;width:75px;text-align:right">						
		<xsl:value-of select="substring-before(format-number(sum($p14s[position() &gt; 10]/eoy:NICs/eoy:Both),'0.00'),'.')"/>
	</div>
	<div style="left:500px;top: 524px;width:25px;text-align:right">						
		<xsl:value-of select="substring-after(format-number(sum($p14s[position() &gt; 10]/eoy:NICs/eoy:Both),'0.00'),'.')"/>
	</div>	
	<div style="left:531px;top: 524px;width:12px">								
		<xsl:choose>
			<xsl:when test="sum($p14s[position() &gt; 10]/eoy:NICs/eoy:Both) &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>			
	<xsl:comment>(4) Total TAX shown above </xsl:comment>
	<div style="left:718px;top: 485px;width:76px;text-align:right">						
		<xsl:value-of select="substring-before(format-number(sum($p14s[position() &lt;= 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax),'0.00'),'.')"/>
	</div>
	<div style="left:799px;top: 485px;width:25px;text-align:right">						
		<xsl:value-of select="substring-after(format-number(sum($p14s[position() &lt;= 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax),'0.00'),'.')"/>
	</div>									
	<div style="left:829px;top: 485px;width:12px">								
		<xsl:choose>
			<xsl:when test="sum($p14s[position() &lt;= 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax) &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>					
	<xsl:comment>(5) Totals from P35(CS) </xsl:comment>
	<div style="left:718px;top: 524px;width:76px;text-align:right">						
		<xsl:value-of select="substring-before(format-number(sum($p14s[position() &gt; 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax),'0.00'),'.')"/>
	</div>
	<div style="left:799px;top: 524px;width:25px;text-align:right">						
		<xsl:value-of select="substring-after(format-number(sum($p14s[position() &gt; 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax),'0.00'),'.')"/>
	</div>	
	<div style="left:829px;top: 524px;width:12px">								
		<xsl:choose>
			<xsl:when test="sum($p14s[position() &gt; 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax) &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>					
	
	<xsl:comment> Part2 Summary of payments for the year </xsl:comment>
	
	<xsl:comment>(3) Total NICs 1 + 2 </xsl:comment>
	<div style="left: 421px;top: 586px;width: 74px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:NIC/eoy:TotalNIC,'0.00'),'.')"/>			
	</div>
	<div style="left: 500px;top: 586px;width: 24px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:TotalNIC, '0.00'),'.')"/>			
	</div>		
	<div style="left: 529px;top: 586px;width:12px">								
		<xsl:choose>
			<xsl:when test="$p35/eoy:Summary/eoy:NIC/eoy:TotalNIC &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>			
	<xsl:comment>(6) Total tax 4 + 5 </xsl:comment>
	<div style="left: 719px;top: 586px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:PAYE/eoy:P14Tax,'0.00'),'.')"/>			
	</div>
	<div style="left: 799px;top: 586px;width: 24px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:PAYE/eoy:P14Tax, '0.00'),'.')"/>			
	</div>		
	<div style="left: 829px;top: 586px;width:12px">								
		<xsl:choose>
			<xsl:when test="$p35/eoy:Summary/eoy:PAYE/eoy:P14Tax &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>			
	
	<xsl:comment>(7) Advance received from HM Revenue &amp; Customs to refund tax</xsl:comment>
	<div style="left: 719px;top: 634px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:PAYE/eoy:TaxAdvance,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=taxAdvance editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>						
	</div>
	<div style="left: 799px;top: 634px;width: 25px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:PAYE/eoy:TaxAdvance, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=taxAdvance editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>												
	</div>		
	
	<xsl:comment>(8) Total Tax 6 + 7</xsl:comment>
	<div style="left: 719px;top: 716px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:PAYE/eoy:TotalTax,'0.00'),'.')"/>
		<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalTax editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>		
	</div>
	<div style="left: 799px;top: 716px;width: 24px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:PAYE/eoy:TotalTax, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalTax editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>								
	</div>	
	<xsl:comment>(9) Total NICs and Tax 3 + 8 </xsl:comment>
	<div style="left: 558px;top: 776px;width: 74px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalTaxAndNIC,'0.00'),'.')"/>
		<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalTaxAndNIC editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>						
	</div>
	<div style="left: 639px;top: 776px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalTaxAndNIC, '0.00'),'.')"/>
		<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalTaxAndNIC editor=FractionPartField </xsl:text>
	  	</xsl:processing-instruction>												
	</div>		
	<xsl:comment>(10) Total Student Loan deductions </xsl:comment>
	<div style="left: 557px;top: 810px;width: 74px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:StudentLoan,'0.00'),'.')"/>			
	</div>
	<xsl:comment>(11) 9 + 10</xsl:comment>
	<div style="left: 558px;top: 851px;width: 74px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalNICsTaxAndStudentLoan,'0.00'),'.')"/>
		<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalNICsTaxAndStudentLoan editor=IntegerPartField </xsl:text>
	  	</xsl:processing-instruction>									
	</div>
	<div style="left: 638px;top: 851px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalNICsTaxAndStudentLoan, '0.00'),'.')"/>
		<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalNICsTaxAndStudentLoan editor=FractionPartField </xsl:text>
	  	</xsl:processing-instruction>							
	</div>			
	<xsl:comment>Statutory payments recovered</xsl:comment>
	<xsl:comment>(12) Statutory Sick Pay (SSP) recovered </xsl:comment>
	<div style="left: 209px;top: 900px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:NIC/eoy:SSP,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=sspRecovered editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<div style="left: 290px;top: 900px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SSP, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=sspRecovered editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>													
	</div>	
	<xsl:comment>(13) Statutory Maternity Pay (SMP) recovered </xsl:comment>
	<div style="left: 209px;top: 932px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:NIC/eoy:SMP,'0.00'),'.')"/>
	</div>
	<div style="left: 290px;top: 932px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SMP, '0.00'),'.')"/>
	</div>			
	<xsl:comment>(14) NIC compensation on SMP</xsl:comment>
	<div style="left: 209px;top: 965px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:NIC/eoy:SMPcompensation,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=smpCompensation editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>													
	</div>
	<div style="left: 290px;top: 965px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SMPcompensation, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=smpCompensation editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>			
	<xsl:comment>(15) Statutory Paterninty Pay (SPP) recovered </xsl:comment>
	<div style="left: 209px;top: 999px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:NIC/eoy:SPP,'0.00'),'.')"/>
	</div>
	<div style="left: 290px;top: 999px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SPP, '0.00'),'.')"/>
	</div>
	<xsl:comment>(16) NIC compensation on SPP </xsl:comment>
	<div style="left: 209px;top: 1032px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:NIC/eoy:SPPcompensation,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=sppCompensation editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<div style="left: 290px;top: 1032px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SPPcompensation, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=sppCompensation editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>		
	<xsl:comment>(17) Statutory Adoption Pay (SAP) recovered</xsl:comment>
	<div style="left: 209px;top: 1065px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:NIC/eoy:SAP,'0.00'),'.')"/>
	</div>
	<div style="left: 290px;top: 1065px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SAP, '0.00'),'.')"/>
	</div>			
	<xsl:comment>(18) NIC compensation on SAP</xsl:comment>
	<div style="left: 209px;top: 1098px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:NIC/eoy:SAPcompensation,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=sapCompensation editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<div style="left: 290px;top: 1098px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SAPcompensation, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=sapCompensation editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>					
	<xsl:comment>(19) Total of boxes 12 - 18</xsl:comment>
	<div style="left: 209px;top: 1133px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetStatutoryPaymentsRecovered + $p35/eoy:Summary/eoy:NIC/eoy:SSPSMPSPPandSAPfunding,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=netStatutoryPaymentsRecoveredPlusSspSmpSppAndSapFunding editor=IntegerPartField </xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<div style="left: 290px;top: 1133px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetStatutoryPaymentsRecovered + $p35/eoy:Summary/eoy:NIC/eoy:SSPSMPSPPandSAPfunding, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=netStatutoryPaymentsRecoveredPlusSspSmpSppAndSapFunding editor=FractionPartField </xsl:text>
	  	</xsl:processing-instruction>						
	</div>
	<xsl:comment>(20) Funding received from HM Revenue &amp; Customs to pay SSP/SMP/SPP/SAP</xsl:comment>
	<div style="left: 209px;top: 1167px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:NIC/eoy:SSPSMPSPPandSAPfunding,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=sspSmpSppAndSapFunding editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<div style="left: 290px;top: 1167px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SSPSMPSPPandSAPfunding, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=sspSmpSppAndSapFunding editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>													
	</div>		
	<xsl:comment>(21) 19 minus 20</xsl:comment>
	<div style="left: 556px;top: 1166px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetStatutoryPaymentsRecovered,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=netStatutoryPaymentsRecovered editor=IntegerPartField </xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<div style="left: 637px;top: 1166px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetStatutoryPaymentsRecovered,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=netStatutoryPaymentsRecovered editor=FractionPartField </xsl:text>
	  	</xsl:processing-instruction>													
	</div>	
	<xsl:comment>(22) 11 minus 21</xsl:comment>
	<div style="left: 556px;top: 1198px;width: 76px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:CombinedLessStatutoryRecovered,'0.00'),'.')"/>
		<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=combinedLessStatutoryRecovered editor=IntegerPartField </xsl:text>
	  	</xsl:processing-instruction>	
	</div>
	<div style="left: 637px;top: 1198px;width: 24px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:CombinedLessStatutoryRecovered,'0.00'),'.')"/>
		<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=combinedLessStatutoryRecovered editor=FractionPartField </xsl:text>
	  	</xsl:processing-instruction>							
	</div>			
	<xsl:comment>(23) Deductions made from subcontractors </xsl:comment>
	<div style="left: 557px;top: 1324px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:SubcontractorTax,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=subcontractorTax editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>													
	</div>
	<div style="left: 638px;top: 1324px;width: 24px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:SubcontractorTax, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=subcontractorTax editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<xsl:comment>(24) Amount payable for the year [22 + 23]</xsl:comment>
	<div style="left: 557px;top: 1359px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalPayable,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalPayable editor=IntegerPartField </xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<div style="left: 635px;top: 1359px;width: 24px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalPayable, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalPayable editor=FractionPartField </xsl:text>
	  	</xsl:processing-instruction>													
	</div>
	<xsl:comment>(25) NICs and Tax paid already</xsl:comment>
	<div style="left: 557px;top: 1396px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalPaid,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalPaid editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<div style="left: 638px;top: 1396px;width: 24px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalPaid, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalPaid editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>	
	<xsl:comment>(26) Tax-free Incentive payment received during the year</xsl:comment>
	<div style="left: 557px;top: 1431px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:IncentivePayment,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=incentivePayment editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<div style="left: 638px;top: 1431px;width: 24px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:IncentivePayment, '0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=incentivePayment editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>		
	<xsl:comment>(27) NOW PAYABLE [24 minus 25 and 26]</xsl:comment>
	<div style="left: 557px;top: 1472px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalRemainingToPay,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalRemainingToPay editor=IntegerPartField </xsl:text>
	  	</xsl:processing-instruction>													
	</div>
	<div style="left: 638px;top: 1472px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalRemainingToPay,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalRemainingToPay editor=FractionPartField </xsl:text>
	  	</xsl:processing-instruction>													
	</div>			
	<xsl:comment>(28) CIS deductions suffered [Total of col E from CIS 132]</xsl:comment>
	<div style="left: 557px;top: 1509px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:CISdeductions,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=cisDeductions editor=IntegerPartField</xsl:text>
	  	</xsl:processing-instruction>							
	</div>
	<div style="left: 638px;top: 1509px;width: 24px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:CISdeductions,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=cisDeductions editor=FractionPartField</xsl:text>
	  	</xsl:processing-instruction>													
	</div>
	<xsl:comment>(29) Revised amount now payable [27 minus 28]</xsl:comment>
	<div style="left: 557px;top: 1540px;width: 75px;text-align: right">			
			<xsl:value-of select="substring-before(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalAfterCISdeductions,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalAfterCISdeductions editor=IntegerPartField </xsl:text>
	  	</xsl:processing-instruction>													
	</div>
	<div style="left: 638px;top: 1540px;width: 23px;text-align: right">			
			<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalAfterCISdeductions,'0.00'),'.')"/>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=totalAfterCISdeductions editor=FractionPartField </xsl:text>
	  	</xsl:processing-instruction>													
	</div>
</xsl:template>

<xsl:template name="page4">
	<xsl:comment>Part 3 Checklist</xsl:comment>
	<xsl:comment>1 Have you send a form P14, End of Year Summary or completed and retained a form P38(S), Student employees for every person in your  paid employement, either on a casual basis or otherwise, during the tax year shown on the front of this form?</xsl:comment>
	<div style="left: 85px;top: 155px;width:12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:CompletedEndOfYearSummary) = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=completedEndOfYearSummary editor=YesNoBox params="no;yes"</xsl:text>
	  	</xsl:processing-instruction>		
	</div>
	<div style="left: 145px;top: 155px;width: 12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:CompletedEndOfYearSummary) = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
		<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=completedEndOfYearSummary editor=YesNoBox</xsl:text>
	  </xsl:processing-instruction>						
	</div>
	<xsl:comment>2 Did you make any  'free of tax' payments to an employee? In other words, did you bear any of the tax yourself rather then deduct it from the employee?</xsl:comment>			
	<div style="left: 85px;top: 284px;width:12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:FreeOfTaxPayments) = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=freeOfTaxPayments editor=YesNoBox params="no;yes"</xsl:text>
	  	</xsl:processing-instruction>			
	</div>		
	<div style="left: 145px;top: 284px;width: 12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:FreeOfTaxPayments) = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=freeOfTaxPayments editor=YesNoBox</xsl:text>
	  	</xsl:processing-instruction>				
	</div>
	<xsl:comment>3 So far as you know, did anyone else pay expense, or in any way provide vouchers or benefits to any of your employees whilst they were employed by you during the year?</xsl:comment>
	<div style="left: 85px;top: 395px;width:12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:ExpensesOrBenefits) = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
		<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=expensesOrBenefits editor=YesNoBox params="no;yes"</xsl:text>
	  	</xsl:processing-instruction>						
	</div>
	<div style="left: 145px;top: 395px;width: 12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:ExpensesOrBenefits) = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=expensesOrBenefits editor=YesNoBox</xsl:text>
	  	</xsl:processing-instruction>						
	</div>
	<xsl:comment>4 Did anyone employed by a person or company outside the UK work for you in the UK for 30 or more days in a row?</xsl:comment>
	<div style="left: 443px;top: 123px;width:13px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:EmployeesOutOfUK) = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=employeesOutOfUK editor=YesNoBox params="no;yes"</xsl:text>
	  	</xsl:processing-instruction>			
	</div>
	<div style="left: 503px;top: 123px;width: 12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:EmployeesOutOfUK) = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=employeesOutOfUK editor=YesNoBox</xsl:text>
	  	</xsl:processing-instruction>						
	</div>
	<xsl:comment>If 'Yes', have you send a form P14 for them?</xsl:comment>	
	<div style="left: 443px;top: 164px;width:13px" class="checkbox">
		<xsl:choose>
		<xsl:when test="$p35/eoy:CheckList/eoy:EmployeesOutOfUK/@IsIncluded = 'no'">x</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=employeesOutOfUKIncluded editor=YesNoBox params="no;yes"</xsl:text>
	  	</xsl:processing-instruction>			
	</div>
	<div style="left: 503px;top: 164px;width: 12px" class="checkbox">
		<xsl:choose>
		<xsl:when test="$p35/eoy:CheckList/eoy:EmployeesOutOfUK/@IsIncluded = 'yes'">x</xsl:when>
		<xsl:otherwise>x&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=employeesOutOfUKIncluded editor=YesNoBox</xsl:text>
	  	</xsl:processing-instruction>				
	</div>			
	<xsl:comment>5 Have you paid any of an employee's pay to someone other then the employee, for example, to a school?</xsl:comment>				
	<div style="left: 443px;top: 247px;width:13px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:EmployeesPayToThirdParty) = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=employeesPayToThirdParty editor=YesNoBox params="no;yes"</xsl:text>
	  	</xsl:processing-instruction>			
	</div>
	<div style="left: 503px;top: 247px;width: 12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:EmployeesPayToThirdParty) = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=employeesPayToThirdParty editor=YesNoBox</xsl:text>
	  	</xsl:processing-instruction>					
	</div>
	<xsl:comment>If 'Yes', have you included this pay on their form P14?</xsl:comment>		
	<div style="left: 443px;top: 289px;width:13px" class="checkbox">
		<xsl:choose>
		<xsl:when test="$p35/eoy:CheckList/eoy:EmployeesPayToThirdParty/@IsIncluded = 'no'">x</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=employeesPayToThirdPartyIncluded editor=YesNoBox params="no;yes"</xsl:text>
	  	</xsl:processing-instruction>			
	</div>
	<div style="left: 503px;top: 289px;width: 12px" class="checkbox">
		<xsl:choose>
		<xsl:when test="$p35/eoy:CheckList/eoy:EmployeesPayToThirdParty/@IsIncluded = 'yes'">x</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
		<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=employeesPayToThirdPartyIncluded editor=YesNoBox</xsl:text>
	  	</xsl:processing-instruction>						
	</div>		
	<xsl:comment>6 Are you a Service Company?</xsl:comment>					
	<div style="left: 441px;top: 345px;width:13px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:ServicePayments) = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=servicePayments editor=YesNoBox params="no;yes"</xsl:text>
	  	</xsl:processing-instruction>			
	</div>					
	<div style="left: 503px;top: 344px;width: 12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:CheckList/eoy:ServicePayments) = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=servicePayments editor=YesNoBox</xsl:text>
	  	</xsl:processing-instruction>						
	</div>
	<xsl:comment>If 'Yes', have you operated the Intermediaries legislation (sometimes known as IR35) or the Managed Service Compaines legislation?</xsl:comment>
	<div style="left: 443px;top: 416px;width:13px" class="checkbox">
		<xsl:choose>
		<xsl:when test="$p35/eoy:CheckList/eoy:ServicePayments/@IsIncluded = 'no'">x</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=servicePaymentsIncluded editor=YesNoBox params="no;yes"</xsl:text>
	  	</xsl:processing-instruction>											
	</div>	
	<div style="left: 503px;top: 416px;width: 12px" class="checkbox">
		<xsl:choose>
		<xsl:when test="$p35/eoy:CheckList/eoy:ServicePayments/@IsIncluded = 'yes'">x</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=servicePaymentsIncluded editor=YesNoBox</xsl:text>
	  	</xsl:processing-instruction>			
	</div>			
	<xsl:comment>Part 4 Contracted out pension schemes [if applicable]</xsl:comment>
	<xsl:comment>If you have a Contracted-out pension scheme, enter your Employer's Contracted-out number (ECON) from your contracting-out certificate</xsl:comment>
	<div style="left:539px;top: 534px;width: 12px" class="large-text">
		<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,3,1)"/>
	</div>
	<div style="left:569px;top: 534px;width: 12px" class="large-text">
		<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,4,1)"/>
	</div>	
	<div style="left:599px;top: 534px;width: 12px" class="large-text">
		<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,5,1)"/>
	</div>	
	<div style="left:629px;top: 534px;width: 12px" class="large-text">
		<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,6,1)"/>
	</div>	
	<div style="left:659px;top: 534px;width: 12px" class="large-text">
		<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,7,1)"/>
	</div>	
	<div style="left:689px;top: 534px;width: 12px" class="large-text">
		<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,8,1)"/>
	</div>	
	<div style="left:718px;top: 534px;width: 12px" class="large-text">
		<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,9,1)"/>
	</div>	
	<xsl:comment>Part 5 Employer's certificate and declaration</xsl:comment>
	<xsl:comment>forms P14, End of Year Summary for each employee or director for whom I was required to complete a form P11 Deductions Working Sheet (or equivalent record) during the year</xsl:comment>
	<xsl:comment>are all enclosed</xsl:comment>
	<div style="left: 200px;top: 690px;width: 12px" class="checkbox">
		<xsl:choose>
		<xsl:when test="$iRenvelope/eoy:EndOfYearReturn/eoy:SubmissionType='complete'">x</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>		
	</div>			
	<xsl:comment>or have been sent separately in one or more parts</xsl:comment>
	<div style="left: 202px;top: 750px;width: 12px" class="checkbox">
		<xsl:choose>
		<xsl:when test="$iRenvelope/eoy:EndOfYearReturn/eoy:SubmissionType='P35Part'">x</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>					
	<xsl:comment>If forms P14 have been sent in more then one part, please state the number of parts sent. For more detailed information, see the Do it online - Online filling and electronic payment handbook</xsl:comment>
	<div style="left: 649px;top: 720px;width: 59px;text-align:right">
		 &#160;<xsl:value-of select="$iRenvelope/eoy:EndOfYearReturn/eoy:NumberOfParts"/>
		<xsl:if test="$iRenvelope/eoy:EndOfYearReturn/eoy:SubmissionType = 'P35Part'">
		  	<xsl:processing-instruction name="editor">
		    	<xsl:text>property=numberOfParts editor=IntField</xsl:text>
		  	</xsl:processing-instruction>
	  	</xsl:if>		
	</div>		
	<xsl:comment>Completed form P38A, Employer's Supplementary Return</xsl:comment>
	<xsl:comment>is enclosed</xsl:comment>
	<div style="left:266px;top: 807px;width: 12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:Declarations/eoy:P38Adeclaration) = 'are not due'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=p38Adeclaration editor=StringCheckBox params="are not due;are due"</xsl:text>
	  	</xsl:processing-instruction>			
	</div>
	<xsl:comment>Completed forms P11D and P11D(b), Returns of expenses payments, benefits and Class 1A contributions</xsl:comment>
	<xsl:comment>are due</xsl:comment>
	<div style="left:143px;top: 864px;width: 12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:Declarations/eoy:P11Ddeclaration) = 'are due'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=p11Ddeclaration editor=StringCheckBox params="are due;are not due"</xsl:text>
	  	</xsl:processing-instruction>			
	</div>	 
	<xsl:comment>are not due</xsl:comment>
	<div style="left:266px;top: 864px;width: 12px" class="checkbox">
		<xsl:choose>
			<xsl:when test="string($p35/eoy:Declarations/eoy:P11Ddeclaration) = 'are not due'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	  	<xsl:processing-instruction name="editor">
	    	<xsl:text>path=getP35() property=p11Ddeclaration editor=StringCheckBox params="are not due;are due"</xsl:text>
	  	</xsl:processing-instruction>			
	</div>		
	<xsl:comment>Employer's signature</xsl:comment>		
	<div style="left:54px;top: 956px;width: 305px;text-align:center">
		Not Applicable
	</div>		
	<xsl:comment>Please print your name</xsl:comment>
	<div style="left:55px;top: 1015px;width: 305px;text-align:center">
		<xsl:choose>
		<xsl:when test="//eoy:IRheader/eoy:Agent">
			<xsl:value-of select="//eoy:IRheader/eoy:Agent/eoy:Contact/eoy:Name/eoy:Ttl"/>			
			<xsl:for-each select="//eoy:IRheader/eoy:Agent/eoy:Contact/eoy:Name/eoy:Fore">
				&#160;<xsl:value-of select="."/>
			</xsl:for-each>
			&#160;			
			<xsl:value-of select="//eoy:IRheader/eoy:Agent/eoy:Contact/eoy:Name/eoy:Sur"/>						
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="//eoy:IRheader/eoy:Principal/eoy:Contact/eoy:Name/eoy:Ttl"/>			
			<xsl:for-each select="//eoy:IRheader/eoy:Principal/eoy:Contact/eoy:Name/eoy:Fore">
				&#160;<xsl:value-of select="."/>
			</xsl:for-each>
			&#160;			
			<xsl:value-of select="//eoy:IRheader/eoy:Principal/eoy:Contact/eoy:Name/eoy:Sur"/>			
		</xsl:otherwise>
		</xsl:choose>			
	</div>
	<xsl:comment>Capacity in which signed</xsl:comment>		
	<div style="left:55px;top: 1071px;width: 305px;text-align:center">
		<xsl:value-of select="//eoy:IRheader/eoy:Sender"/>
	</div>		
	<xsl:comment>Date</xsl:comment>
	<div style="left:445px;top: 952px;width: 28px;text-align:center">
		<xsl:value-of select="$issueDate.month"/>		
	</div>
	<div style="left:486px;top: 952px;width: 52px;text-align:center">
		<xsl:value-of select="$issueDate.day"/>				
	</div>		
	<div style="left:549px;top: 952px;width: 50px;text-align:center">
		<xsl:value-of select="$issueDate.year"/>				
	</div>		
	<xsl:comment>Please give a daytime telephone number. It will help speed things up if we need to talk to you about your return.</xsl:comment>
	<div style="left:433px;top: 1040px;width: 306px;text-align:center">
		<xsl:choose>
		<xsl:when test="//eoy:IRheader/eoy:Agent">
		&#160;<xsl:value-of select="//eoy:IRheader/eoy:Agent/eoy:Contact/eoy:Name/eoy:Telephone"/>
		</xsl:when>
		<xsl:otherwise>
		&#160;<xsl:value-of select="//eoy:IRheader/eoy:Principal/eoy:Contact/eoy:Name/eoy:Telephone"/>			
		</xsl:otherwise>
		</xsl:choose>
	</div>		
</xsl:template>

<xsl:template name="csPageEmployee">
	<xsl:param name="first"/>
	<xsl:comment><xsl:value-of select="name()"/> for <xsl:value-of select="eoy:Name"/> </xsl:comment>
	<xsl:variable name="y-offset" select="195+(position()-1)*32"/> 
	<div style="left:67px;top: {$y-offset}px;width:226px">
		<a href="{concat($url,'&amp;transformation=/templates/PAYE/P14(2009).xsl&amp;page=',$first + position())}"> 					
			<xsl:value-of select="eoy:Name/eoy:Sur"/>
			<xsl:for-each select="eoy:Name/eoy:Fore">&#160;<xsl:value-of select="."/></xsl:for-each>
		</a>
	</div>
	<div style="left:324px;top: {$y-offset}px;width:80px;text-align:right">
		<xsl:choose>
			<xsl:when test="eoy:NICs/eoy:Both">						
				<xsl:value-of select="substring-before(format-number(sum(eoy:NICs/eoy:Both),'0.00'),'.')"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>		
	</div>
	<div style="left:413px;top: {$y-offset}px;width:28px;text-align:right">
		<xsl:choose>
			<xsl:when test="eoy:NICs/eoy:Both">								
				<xsl:value-of select="substring-after(format-number(sum(eoy:NICs/eoy:Both),'0.00'),'.')"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>			
	</div>					
	<div style="left:448px;top: {$y-offset}px;width:12px">								
		<xsl:choose>
			<xsl:when test="sum(eoy:NICs/eoy:Both) &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>
	<div style="left:469px;top: {$y-offset}px;width:83px;text-align:right">						
		<xsl:value-of select="substring-before(format-number(eoy:PayAndTax/eoy:ThisEmp/eoy:Tax,'0.00'),'.')"/>
	</div>					
	<div style="left:559px;top: {$y-offset}px;width:28px;text-align:right">						
		<xsl:value-of select="substring-after(format-number(eoy:PayAndTax/eoy:ThisEmp/eoy:Tax,'0.00'),'.')"/>
	</div>										
	<div style="left:594px;top: {$y-offset}px;width:12px">								
		<xsl:choose>
			<xsl:when test="eoy:PayAndTax/eoy:ThisEmp/eoy:Tax &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>	
</xsl:template>

<xsl:template name="csPage">
 	<xsl:param name="pageP14"/>
	<xsl:comment>Totals carried to box 2 of form P35 after deducting amounts marked 'R'</xsl:comment>				
	<div style="left:324px;top: 1005px;width:80px;text-align:right">				
		<xsl:value-of select="substring-before(format-number(sum($pageP14/eoy:NICs/eoy:Both),'0.00'),'.')"/>
	</div>
	<div style="left:413px;top: 1005px;width:28px;text-align:right">						
		<xsl:value-of select="substring-after(format-number(sum($pageP14/eoy:NICs/eoy:Both),'0.00'),'.')"/>
	</div>			
	<xsl:comment>Totals carried to box 5 of form P35 after deducting amounts marked 'R'</xsl:comment>
	<div style="left:470px;top: 1005px;width:82px;text-align:right">				
		<xsl:value-of select="substring-before(format-number(sum($pageP14/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax),'0.00'),'.')"/>
	</div>
	<div style="left:560px;top: 1005px;width:28px;text-align:right">						
		<xsl:value-of select="substring-after(format-number(sum($pageP14/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax),'0.00'),'.')"/>
	</div>					
</xsl:template>

</xsl:stylesheet>
