<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext"							  
                              xmlns:eoy="selima:FBI Rendering">
<ext:annotation
	rewrite_from_ns="http://www.govtalk.gov.uk/taxation/EOY"
    rewrite_to_ns="selima:FBI Rendering"	
	metadata="P35(base).metadata.xsl"	
/>								  
<!-- Import -->
<xsl:import href="P35(base).xsl"/>
							  
<!-- Import dependencies -->							  
<xsl:variable name="taxYear">2006</xsl:variable>
<xsl:variable name="page1Size">width: 788px; height: 1133px</xsl:variable>
<xsl:variable name="page2-3Size">width: 1152px;height: 1582px</xsl:variable>
<xsl:variable name="page4Size">width: 784px;height: 1115px</xsl:variable>
<xsl:variable name="csPageSize">width: 793px;height: 1124px</xsl:variable>							  

<!-- Outer dependencies -->
<xsl:param name="url">../P14/2006-eoy-p14part.xml?</xsl:param>
<xsl:param name="issueDate.day">30</xsl:param>
<xsl:param name="issueDate.month">3</xsl:param>
<xsl:param name="issueDate.year">2006</xsl:param>

<!-- Helpers -->
<xsl:variable name="iRenvelope" select="//eoy:IRenvelope"/>
<xsl:variable name="p35" select="$iRenvelope/eoy:EndOfYearReturn/eoy:P35"/>
<xsl:variable name="p14s" select="$iRenvelope/eoy:EndOfYearReturn/eoy:P14"/>
	
<xsl:template name="page1">
		<xsl:comment> Please return to</xsl:comment>
		<div style="left: 150px;top: 143px;width: 150px">
		Known by HMRC
		</div>	
	
		<xsl:comment> Tax office number </xsl:comment>
		<div style="left: 190px;top: 314px;width: 50px;text-align: right">
			&#160;	
			<xsl:value-of select="$iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeNumber']"/>			
		</div>
		
		<xsl:comment> Tax office reference </xsl:comment>
		<div style="left: 250px;top: 314px;width: 90px;">			
			<xsl:value-of select="$iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeReference']"/>
			&#160;				
		</div>	
		
		<xsl:comment> Inland Revenue office telephone no.</xsl:comment>
		<div style="left: 240px;top: 338px;width: 150px">
		Known by HMRC
		</div>			
		
		<xsl:comment> Your reference</xsl:comment>
		<div style="left: 545px;top: 314px;width: 150px">
			Not Applicable
		</div>			
				
		<xsl:comment>Accounts Office reference</xsl:comment>
		<div style="left: 545px;top: 338px;width: 150px">
		Known by HMRC 
		</div>			
</xsl:template>

<xsl:template name="page2-3Employee">
		<xsl:variable name="y-offset" select="230+(position()-1)*22.5"/> 
		<div style="left:70px;top: {$y-offset}px;width:258px">			
			<a href="{concat($url,'&amp;transformation=/templates/PAYE/P14(2006).xsl&amp;page=', position())}"> 					
				<xsl:value-of select="eoy:Name/eoy:Sur"/>
				<xsl:for-each select="eoy:Name/eoy:Fore">&#160;<xsl:value-of select="."/></xsl:for-each>
			</a>			
		</div>
		<div style="left:428px;top: {$y-offset}px;width:105px;text-align:right">						
			<xsl:value-of select="sum(eoy:NICs/eoy:Both)"/>
		</div>
		<div style="left:540px;top: {$y-offset}px;width:12px">								
			<xsl:choose>
				<xsl:when test="sum(eoy:NICs/eoy:Both) &lt; 0">R</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>
		<div style="left:734px;top: {$y-offset}px;width:100px;text-align:right">						
			<xsl:value-of select="eoy:PayAndTax/eoy:ThisEmp/eoy:Tax"/>
		</div>
		
		<div style="left:840px;top: {$y-offset}px;width:12px">								
			<xsl:choose>
				<xsl:when test="eoy:PayAndTax/eoy:ThisEmp/eoy:Tax &lt; 0">R</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>				
</xsl:template>

<xsl:template name="page2-3">
		<xsl:comment>(1) Total NIC shown above </xsl:comment>
		<div style="left:430px;top: 480px;width:74px;text-align:right">						
			<xsl:value-of select="format-number(floor(sum($p14s[position() &lt; 10]/eoy:NICs/eoy:Both)),'#0')"/>
		</div>
		<div style="left:510px;top: 480px;width:23px;text-align:right">						
			<xsl:value-of select="substring-after(format-number(sum($p14s[position() &lt; 10]/eoy:NICs/eoy:Both),'0.00'),'.')"/>
		</div>									
		<div style="left:540px;top: 480px;width:12px">								
			<xsl:choose>
				<xsl:when test="sum($p14s[position() &lt; 10]/eoy:NICs/eoy:Both) &lt; 0">R</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>	
		<xsl:comment>(2) Total NIC from P35(CS) </xsl:comment>
		<div style="left:430px;top: 520px;width:74px;text-align:right">						
			<xsl:value-of select="format-number(floor(sum($p14s[position() &gt; 10]/eoy:NICs/eoy:Both)),'#0')"/>
		</div>
		<div style="left:510px;top: 520px;width:23px;text-align:right">						
			<xsl:value-of select="substring-after(format-number(sum($p14s[position() &gt; 10]/eoy:NICs/eoy:Both),'0.00'),'.')"/>
		</div>	
		<div style="left:540px;top: 520px;width:12px">								
			<xsl:choose>
				<xsl:when test="sum($p14s[position() &gt; 10]/eoy:NICs/eoy:Both) &lt; 0">R</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>			
		<xsl:comment>(4) Total TAX shown above </xsl:comment>
		<div style="left:728px;top: 480px;width:75px;text-align:right">						
			<xsl:value-of select="format-number(floor(sum($p14s[position() &lt; 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax)),'#0')"/>
		</div>
		<div style="left:809px;top: 480px;width:23px;text-align:right">						
			<xsl:value-of select="substring-after(format-number(sum($p14s[position() &lt; 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax),'0.00'),'.')"/>
		</div>									
		<div style="left:839px;top: 480px;width:12px">								
			<xsl:choose>
				<xsl:when test="sum($p14s[position() &lt; 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax) &lt; 0">R</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>					
		<xsl:comment>(5) Total TAX from P35(CS) </xsl:comment>
		<div style="left:728px;top: 520px;width:74px;text-align:right">						
			<xsl:value-of select="format-number(floor(sum($p14s[position() &gt; 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax)),'#0')"/>
		</div>
		<div style="left:808px;top: 520px;width:23px;text-align:right">						
			<xsl:value-of select="substring-after(format-number(sum($p14s[position() &gt; 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax),'0.00'),'.')"/>
		</div>	
		<div style="left:839px;top: 520px;width:12px">								
			<xsl:choose>
				<xsl:when test="sum($p14s[position() &gt; 10]/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax) &lt; 0">R</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>					
		
		<xsl:comment> Part2 Summary of payments for the year </xsl:comment>
		
		<xsl:comment>(3) Total NIC </xsl:comment>
		<div style="left: 432px;top: 583px;width: 72px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:NIC/eoy:TotalNIC), '#0')"/>			
		</div>
		<div style="left: 510px;top: 582px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:TotalNIC, '0.00'),'.')"/>			
		</div>		
		<div style="left:540px;top: 582px;width:12px">								
			<xsl:choose>
				<xsl:when test="$p35/eoy:Summary/eoy:NIC/eoy:TotalNIC &lt; 0">R</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>			
		<xsl:comment>(6) Total Tax </xsl:comment>
		<div style="left: 728px;top: 583px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:PAYE/eoy:P14Tax), '#0')"/>			
		</div>
		<div style="left: 808px;top: 583px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:PAYE/eoy:P14Tax, '0.00'),'.')"/>			
		</div>		
		<div style="left:838px;top: 583px;width:12px">								
			<xsl:choose>
				<xsl:when test="$p35/eoy:Summary/eoy:PAYE/eoy:P14Tax &lt; 0">R</xsl:when>
				<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>			
		
		<xsl:comment>(7) Advance received from Inland Revenue to refund TAX </xsl:comment>
		<div style="left: 728px;top: 630px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:PAYE/eoy:TaxAdvance), '#0')"/>			
		</div>
		<div style="left: 808px;top: 630px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:PAYE/eoy:TaxAdvance, '0.00'),'.')"/>			
		</div>		
		<xsl:comment>(8) Deductions made from subcontractors </xsl:comment>
		<div style="left: 728px;top: 670px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:PAYE/eoy:SubcontractorTax), '#0')"/>			
		</div>
		<div style="left: 808px;top: 670px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:PAYE/eoy:SubcontractorTax, '0.00'),'.')"/>			
		</div>	
		
		<xsl:comment>(9) Total Tax </xsl:comment>
		<div style="left: 728px;top: 738px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:PAYE/eoy:TotalTax), '#0')"/>			
		</div>
		<div style="left: 808px;top: 738px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:PAYE/eoy:TotalTax, '0.00'),'.')"/>			
		</div>	
		<xsl:comment>(10) Total NIC and TAX </xsl:comment>
		<div style="left: 567px;top: 773px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalTaxAndNIC), '#0')"/>			
		</div>
		<div style="left: 647px;top: 773px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalTaxAndNIC, '0.00'),'.')"/>			
		</div>		
		<xsl:comment>(11) Total Student Loan deductions </xsl:comment>
		<div style="left: 567px;top: 805px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:StudentLoan), '#0')"/>			
		</div>
		<xsl:comment>(12) 10 + 11</xsl:comment>
		<div style="left: 567px;top: 847px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalNICsTaxAndStudentLoan), '#0')"/>			
		</div>
		<div style="left: 647px;top: 847px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalNICsTaxAndStudentLoan, '0.00'),'.')"/>			
		</div>			
		<xsl:comment>(13) Statutory Sick Pay (SSP) recovered </xsl:comment>
		<div style="left: 218px;top: 897px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:NIC/eoy:SSP), '#0')"/>			
		</div>
		<div style="left: 300px;top: 897px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SSP, '0.00'),'.')"/>			
		</div>	
		<xsl:comment>(14) Statutory Maternity Pay (SMP) recovered </xsl:comment>
		<div style="left: 218px;top: 928px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:NIC/eoy:SMP), '#0')"/>			
		</div>
		<div style="left: 300px;top: 928px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SMP, '0.00'),'.')"/>			
		</div>			
		<xsl:comment>(15) NIC compensation on SMP</xsl:comment>
		<div style="left: 218px;top: 961px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:NIC/eoy:SMPcompensation), '#0')"/>			
		</div>
		<div style="left: 300px;top: 961px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SMPcompensation, '0.00'),'.')"/>			
		</div>			
		<xsl:comment>(16) Statutory Paterninty Pay (SPP) recovered </xsl:comment>
		<div style="left: 218px;top: 994px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:NIC/eoy:SPP), '#0')"/>			
		</div>
		<div style="left: 300px;top: 994px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SPP, '0.00'),'.')"/>			
		</div>
		<xsl:comment>(17) NIC compensation on SPP </xsl:comment>
		<div style="left: 218px;top: 1028px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:NIC/eoy:SPPcompensation), '#0')"/>			
		</div>
		<div style="left: 300px;top: 1028px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SPPcompensation, '0.00'),'.')"/>			
		</div>		
		<xsl:comment>(18) Statutory Adoption Pay (SAP) recovered</xsl:comment>
		<div style="left: 218px;top: 1062px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:NIC/eoy:SAP), '#0')"/>			
		</div>
		<div style="left: 300px;top: 1062px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SAP, '0.00'),'.')"/>			
		</div>			
		<xsl:comment>(19) NIC compensation on SAP</xsl:comment>
		<div style="left: 218px;top: 1094px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:NIC/eoy:SAPcompensation),'#0')"/>			
		</div>
		<div style="left: 300px;top: 1094px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SAPcompensation, '0.00'),'.')"/>			
		</div>					
		<xsl:comment>(20) Total of boxes 13 - 19</xsl:comment>
		<div style="left: 218px;top: 1129px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetStatutoryPaymentsRecovered + $p35/eoy:Summary/eoy:NIC/eoy:SSPSMPSPPandSAPfunding),'#0')"/>			
		</div>
		<div style="left: 300px;top: 1129px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetStatutoryPaymentsRecovered + $p35/eoy:Summary/eoy:NIC/eoy:SSPSMPSPPandSAPfunding, '0.00'),'.')"/>			
		</div>
		<xsl:comment>(21) Funding received from Inland Revenue to pay SSP/SMP/SPP/SAP</xsl:comment>
		<div style="left: 218px;top: 1162px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:NIC/eoy:SSPSMPSPPandSAPfunding),'#0')"/>			
		</div>
		<div style="left: 300px;top: 1162px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:NIC/eoy:SSPSMPSPPandSAPfunding, '0.00'),'.')"/>			
		</div>		
		<xsl:comment>(22) 20 minus 21</xsl:comment>
		<div style="left: 428px;top: 1162px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetStatutoryPaymentsRecovered),'#0')"/>			
		</div>
		<div style="left: 510px;top: 1162px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetStatutoryPaymentsRecovered,'0.00'),'.')"/>			
		</div>	
		<xsl:comment>(23) Total Tax Credits paid to employees</xsl:comment>
		<div style="left: 218px;top: 1244px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TaxCredit),'#0')"/>			
		</div>
		<div style="left: 300px;top: 1244px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TaxCredit, '0.00'),'.')"/>			
		</div>
		<xsl:comment>(24) Funding received from Inland Revenue to pay Tax Credits</xsl:comment>
		<div style="left: 218px;top: 1278px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TaxCreditFunding),'#0')"/>			
		</div>
		<div style="left: 300px;top: 1278px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TaxCreditFunding, '0.00'),'.')"/>			
		</div>
		<xsl:comment>(25)23 minus 24</xsl:comment>
		<div style="left: 428px;top: 1278px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetTaxCredits),'#0')"/>			
		</div>
		<div style="left: 509px;top: 1278px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetTaxCredits, '0.00'),'.')"/>			
		</div>	
		<xsl:comment>(26) 22 + 26</xsl:comment>		
		<div style="left: 566px;top: 1327px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetDeductions),'#0')"/>			
		</div>
		<div style="left: 647px;top: 1327px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:NetDeductions, '0.00'),'.')"/>			
		</div>	
		<xsl:comment>(27) Amount payable for the year [12 minus 26]</xsl:comment>
		<div style="left: 566px;top: 1360px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalPayable),'#0')"/>			
		</div>
		<div style="left: 647px;top: 1360px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalPayable, '0.00'),'.')"/>			
		</div>
		<xsl:comment>(28) NICs and Tax paid already</xsl:comment>
		<div style="left: 566px;top: 1392px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalPaid),'#0')"/>			
		</div>
		<div style="left: 647px;top: 1392px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalPaid, '0.00'),'.')"/>			
		</div>	
		<xsl:comment>(29) Tax-free Incentive payment received during the year</xsl:comment>
		<div style="left: 566px;top: 1427px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:IncentivePayment),'#0')"/>			
		</div>
		<div style="left: 647px;top: 1427px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:IncentivePayment, '0.00'),'.')"/>			
		</div>		
		<xsl:comment>(30) NOW PAYABLE [27 minus 28 and 29]</xsl:comment>
		<div style="left: 566px;top: 1468px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalRemainingToPay),'#0')"/>			
		</div>
		<div style="left: 647px;top: 1468px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalRemainingToPay,'0.00'),'.')"/>			
		</div>			
		<xsl:comment>(31) CIS deductions suffered [Total of col E from CIS 132]</xsl:comment>
		<div style="left: 566px;top: 1505px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:CISdeductions),'#0')"/>			
		</div>
		<div style="left: 647px;top: 1505px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:CISdeductions,'0.00'),'.')"/>			
		</div>
		<xsl:comment>(32) Revised amount now payable [30 minus 31]</xsl:comment>
		<div style="left: 566px;top: 1536px;width: 74px;text-align: right">			
				<xsl:value-of select="format-number(floor($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalAfterCISdeductions),'#0')"/>			
		</div>
		<div style="left: 647px;top: 1536px;width: 23px;text-align: right">			
				<xsl:value-of select="substring-after(format-number($p35/eoy:Summary/eoy:CombinedAmounts/eoy:TotalAfterCISdeductions,'0.00'),'.')"/>			
		</div>	
</xsl:template>

<xsl:template name="page4">
		<xsl:comment>Part 3 Checklist</xsl:comment>
		<xsl:comment>1 Have you send a form P14, End of Year Summary or completed and retained a form P38(S), Student employees for every person in your  paid employement, either on a casual basis or otherwise, during the tax year shown on the front of this form?</xsl:comment>		
		<div style="left: 81px;top: 145px;width:12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:CompletedEndOfYearSummary,'yes','&#160;'),'no','x')"/>
		</div>
		<div style="left: 142px;top: 145px;width: 12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:CompletedEndOfYearSummary,'yes','x'),'no','&#160;')"/>		
		</div>
		<xsl:comment>2 Did you make any  'free of tax' payments to an employee? In other words, did you bear any of the tax yourself rather then deduct it from the employee?</xsl:comment>		
		<div style="left: 81px;top: 273px;width:12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:FreeOfTaxPayments,'yes','&#160;'),'no','x')"/>
		</div>
		<div style="left: 142px;top: 273px;width: 12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:FreeOfTaxPayments,'yes','x'),'no','&#160;')"/>		
		</div>
		<xsl:comment>3 So far as you know, did anyone else pay expense, or in any way provide vouchers or benefits to any of your employees whilst they were employed by you during the year?</xsl:comment>		
		<div style="left: 81px;top: 392px;width:12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:ExpensesOrBenefits,'yes','&#160;'),'no','x')"/>
		</div>
		<div style="left: 142px;top: 392px;width: 12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:ExpensesOrBenefits,'yes','x'),'no','&#160;')"/>		
		</div>
		<xsl:comment>4 Did anyone employed by a person or company outside the UK work for you in the UK for 30 or more days in a row?</xsl:comment>		
		<div style="left: 446px;top: 113px;width:13px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:EmployeesOutOfUK,'yes','&#160;'),'no','x')"/>
		</div>
		<div style="left: 507px;top: 113px;width: 12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:EmployeesOutOfUK,'yes','x'),'no','&#160;')"/>		
		</div>
		<xsl:comment>If 'Yes', have you send a form P14 for them?</xsl:comment>		
		<div style="left: 446px;top: 153px;width:13px" class="checkbox">
			<xsl:choose>
			<xsl:when test="$p35/eoy:CheckList/eoy:EmployeesOutOfUK/@IsIncluded = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>
		<div style="left: 507px;top: 153px;width: 12px" class="checkbox">
			<xsl:choose>
			<xsl:when test="$p35/eoy:CheckList/eoy:EmployeesOutOfUK/@IsIncluded = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>			
		<xsl:comment>5 Have you paid any of an employee's pay to someone other then the employee, for example, to a school?</xsl:comment>		
		<div style="left: 446px;top: 236px;width:13px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:EmployeesPayToThirdParty,'yes','&#160;'),'no','x')"/>
		</div>
		<div style="left: 507px;top: 236px;width: 12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:EmployeesPayToThirdParty,'yes','x'),'no','&#160;')"/>		
		</div>
		<xsl:comment>If 'Yes', have you included this pay on their form P14?</xsl:comment>		
		<div style="left: 451px;top: 278px;width:13px" class="checkbox">
			<xsl:choose>
			<xsl:when test="$p35/eoy:CheckList/eoy:EmployeesPayToThirdParty/@IsIncluded = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>
		<div style="left: 507px;top: 278px;width: 12px" class="checkbox">
			<xsl:choose>
			<xsl:when test="$p35/eoy:CheckList/eoy:EmployeesPayToThirdParty/@IsIncluded = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>		
		<xsl:comment>6 Do the rules relating to services provided through an intermediary (sometimes known as IR35) apply to any work carried out by any worker listed on this return?</xsl:comment>		
		<div style="left: 446px;top: 365px;width:13px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:ServicePayments,'yes','&#160;'),'no','x')"/>
		</div>
		<div style="left: 507px;top: 365px;width: 12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:CheckList/eoy:ServicePayments,'yes','x'),'no','&#160;')"/>		
		</div>
		<xsl:comment>If 'Yes', have you included this pay on their form P14?</xsl:comment>		
		<div style="left: 451px;top: 421px;width:13px" class="checkbox">
			<xsl:choose>
			<xsl:when test="$p35/eoy:CheckList/eoy:ServicePayments/@IsIncluded = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>
		<div style="left: 507px;top: 421px;width: 12px" class="checkbox">
			<xsl:choose>
			<xsl:when test="$p35/eoy:CheckList/eoy:ServicePayments/@IsIncluded = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>			
		<xsl:comment>Part 4 Contracted out pension schemes [if applicable]</xsl:comment>
		<xsl:comment>If you have a Contracted-out pension scheme, enter your Employer's Contracted-out number (ECON) from your contracting-out certificate</xsl:comment>
		<div style="left:532px;top: 512px;width: 12px" class="large-text">
			<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,3,1)"/>
		</div>
		<div style="left:562px;top: 512px;width: 12px" class="large-text">
			<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,4,1)"/>
		</div>	
		<div style="left:592px;top: 512px;width: 12px" class="large-text">
			<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,5,1)"/>
		</div>	
		<div style="left:622px;top: 512px;width: 12px" class="large-text">
			<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,6,1)"/>
		</div>	
		<div style="left:652px;top: 512px;width: 12px" class="large-text">
			<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,7,1)"/>
		</div>	
		<div style="left:682px;top: 512px;width: 12px" class="large-text">
			<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,8,1)"/>
		</div>	
		<div style="left:712px;top: 512px;width: 12px" class="large-text">
			<xsl:value-of select="substring($p35/eoy:EmployerDetails/eoy:ECON,9,1)"/>
		</div>	
		<xsl:comment>Part 5 Employer's certificate and declaration</xsl:comment>
		<xsl:comment>forms P14, End of Year Summary for each employee or director for whom I was required to complete a form P11 Deductions Working Sheet (or equivalent record) during the year</xsl:comment>
		<div style="left: 195px;top: 663px;width: 12px" class="checkbox">
			<xsl:choose>
			<xsl:when test="$iRenvelope/eoy:EndOfYearReturn/eoy:SubmissionType='complete'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>			
		<xsl:comment>or have been sent separately in one or more parts</xsl:comment>
		<div style="left: 195px;top: 722px;width: 12px" class="checkbox">
			<xsl:choose>
			<xsl:when test="$iRenvelope/eoy:EndOfYearReturn/eoy:SubmissionType='P35Part'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		</div>					
		<xsl:comment>If forms P14 have been sent in more then one part, please state the number of parts sent. For more detailed information, see the Do it online - Online filling and electronic payment handbook</xsl:comment>
		<div style="left: 608px;top: 707px;width: 62px;text-align:right">
			&#160;<xsl:value-of select="$iRenvelope/eoy:EndOfYearReturn/eoy:NumberOfParts"/>
		</div>		
		<xsl:comment>Completed form P38A, Employer's Supplementary Return</xsl:comment>
		<xsl:comment>is not due</xsl:comment>
		<div style="left:282px;top: 778px;width: 12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:Declarations/eoy:P38Adeclaration,'are not due','x'),'are due','&#160;')"/>
		</div>
		<xsl:comment>Completed forms P11D and P11D(b), Returns of expenses payments, benefits and Class 1A contributions</xsl:comment> 
		<xsl:comment>are not due</xsl:comment>
		<div style="left:403px;top: 834px;width: 12px" class="checkbox">
			<xsl:value-of select="translate(translate($p35/eoy:Declarations/eoy:P11Ddeclaration,'are not due','x'),'are due','&#160;')"/>
		</div>		
		<xsl:comment>Please print your name</xsl:comment>
		<div style="left:46px;top: 996px;width: 305px;text-align:center">		
			<xsl:choose>
			<xsl:when test="//eoy:IRheader/eoy:Agent">
				<xsl:value-of select="//eoy:IRheader/eoy:Agent/eoy:Contact/eoy:Name/eoy:Ttl"/>			
				<xsl:for-each select="//eoy:IRheader/eoy:Agent/eoy:Contact/eoy:Name/eoy:Fore">
					&#160;<xsl:value-of select="."/>
				</xsl:for-each>
				&#160;			
				<xsl:value-of select="//eoy:IRheader/eoy:Agent/eoy:Contact/eoy:Name/eoy:Sur"/>						
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="//eoy:IRheader/eoy:Principal/eoy:Contact/eoy:Name/eoy:Ttl"/>			
				<xsl:for-each select="//eoy:IRheader/eoy:Principal/eoy:Contact/eoy:Name/eoy:Fore">
					&#160;<xsl:value-of select="."/>
				</xsl:for-each>
				&#160;			
				<xsl:value-of select="//eoy:IRheader/eoy:Principal/eoy:Contact/eoy:Name/eoy:Sur"/>			
			</xsl:otherwise>
			</xsl:choose>			
		</div>		
		<xsl:comment>Employer's signature</xsl:comment>		
		<div style="left:46px;top: 938px;width: 305px;text-align:center">
			Not Applicable
		</div>			
		<xsl:comment>Capacity in which signed</xsl:comment>		
		<div style="left:46px;top: 1056px;width: 305px;text-align:center">
			<xsl:value-of select="//eoy:IRheader/eoy:Sender"/>
		</div>		
		<xsl:comment>Date</xsl:comment>
		<div style="left:456px;top: 925px;width: 28px;text-align:center">
			<xsl:value-of select="$issueDate.month"/>		
		</div>
		<div style="left:495px;top: 925px;width: 52px;text-align:center">
			<xsl:value-of select="$issueDate.day"/>				
		</div>		
		<div style="left:560px;top: 925px;width: 70px;text-align:center">
			<xsl:value-of select="$issueDate.year"/>				
		</div>				
		
		<xsl:comment>Please give a daytime telephone number. It will help speed things up if we need to talk to you about your return.</xsl:comment>
		<div style="left:424px;top: 1008px;width: 306px;text-align:center">
			<xsl:choose>
				<xsl:when test="//eoy:IRheader/eoy:Agent">
					&#160;<xsl:value-of select="//eoy:IRheader/eoy:Agent/eoy:Contact/eoy:Name/eoy:Telephone"/>				
				</xsl:when>
				<xsl:otherwise>	
					&#160;<xsl:value-of select="//eoy:IRheader/eoy:Principal/eoy:Contact/eoy:Name/eoy:Telephone"/>
				</xsl:otherwise>
			</xsl:choose>
		</div>		
</xsl:template>

<xsl:template name="csPageEmployee">
	<xsl:param name="first"/>
	<xsl:comment><xsl:value-of select="name()"/> for <xsl:value-of select="eoy:Name"/> </xsl:comment>
	<xsl:variable name="y-offset" select="195+(position()-1)*32"/> 
	<div style="left:67px;top: {$y-offset}px;width:226px">
		<a href="{concat($url,'&amp;transformation=/templates/PAYE/P14(2006).xsl&amp;page=',$first + position())}"> 					
			<xsl:value-of select="eoy:Name/eoy:Sur"/>
			<xsl:for-each select="eoy:Name/eoy:Fore">&#160;<xsl:value-of select="."/></xsl:for-each>
		</a>
	</div>
	<div style="left:324px;top: {$y-offset}px;width:80px;text-align:right">						
		<xsl:value-of select="format-number(floor(sum(eoy:NICs/eoy:Both)),'#0')"/>
	</div>
	<div style="left:413px;top: {$y-offset}px;width:28px;text-align:right">						
		<xsl:value-of select="substring-after(format-number(sum(eoy:NICs/eoy:Both),'0.00'),'.')"/>
	</div>					
	<div style="left:448px;top: {$y-offset}px;width:12px">								
		<xsl:choose>
			<xsl:when test="sum(eoy:NICs/eoy:Both) &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>
	<div style="left:469px;top: {$y-offset}px;width:83px;text-align:right">						
		<xsl:value-of select="format-number(floor(eoy:PayAndTax/eoy:ThisEmp/eoy:Tax),'#0')"/>
	</div>					
	<div style="left:559px;top: {$y-offset}px;width:28px;text-align:right">						
		<xsl:value-of select="substring-after(format-number(eoy:PayAndTax/eoy:ThisEmp/eoy:Tax,'0.00'),'.')"/>
	</div>										
	<div style="left:594px;top: {$y-offset}px;width:12px">								
		<xsl:choose>
			<xsl:when test="eoy:PayAndTax/eoy:ThisEmp/eoy:Tax &lt; 0">R</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>										
</xsl:template>

<xsl:template name="csPage">
	<xsl:param name="pageP14"/>
	<xsl:comment>Totals carried to box 2 of form P35 after deducting amounts marked 'R'</xsl:comment>				
	<div style="left:324px;top: 1005px;width:80px;text-align:right">				
		<xsl:value-of select="format-number(floor(sum($pageP14/eoy:NICs/eoy:Both)),'#0')"/>
	</div>
	<div style="left:413px;top: 1005px;width:28px;text-align:right">						
			<xsl:value-of select="substring-after(format-number(sum($pageP14/eoy:NICs/eoy:Both),'0.00'),'.')"/>
	</div>			
	<xsl:comment>Totals carried to box 5 of form P35 after deducting amounts marked 'R'</xsl:comment>
	<div style="left:470px;top: 1005px;width:82px;text-align:right">				
		<xsl:value-of select="format-number(floor(sum($pageP14/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax)),'#0')"/>
	</div>
	<div style="left:560px;top: 1005px;width:28px;text-align:right">						
			<xsl:value-of select="substring-after(format-number(sum($pageP14/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax),'0.00'),'.')"/>
	</div>					
</xsl:template>

</xsl:stylesheet>
