<xsl:stylesheet version="1.1" xmlns="http://www.w3.org/1999/xhtml"
							  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
							  xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"							  
							  extension-element-prefixes="ext"							  
                              xmlns:eoy="selima:FBI Rendering">
<ext:annotation
	rewrite_from_ns="http://www.govtalk.gov.uk/taxation/EOY/08-09/1"
    rewrite_to_ns="selima:FBI Rendering"	
	metadata="P14(base).metadata.xsl"	
/>
<xsl:import href="P14(base).xsl"/>
<xsl:variable name="taxYear">2009</xsl:variable>
<xsl:variable name="page1Size">width: 914px; height: 1154px</xsl:variable>

<xsl:template name="page1">
	<xsl:variable name="iRenvelope" select="//eoy:IRenvelope"/>
	<xsl:variable name="p35" select="$iRenvelope/eoy:EndOfYearReturn/eoy:P35"/>
	<xsl:variable name="p14" select="$iRenvelope/eoy:EndOfYearReturn/eoy:P14[position()=$page]"/>

	<xsl:comment>Your name and address as employer</xsl:comment>
	<div style="left: 110px;top: 85px;width: 345px;">
		<xsl:choose>
			<xsl:when test="$p35"><xsl:value-of select="$p35/eoy:EmployerDetails/eoy:EmployerName"/></xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>					
	<xsl:comment>Tax Year to 5 April</xsl:comment>
	<div style="left: 701px;top: 76px;width: 55px;text-align: right" class="large-text">				
		<xsl:value-of select="substring($iRenvelope/eoy:IRheader/eoy:PeriodEnd,1,4)"/>			
	</div>		
	<xsl:comment> HM Revenue &amp; Customs office name</xsl:comment>
	<div style="left: 475px;top: 127px;width: 150px">
	Known by HMRC
	</div>		
	<xsl:comment> Employer's  PAY  reference: Tax office number </xsl:comment>
	<div style="left: 583px;top: 158px;width: 48px;text-align: right">
		&#160;	
		<xsl:value-of select="$iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeNumber']"/>			
	</div>		
	<xsl:comment> Employer's PAY reference: Tax office reference </xsl:comment>
	<div style="left: 648px;top: 158px;width: 90px;">			
		<xsl:value-of select="$iRenvelope/eoy:IRheader/eoy:Keys/eoy:Key[@Type='TaxOfficeReference']"/>
		&#160;				
	</div>		
	<xsl:comment>National Insurance no.</xsl:comment>
	<div style="left: 203px;top: 240px;width: 30px;text-align: center">				
		<xsl:value-of select="substring($p14/eoy:NINO,1,2)"/>			
	</div>		
	<div style="left: 239px;top: 240px;width: 30px;text-align: center">				
		<xsl:value-of select="substring($p14/eoy:NINO,3,2)"/>			
	</div>		
	<div style="left: 279px;top: 240px;width: 30px;text-align: center">				
		<xsl:value-of select="substring($p14/eoy:NINO,5,2)"/>			
	</div>		
	<div style="left: 316px;top: 240px;width: 30px;text-align: center">				
		<xsl:value-of select="substring($p14/eoy:NINO,7,2)"/>			
	</div>		
	<div style="left: 353px;top: 240px;width: 25px;text-align: center">				
		<xsl:value-of select="translate(substring($p14/eoy:NINO,9,1),' ','&#160;')"/>			
	</div>		
	<xsl:comment>Date of birth in figures (if known)</xsl:comment>
	<div style="left: 518px;top: 240px;width: 30px;text-align: center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:DOB"><xsl:value-of select="substring($p14/eoy:DOB,9,2)"/></xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>
	<div style="left: 553px;top: 240px;width: 23px;text-align: center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:DOB"><xsl:value-of select="substring($p14/eoy:DOB,6,2)"/></xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>				
	</div>			
	<div style="left: 582px;top: 240px;width: 49px;text-align: center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:DOB"><xsl:value-of select="substring($p14/eoy:DOB,1,4)"/></xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>							
	</div>		
	<xsl:comment>Sex</xsl:comment>
	<div style="left: 653px;top: 240px;width: 25px;text-align: center;text-transform:uppercase">
		<xsl:choose>
			<xsl:when test="$p14/eoy:Sex"><xsl:value-of select="substring($p14/eoy:Sex,1,1)"/></xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>											
	</div>		
	<xsl:comment>Surname</xsl:comment>
	<div style="left: 203px;top: 273px;width: 242px">				
		<xsl:value-of select="$p14/eoy:Name/eoy:Sur"/>			
	</div>		
	<xsl:comment>First two forenames</xsl:comment>
	<div style="left: 203px;top: 302px;width: 242px">				
		<xsl:value-of select="$p14/eoy:Name/eoy:Fore[1]"/>
	</div>
	<div style="left: 203px;top: 334px;width: 242px">			
		<xsl:value-of select="$p14/eoy:Name/eoy:Fore[2]"/>&#160;
	</div>		
	<xsl:comment>Works/ payroll no. etc</xsl:comment>
	<div style="left: 203px;top: 375px;width: 242px">			
		<xsl:value-of select="$p14/eoy:WkNo"/>&#160;
	</div>		
	<xsl:comment>Employee's private address incl. postcode (if known)</xsl:comment>
	<div style="left: 474px;top: 305px;width: 286px">
		<xsl:choose>
			<xsl:when test="$p14/eoy:Address">
				<xsl:for-each select="$p14/eoy:Address/*">
					<xsl:value-of select="."/><br/>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>		
	<xsl:comment>National Insurance contributions in this employement</xsl:comment>
	<xsl:for-each select="$p14/eoy:NICs">
	<xsl:variable name="y-offset" select="588+(position()-1)*18"/>
	<xsl:comment>NIC table letter</xsl:comment> 		
	<div style="left: 106px;top: {$y-offset}px;width: 24px;text-align:center">				
		<xsl:value-of select="@Tab"/>			
	</div>	
	<xsl:comment>Earnings at the LEL (where earnings are equal to or exceed the LEL)</xsl:comment>
	<div style="left: 153px;top: {$y-offset}px;width: 54px;text-align:right">				
		<xsl:value-of select="format-number(floor(eoy:Earn/eoy:AtLEL),'#0')"/>		
	</div>		
	<xsl:comment>Earnings above the LEL up to and including the ET</xsl:comment>
	<div style="left: 230px;top: {$y-offset}px;width: 54px;text-align:right">				
		<xsl:value-of select="format-number(floor(eoy:Earn/eoy:LELtoET),'#0')"/>			
	</div>					
	<xsl:comment>Earnings above the ET up to and including the UEL</xsl:comment>
	<div style="left: 307px;top: {$y-offset}px;width: 63px;text-align:right">				
		<xsl:value-of select="format-number(floor(eoy:Earn/eoy:ETtoUEL),'#0')"/>			
	</div>				
	<xsl:comment>Total of employee's and employer's contributions</xsl:comment>
	<div style="left: 384px;top: {$y-offset}px;width: 120px;text-align:right">				
		<xsl:value-of select="format-number(eoy:Both,'#0.00')"/>			
	</div>		
	<xsl:comment>If amount in col. 1d is a minus amount, enter 'R' here</xsl:comment>
	<div style="left: 510px;top: {$y-offset}px;width: 16px">
		<xsl:choose>
		<xsl:when test="eoy:Both &lt; 0">R</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>			
	</div>
	<xsl:comment>Employee's contributions due on all earnings above the ET</xsl:comment>
	<div style="left: 538px;top: {$y-offset}px;width: 110px;text-align:right">				
		<xsl:value-of select="format-number(eoy:Emp,'#0.00')"/>						
	</div>		
	<xsl:comment>Scheme Contracted-out Number</xsl:comment>
	<div style="left: 673px;top: {$y-offset}px;width: 92px">				
		<xsl:value-of select="substring(eoy:SCON,2,8)"/>&#160;			
	</div>				
	</xsl:for-each>
	<xsl:comment>Statutory payments Included in the pay 'in this employement' figure bellow</xsl:comment>		
	<xsl:comment>Statutory Sick Pay (SSP)</xsl:comment>
	<div style="left: 403px;top: 688px;width: 101px;text-align:right">			
		<xsl:value-of select="format-number($p14/eoy:SSP,'#0.00')"/>
	</div>
	<xsl:comment>Statutory Materninty Pay (SMP)</xsl:comment>
	<div style="left: 661px;top: 688px;width: 103px;text-align:right">			
		<xsl:value-of select="format-number($p14/eoy:SMP,'#0.00')"/>
	</div>		
	<xsl:comment>Statutory Paternity Pay (SPP)</xsl:comment>
	<div style="left: 403px;top: 736px;width: 101px;text-align:right">			
		<xsl:value-of select="format-number($p14/eoy:SPP,'#0.00')"/>
	</div>		
	<xsl:comment>Statutory Adoption Pay (SAP)</xsl:comment>
	<div style="left: 661px;top: 736px;width: 101px;text-align:right">			
		<xsl:value-of select="format-number($p14/eoy:SAP,'#0.00')"/>
	</div>		
	<xsl:comment>Pay and Income Tax details</xsl:comment>
	<xsl:comment>In previous employements(s)</xsl:comment>
	<xsl:comment>Pay</xsl:comment>
	<div style="left: 221px;top: 814px;width: 140px;text-align:right">			
		<xsl:value-of select="format-number($p14/eoy:PayAndTax/eoy:PrevEmp/eoy:TaxablePay,'#0.00')"/>
	</div>
	<xsl:comment>Tax deducted</xsl:comment>		
	<div style="left: 375px;top: 814px;width: 120px;text-align:right">			
		<xsl:value-of select="format-number($p14/eoy:PayAndTax/eoy:PrevEmp/eoy:Tax,'#0.00')"/>
	</div>
	<xsl:comment>In this employment</xsl:comment>
	<xsl:comment>Pay</xsl:comment>
	<div style="left: 221px;top: 846px;width: 140px;text-align:right">			
		<xsl:value-of select="format-number($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:TaxablePay,'#0.00')"/>
	</div>
	<xsl:comment>Tax deducted</xsl:comment>		
	<div style="left: 375px;top: 846px;width: 120px;text-align:right">			
		<xsl:value-of select="format-number($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax,'#0.00')"/>
	</div>		
	<xsl:comment>Enter 'R' in this box if net refund</xsl:comment>
	<div style="left: 503px;top: 846px;width: 16px">
		<xsl:choose>
		<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Tax &lt; 0">R</xsl:when>
		<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>			
	</div>		
	<xsl:comment>Total for year</xsl:comment>
	<xsl:comment>Pay</xsl:comment>
	<div style="left: 221px;top: 880px;width: 140px;text-align:right">
		<xsl:value-of select="format-number(sum($p14/eoy:PayAndTax//eoy:TaxablePay),'#0.00')"/>
	</div>	
	<xsl:comment>Tax deducted</xsl:comment>
	<div style="left: 375px;top: 880px;width: 120px;text-align:right">
		<xsl:value-of select="format-number(sum($p14/eoy:PayAndTax//eoy:Tax),'#0.00')"/>
	</div>		
	<xsl:comment>Employee's Widows &amp; Orphans / Life Assurance contributions in this employement</xsl:comment>
	<div style="left: 288px;top: 926px;width: 91px;text-align:right">			
		<xsl:value-of select="format-number($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:WidOrph,'#0.00')"/>
	</div>		
	<xsl:comment>Final tax code</xsl:comment>
	<div style="left: 302px;top: 958px;width: 78px">			
		<xsl:value-of select="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Code"/>
	</div>
	<xsl:comment>Payment in week 53: if included in Pay and Tax totals enter '53', '54' or '56' here</xsl:comment>
	<div style="left: 394px;top: 958px;width: 34px">			
		<xsl:value-of select="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Week53Indicator"/>&#160;
	</div>				
	<xsl:comment>Student Loan Deductions in this employement (whole $ only)</xsl:comment>
	<div style="left: 661px;top: 830px;width: 64px;text-align:right">			
		<xsl:value-of select="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:StLoan"/>
	</div>				
	<xsl:comment>Date of starting if during tax year to 5 April 2008</xsl:comment>
	<xsl:comment>Day</xsl:comment>
	<div style="left: 614px;top: 991px;width: 29px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start,9,2)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>
	<xsl:comment>Month</xsl:comment>
	<div style="left: 650px;top: 991px;width: 22px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start,6,2)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>
	<xsl:comment>Year</xsl:comment>
	<div style="left: 678px;top: 991px;width: 47px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:Start,1,4)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>	
	<xsl:comment>Date of leaving if during tax year to 5 April 2008</xsl:comment>
	<xsl:comment>Day</xsl:comment>		
	<div style="left: 614px;top: 1022px;width: 29px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate,9,2)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>
	<xsl:comment>Month</xsl:comment>
	<div style="left: 650px;top: 1022px;width: 22px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate,6,2)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>
	<xsl:comment>Year</xsl:comment>
	<div style="left: 678px;top: 1022px;width: 47px;text-align:center">
		<xsl:choose>
			<xsl:when test="$p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate">
				<xsl:value-of select="substring($p14/eoy:PayAndTax/eoy:ThisEmp/eoy:EndDate,1,4)"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>	
	</div>		
</xsl:template>

</xsl:stylesheet>
