<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:rti="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>
    <ext:annotation
     metadata="NINOVR(2013).metadata.xsl"
     rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/RTI/2"
     rewrite_to_ns="selima:FBI Rendering"
    />
        <xsl:variable name="pageType">
            <xsl:choose>
                <xsl:when test="$page = 1">title page</xsl:when>
                <xsl:when test="$page mod 2 = 0">cont. sheet 1</xsl:when>
                <xsl:otherwise>cont. sheet 2</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
		<xsl:variable name="firstPosition">
			<xsl:choose>
			<xsl:when test="$pageType='title page'">
				<xsl:value-of select="0"/>
			</xsl:when>
			<xsl:when test="$pageType='cont. sheet 1'">
				<xsl:value-of select="floor(($page - 2) div 2) * 66 + 25"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="floor(($page - 2) div 2) * 66 + 57"/>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:variable name="lastPosition">
			<xsl:choose>
			<xsl:when test="$pageType='title page'">
				<xsl:value-of select="24"/>
			</xsl:when>
			<xsl:when test="$pageType='cont. sheet 1'">
				<xsl:value-of select="$firstPosition + 31"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$firstPosition + 33"/>
			</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
	
    <xsl:output method="html" encoding="UTF-8"/>
    
    <!-- These should be supplied by external stylesheet user-->
    <xsl:param name="page">1</xsl:param>
	
    <xsl:template match="/">
		<xsl:variable name="employees" select="//rti:IRenvelope/rti:RTI/rti:NINOverificationRequest/rti:Employee[ $firstPosition &lt;= position() and position() &lt;= $lastPosition]"/>	
        <html>
            <head>
                <title>EAS</title>
                <style type="text/css">
                    body {
                    margin: 0px;
                    padding: 0px;
                    color: blue;
                    font: normal normal bold 11pt monospace;
                    }
                    
                    div {
                    background: transparent none no-repeat scroll top left;
                    }
                    
                    body * div {
                    position: absolute;
                    border: 1px dotted transparent;
                    }
                    
                    div.checkbox {
                    font-family:sans-serif;text-align:center
                    }
                    
                    div.large-text {
                    font-size: 32pt
                    }
                    
                    div.label {
                    	color: black;
                    }
                </style>
            </head>
            
            <body>
                <xsl:choose>
                    <xsl:when test="$pageType = 'title page'">
                        <div style="background-image: url(images/ninovr_p1a.png);width:825px;height:1123px">
                            <div style="width:794px;height:1130px">
                            	<xsl:variable name="top" select="170"/>
                            	<xsl:variable name="rowHeight" select="22"/>
                            	<xsl:variable name="left" select="67"/>
                            	<xsl:variable name="widthLabel" select="425"/>
                            	<div class="label" style="left:{$left}px;top:{$top}px;width:250px">
                            		HRMC Office Number
                            	</div>
                            	<div style="left:{$left + $widthLabel}px;top:{$top}px;width:200px">
                            		<xsl:value-of select="//rti:IRenvelope/rti:RTI/rti:NINOverificationRequest/rti:EmpRefs/rti:OfficeNo"/>
                            	</div>
                            	<div class="label" style="left:{$left}px;top:{$top+ 1 * $rowHeight}px;width:250px">
                            		Employer PAYE Reference
                            	</div>
                            	<div style="left:{$left + $widthLabel}px;top:{$top+ 1 * $rowHeight}px;width:200px">
                            		<xsl:value-of select="//rti:IRenvelope/rti:RTI/rti:NINOverificationRequest/rti:EmpRefs/rti:PayeRef"/>
                            	</div>
                            	<div class="label" style="left:{$left}px;top:{$top+ 2 * $rowHeight}px;width:250px">
                            		Accounts Office Reference
                            	</div>
                            	<div style="left:{$left + $widthLabel}px;top:{$top+ 2 * $rowHeight}px;width:200px">
                            		<xsl:value-of select="//rti:IRenvelope/rti:RTI/rti:NINOverificationRequest/rti:EmpRefs/rti:AORef"/>
                            	</div>
                            	
								<xsl:for-each select="$employees">
									<xsl:call-template name="row">
										<xsl:with-param name="top" select="380 + position()*26.25"/>
										<xsl:with-param name="left1" select="75"/>
										<xsl:with-param name="left2" select="383"/>
										<xsl:with-param name="left3" select="545"/>
									</xsl:call-template>
								</xsl:for-each>
                            </div>
                        </div>
                    </xsl:when>
		<xsl:when test="$pageType = 'cont. sheet 1'">
		<div style="background-image: url(images/ninovr_cs_p1.png);width:825px;height:1123px">
				<div style="width:794px;height:1123px">
				<xsl:for-each select="$employees">
					<xsl:call-template name="row">
						<xsl:with-param name="top" select="162 + position()*26.6"/>
						<xsl:with-param name="left1" select="59"/>
						<xsl:with-param name="left2" select="389"/>
						<xsl:with-param name="left3" select="560"/>
					</xsl:call-template>
				</xsl:for-each>
			</div>
		</div>
		</xsl:when>
        <xsl:otherwise>
		<div style="background-image: url(images/ninovr_cs_p2.png);width:825px;height:1123px">
			<div style="width:794px;height:1123px">
			<xsl:for-each select="$employees">
				<xsl:call-template name="row">
					<xsl:with-param name="top" select="140 + position()*26.6"/>
					<xsl:with-param name="left1" select="59"/>
					<xsl:with-param name="left2" select="389"/>
					<xsl:with-param name="left3" select="560"/>
				</xsl:call-template>
			</xsl:for-each>				
			</div>
		</div>		
        </xsl:otherwise>
    </xsl:choose>
</body>
</html>
</xsl:template>

<xsl:template name="row">
	<xsl:param name="top"/>
	<xsl:param name="left1">59</xsl:param>
	<xsl:param name="left2">367</xsl:param>
	<xsl:param name="left3">519</xsl:param>
	<div style="left: {$left1}px;top: {$top}px;width: 292px;text-align: left">
		<xsl:choose>
			<xsl:when test="rti:EmployeeDetails/rti:Name">
				<xsl:for-each select="rti:EmployeeDetails/rti:Name/*"><xsl:value-of select="."/>&#160;</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>	
	<div style="left: {$left2}px;top: {$top}px;width: 90px;text-align: left">
		<xsl:choose>
			<xsl:when test="rti:EmployeeDetails/rti:NINO">
				<xsl:value-of select="rti:EmployeeDetails/rti:NINO"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
	</div>			
	<div style="left: {$left3}px;top: {$top}px;width: 150px;text-align: left">
		<xsl:choose>
			<xsl:when test="rti:EmployeeDetails/rti:BirthDate">
				<xsl:value-of select="rti:EmployeeDetails/rti:BirthDate"/>
			</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
		</xsl:choose>
		<xsl:choose>
		<xsl:when test="rti:EmployeeDetails/rti:BirthDate">
		<xsl:choose>												
			<xsl:when test="rti:EmployeeDetails/rti:Gender">
				/ <xsl:value-of select="rti:EmployeeDetails/rti:Gender"/>
			</xsl:when>	
		</xsl:choose>	
		</xsl:when>
		</xsl:choose>
	</div>
</xsl:template>
</xsl:stylesheet>
