<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:rti="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>
    <ext:annotation
     metadata="FPS(base).metadata.xsl"
     rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/RTI/2"
     rewrite_to_ns="selima:FBI Rendering"	
    />
    <xsl:output method="html" encoding="UTF-8"/>
    <!-- These should be supplied by external stylesheet user-->
    <xsl:param name="page">1</xsl:param>
    <xsl:template match="/">
        <xsl:variable name="pageType">
            <xsl:choose>
                <xsl:when test="$page = 1">title page</xsl:when>
                <xsl:when test="$page mod 2 = 0">cont. sheet 1</xsl:when>
                <xsl:otherwise>cont. sheet 2</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

		<xsl:variable name="employees">
			<xsl:copy-of select="//rti:IRenvelope/rti:RTI/rti:FullPaymentSubmission/rti:Employee"/>
	    </xsl:variable>
        <html>
            <head>
                <title>FPS</title>
                <style type="text/css">
                    body {
                    margin: 15px;
                    padding: 0px;
                    }
                    
                    div {
                    background: transparent none no-repeat scroll top left;
                    }
                    
                    body * div {
                    position: absolute;
                    border: 1px dotted transparent;
                    }
                    
                    div.checkbox {
                    font-family:sans-serif;text-align:center
                    }
                    
                    div.large-text {
                    font-size: 32pt
                    }
                </style>
            </head>
            <body>
            	<br/>
				Totals
				<br/><br/>
		        Taxable Pay: <xsl:value-of select="substring-before(format-number(sum(//rti:IRenvelope/rti:RTI/rti:FullPaymentSubmission/rti:Employee/rti:Employment/rti:Payment/rti:TaxablePay),'0.00'),'.')"/><BR/>			
		        Non Tax or NI Payment: <xsl:value-of select="substring-before(format-number(sum(//rti:IRenvelope/rti:RTI/rti:FullPaymentSubmission/rti:Employee/rti:Employment/rti:Payment/rti:NonTaxOrNICPmt),'0.00'),'.')"/><BR/>
				Deds From Net: <xsl:value-of select="substring-before(format-number(sum(//rti:IRenvelope/rti:RTI/rti:FullPaymentSubmission/rti:Employee/rti:Employment/rti:Payment/rti:DednsFromNetPay),'0.00'),'.')"/><BR/>
				Pay After Stat Deds: <xsl:value-of select="substring-before(format-number(sum(//rti:IRenvelope/rti:RTI/rti:FullPaymentSubmission/rti:Employee/rti:Employment/rti:Payment/rti:PayAfterStatDedns),'0.00'),'.')"/><BR/>
				Benefits Taxed via Payroll: <xsl:value-of select="substring-before(format-number(sum(//rti:IRenvelope/rti:RTI/rti:FullPaymentSubmission/rti:Employee/rti:Employment/rti:Payment/rti:BenefitsTaxedViaPayroll),'0.00'),'.')"/><BR/>
				Employee Pension Contributions: <xsl:value-of select="substring-before(format-number(sum(//rti:IRenvelope/rti:RTI/rti:FullPaymentSubmission/rti:Employee/rti:Employment/rti:Payment/rti:EmpeePenContribnsPaid),'0.00'),'.')"/><BR/>
				Items Subject to Class 1 NIC: <xsl:value-of select="substring-before(format-number(sum(//rti:IRenvelope/rti:RTI/rti:FullPaymentSubmission/rti:Employee/rti:Employment/rti:Payment/rti:ItemsSubjectToClass1NIC),'0.00'),'.')"/><BR/>
				Employee Contributions not Paid: <xsl:value-of select="substring-before(format-number(sum(//rti:IRenvelope/rti:RTI/rti:FullPaymentSubmission/rti:Employee/rti:Employment/rti:Payment/rti:EmpeePenContribnsNotPaid),'0.00'),'.')"/><BR/>
				Student Loan Repayment Recovered this period: <xsl:value-of select="substring-before(format-number(sum(//rti:IRenvelope/rti:RTI/rti:FullPaymentSubmission/rti:Employee/rti:Employment/rti:Payment/rti:StudentLoanRecovered),'0.00'),'.')"/>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
