<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:rti="selima:FBI Rendering"
 xmlns:xalan="http://xml.apache.org/xalan"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"> 
    <ext:cuttingRules>
        <rules>
            <exclude path="/IRenvelope/EarlierYearUpdate/Employee/*">
            	<exception path="/IRenvelope/EarlierYearUpdate/Employee/Employment"/>
            </exclude>
            <exclude path="/IRenvelope/EarlierYearUpdate/Employee/Employment/*"/>
        </rules>
    </ext:cuttingRules>	
    <xsl:output method="xml" encoding="UTF-8"/>
    
    <xsl:template match="/">
        <pages>
            <xsl:for-each select="/rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee">
            <page id="{position()}">
                <keys>
					<key name="Name" default="true">
						<xsl:for-each select="rti:EmployeeDetails/rti:Name/*">
						 	<xsl:value-of select="."/><xsl:text> </xsl:text>
						 </xsl:for-each>
						 (<xsl:value-of select="position()"/>)
					</key>
                </keys>
				<rules>
					<exclude path="/IRenvelope/EarlierYearUpdate/Employee">
						<exception path="/IRenvelope/EarlierYearUpdate/Employee[{position()}]"/>
					</exclude>
				</rules>
            </page>
            </xsl:for-each>
        </pages>
    </xsl:template>
    
</xsl:stylesheet>
