<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:rti="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>
    <ext:annotation
     metadata="EYUEmployee(20XX).metadata.xsl"
     rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/RTI/EarlierYearUpdate/19-20/1"
     rewrite_to_ns="selima:FBI Rendering"
    />
    <xsl:output method="html" encoding="UTF-8"/>

    <xsl:param name="page">title-page</xsl:param>
    <xsl:param name="url"/>
	<xsl:variable name="pageSize">width: 826px; height: 1123px;</xsl:variable>
    <xsl:template match="/">
        <html>
            <head>
                <title>EYU(<xsl:value-of select="rti:IRenvelope/rti:EarlierYearUpdate/rti:RelatedTaxYear"/>)</title>
                <style type="text/css">
					body {
						margin: 0px;
						padding: 0px;
						font: normal normal normal 11pt monospace;
					}
                    
                    div {
                    background: transparent none no-repeat scroll top left;
                    }
                    
                    body * div {
                    position: absolute;
                    border: 1px dotted transparent;
                    }
                    
                    div.checkbox {
                    	font-family:sans-serif;text-align:center;
                    	border-left: 1px solid #606060;
                    	border-bottom: 1px solid #606060;
                    	border-right: 1px solid #D0D0D0;
                    	border-top: 1px solid #D0D0D0;
                        background-color: #FFD;
                        width: 19px;
	                    padding-left: 0px;
                    }
                    
                    div.large-text {
                    	font-size: 18pt
                    }
                    
                    div.number {
                    	text-align: right;
                    }
                    
                    div.date {
                    	text-align: center;
                    }
                    
                    div.label {
                    	color: black;
                    }
                    
                    div.section-header {
                    	font-size: 16pt;
                    }
                    
                    div.field {
                        border-bottom: 1px solid #008080;
                        padding-left: 5px;
                    	color: blue;
                    	font-weight: bold;
                    }
                    div.remark {
                        padding-left: 5px;
                    	color: gray;
                    }
                </style>
            </head>
            <body>
				<div style="background-image: url(images/fps.png);{$pageSize}">
					<div style="{$pageSize};padding:0px;padding-top:100px">
						<div style="left:20px;top:100px">
							<div style="position:relative">
								<div class="label">
									NINO
								</div>
								<div class="field" style="left:100px;width:125px">
									<xsl:value-of select="//rti:EmployeeDetails/rti:NINO"/>&#160;
								</div>					
								<div class="label" style="left:250px">
									Name
								</div>
								<div class="field" style="left:380px;width:400px">					
									<xsl:for-each select="//rti:EmployeeDetails/rti:Name/*">
										<xsl:value-of select="."/><xsl:text> </xsl:text>
									</xsl:for-each>
								</div>
							</div>
							<div style="position: relative">
								<div class="label">
									Birth Date	
								</div>
								<div class="field" style="left:100px;width:100px">
									<xsl:value-of select="ext:dateFormat(//rti:EmployeeDetails/rti:BirthDate)"/>&#160;
								</div>					
								<div class="label" style="left:250px">
									Passport Number
								</div>
								<div class="field" style="left:380px;width:225px">					
									<xsl:value-of select="//rti:EmployeeDetails/rti:PassportNumber"/>&#160;
								</div>
								<div class="label" style="left:675px">
									Gender
								</div>
								<div class="field" style="left:750px;width:25px">
									<xsl:value-of select="//rti:EmployeeDetails/rti:Gender"/>&#160;
								</div>	
							</div>
							<div style="position: relative">
								<div class="label">
									Partner NINO
								</div>
								<div class="field" style="left:100px;width:125px">
									<xsl:value-of select="//rti:EmployeeDetails/rti:PartnerDetails/rti:NINO"/>&#160;
								</div>
								<div class="label" style="left:250px">
									Partner Name
								</div>
								<div class="field" style="left:380px;width:400px">					
									<xsl:for-each select="//rti:EmployeeDetails/rti:PartnerDetails/rti:Name/*">
										<xsl:value-of select="."/><xsl:text> </xsl:text>
									</xsl:for-each>&#160;
								</div>
							</div>
							<xsl:for-each select="//rti:Employment">
							<div class="large-text" style="position:relative; margin: 25px 0px 10px 0px">
								Employment
							</div>
							<div style="position: relative">
								<div class="label" style="left:0px">
									Starting Declaration
								</div>
								<div class="field" style="left:210px;width:100px">
									<xsl:value-of select="rti:Starter/rti:StartDec"/>&#160;									
								</div>
								<div class="label" style="left:330px">
									Starting Date									
								</div>
								<div class="field" style="left:485px;width:30px">
									<xsl:value-of select="ext:dateFormat(rti:Starter/rti:StartDate)"/>&#160;
								</div>								
								<div class="label" style="left:610px">
									Student Loan
								</div>
								<div class="field" style="left:740px;width:30px">					
									<xsl:value-of select="rti:Starter/rti:StudentLoan"/>&#160;
								</div>
							</div>
							<div style="position: relative">
								<div class="label" style="left:0px">
									Postgraduate Loan
								</div>
								<div class="field" style="left:210px;width:100px">
									<xsl:value-of select="rti:Starter/rti:PostgradLoan"/>&#160;
								</div>
								<div class="label" style="left:330px">
									EPM 6 (modified) scheme
								</div>
								<div class="field" style="left:550px;width:30px">					
									<xsl:value-of select="rti:Starter/rti:Seconded/rti:EPM6"/>&#160;
								</div>							
								<div class="label" style="left:610px">
									EEA citizen
								</div>
								<div class="field" style="left:740px;width:30px">					
									<xsl:value-of select="rti:Starter/rti:Seconded/rti:EEACitizen"/>&#160;
								</div>							
							</div>											
							<div style="position: relative">
								<div class="label" style="left:0px">
									In UK for 183 days or more
								</div>
								<div class="field" style="left:210px;width:100px">
									<xsl:value-of select="rti:Starter/rti:Seconded/rti:Stay183DaysOrMore"/>&#160;
								</div>
								<div class="label" style="left:330px">
									In UK for less than 183 days
								</div>
								<div class="field" style="left:550px;width:30px">
									<xsl:value-of select="rti:Starter/rti:Seconded/rti:StayLessThan183Days"/>&#160;
								</div>
								<div class="label" style="left:610px">
									In / out of the UK
								</div>
								<div class="field" style="left:740px;width:30px">
									<xsl:value-of select="rti:Starter/rti:Seconded/rti:InOutUK"/>&#160;
								</div>								
							</div>
							<div style="position: relative">
								<div class="label">
									Occupational pension
								</div>
								<div class="field" style="left:210px;width:100px">
									<xsl:value-of select="rti:Starter/rti:OccPension/rti:Amount"/>&#160;
								</div>
								<div class="label" style="left:330px">
									Bereaved
								</div>
								<div class="field" style="left:550px;width:30px">					
									<xsl:value-of select="rti:Starter/rti:OccPension/rti:Bereaved"/>&#160;
								</div>				
							</div>
							<div style="position: relative">
								<div class="label">
									Payroll ID
								</div>
								<div class="field" style="left:210px;width:100px">
									<xsl:value-of select="rti:PayId"/>&#160;
								</div>
								<div class="label" style="left:330px">
									Payment to a non individual
								</div>
								<div class="field" style="left:550px;width:30px">
									<xsl:value-of select="rti:PaymentToANonIndividual"/>&#160;
								</div>								
							</div>
							<div style="position: relative">
								<div class="label" style="left:0px">
									Leaving Date
								</div>
								<div class="field" style="left:210px;width:100px">
									<xsl:value-of select="ext:dateFormat(rti:LeavingDate)"/>&#160;
								</div>
							</div>							
							<div class="large-text" style="position:relative; margin: 25px 0px 0px 0px">
								Payment
							</div>
							<div style="position: relative">			
								<div class="label"  style="left:0px">
									Tax code
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:TaxCode"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Tax Code basis non-cumulative
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:TaxCode/@BasisNonCumulative"/>&#160;
								</div>							
							</div>
							<div style="position: relative">			
								<div class="label" style="left:0px">
									Tax regime
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:TaxCode/@TaxRegime"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Taxable pay
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:TaxablePay"/>&#160;
								</div>															
							</div>							
							<div style="position: relative">			
								<div class="label" style="left:0px">
									Tax
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:Tax"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Benefits taxed via the payroll
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:BenefitsTaxedViaPayroll"/>&#160;
								</div>
							</div>
							<div style="position: relative">			
								<div class="label" style="left:0px">
									Employee pension contributions<br/>under 'net pay arrangements'
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:EmpeePenContribnsPaid"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Employee pension contributions<br/>not under 'net pay arrangements'
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:EmpeePenContribnsNotPaid"/>&#160;
								</div>
							</div>
							<div style="position: relative">			
								<div class="label" style="left:0px">
									Student loans repayments
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:StudentLoanRecovered"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Postgraduate loans repayments
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:PostgradLoanRecovered"/>&#160;
								</div>
							</div>
							<div style="position: relative">			
								<div class="label">
									Statutory Maternity pay (SMP)
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:SMP"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Statutory Paternity pay (SPP)
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:SPP"/>&#160;
								</div>
							</div>
							<div style="position: relative">			
								<div class="label">
									Statutory Adoption pay (SAP)
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:SAP"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Shared Parental pay (ShPP)
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:ShPP"/>&#160;
								</div>
							</div>
							<div style="position: relative">			
								<div class="label" style="left:0px">
									Flexibly accessing pen. rights
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:FlexibleDrawdown/rti:FlexiblyAccessingPensionRights"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Pension Death Benefit
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:FlexibleDrawdown/rti:PensionDeathBenefit"/>&#160;
								</div>
							</div>
							<div style="position:relative">
								<div class="label" style="left:0px">
									Flexible drawdown taxable<BR/>payment
								</div>
								<div class="field" style="left:250px;width:100px">
									<xsl:value-of select="rti:Payment/rti:FlexibleDrawdown/rti:TaxablePayment"/>&#160;
								</div>
								<div class="label" style="left:440px">
									Flexible drawdown non-taxable<BR/>payment
								</div>
								<div class="field" style="left:680px;width:100px">
									<xsl:value-of select="rti:Payment/rti:FlexibleDrawdown/rti:NontaxablePayment"/>&#160;
								</div>				
							</div>
							<div class="large-text" style="position:relative; margin: 25px 0px 0px 0px">
								NI Letters and Values
							</div>
							<xsl:for-each select="rti:NIlettersAndValues">
							<div style="position: relative; margin:10px">			
								<div class="label" style="left:30px">
									(Category)
								</div>
								<div class="field" style="left:0px;width:20px">
									<xsl:value-of select="rti:NIletter"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label">
									Gross earnings for NICs
								</div>
								<div class="field" style="left:610px;width:100px">
									<xsl:value-of select="rti:GrossEarningsForNICs"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label">
									Earnings at Lower Earnings Limit
								</div>				
								<div class="field" style="left:610px;width:100px">
									<xsl:value-of select="rti:AtLEL"/>&#160;				
								</div>
							</div>
							<div  style="position: relative;left:20px">			
								<div class="label" style="left:0px">
									Earnings above Lower Earnings Limit to Primary Threshold
								</div>
								<div class="field" style="left:610px;width:100px">
									<xsl:value-of select="rti:LELtoPT"/>&#160;
								</div>
							</div>
							<div  style="position: relative;left:20px">			
								<div class="label" style="left:0px">
									Earnings from the Primary Threshold up to and including the Upper Earnings Limit
								</div>
								<div class="field" style="left:610px;width:100px">
									<xsl:value-of select="rti:PTtoUEL"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label">
									Total of employer NI Contributions
								</div>
								<div class="field" style="left:610px;width:100px">
									<xsl:value-of select="rti:TotalEmpNIC"/>&#160;
								</div>
							</div>							
							<div style="position: relative;left:20px">
								<div class="label">
									Employees contributions due on earnings
								</div>
								<div class="field" style="left:610px;width:100px">
									<xsl:value-of select="rti:EmpeeContribns"/>&#160;
								</div>
							</div>
							<div style="position: relative;left:20px">
								<div class="label">
									Overpayment of primary NIC, refund made to employee
								</div>
								<div class="field" style="left:610px;width:100px">
									<xsl:value-of select="rti:NICRefund"/>&#160;
								</div>
							</div>														
							</xsl:for-each>						
							</xsl:for-each>
							<div style="position:relative;margin:20px">
							</div>
						</div>   
			        </div>
		        </div>
			</body>
		</html>    
	</xsl:template>

</xsl:stylesheet>
