<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:rti="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>	
    <xsl:output method="html" encoding="UTF-8"/>
    
    <!-- These should be supplied by external stylesheet user-->
    <xsl:param name="page">1</xsl:param>
    <xsl:template match="/">
        <xsl:variable name="pageType">
            <xsl:choose>
                <xsl:when test="$page = 1">title page</xsl:when>
                <xsl:when test="$page mod 2 = 0">cont. sheet 1</xsl:when>
                <xsl:otherwise>cont. sheet 2</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

		<xsl:variable name="employees">
			<xsl:copy-of select="//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee"/>
	    </xsl:variable>
        <html>
            <head>
                <title>EYU</title>
                <style type="text/css">
                    body {
                    margin: 15px;
                    padding: 0px;
                    }
                    
                    div {
                    background: transparent none no-repeat scroll top left;
                    }
                    
                    body * div {
                    position: absolute;
                    border: 1px dotted transparent;
                    }
                    
                    div.checkbox {
                    font-family:sans-serif;text-align:center
                    }
                    
                    div.large-text {
                    font-size: 32pt
                    }
                    
                    div {
                    	margin-top: 5px;
                    }
                </style>
            </head>
            <body>
            	<xsl:call-template name="totals"/>
			</body>
</html>
</xsl:template>

<xsl:template name="totals">
</xsl:template>
</xsl:stylesheet>
