<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:rti="selima:FBI Rendering"
 xmlns:xalan="http://xml.apache.org/xalan"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"> 
    <ext:cuttingRules>
        <rules>
            <exclude path="/IRenvelope/EarlierYearUpdate/Employee/*"/>
        </rules>
    </ext:cuttingRules>	
    <xsl:output method="xml" encoding="UTF-8"/>
    
    <xsl:template match="/">
        <pages>
            <page id="title">
                <keys>
                    <key name="Name" default="true">
                        Header (1)
                    </key>
                </keys>
            </page>
            <xsl:variable name="rowCount" select="42"/>
            <xsl:for-each select="/rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee">
            <xsl:if test="position() mod $rowCount = 1">
	            <page id="{position()}">
	                <keys>
						<key name="Name" default="true">
							Cont. sheet (<xsl:value-of select="format-number(position() div $rowCount + 2,'0')"/>)
						</key>
	                </keys>
					<rules>
						<exclude path="/IRenvelope/EarlierYearUpdate/Employee">
							<exception path="/IRenvelope/EarlierYearUpdate/Employee[position() &gt;= {position()} and position() &lt;= {position() + $rowCount - 1} ]"/>
						</exclude>
					</rules>
	            </page>
            </xsl:if>
            </xsl:for-each>
        </pages>
    </xsl:template>
    
</xsl:stylesheet>
