<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:rti="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>
    <ext:annotation
     metadata="EYU(20XX).metadata.xsl"
     rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/RTI/EarlierYearUpdate/19-20/1"
     rewrite_to_ns="selima:FBI Rendering"
    />
    <xsl:output method="html" encoding="UTF-8"/>

    <xsl:param name="page">title-page</xsl:param>
    <xsl:param name="url"/>
	<xsl:variable name="pageSize">width: 826px; height: 1123px;</xsl:variable>
    <xsl:template match="/">
        <html>
            <head>
                <title>EYU(<xsl:value-of select="rti:IRenvelope/rti:EarlierYearUpdate/rti:RelatedTaxYear"/>)</title>
                <style type="text/css">
					body {
						margin: 0px;
						padding: 0px;
						font: normal normal normal 11pt monospace;
					}
                    
                    div {
                    background: transparent none no-repeat scroll top left;
                    }
                    
                    body * div {
                    position: absolute;
                    border: 1px dotted transparent;
                    }
                    
                    div.checkbox {
                    	font-family:sans-serif;text-align:center;
                    	border-left: 1px solid #606060;
                    	border-bottom: 1px solid #606060;
                    	border-right: 1px solid #D0D0D0;
                    	border-top: 1px solid #D0D0D0;
                        background-color: #FFD;
                        width: 19px;
	                    padding-left: 0px;
                    }
                    
                    div.large-text {
                    	font-size: 18pt
                    }
                    
                    div.number {
                    	text-align: right;
                    }
                    
                    div.date {
                    	text-align: center;
                    }
                    
                    div.label {
                    	color: black;
                    }
                    
                    div.section-header {
                    	font-size: 16pt;
                    }
                    
                    div.field {
                        border-bottom: 1px solid #008080;
                        padding-left: 5px;
                    	color: blue;
                    	font-weight: bold;
                    }
                    div.remark {
                        padding-left: 5px;
                    	color: gray;
                    }
                </style>
            </head>
            <body>
				<div style="background-image: url(images/eyu.png);{$pageSize}">
					<div style="{$pageSize}; padding: 0px;padding-top: 100px">
			        <xsl:choose>
			            <xsl:when test="$page = 'title'">
			            	<xsl:apply-templates select="self::node()" mode="title-page"/>
			            </xsl:when>
			            <xsl:otherwise>
			            	<xsl:apply-templates select="self::node()" mode="list-page"/>
			            </xsl:otherwise>
			        </xsl:choose>
			        </div>
		        </div>
			</body>
		</html>        
	</xsl:template>

	<xsl:template match="/" mode="title-page">
		<div style="left: 20px;top: 100px">	
			<xsl:if test="rti:IRenvelope/rti:IRheader/rti:Principal">
			<div style="position: relative">
				<div class="label">Principal</div>		
				<div class="field" style="left:100px; width:450px">
					<xsl:for-each select="rti:IRenvelope/rti:IRheader/rti:Principal/rti:Contact/rti:Name/*">
						<xsl:value-of select="."/>
						<xsl:text> </xsl:text>
					</xsl:for-each>
				</div>
				<div class="label" style="left:560px">Period End</div>
				<div class="field" style="left:660px">
					<xsl:value-of select="ext:dateFormat(rti:IRenvelope/rti:IRheader/rti:PeriodEnd)"/>
				</div>
			</div>
			<div style="position: relative">
					<div>
						<div class="label">Email</div>
						<div style="left:100px">
							<xsl:for-each select="rti:IRenvelope/rti:IRheader/rti:Principal/rti:Contact/rti:Email">
								<div class="field" style="position: relative">
								<xsl:value-of select="."/>
								</div>
								<div class="remark" style="position: relative">
									<xsl:for-each select="@*">
										<xsl:if test="name()='Type'"> (<xsl:value-of select="."/>)</xsl:if>
										<xsl:if test="name()='Preferred' and .='yes'"> [pref]</xsl:if>
									</xsl:for-each>
								</div>
							</xsl:for-each>
						</div>
					</div>
					<div style="left:455px">
						<xsl:if test="rti:IRenvelope/rti:IRheader/rti:Principal/rti:Contact/rti:Telephone">			
							<div style="position: relative">
								<div class="label">Telephone</div>
								<div style="left: 100px">
									<xsl:for-each select="rti:IRenvelope/rti:IRheader/rti:Principal/rti:Contact/rti:Telephone">
										<div class="field" style="position: relative">
										<xsl:value-of select="rti:Number"/><xsl:if test="rti:Extension">-<xsl:value-of select="rti:Extension"/></xsl:if>
										</div>
										<div class="remark" style="position: relative">
											<xsl:for-each select="@*">
												<xsl:if test="name()='Type'"> (<xsl:value-of select="."/>)</xsl:if>
												<xsl:if test="name()='Preferred' and .='yes'"> [pref]</xsl:if>
												<xsl:if test="name()='Mobile' and .='yes'"> {mob}</xsl:if>
											</xsl:for-each>
										</div>
									</xsl:for-each>
								</div>
							</div>
						</xsl:if>
						<xsl:if test="rti:IRenvelope/rti:IRheader/rti:Principal/rti:Contact/rti:Fax">
							<div style="position: relative">
								<div class="label">Fax</div>
								<div style="left:100px">
									<xsl:for-each select="rti:IRenvelope/rti:IRheader/rti:Principal/rti:Contact/rti:Fax">
										<div class="field" style="position: relative">
										<xsl:value-of select="rti:Number"/><xsl:if test="rti:Extension">-<xsl:value-of select="rti:Extension"/></xsl:if>
										</div>
										<div class="remark" style="position: relative">
											<xsl:for-each select="@*">
												<xsl:if test="name()='Type'"> (<xsl:value-of select="."/>)</xsl:if>
												<xsl:if test="name()='Preferred' and .='yes'"> [pref]</xsl:if>
											</xsl:for-each>
										</div>
									</xsl:for-each>
								</div>
							</div>
						</xsl:if>
					</div>			
			</div>
			</xsl:if>
			<xsl:if test="rti:IRenvelope/rti:IRheader/rti:Agent">
			<div style="position: relative">
				<div class="label">Agent ID</div>		
				<div class="field" style="left:100px; width:425px">
					<xsl:value-of select="rti:IRenvelope/rti:IRheader/rti:Agent/rti:AgentID"/>
				</div>
				<div class="label" style="left:560px">Period End</div>
				<div class="field" style="left:660px;width:110px">
					<xsl:value-of select="ext:dateFormat(rti:IRenvelope/rti:IRheader/rti:PeriodEnd)"/>
				</div>
			</div>
			<div style="position: relative; margin-top: 20px">
				<div class="label">Company</div>		
				<div class="field" style="left:100px; width:425px">
					<xsl:value-of select="rti:IRenvelope/rti:IRheader/rti:Agent/rti:Company"/>
				</div>
			</div>
			<div style="position: relative; margin-top: 20px">
				<div class="label">Address</div>		
				<div class="field" style="left:100px; width:325px">
					<xsl:for-each select="rti:IRenvelope/rti:IRheader/rti:Agent/rti:Address/rti:Line">
						<div style="position: relative">
							<xsl:value-of select="."/>
						</div>
					</xsl:for-each>
				</div>
				<div class="label" style="left:455px">PostCode</div>
				<div class="field" style="left:555px;width:180px">
					<xsl:value-of select="rti:IRenvelope/rti:IRheader/rti:Agent/rti:Address/rti:PostCode"/>
				</div>
				<div class="label" style="left:455px;top:30px">Country</div>
				<div class="field" style="left:555px;top:30px;width:180px">
					<xsl:value-of select="rti:IRenvelope/rti:IRheader/rti:Agent/rti:Address/rti:Country"/>
				</div>
			</div>
			<div style="position: relative; margin-top: 20px">				
				<div>
				<div style="position: relative">
				<div class="label">Contact</div>		
					<div class="field" style="left:100px; width:325px">
						<xsl:for-each select="rti:IRenvelope/rti:IRheader/rti:Agent/rti:Contact/rti:Name/*">
							<xsl:value-of select="."/>
							<xsl:text> </xsl:text>
						</xsl:for-each>
					</div>
				</div>				
				<div style="position:relative; margin-top:20px">
					<div class="label">Email</div>
					<div style="left:100px">
						<xsl:for-each select="rti:IRenvelope/rti:IRheader/rti:Agent/rti:Contact/rti:Email">
							<div class="field" style="position: relative; width:325px">
							<xsl:value-of select="."/>
							</div>
							<div class="remark" style="position: relative">
								<xsl:for-each select="@*">
									<xsl:if test="name()='Type'"> (<xsl:value-of select="."/>)</xsl:if>
									<xsl:if test="name()='Preferred' and .='yes'"> [pref]</xsl:if>
								</xsl:for-each>
							</div>
						</xsl:for-each>
					</div>
				</div>
				</div>
				<div style="left:455px">
					<xsl:if test="rti:IRenvelope/rti:IRheader/rti:Agent/rti:Contact/rti:Telephone">			
						<div style="position: relative">
							<div class="label">Telephone</div>
							<div style="left: 100px">
								<xsl:for-each select="rti:IRenvelope/rti:IRheader/rti:Agent/rti:Contact/rti:Telephone">
									<div class="field" style="position: relative;width:180px">
									<xsl:value-of select="rti:Number"/><xsl:if test="rti:Extension">-<xsl:value-of select="rti:Extension"/></xsl:if>
									</div>
									<div class="remark" style="position: relative">
										<xsl:for-each select="@*">
											<xsl:if test="name()='Type'"> (<xsl:value-of select="."/>)</xsl:if>
											<xsl:if test="name()='Preferred' and .='yes'"> [pref]</xsl:if>
											<xsl:if test="name()='Mobile' and .='yes'"> {mob}</xsl:if>
										</xsl:for-each>
									</div>
								</xsl:for-each>
							</div>
						</div>
					</xsl:if>
					<xsl:if test="rti:IRenvelope/rti:IRheader/rti:Agent/rti:Contact/rti:Fax">
						<div style="position: relative">
							<div class="label">Fax</div>
							<div style="left:100px">
								<xsl:for-each select="rti:IRenvelope/rti:IRheader/rti:Agent/rti:Contact/rti:Fax">
									<div class="field" style="position: relative;width:180px">
									<xsl:value-of select="rti:Number"/><xsl:if test="rti:Extension">-<xsl:value-of select="rti:Extension"/></xsl:if>
									</div>
									<div class="remark" style="position: relative">
										<xsl:for-each select="@*">
											<xsl:if test="name()='Type'"> (<xsl:value-of select="."/>)</xsl:if>
											<xsl:if test="name()='Preferred' and .='yes'"> [pref]</xsl:if>
										</xsl:for-each>
									</div>
								</xsl:for-each>
							</div>
						</div>
					</xsl:if>
				</div>
			</div>
			</xsl:if>
			<div style="position:relative; margin-top:20px">
				<div class="label">Sender</div>
				<div class="field" style="left:125px;width:275px">
					<xsl:value-of select="rti:IRenvelope/rti:IRheader/rti:Sender"/>
				</div>
				<div class="label" style="left:455px">
					Default Currency
				</div>
				<div class="field" style="left:600px;width:135px">
					<xsl:value-of select="rti:IRenvelope/rti:IRheader/rti:DefaultCurrency"/>
				</div>
			</div>
			<div style="position:relative; margin-top: 20px">
				<div class="label">Office Number</div>
				<div class="field" style="left:125px;width:50px">
					<xsl:value-of select="rti:IRenvelope/rti:EarlierYearUpdate/rti:EmpRefs/rti:OfficeNo"/>
				</div>
				<div class="label" style="left:455px">
					PAYE Reference
				</div>
				<div class="field" style="left:600px;width:135px">
					<xsl:value-of select="rti:IRenvelope/rti:EarlierYearUpdate/rti:EmpRefs/rti:PayeRef"/>
				</div>
			</div>
			<div style="position:relative; margin-top: 20px">
				<div class="label" style="width:280px">Employer Accounts Office reference</div>
				<div class="field" style="left:275px;width:150px">
					<xsl:value-of select="rti:IRenvelope/rti:EarlierYearUpdate/rti:EmpRefs/rti:AORef"/>
				</div>
			</div>
			<div class="large-text" style="position:relative; margin: 75px 0px 0px 0px">
				Submission Totals
			</div>
			<div style="position:relative; margin-top: 20px">
				<div class="label" style="width:300px">Taxable pay including benefits<br/>undertaken through payroll</div>
				<div class="field" style="left:250px;width:100px">
					<xsl:value-of select="format-number(floor(sum(//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee/rti:Employment/rti:Payment/rti:TaxablePay)),'0')"/>
				</div>
				<div class="label" style="left:400px;width:250px">Benefits taxed via payroll</div>
				<div class="field" style="left:670px;width:100px">			
					<xsl:value-of select="format-number(floor(sum(//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee/rti:Employment/rti:Payment/rti:BenefitsTaxedViaPayroll)),'0')"/>
				</div>				
	        </div>
			<div style="position:relative; margin-top: 20px">
				<div class="label" style="left: 0px; width:250px">Employee pension contributions<br/>under 'Net Pay Arrangements'</div>
				<div class="field" style="left: 250px;width:100px">			
					<xsl:value-of select="format-number(floor(sum(//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee/rti:Employment/rti:Payment/rti:EmpeePenContribnsPaid)),'0')"/>
				</div>
				<div class="label" style="left: 400px; width:250px">Employee Pension Contributions<br/>not under 'Net Pay Arrangements'</div>
				<div class="field" style="left: 670px;width:100px">			
					<xsl:value-of select="format-number(floor(sum(//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee/rti:Employment/rti:Payment/rti:EmpeePenContribnsNotPaid)),'0')"/>
				</div>				
			</div>
			<div style="position:relative; margin-top: 20px">
				<div class="label" style="width:400px">Student loans repayments</div>
				<div class="field" style="left:250px;width:100px">			
					<xsl:value-of select="format-number(floor(sum(//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee/rti:Employment/rti:Payment/rti:StudentLoanRecovered)),'0')"/>
				</div>
				<div class="label" style="left: 400px; width:250px">Tax</div>
				<div class="field" style="left: 670px;width:100px">			
					<xsl:value-of select="format-number(floor(sum(//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee/rti:Employment/rti:Payment/rti:Tax)),'0')"/>
				</div>
			</div>
			<div style="position:relative; margin-top: 20px">
				<div class="label" style="width:400px">Statutory Maternity pay (SMP)</div>
				<div class="field" style="left:250px;width:100px">			
					<xsl:value-of select="format-number(floor(sum(//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee/rti:Employment/rti:Payment/rti:SMP)),'0')"/>
				</div>
				<div class="label" style="left: 400px; width:250px">Statutory Paternity pay (SPP)</div>
				<div class="field" style="left: 670px;width:100px">			
					<xsl:value-of select="format-number(floor(sum(//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee/rti:Employment/rti:Payment/rti:SPP)),'0')"/>
				</div>				
			</div>
			<div style="position:relative; margin-top: 20px">
				<div class="label" style="width:400px">Statutory Adoption pay (SAP)</div>
				<div class="field" style="left:250px;width:100px">			
					<xsl:value-of select="format-number(floor(sum(//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee/rti:Employment/rti:Payment/rti:SAP)),'0')"/>
				</div>
				<div class="label" style="left: 400px; width:250px">Shared Parental pay (ShPP)</div>
				<div class="field" style="left: 670px;width:100px">			
					<xsl:value-of select="format-number(floor(sum(//rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee/rti:Employment/rti:Payment/rti:ShPP)),'0')"/>
				</div>				
			</div>			
		</div>		
	</xsl:template>


	<xsl:template match="/" mode="list-page">
		<div style="left: 20px;top: 100px">
			<div style="position: relative;border: 1px solid black">
				<div class="section-header" style="left:0px;padding: 0px 5px">NINO</div>
				<div class="section-header" style="left:125px;padding: 0px 5px;border-left:1px solid black">Name</div>
				<div class="section-header" style="left:650px;width:135px;padding: 0px 5px;border-left:1px solid black">Birth Date</div>			
			</div>		
		<xsl:for-each select="/rti:IRenvelope/rti:EarlierYearUpdate/rti:Employee">
			<div style="width:100px;position: relative; border: 1px solid black">
				<div style="padding:0px 10px;border-left:1px solid black">
					<div class="field">
						<a href="{concat($url,'&amp;transformation=/templates/PAYE/EYUEmployee(2020).xsl&amp;page=',$page + position() - 1)}">
							<xsl:value-of select="rti:EmployeeDetails/rti:NINO"/>&#160;
						</a>
					</div>
				</div>
				<div style="left:125px;width: 550px;padding:0px 10px;border-left:1px solid black">
					<div class="field">
					<a href="{concat($url,'&amp;transformation=/templates/PAYE/EYUEmployee(2020).xsl&amp;page=',$page + position() - 1)}"><xsl:for-each select="rti:EmployeeDetails/rti:Name/*">
						<xsl:value-of select="."/><xsl:text> </xsl:text>
					</xsl:for-each>
					</a>
					</div>
				</div>
				<div style="left:650px;width:125px;padding:0px 10px;border-left:1px solid black">
					<div class="field">
						<xsl:value-of select="ext:dateFormat(rti:EmployeeDetails/rti:BirthDate)"/>&#160;
					</div>
				</div>
			</div>
		</xsl:for-each>
		</div>       
	</xsl:template>

</xsl:stylesheet>
