<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:eps="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>    
	<xsl:output method="html" encoding="UTF-8"/>
	<xsl:variable name="labelGap" select="10"/>
	<xsl:variable name="rowHeight" select="25"/>
	<xsl:variable name="leftEdge" select="10"/>
	<xsl:variable name="topEdge" select="125"/>
	<xsl:variable name="widthLabelPayeReference" select="200"/>
	<xsl:variable name="leftFieldPayeReference" select="$leftEdge + $widthLabelPayeReference + $labelGap"/>
	<xsl:variable name="widthFieldPayeReference" select="150"/>
	<xsl:variable name="topAccountsOfficeReference" select="$topEdge + $rowHeight"/>
	<xsl:variable name="widthDateField" select="100"/>
	
	<xsl:variable name="leftTaxYear" select="$leftFieldPayeReference + $widthFieldPayeReference + $labelGap + 30"/>
	<xsl:variable name="widthTaxYearLabel">175</xsl:variable>
	<xsl:variable name="leftTaxYearField" select="$leftTaxYear + $widthTaxYearLabel + $labelGap"/>
	<xsl:variable name="widthTaxYearField" select="150"/>
	
	<xsl:variable name="topNoPaymentPeriod" select="$topAccountsOfficeReference + $rowHeight + 20"/>
	<xsl:variable name="leftNoPaymentPeriod" select="$leftEdge"/>
	<xsl:variable name="widthNoPaymentPeriod" select="150"/>
	<xsl:variable name="leftLabelFrom" select="$leftFieldPayeReference"/>
	<xsl:variable name="widthLabelFrom" select="50"/>
	<xsl:variable name="leftFieldFrom" select="$leftLabelFrom + $widthLabelFrom + $labelGap"/>
	<xsl:variable name="widthFieldFrom" select="$widthDateField"/>	
	<xsl:variable name="leftLabelTo" select="$leftTaxYear + 60"/>
	<xsl:variable name="widthLabelTo" select="30"/>
	<xsl:variable name="leftFieldTo" select="$leftLabelTo + $widthLabelTo + $labelGap"/>
	<xsl:variable name="widthFieldTo" select="$widthDateField"/>	

	<xsl:variable name="topPeriodOfInactivity" select="$topNoPaymentPeriod + $rowHeight + 5"/>
	<xsl:variable name="leftPeriodOfInactivity" select="$leftNoPaymentPeriod"/>
	<xsl:variable name="widthPeriodOfInactivity" select="$widthNoPaymentPeriod"/>
	
	<xsl:variable name="topFinalSubmission" select="$topPeriodOfInactivity + $rowHeight + 20"/>
	<xsl:variable name="leftFinalSubmission" select="$leftEdge"/>
	<xsl:variable name="widthFinalSubmission" select="200"/>
	<xsl:variable name="leftLabelBecauseSchemeCeased" select="$leftFieldPayeReference"/>
	<xsl:variable name="widthLabelBecauseSchemeCeased" select="210"/>
	<xsl:variable name="leftFieldBecauseSchemeCeased" select="$leftTaxYear + 20"/>
	<xsl:variable name="leftLabelDateSchemeCeased" select="$leftLabelTo"/>
	<xsl:variable name="widthLabelDateSchemeCeased" select="160"/>
	<xsl:variable name="leftFieldDateSchemeCeased" select="$leftLabelDateSchemeCeased + $widthLabelDateSchemeCeased + $labelGap"/>
	<xsl:variable name="widthFieldDateSchemeCeased" select="$widthDateField"/>
	<xsl:variable name="topFinalSubmissionForYear" select="$topFinalSubmission + $rowHeight"/>
	<xsl:variable name="leftLabelFinalSubmissionForYear" select="$leftLabelBecauseSchemeCeased"/>
	<xsl:variable name="widthLabelFinalSubmissionForYear" select="$widthLabelBecauseSchemeCeased"/>
	<xsl:variable name="leftFieldFinalSubmissionForYear" select="$leftFieldBecauseSchemeCeased"/>

	
	<xsl:variable name="topRecoverableAmountsYTD" select="$topFinalSubmissionForYear + $rowHeight + 75"/>
	<xsl:variable name="leftRecoverableAmountsYTD" select="$leftEdge"/>
	<xsl:variable name="widthRecoverableAmountsYTD" select="500"/>

	<xsl:variable name="topRecoverableAmountsYTD_line1" select="$topRecoverableAmountsYTD + $rowHeight + 10"/>
	<xsl:variable name="widthLabeltopRecoverableAmountsYTD" select="215"/>
	<xsl:variable name="widthFieldtopRecoverableAmountsYTD" select="145"/>	
	<xsl:variable name="leftRecoverableAmountsYTD_column1" select="$leftRecoverableAmountsYTD"/>
	<xsl:variable name="leftRecoverableAmountsYTD_column2" select="$leftLabelFinalSubmissionForYear"/>
	<xsl:variable name="leftRecoverableAmountsYTD_column3" select="$leftTaxYear"/>
	<xsl:variable name="leftRecoverableAmountsYTD_column4" select="$leftTaxYearField + $widthTaxYearField - $widthFieldtopRecoverableAmountsYTD + 20"/>
	<xsl:variable name="topRecoverableAmountsYTD_line2" select="$topRecoverableAmountsYTD_line1 + $rowHeight"/>
	<xsl:variable name="topRecoverableAmountsYTD_line3" select="$topRecoverableAmountsYTD_line2 + $rowHeight"/>
	<xsl:variable name="topRecoverableAmountsYTD_line4" select="$topRecoverableAmountsYTD_line3 + $rowHeight"/>
	<xsl:variable name="topRecoverableAmountsYTD_line5" select="$topRecoverableAmountsYTD_line4 + $rowHeight"/>
	<xsl:variable name="topRecoverableAmountsYTD_line6" select="$topRecoverableAmountsYTD_line5 + $rowHeight"/>		
	
	<xsl:variable name="topQuestionsAndDeclarations" select="$topRecoverableAmountsYTD_line6 + $rowHeight + 50"/>
	<xsl:variable name="leftQuestionsAndDeclarations" select="$leftEdge"/>
	<xsl:variable name="widthQuestionsAndDeclarations" select="500"/>
	<xsl:variable name="widthLabelQuestionsAndDeclarations" select="375"/>
	<xsl:variable name="widthYesNoLabel" select="30"/>
	<xsl:variable name="topQuestionsAndDeclarations_line1" select="$topQuestionsAndDeclarations + 2 * $rowHeight + 10"/>	
	<xsl:variable name="leftQuestionsAndDeclarations_column1" select="$leftQuestionsAndDeclarations"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column4" select="$leftRecoverableAmountsYTD_column2"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column2" select="$leftQuestionsAndDeclarations_column1 + $widthYesNoLabel + $labelGap"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column3" select="$leftQuestionsAndDeclarations_column4 - $widthYesNoLabel - $labelGap"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column5" select="$leftTaxYear"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column8" select="$leftRecoverableAmountsYTD_column4"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column6" select="$leftQuestionsAndDeclarations_column5 + $widthYesNoLabel + $labelGap"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column7" select="$leftQuestionsAndDeclarations_column8 - $widthYesNoLabel - $labelGap"/>
	<xsl:variable name="topQuestionsAndDeclarations_line2" select="$topQuestionsAndDeclarations_line1 + 2 * $rowHeight + 10"/>		
	<xsl:variable name="topQuestionsAndDeclarations_line3" select="$topQuestionsAndDeclarations_line2 + 2 * $rowHeight"/>
	<xsl:variable name="topQuestionsAndDeclarations_line4" select="$topQuestionsAndDeclarations_line3 + 3 * $rowHeight + 10"/>
	<xsl:variable name="topQuestionsAndDeclarations_line5" select="$topQuestionsAndDeclarations_line4 + 2 * $rowHeight"/>
	<xsl:variable name="topQuestionsAndDeclarations_line6" select="$topQuestionsAndDeclarations_line5 + 2 * $rowHeight + 10"/>
		
    <xsl:template match="/">
        <html>
            <head>
                <title>EPS(<xsl:value-of select="eps:IRenvelope/eps:IRheader/eps:RelatedTaxYear"/>)</title>
                <style type="text/css">
					body {
						margin: 0px;
						padding: 0px;
						font: normal normal normal 11pt monospace;
					}
                    
                    div {
                    background: transparent none no-repeat scroll top left;
                    }
                    
                    body * div {
                    position: absolute;
                    border: 1px dotted transparent;
                    }
                    
                    div.checkbox {
                    	font-family:sans-serif;text-align:center;
                    	border-left: 1px solid #606060;
                    	border-bottom: 1px solid #606060;
                    	border-right: 1px solid #D0D0D0;
                    	border-top: 1px solid #D0D0D0;
                        background-color: #FFD;
                        width: 19px;
	                    padding-left: 0px;
                    }
                    
                    div.large-text {
                    	font-size: 26pt
                    }
                    
                    div.number {
                    	text-align: right;
                    }
                    
                    div.date {
                    	text-align: center;
                    }
                    
                    div.label {
                    	color: black;
                    }
                    
                    div.section-header {
                    	font-size: 16pt;
                    }
                    
                    div.field {
                        border-bottom: 1px solid #008080;
                        padding-left: 5px;
                    	color: blue;
                    	font-weight: bold;
                    }
                </style>
            </head>
            <!--                       
            	border-bottom: 1px solid black;
            	background-color: #FFD
             -->
			<xsl:variable name="pageSize">width: 827px; height: 1123px;</xsl:variable>
            <body>
				<div style="background-image: url(images/eps.png);{$pageSize}">
				<div style="{$pageSize}">
					<xsl:call-template name="page1"/>
				</div>
				</div>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="page1">
		
		<div class="label" style="left: {$leftEdge}px;top: {$topEdge}px;width: {$widthLabelPayeReference}px;">
		 Employer PAYE Reference	
		</div>
		<div class="field" style="left: {$leftFieldPayeReference}px;top: {$topEdge}px;width: {$widthFieldPayeReference}px;">
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:EmpRefs/eps:OfficeNo"/>
		 	/<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:EmpRefs/eps:PayeRef"/>&#160;
		 </div>
		 
		<div class="label" style="left: {$leftEdge}px;top: {$topAccountsOfficeReference}px;width: {$widthLabelPayeReference}px;">
		 Accounts Office Reference	
		</div>
		<div class="field" style="left: {$leftFieldPayeReference}px;top: {$topAccountsOfficeReference}px;width: {$widthFieldPayeReference}px;">
		 	<xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:EmpRefs/eps:AORef"/>&#160;
		 </div>
		 
		<!--  RelatedTaxYear -->
		<div class="label large-text" style="left: {$leftTaxYear}px;top: {$topEdge}px;width: {$widthTaxYearLabel}px;">
		 Tax Year
		</div>
		<div class="field large-text" style="left: {$leftTaxYearField}px;top: {$topEdge}px;width: {$widthTaxYearField}px;">
		 	<xsl:text>20</xsl:text><xsl:value-of select="eps:IRenvelope/eps:EmployerPaymentSummary/eps:RelatedTaxYear"/>
		 </div>
	
		 <xsl:call-template name="bellow-header"/>
	
		<!-- NoPaymentPeriod -->
		<div class="label" style="left: {$leftNoPaymentPeriod}px;top: {$topNoPaymentPeriod}px;width: {$widthNoPaymentPeriod}px;">
		 No Payment Period	
		</div>
		<div class="label" style="left: {$leftLabelFrom}px;top: {$topNoPaymentPeriod}px;width: {$widthLabelFrom}px;">
			From
		 </div>
		<div class="field date" style="left: {$leftFieldFrom}px;top: {$topNoPaymentPeriod}px;width: {$widthFieldFrom}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=noPaymentDateFrom editor=DateField
		    	tooltip="If you have made no payments to employees or directors
		    			 for an earlier period of one or more complete tax months
		    			 and there was no FPS made.
		    			  
		    			 Enter the start date of the first tax month in which no
		    			 payments were made. 
		    			 
		    			 This date must be the 6th of the relevant calendar month."</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="ext:dateFormat(eps:IRenvelope/eps:EmployerPaymentSummary/eps:NoPaymentDates/eps:From)"/>&#160;
		 </div>
		<div class="label" style="left: {$leftLabelTo}px;top: {$topNoPaymentPeriod}px;width: {$widthLabelTo}px;">
			To
		 </div>
		<div class="field date" style="left: {$leftFieldTo}px;top: {$topNoPaymentPeriod}px;width: {$widthFieldTo}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=noPaymentDateTo editor=DateField
		    	tooltip="If you have entered 'From' you must enter the end date 
		    			 of the last tax month in which no payments were made. 
		    			  
		    			 This date must be earlier then the date of the EPS 
		    			 submission."</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="ext:dateFormat(eps:IRenvelope/eps:EmployerPaymentSummary/eps:NoPaymentDates/eps:To)"/>&#160;
		 </div>
		 
		<!-- Period of Inactivity -->
		<div class="label" style="left: {$leftPeriodOfInactivity}px;top: {$topPeriodOfInactivity}px;width: {$widthPeriodOfInactivity}px;">
		 Period of Inactivity
		</div>
		<div class="label" style="left: {$leftLabelFrom}px;top: {$topPeriodOfInactivity}px;width: {$widthLabelFrom}px;">
			From
		 </div>
		<div class="field date" style="left: {$leftFieldFrom}px;top: {$topPeriodOfInactivity}px;width: {$widthFieldFrom}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=periodOfInactivityFrom editor=DateField
		    	tooltip="If,for a future period of one or more complete tax months
		    			 within the tax year, you will have no paid employees or
		    			 directors, so there will be no FPS return to make, you 
		    			 can submit an EPS now to let HMRC know you won't be 
		    			 sending any FPSs for these months. 
		    			 
		    			 Enter the start date of the first tax month of your 
		    			 'period of inactivity'. This date must be the start of 
		    			 the next tax month, that is the 6th of the next calendar
		    			 month not including today.
		    			 
		    			 You can only use this field to report future periods of 
		    			 inactivity. The date must be later then the date of EPS 
		    			 submission."</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="ext:dateFormat(eps:IRenvelope/eps:EmployerPaymentSummary/eps:PeriodOfInactivity/eps:From)"/>&#160;
		 </div>
		<div class="label" style="left: {$leftLabelTo}px;top: {$topPeriodOfInactivity}px;width: {$widthLabelTo}px;">
			To
		 </div>
		<div class="field date" style="left: {$leftFieldTo}px;top: {$topPeriodOfInactivity}px;width: {$widthFieldTo}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=periodOfInactivityTo editor=DateField
		    	tooltip="If you have entered 'From' you must enter the end date
		    			 of the last tax month of your 'period of inactivity'. 
		    			 This date must be the end of a tax month that is the
		    			 5th of the relevant calendar month.
		    			 
		    			 The date must be latter then the 'From'"</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="ext:dateFormat(eps:IRenvelope/eps:EmployerPaymentSummary/eps:PeriodOfInactivity/eps:To)"/>&#160;
		 </div>		 
		 
		<!-- Final Submission -->
		<div class="label" style="left: {$leftFinalSubmission}px;top: {$topFinalSubmission}px;width: {$widthFinalSubmission}px;">
		 Final Submission
		</div>
		<div class="label" style="left: {$leftLabelBecauseSchemeCeased}px;top: {$topFinalSubmission}px;width: {$widthLabelBecauseSchemeCeased}px;">
			Because Scheme Ceased
		 </div>
		<div class="checkbox field" style="left: {$leftFieldBecauseSchemeCeased}px;top: {$topFinalSubmission}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=finalSubmissionBecauseSchemeCeased editor=YesBox
		    	tooltip="Idicate 'Yes' if you have ceased as an employer and are
		    			 paying your employees for the last time."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:FinalSubmission/eps:BecauseSchemeCeased">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftLabelDateSchemeCeased}px;top: {$topFinalSubmission}px;width: {$widthLabelDateSchemeCeased}px;">
			Date Scheme Ceased
		 </div>
		<div class="field date" style="left: {$leftFieldDateSchemeCeased}px;top: {$topFinalSubmission}px;width: {$widthFieldDateSchemeCeased}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=dateSchemeCeased editor=DateField
		    	tooltip="Enter the date if you have ceased as an employer and are
		    			 paying your employees for the last time.
		    			 "</xsl:text>
		  	</xsl:processing-instruction>
		 	<xsl:value-of select="ext:dateFormat(eps:IRenvelope/eps:EmployerPaymentSummary/eps:FinalSubmission/eps:DateSchemeCeased)"/>&#160;
		 </div>				 
		<div class="label" style="left: {$leftLabelFinalSubmissionForYear}px;top: {$topFinalSubmissionForYear}px;width: {$widthLabelFinalSubmissionForYear}px;">
		 For Year
		</div>
		<div class="checkbox field" style="left: {$leftFieldFinalSubmissionForYear}px;top: {$topFinalSubmissionForYear}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=finalSubmissionForYear editor=YesBox
		    	tooltip="Idicate 'Yes' if this is your last submission for the
		    			 year for the entire PAYE scheme, to indicate that this 
		    			 is the final submission for the tax year."</xsl:text>
		  	</xsl:processing-instruction>		
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:FinalSubmission/eps:ForYear">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		 
		 <xsl:call-template name="above-recovered-amounts-ytd"/>
		 
		 <xsl:call-template name="recovered-amounts-ytd"/>
		 
		 <xsl:call-template name="questions-and-declarations"/>
	</xsl:template>
	
	<xsl:template name="questions-and-declarations">
		 <xsl:call-template name="above-questions-and-declarations"/>
		 
		<!-- Questions and Declarations -->
		<div class="section-header" style="left: {$leftQuestionsAndDeclarations}px;top: {$topQuestionsAndDeclarations}px;width: {$widthQuestionsAndDeclarations}px;">
		 Questions And Declarations
		</div>
		<xsl:call-template name="bellow-questions-and-declarations"/>
		<!--  line1 -->
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line1}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Did you make any free of tax payments to an employee?
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line2}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column2}px;top: {$topQuestionsAndDeclarations_line2}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=freeOfTaxPaymentsMadeToEmployee editor=YesNoBox
		    	params="yes;no"
		    	tooltip="Idicate 'Yes' if you made any 'free of tax' payments to
		    			 an employee. A 'free of tax' payment is a payment where
		    			 the employer (rather then the employee) bears any tax 
		    			 due. Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:FreeOfTaxPaymentsMadeToEmployee = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		 <div class="label" style="left: {$leftQuestionsAndDeclarations_column3}px;top: {$topQuestionsAndDeclarations_line2}px;width: {$widthYesNoLabel}px;">
			No
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column4}px;top: {$topQuestionsAndDeclarations_line2}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=freeOfTaxPaymentsMadeToEmployee editor=YesNoBox
		    	params="no;yes"
		    	tooltip="Idicate 'Yes' if you made any 'free of tax' payments to
		    			 an employee. A 'free of tax' payment is a payment where
		    			 the employer (rather then the employee) bears any tax
		    			 due. Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:FreeOfTaxPaymentsMadeToEmployee = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		 
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line1}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Have you paid any of an employee's pay to someone other then the employee, for example to a school?
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line2}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column6}px;top: {$topQuestionsAndDeclarations_line2}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=payToSomeoneElse editor=YesNoBox
		    	params="yes;no"
		    	tooltip="Idicate 'Yes' if you paid any of employee's pay to     
		    			 someone other then the employee, for example a school, 
		    			 and you did not include this pay on RTI submission.
		    			 Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:PayToSomeoneElse = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column7}px;top: {$topQuestionsAndDeclarations_line2}px;width: {$widthYesNoLabel}px;">
			No
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column8}px;top: {$topQuestionsAndDeclarations_line2}px;">			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=payToSomeoneElse editor=YesNoBox
		    	params="no;yes"
		    	tooltip="Idicate 'Yes' if you paid any of employee's pay to     
		    			 someone other then the employee, for example a school, 
		    			 and you did not include this pay on RTI submission.
		    			 Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:PayToSomeoneElse = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>


		<!--  line2 -->
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line3}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Did anyone else pay expenses or in any way provide vouchers or benefits to any of your employees while they were employed by you during the year?
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line4}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column2}px;top: {$topQuestionsAndDeclarations_line4}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=expensesVouchersOrBenefitsFromOthers editor=YesNoBox
		    	params="yes;no"
		    	tooltip="Idicate 'Yes' if some other then you, paid expenses or 
		    			 provided benefits to any of your employees during the  
		    			 year as a result of the employee working for you.
		    			 Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:ExpensesVouchersOrBenefitsFromOthers = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column3}px;top: {$topQuestionsAndDeclarations_line4}px;width: {$widthYesNoLabel}px;">
			No
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column4}px;top: {$topQuestionsAndDeclarations_line4}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=expensesVouchersOrBenefitsFromOthers editor=YesNoBox
		    	params="no;yes"
		    	tooltip="Idicate 'Yes' if some other then you, paid expenses or 
		    			 provided benefits to any of your employees during the  
		    			 year as a result of the employee working for you.
		    			 Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:ExpensesVouchersOrBenefitsFromOthers = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		 
		 
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line3}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Completed forms P11D and P11D(b) are due.
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line4}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>		 
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column6}px;top: {$topQuestionsAndDeclarations_line4}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=p11DFormsDue editor=YesNoBox
		    	params="yes;no"
		    	tooltip="Idicate 'Yes' if completed forms P11D and P11D(b) are due
		    			 for the year. Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:P11DFormsDue = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column7}px;top: {$topQuestionsAndDeclarations_line4}px;width: {$widthYesNoLabel}px;">
			No 
		 </div>		 
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column8}px;top: {$topQuestionsAndDeclarations_line4}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=p11DFormsDue editor=YesNoBox
		    	params="no;yes"
		    	tooltip="Idicate 'Yes' if completed forms P11D and P11D(b) are due
		    			 for the year. Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:P11DFormsDue = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>

		 
		 
		 
		<!--  line3 -->
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line5}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Did anyone employed by a person or company outside the UK work for you in the UK for 30 days or more in a row?
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line6}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>	
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column2}px;top: {$topQuestionsAndDeclarations_line6}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=personEmployedOutsideUKWorkedFor30DaysOrMore editor=YesNoBox
		    	params="yes;no"
		    	tooltip="Idicate 'Yes' if anyone employed by a person or company 
		    			 outside the UK worked for you in the UK for 30 days or
		    			 more in a row and you did not include them on a RTI
		    			 submission. Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:PersonEmployedOutsideUKWorkedFor30DaysOrMore = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column3}px;top: {$topQuestionsAndDeclarations_line6}px;width: {$widthYesNoLabel}px;">
			No
		 </div>	
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column4}px;top: {$topQuestionsAndDeclarations_line6}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=personEmployedOutsideUKWorkedFor30DaysOrMore editor=YesNoBox
		    	params="no;yes"
		    	tooltip="Idicate 'Yes' if anyone employed by a person or company 
		    			 outside the UK worked for you in the UK for 30 days or
		    			 more in a row and you did not include them on a RTI
		    			 submission. Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:PersonEmployedOutsideUKWorkedFor30DaysOrMore = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>

		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line5}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Are you a Service Company?
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line6}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>			 
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column6}px;top: {$topQuestionsAndDeclarations_line6}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=serviceCompany editor=YesNoBox
		    	params="yes;no"
		    	tooltip="Idicate 'Yes' if you are a Service Company and have
		    			 operated the Intermediaries legislation (chapter 8 of part
		    			 2 of ITEPA, sometimes known as IR35).
		    			 Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>		
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:ServiceCompany = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column7}px;top: {$topQuestionsAndDeclarations_line6}px;width: {$widthYesNoLabel}px;">
			No
		 </div>			 
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column8}px;top: {$topQuestionsAndDeclarations_line6}px;">
			<xsl:processing-instruction name="editor">
		    	<xsl:text>property=serviceCompany editor=YesNoBox
		    	params="no;yes"
		    	tooltip="Idicate 'Yes' if you are a Service Company and have
		    			 operated the Intermediaries legislation (chapter 8 of part
		    			 2 of ITEPA, sometimes known as IR35).
		    			 Otherwise indicate 'No'."</xsl:text>
		  	</xsl:processing-instruction>	
			<xsl:choose>
		 	<xsl:when test="eps:IRenvelope/eps:EmployerPaymentSummary/eps:QuestionsAndDeclarations/eps:ServiceCompany = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>	
	</xsl:template>
	
	<!--  overridable plug-point for tax-year specific recovered-amounts table -->
	<xsl:template name="recovered-amounts-ytd"/>	
	
	<!--  insert additional content above the recovered-amounts table -->
	<xsl:template name="above-recovered-amounts-ytd"/>

	<!--  insert additional content above the questions-and-declarations -->
	<xsl:template name="above-questions-and-declarations"/>

	<!--  insert additional content bellow the -->
	<xsl:template name="bellow-header"/>
	
	<xsl:template name="bellow-questions-and-declarations"/>
</xsl:stylesheet>
