<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/1999/xhtml"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
 xmlns:eps="selima:FBI Rendering"
 xmlns:ext="xalan://com.selima.fbi.webserver.XalanExtension"
 extension-element-prefixes="ext"
 xmlns:xalan="http://xml.apache.org/xalan"
 exclude-result-prefixes="xalan"
>
    <ext:annotation
     	metadata="EPS(base).metadata.xsl"
		rewrite_from_ns="http://www.govtalk.gov.uk/taxation/PAYE/RTI/2"
    	rewrite_to_ns="selima:FBI Rendering"
    />
	<xsl:output method="html" encoding="UTF-8"/>
	<xsl:variable name="labelGap" select="10"/>
	<xsl:variable name="rowHeight" select="25"/>
	<xsl:variable name="leftEdge" select="10"/>
	<xsl:variable name="topEdge" select="125"/>
	<xsl:variable name="widthLabelPayeReference" select="200"/>
	<xsl:variable name="leftFieldPayeReference" select="$leftEdge + $widthLabelPayeReference + $labelGap"/>
	<xsl:variable name="widthFieldPayeReference" select="150"/>
	<xsl:variable name="topAccountsOfficeReference" select="$topEdge + $rowHeight"/>
	<xsl:variable name="widthDateField" select="100"/>
	
	<xsl:variable name="leftTaxYear" select="$leftFieldPayeReference + $widthFieldPayeReference + $labelGap + 30"/>
	<xsl:variable name="widthTaxYearLabel">175</xsl:variable>
	<xsl:variable name="leftTaxYearField" select="$leftTaxYear + $widthTaxYearLabel + $labelGap"/>
	<xsl:variable name="widthTaxYearField" select="150"/>
	
	<xsl:variable name="topFinalSubmission" select="$topAccountsOfficeReference + $rowHeight + 20 + $rowHeight"/>
	<xsl:variable name="leftFinalSubmission" select="$leftEdge"/>
	<xsl:variable name="widthFinalSubmission" select="200"/>
	<xsl:variable name="leftLabelBecauseSchemeCeased" select="$leftFieldPayeReference"/>
	<xsl:variable name="widthLabelBecauseSchemeCeased" select="210"/>
	<xsl:variable name="leftFieldBecauseSchemeCeased" select="$leftTaxYear + 20"/>
	<xsl:variable name="leftLabelECON" select="$leftTaxYear + 60"/>
	<xsl:variable name="widthLabelECON" select="160"/>
	<xsl:variable name="leftFieldECON" select="$leftLabelECON + $widthLabelECON + $labelGap"/>
	<xsl:variable name="widthFieldECON" select="$widthDateField"/>
	<xsl:variable name="topFinalSubmissionForYear" select="$topFinalSubmission + $rowHeight"/>
	<xsl:variable name="leftLabelFinalSubmissionForYear" select="$leftLabelBecauseSchemeCeased"/>
	<xsl:variable name="widthLabelFinalSubmissionForYear" select="$widthLabelBecauseSchemeCeased"/>
	<xsl:variable name="leftFieldFinalSubmissionForYear" select="$leftFieldBecauseSchemeCeased"/>

	
	<xsl:variable name="topPaymentForPeriod" select="$topFinalSubmissionForYear + $rowHeight + 75"/>
	<xsl:variable name="leftPaymentForPeriod" select="$leftEdge"/>
	<xsl:variable name="widthPaymentForPeriod" select="500"/>

	<xsl:variable name="topPaymentForPeriod_line1" select="$topPaymentForPeriod + $rowHeight + 10"/>
	<xsl:variable name="widthLabeltopPaymentForPeriod" select="215"/>
	<xsl:variable name="widthFieldtopPaymentForPeriod" select="145"/>	
	<xsl:variable name="leftPaymentForPeriod_column1" select="$leftPaymentForPeriod"/>
	<xsl:variable name="leftPaymentForPeriod_column2" select="$leftLabelFinalSubmissionForYear"/>
	<xsl:variable name="leftPaymentForPeriod_column3" select="$leftTaxYear"/>
	<xsl:variable name="leftPaymentForPeriod_column4" select="$leftTaxYearField + $widthTaxYearField - $widthFieldtopPaymentForPeriod + 20"/>
	<xsl:variable name="topPaymentForPeriod_line2" select="$topPaymentForPeriod_line1 + $rowHeight"/>
	<xsl:variable name="topPaymentForPeriod_line3" select="$topPaymentForPeriod_line2 + $rowHeight"/>
	<xsl:variable name="topPaymentForPeriod_line4" select="$topPaymentForPeriod_line3 + $rowHeight"/>
	<xsl:variable name="topPaymentForPeriod_line5" select="$topPaymentForPeriod_line4 + $rowHeight"/>
	<xsl:variable name="topPaymentForPeriod_line6" select="$topPaymentForPeriod_line5 + $rowHeight"/>		
	
	<xsl:variable name="topQuestionsAndDeclarations" select="$topPaymentForPeriod_line6 + $rowHeight + 50"/>
	<xsl:variable name="leftQuestionsAndDeclarations" select="$leftEdge"/>
	<xsl:variable name="widthQuestionsAndDeclarations" select="500"/>
	<xsl:variable name="widthLabelQuestionsAndDeclarations" select="375"/>
	<xsl:variable name="widthYesNoLabel" select="30"/>
	<xsl:variable name="topQuestionsAndDeclarations_line1" select="$topQuestionsAndDeclarations + $rowHeight + 10"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column1" select="$leftQuestionsAndDeclarations"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column4" select="$leftPaymentForPeriod_column2"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column2" select="$leftQuestionsAndDeclarations_column1 + $widthYesNoLabel + $labelGap"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column3" select="$leftQuestionsAndDeclarations_column4 - $widthYesNoLabel - $labelGap"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column5" select="$leftTaxYear"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column8" select="$leftPaymentForPeriod_column4"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column6" select="$leftQuestionsAndDeclarations_column5 + $widthYesNoLabel + $labelGap"/>
	<xsl:variable name="leftQuestionsAndDeclarations_column7" select="$leftQuestionsAndDeclarations_column8 - $widthYesNoLabel - $labelGap"/>
	<xsl:variable name="topQuestionsAndDeclarations_line2" select="$topQuestionsAndDeclarations_line1 + 2 * $rowHeight + 10"/>		
	<xsl:variable name="topQuestionsAndDeclarations_line3" select="$topQuestionsAndDeclarations_line2 + 2 * $rowHeight"/>
	<xsl:variable name="topQuestionsAndDeclarations_line4" select="$topQuestionsAndDeclarations_line3 + 3 * $rowHeight + 10"/>
	<xsl:variable name="topQuestionsAndDeclarations_line5" select="$topQuestionsAndDeclarations_line4 + 2 * $rowHeight"/>
	<xsl:variable name="topQuestionsAndDeclarations_line6" select="$topQuestionsAndDeclarations_line5 + 2 * $rowHeight + 10"/>
		
    <xsl:template match="/">
        <html>
            <head>
                <title>EPS(<xsl:value-of select="eps:IRenvelope/eps:IRheader/eps:RelatedTaxYear"/>)</title>
                <style type="text/css">
					body {
						margin: 0px;
						padding: 0px;
						font: normal normal normal 11pt monospace;
					}
                    
                    div {
                    background: transparent none no-repeat scroll top left;
                    }
                    
                    body * div {
                    position: absolute;
                    border: 1px dotted transparent;
                    }
                    
                    div.checkbox {
                    	font-family:sans-serif;text-align:center;
                    	border-left: 1px solid #606060;
                    	border-bottom: 1px solid #606060;
                    	border-right: 1px solid #D0D0D0;
                    	border-top: 1px solid #D0D0D0;
                        background-color: #FFD;
                        width: 19px;
	                    padding-left: 0px;
                    }
                    
                    div.large-text {
                    	font-size: 26pt
                    }
                    
                    div.number {
                    	text-align: right;
                    }
                    
                    div.date {
                    	text-align: center;
                    }
                    
                    div.label {
                    	color: black;
                    }
                    
                    div.section-header {
                    	font-size: 16pt;
                    }
                    
                    div.field {
                        border-bottom: 1px solid #008080;
                        padding-left: 5px;
                    	color: blue;
                    	font-weight: bold;
                    }
                </style>
            </head>
            <!--                       
            	border-bottom: 1px solid black;
            	background-color: #FFD
             -->
			<xsl:variable name="pageSize">width: 827px; height: 1123px;</xsl:variable>
            <body>
				<div style="background-image: url(images/eps.png);{$pageSize}">
				<div style="{$pageSize}">
					<xsl:call-template name="page1"/>
				</div>
				</div>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template name="page1">
		<xsl:variable name="employerPaymentSummary" select="eps:IRenvelope/eps:RTI/eps:EmployerPaymentSummary"/>
		
		<div class="label" style="left: {$leftEdge}px;top: {$topEdge}px;width: {$widthLabelPayeReference}px;">
		 Employer PAYE Reference	
		</div>
		<div class="field" style="left: {$leftFieldPayeReference}px;top: {$topEdge}px;width: {$widthFieldPayeReference}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:EmpRefs/eps:OfficeNo"/>
		 	/<xsl:value-of select="$employerPaymentSummary/eps:EmpRefs/eps:PayeRef"/>&#160;
		 </div>
		 
		<div class="label" style="left: {$leftEdge}px;top: {$topAccountsOfficeReference}px;width: {$widthLabelPayeReference}px;">
		 Accounts Office Reference	
		</div>
		<div class="field" style="left: {$leftFieldPayeReference}px;top: {$topAccountsOfficeReference}px;width: {$widthFieldPayeReference}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:EmpRefs/eps:AORef"/>&#160;
		 </div>
		 
		<!--  RelatedTaxYear -->
		<div class="label large-text" style="left: {$leftTaxYear}px;top: {$topEdge}px;width: {$widthTaxYearLabel}px;">
		 Tax Year
		</div>
		<div class="field large-text" style="left: {$leftTaxYearField}px;top: {$topEdge}px;width: {$widthTaxYearField}px;">
		 	<xsl:text>20</xsl:text><xsl:value-of select="$employerPaymentSummary/eps:RelatedTaxYear"/>
		 </div>
	
		<!-- Final Submission -->
		<div class="label" style="left: {$leftFinalSubmission}px;top: {$topFinalSubmission}px;width: {$widthFinalSubmission}px;">
		 Final Submission
		</div>
		<div class="label" style="left: {$leftLabelBecauseSchemeCeased}px;top: {$topFinalSubmission}px;width: {$widthLabelBecauseSchemeCeased}px;">
			Because Scheme Ceased
		 </div>
		<div class="checkbox field" style="left: {$leftFieldBecauseSchemeCeased}px;top: {$topFinalSubmission}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:FinalSubmission/eps:BecauseSchemeCeased">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftLabelECON}px;top: {$topFinalSubmission}px;width: {$widthLabelECON}px;">
			ECON
		 </div>
		<div class="field date" style="left: {$leftFieldECON}px;top: {$topFinalSubmission}px;width: {$widthFieldECON}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:FinalSubmission/eps:ECON"/>&#160;
		 </div>				 
		<div class="label" style="left: {$leftLabelFinalSubmissionForYear}px;top: {$topFinalSubmissionForYear}px;width: {$widthLabelFinalSubmissionForYear}px;">
		 For Year
		</div>
		<div class="checkbox field" style="left: {$leftFieldFinalSubmissionForYear}px;top: {$topFinalSubmissionForYear}px;">	
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:FinalSubmission/eps:ForYear">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		 
		<!-- Payment For Period -->
		<div class="section-header" style="left: {$leftPaymentForPeriod}px;top: {$topPaymentForPeriod}px;width: {$widthPaymentForPeriod}px;">
		 Payment For Period
		</div>
		<!--  line1 -->
		<div class="label" style="left: {$leftPaymentForPeriod_column1}px;top: {$topPaymentForPeriod_line1}px;width: {$widthLabeltopPaymentForPeriod}px;">
			Advance
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column2}px;top: {$topPaymentForPeriod_line1}px;width: {$widthFieldtopPaymentForPeriod}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:Advance"/>&#160;
		 </div>
		<div class="label" style="left: {$leftPaymentForPeriod_column3}px;top: {$topPaymentForPeriod_line1}px;width: {$widthLabeltopPaymentForPeriod}px;">
			NIC Compensation on SMP
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column4}px;top: {$topPaymentForPeriod_line1}px;width: {$widthFieldtopPaymentForPeriod}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:NICCompensationOnSMP"/>&#160;
		 </div>		
		 
		 <!--  line2 -->
		<div class="label" style="left: {$leftPaymentForPeriod_column1}px;top: {$topPaymentForPeriod_line2}px;width: {$widthLabeltopPaymentForPeriod}px;">
			SSP Recovered
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column2}px;top: {$topPaymentForPeriod_line2}px;width: {$widthFieldtopPaymentForPeriod}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:SSPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftPaymentForPeriod_column3}px;top: {$topPaymentForPeriod_line2}px;width: {$widthLabeltopPaymentForPeriod}px;">
			NIC Compensation on OSPP
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column4}px;top: {$topPaymentForPeriod_line2}px;width: {$widthFieldtopPaymentForPeriod}px;">	
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:NICCompensationOnOSPP"/>&#160;
		 </div>	
		 
		 <!--  line3 -->
		<div class="label" style="left: {$leftPaymentForPeriod_column1}px;top: {$topPaymentForPeriod_line3}px;width: {$widthLabeltopPaymentForPeriod}px;">
			SMP Recovered
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column2}px;top: {$topPaymentForPeriod_line3}px;width: {$widthFieldtopPaymentForPeriod}px;">	
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:SMPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftPaymentForPeriod_column3}px;top: {$topPaymentForPeriod_line3}px;width: {$widthLabeltopPaymentForPeriod}px;">
			NIC Compensation On SAP
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column4}px;top: {$topPaymentForPeriod_line3}px;width: {$widthFieldtopPaymentForPeriod}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:NICCompensationOnSAP"/>&#160;
		 </div>
		 
  		 <!--  line4 -->
		<div class="label" style="left: {$leftPaymentForPeriod_column1}px;top: {$topPaymentForPeriod_line4}px;width: {$widthLabeltopPaymentForPeriod}px;">
			OSPP Recovered
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column2}px;top: {$topPaymentForPeriod_line4}px;width: {$widthFieldtopPaymentForPeriod}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:OSPPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftPaymentForPeriod_column3}px;top: {$topPaymentForPeriod_line4}px;width: {$widthLabeltopPaymentForPeriod}px;">
			NIC Compensation On ASPP
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column4}px;top: {$topPaymentForPeriod_line4}px;width: {$widthFieldtopPaymentForPeriod}px;">	
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:NICCompensationOnASPP"/>&#160;
		 </div>	
		 
  		 <!--  line5 -->
		<div class="label" style="left: {$leftPaymentForPeriod_column1}px;top: {$topPaymentForPeriod_line5}px;width: {$widthLabeltopPaymentForPeriod}px;">
			SAP Recovered
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column2}px;top: {$topPaymentForPeriod_line5}px;width: {$widthFieldtopPaymentForPeriod}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:SAPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftPaymentForPeriod_column3}px;top: {$topPaymentForPeriod_line5}px;width: {$widthLabeltopPaymentForPeriod}px;">
			CIS Deductions Suffered
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column4}px;top: {$topPaymentForPeriod_line5}px;width: {$widthFieldtopPaymentForPeriod}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:CISDeductionsSuffered"/>&#160;
		 </div>		
		 
  		 <!--  line6 -->
		<div class="label" style="left: {$leftPaymentForPeriod_column1}px;top: {$topPaymentForPeriod_line6}px;width: {$widthLabeltopPaymentForPeriod}px;">
			ASPP Recovered
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column2}px;top: {$topPaymentForPeriod_line6}px;width: {$widthFieldtopPaymentForPeriod}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:ASPPRecovered"/>&#160;
		 </div>
		<div class="label" style="left: {$leftPaymentForPeriod_column3}px;top: {$topPaymentForPeriod_line6}px;width: {$widthLabeltopPaymentForPeriod}px;">
			NICs Holiday
		 </div>
		<div class="field number" style="left: {$leftPaymentForPeriod_column4}px;top: {$topPaymentForPeriod_line6}px;width: {$widthFieldtopPaymentForPeriod}px;">
		 	<xsl:value-of select="$employerPaymentSummary/eps:PaymentForPeriod/eps:NICsHoliday"/>&#160;
		 </div>	
		 
		 <!-- Questions and Declarations -->
		<div class="section-header" style="left: {$leftQuestionsAndDeclarations}px;top: {$topQuestionsAndDeclarations}px;width: {$widthQuestionsAndDeclarations}px;">
		 Questions And Declarations
		</div>
		<!--  line1 -->
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line1}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Did you make any free of tax payments to an employee?
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line2}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column2}px;top: {$topQuestionsAndDeclarations_line2}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:FreeOfTaxPaymentsMadeToEmployee = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		 <div class="label" style="left: {$leftQuestionsAndDeclarations_column3}px;top: {$topQuestionsAndDeclarations_line2}px;width: {$widthYesNoLabel}px;">
			No
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column4}px;top: {$topQuestionsAndDeclarations_line2}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:FreeOfTaxPaymentsMadeToEmployee = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		 
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line1}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Have you paid any of an employee's pay to someone other then the employee, for example to a school?
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line2}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column6}px;top: {$topQuestionsAndDeclarations_line2}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:PayToSomeoneElse = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column7}px;top: {$topQuestionsAndDeclarations_line2}px;width: {$widthYesNoLabel}px;">
			No
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column8}px;top: {$topQuestionsAndDeclarations_line2}px;">		
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:PayToSomeoneElse = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>


		<!--  line2 -->
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line3}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Did anyone else pay expenses or in any way provide vouchers or benefits to any of your employees while they were employed by you during the year?
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line4}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column2}px;top: {$topQuestionsAndDeclarations_line4}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:ExpensesVouchersOrBenefitsFromOthers = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column3}px;top: {$topQuestionsAndDeclarations_line4}px;width: {$widthYesNoLabel}px;">
			No
		 </div>
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column4}px;top: {$topQuestionsAndDeclarations_line4}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:ExpensesVouchersOrBenefitsFromOthers = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		 
		 
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line3}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Completed forms P11D and P11D(b) are due.
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line4}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>		 
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column6}px;top: {$topQuestionsAndDeclarations_line4}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:P11DFormsDue = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column7}px;top: {$topQuestionsAndDeclarations_line4}px;width: {$widthYesNoLabel}px;">
			No 
		 </div>		 
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column8}px;top: {$topQuestionsAndDeclarations_line4}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:P11DFormsDue = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>

		 
		 
		 
		<!--  line3 -->
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line5}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Did anyone employed by a person or company outside the UK work for you in the UK for 30 days or more in a row?
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column1}px;top: {$topQuestionsAndDeclarations_line6}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>	
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column2}px;top: {$topQuestionsAndDeclarations_line6}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:PersonEmployedOutsideUKWorkedFor30DaysOrMore = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column3}px;top: {$topQuestionsAndDeclarations_line6}px;width: {$widthYesNoLabel}px;">
			No
		 </div>	
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column4}px;top: {$topQuestionsAndDeclarations_line6}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:PersonEmployedOutsideUKWorkedFor30DaysOrMore = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>

		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line5}px;width: {$widthLabelQuestionsAndDeclarations}px;">
			Are you a Service Company?
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column5}px;top: {$topQuestionsAndDeclarations_line6}px;width: {$widthYesNoLabel}px;">
			Yes
		 </div>			 
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column6}px;top: {$topQuestionsAndDeclarations_line6}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:ServiceCompany = 'yes'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>
		<div class="label" style="left: {$leftQuestionsAndDeclarations_column7}px;top: {$topQuestionsAndDeclarations_line6}px;width: {$widthYesNoLabel}px;">
			No
		 </div>			 
		<div class="checkbox field" style="left: {$leftQuestionsAndDeclarations_column8}px;top: {$topQuestionsAndDeclarations_line6}px;">
			<xsl:choose>
		 	<xsl:when test="$employerPaymentSummary/eps:QuestionsAndDeclarations/eps:ServiceCompany = 'no'">x</xsl:when>
			<xsl:otherwise>&#160;</xsl:otherwise>
			</xsl:choose>
		 </div>		 
	</xsl:template>
		
</xsl:stylesheet>
