<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:dps="http://www.govtalk.gov.uk/taxation/DPSwrapper/1" xmlns:sl1="http://www.govtalk.gov.uk/taxation/StudentLoanStart/2">
    <xsl:import href='dps_variables.xsl'/>
    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:variable name="FBIGGISVersion">
 /**
 *
 *  Program Name:      sl1_dps_stylesheet_2007.xsl    
 *
 *  Description:       Outgoing Forms - rendering stylesheet for student loan start forms.
 *
 *  Author:            Jon Head
 *
 *  Amendment History:
 *
 * Date       Author        Release   Description
 * 18/01/2006 J Head        56RJ      Modified for 56RJ project (re-writing secure mail)
 * 02/02/2006 J Head:       All DPS form stylesheets now import another stylesheet, dps_variables.xsl. Variables that may change between
 *                          environments, such as image and help page URIs and URLs, are set in dps_variables.xsl and referenced
 *                          in the DPS form stylesheets. This facilitates making the stylesheets environment specific without the need to
 *                          change hard coded variables in each and every DPS stylesheet as only dps_variables.xsl needs to be changed.
 * 23/02/2006 J Head        Changes made in response to email received by SDSTeam on 21/02/2006: -
 *                              1. Borders are used on all tabular stylesheets now for both single and multiple employers for clarity and consistency.
 *                              2. Date of Issue is now included in the table rows for single employers and not at the top of the page.
*/
    </xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<title>Student Loan Notice - SL1</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			</head>
			<body bgcolor="#FFFFFF">
				<table width="95%" border="0">
					<tr>
						<td width="15%">
							<xsl:element name="img">
								<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
							</xsl:element>
						</td>
						<td colspan="5" valign="top">
							<div align="right">
								<b>
									<i>
										<font size="5"/>
										<font size="5">Student 
        Loan </font>
									</i>
								</b>
							</div>
						</td>
					</tr>
					<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
						<tr>
							<td width="15%" height="22">&#160;</td>
							<td width="10%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="26%" height="22">&#160;</td>
							<td colspan="2" height="22" width="29%">&#160;</td>
						</tr>
						<tr>
							<td colspan="4">
								<div align="right">
									<font face="Tahoma" size="2">
										<b>Employer Reference</b>
									</font>
								</div>
							</td>
							<td colspan="2" width="29%">
								<xsl:value-of select="/dps:DPSdata/sl1:StudentLoanStart/sl1:EmployerRef"/>
							</td>
						</tr>
						<tr>
							<td rowspan="3">&#160;</td>
						</tr>
					</xsl:if>
					<tr> </tr>
				</table>
				<table width="100%" border="0">
					<tr>
						<td>&#160;</td>
					</tr>
					<tr>
						<td bgcolor="#33CC33">
							<xsl:element name="img">
								<xsl:attribute name="alt">Student Loan Start</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$student_loan_start_image_URI"/></xsl:attribute>
							</xsl:element>
						</td>
					</tr>
					<tr>
						<td>&#160;</td>
					</tr>
					<tr>
						<td colspan="2">
							<b>Student Loan deductions must start from the first pay day on or after the start date shown below whenever total pay exceeds the
							<xsl:element name="a">
								<xsl:attribute name="href"><xsl:value-of select="$student_loan_threshold_htm_URI"/></xsl:attribute>
								Student Loan threshold</xsl:element>.</b>
						</td>
					</tr>
					<tr>
						<td>
							<b>Failure to comply with this notice may result in a penalty being charged</b>
						</td>
					</tr>
					<tr>
						<td colspan="2">Use the Student Loan Deduction Tables to work out how much to deduct. Guidance can be found in Employer's Help Book Day-to-day payroll, E13. The Tables and Employer's Help Book are available through the Employer's Orderline, telephone 0845 7 646 646.</td>
					</tr>
					<tr>
						<td colspan="2">&#160;</td>
					</tr>
				</table>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
					<center>
					<table width="95%" border="1">
						<tr align="center">
							<td>
								<font face="Tahoma" size="2">
									<b>Employee Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>National Insurance Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Works/ Payroll Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Date of Issue</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Student Loan Deduction Start Date</b>
								</font>
							</td>
						</tr>
						<xsl:for-each select="/dps:DPSdata/sl1:StudentLoanStart/sl1:NINO">
						<xsl:sort select="." order="ascending" data-type="text"/>
						<tr align="center">
							<td width="16%">
								<xsl:value-of select="../sl1:Name/sl1:Title"/>&#160;<xsl:value-of select="../sl1:Name/sl1:Forename"/>&#160;<xsl:value-of select="../sl1:Name/sl1:Surname"/>
							</td>
							<td width="16%">
								<xsl:value-of select="../sl1:NINO"/>
							</td>
							<td width="16%">
								<xsl:value-of select="../sl1:WorksNumber"/>
							</td>
							<td width="16%">
								<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
							</td>
							<td width="16%">
								<xsl:value-of select="substring(../sl1:LoanStartDate, 9, 2)"/>-<xsl:value-of select="substring(../sl1:LoanStartDate, 6, 2)"/>-<xsl:value-of select="substring(../sl1:LoanStartDate, 1, 4)"/>
							</td>
						</tr>
						</xsl:for-each>
					</table>
					</center>
				</xsl:if>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity=''">
					<table width="100%" border="1">
						<tr align="center">
							<td>
								<font face="Tahoma" size="2">
									<b>Employee Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Employer Reference</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>National Insurance Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Works/ Payroll Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Date of Issue</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Student Loan Deduction Start Date</b>
								</font>
							</td>
						</tr>
						<xsl:for-each select="/dps:DPSdata/sl1:StudentLoanStart/sl1:NINO">
							<xsl:sort select="." order="ascending" data-type="text"/>
							<tr align="center">
								<td width="16%">
									<xsl:value-of select="../sl1:Name/sl1:Title"/>&#160;<xsl:value-of select="../sl1:Name/sl1:Forename"/>&#160;<xsl:value-of select="../sl1:Name/sl1:Surname"/>
								</td>
								<td width="16%">
									<xsl:value-of select="../sl1:EmployerRef"/>
								</td>
								<td width="16%">
									<xsl:value-of select="../sl1:NINO"/>
								</td>
								<td width="16%">
									<xsl:value-of select="../sl1:WorksNumber"/>
								</td>
								<td width="16%">
									<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
								</td>
								<td width="16%">
									<xsl:value-of select="substring(../sl1:LoanStartDate, 9, 2)"/>-<xsl:value-of select="substring(../sl1:LoanStartDate, 6, 2)"/>-<xsl:value-of select="substring(../sl1:LoanStartDate, 1, 4)"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
				</xsl:if>
				<br/>
				<table width="100%" border="0">
					<tr>
						<td align="left">
							<font face="Tahoma">
								<b>
									<font size="2">END OF LIST</font>
								</b>
							</font>
						</td>
						<td>
							<div align="right">
								<a style="text-decoration: none" href="javascript:window.close()">
									<b>
										<font size="2" face="Tahoma">Close Window</font>
									</b>
								</a>
							</div>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
