<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:one="http://www.govtalk.gov.uk/taxation/DPSwrapper/1" xmlns:two="http://www.govtalk.gov.uk/taxation/ReminderAR/2" xmlns:three="http://www.govtalk.gov.uk/taxation/ReminderARmn/2">
    <xsl:import href='dps_variables.xsl'/>
    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:variable name="FBIGGISVersion">
 /**
 *
 * Program Name:            reminders_dps_stylesheets_2006.xsl 
 *
 * Description:             Outgoing Forms - rendering stylesheet for Reminders: AR1n, AR2n, AR6, AR2mn
 *
 * Amendment History:
 *
 * Date       Author        Release   Description
 * 18/01/2006 J Head        56RJ      2006 version created for 56RJ project (re-writing secure mail).
 * 02/02/2006 J Head:       All DPS form stylesheets now import another stylesheet, dps_variables.xsl. Variables that may change between
 *                          environments, such as image and help page URIs and URLs, are set in dps_variables.xsl and referenced
 *                          in the DPS form stylesheets. This facilitates making the stylesheets environment specific without the need to
 *                          change hard coded variables in each and every DPS stylesheet as only dps_variables.xsl needs to be changed.
 * 08/08/2008 D Patel		CR 08/09-025 - Text rewriting, AR1N, AR2N, AR1MN, AR2MN, AR6.
 * 11/08/2008 S Marni	CR 08/09-025 - Modified the Year formats.
 * 03/08/2009 R Videla	Changes made as per the instructions in 8522788 and 8522887
 */
    </xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
				<title>Reminders</title>
			</head>
			<body bgcolor="#FFFFFF">
				<xsl:for-each select="/one:DPSdata/two:ReminderAR">				    
					<table width="93%" border="0">
						<tr>
							<td width="15%">
								<xsl:element name="img">
									<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
									<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
								</xsl:element>
							</td>
							<td colspan="5" valign="top">
								<xsl:choose>
									<xsl:when test="./@FormType='AR6'">
										<div align="right">
											<xsl:element name="img">
												<xsl:attribute name="alt">Reminder</xsl:attribute>
												<xsl:attribute name="src"><xsl:value-of select="$reminder_image_URI"/></xsl:attribute>
											</xsl:element>
										</div>
									</xsl:when>
									<xsl:otherwise>
										<div align="right">
											<xsl:element name="img">
												<xsl:attribute name="alt">Reminder B</xsl:attribute>
												<xsl:attribute name="src"><xsl:value-of select="$reminder_b_image_URI"/></xsl:attribute>
											</xsl:element>
										</div>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td width="15%" height="22">&#160;</td>
							<td width="10%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="26%" height="22">&#160;</td>
							<td colspan="2" height="22" width="29%">&#160;</td>
						</tr>
						<tr>
							<td colspan="4">
								<div align="right">
									<font face="Tahoma" size="2">
										<b>Date of Issue</b>
									</font>
								</div>
							</td>
							<td colspan="2" width="29%">
								<xsl:value-of select="substring(./@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 1, 4)"/>
							</td>
						</tr>
						<tr>
							<td colspan="3" valign="top">&#160;</td>
							<td colspan="3" valign="top" height="4">&#160;</td>
						</tr>
						<tr>
							<td colspan="3" valign="top">
								<table width="100%" border="0" name="AddressTable">
									<xsl:if test="not(./two:EmployerDetails/two:AgentDetails/two:Address/two:Line[1])">
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./two:EmployerDetails/two:Address/two:Line">
											<tr>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:Address/two:PostCode"/>
											</td>
										</tr>
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:Address/two:Country"/>
											</td>
										</tr>
										<tr>
											<td>&#160;</td>
										</tr>
									</xsl:if>
									<xsl:if test="./two:EmployerDetails/two:AgentDetails/two:Address/two:Line[1]">
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:AgentDetails/two:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./two:EmployerDetails/two:AgentDetails/two:Address/two:Line">
											<tr>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:AgentDetails/two:Address/two:PostCode"/>
											</td>
										</tr>
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:AgentDetails/two:Address/two:Country"/>
											</td>
										</tr>
										<tr>
											<td>&#160;</td>
										</tr>
									</xsl:if>
								</table>
							</td>
							<td colspan="3" valign="top">
								<div align="right">
									<font face="Tahoma" size="2"/>
								</div>
								<table width="100%" border="0" name="IssuingAddressTable">
									<tr>
										<td height="23" valign="top" colspan="2">
											<div align="center">
												<i>Please use this reference if you write or call.<br/>
 It will help to avoid delay. </i>
											</div>
										</td>
									</tr>
									<tr>
										<td height="23" valign="top" width="47%">
											<div align="right">
												<b>
													<font face="Tahoma" size="2">Employer Reference</font>
												</b>
											</div>
										</td>
										<td height="23" width="53%">
											<xsl:value-of select="./two:EmployerDetails/two:EmployerRef"/>
										</td>
									</tr>
									<tr>
										<td height="23" valign="top" width="47%">
											<div align="right">
												<b>
													<font face="Tahoma" size="2">Accounts Office Reference</font>
												</b>
											</div>
										</td>
										<td height="23" width="53%">
											<xsl:value-of select="./two:EmployerDetails/two:AORef"/>
										</td>
									</tr>
									<tr>
										<td height="23" valign="top" width="47%">
											<div align="right">
												<font face="Tahoma" size="2">
													<b>Issued By</b>
												</font>
											</div>
										</td>
										<td height="23" width="53%">
											<xsl:value-of select="./two:EmployerDetails/two:HMRCoffice/two:Name"/>
										</td>
									</tr>
									<xsl:for-each select="./two:EmployerDetails/two:HMRCoffice/two:Address/two:Line">
										<tr>
											<td width="47%">&#160;</td>
											<td>
												<xsl:value-of select="."/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td width="47%">&#160;</td>
										<td width="53%">
											<xsl:value-of select="./two:EmployerDetails/two:HMRCoffice/two:Address/two:PostCode"/>
										</td>
									</tr>
									<tr>
										<td width="47%">&#160;</td>
										<td width="53%"/>
									</tr>
									<tr>
										<td width="47%">
											<div align="right">
												<font face="Tahoma" size="2">
													<b>Tax Office Number</b>
												</font>
											</div>
										</td>
										<td width="53%">
											<xsl:value-of select="./two:EmployerDetails/two:HMRCoffice/two:Number"/> / <xsl:value-of select="./two:EmployerDetails/two:HMRCoffice/two:Reference"/>
										</td>
									</tr>
									<tr>
										<td width="47%">
											<div align="right">
												<font face="Tahoma" size="2">
													<b>Telephone Number</b>
												</font>
											</div>
										</td>
										<td width="53%">
											<xsl:value-of select="./two:EmployerDetails/two:HMRCoffice/two:Telephone/two:Number"/>
										</td>
									</tr>
									<tr>
										<td width="47%">
											<div align="right">
												<font face="Tahoma" size="2"/>
											</div>
										</td>
										<td width="53%">
											<font face="Tahoma" size="2">
												<b>
													<xsl:element name="a">
														<xsl:attribute name="href"><xsl:value-of select="$outgoing_helpline_numbers_htm_URI"/></xsl:attribute>
														Helpline Numbers</xsl:element></b>
											</font>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td colspan="6" valign="top">&#160;</td>
						</tr>
						<tr>
							<td colspan="6" valign="top">&#160;</td>
						</tr>																							
						<tr>
							<td colspan="6" valign="top">
								<b>
									<font face="Tahoma" size="4">Employer Annual Return (P35 and P14s) tax year 
									<xsl:value-of select="./@TaxYearEnd -1"/>/<xsl:value-of select="substring(./@TaxYearEnd,3)"/>
									</font>
								</b>
							</td>
						</tr>
					</table>
					<table width="93%" border="0">
<!--						<xsl:for-each select="./two:EmployerDetails/two:LiabilityType">
	
						<tr>
								<td colspan="6">
									<xsl:value-of select="."/>
								</td>
							</tr>    

						</xsl:for-each>-->
						<tr>
							<td colspan="6" height="5">&#160;</td>
						</tr>
						<xsl:if test="./@FormType='AR1n'">
							<tr>
								<td colspan="6" height="5">
									<b>19 May</b> is the date your Return is due.
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6" height="5"><b>Already sent yours?</b> Thank you and please ignore this reminder.
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6" height="5"><b>Do not have to send one,</b> for example because you did not employ anyone? Please let me know, this will stop unnecessary reminders and penalties.
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5"><b>Not yet sent your Return?</b> Please do so now. We charge penalties of £100 per group of 50 employees per month, or part month your Return is late. We also will charge an additional penalty of up to £3,000, if we have told you to file your Return online but you fail to do so.
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;
								</td>
							</tr>
							<tr>
								<td colspan="6">
									You can find help with completing your return, and online filing at <br/>
									<ul>
										<p><li>your Employer CD-ROM,
										</li></p>
										<p><li>
											<strong>
												<xsl:element name="a">
												<xsl:attribute name="href"><xsl:value-of select="$sending_paye_online_URL"/></xsl:attribute>
												<xsl:value-of select="substring($sending_paye_online_URL, 8)"/></xsl:element>
											</strong> 
										</li></p>
									</ul>
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							</xsl:if>
						<xsl:if test="./@FormType='AR2n'">
							<tr>
								<td colspan="6" height="5">
									Your Annual Return, which was due by 19 May, is late. If you have sent yours within the last few days, thank you and please ignore this reminder.
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									It is important that you send your Return now, as we charge penalties of £100 per group of 50 employees per month, or part month your Return is late. We will also charge an additional penalty of up to £3,000, if we have told you to file your Return online but you fail to do so.
								 </td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;
								</td>
							</tr>
							<tr>
								<td colspan="6">
									You can find help with completing your return, and online filing at <br/>
									<ul>
										<p><li>your Employer CD-ROM,
										</li></p>
										<p><li>
											<strong>
												<xsl:element name="a">
												<xsl:attribute name="href"><xsl:value-of select="$sending_paye_online_URL"/></xsl:attribute>
												<xsl:value-of select="substring($sending_paye_online_URL, 8)"/></xsl:element>
											</strong> 
										</li></p>
									</ul>
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">If you do not have to send a Return, for example because you did not employ anyone, please let me know. This will stop further reminders and penalties.
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>

						</xsl:if>
						<xsl:if test="./@FormType='AR6'">
							<tr>
								<td colspan="6" height="5">
									Your Annual Return, which was due by 19 May, is late. If you have sent yours within the last 
									few days, thank you and please ignore this reminder.
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6" height="5">
									We charge penalties of &#163;<xsl:value-of select="$annual_returns_late_penalty"/> per group of 50 employees per month, or part month, 
									your Return is late, so it is important you send your Return now. We will also charge an additional 
									penalty of up to £3,000, if we have told you to file your Return online but you fail to do so.
								 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>							
							<tr>
								<td colspan="6">
									You can find help with completing your return, and online filing at <br/>
									<ul>
										<p><li>your Employer CD-ROM,
										</li></p>
										<p><li>
											<strong>
												<xsl:element name="a">
												<xsl:attribute name="href"><xsl:value-of select="$sending_paye_online_URL"/></xsl:attribute>
												<xsl:value-of select="substring($sending_paye_online_URL, 8)"/></xsl:element>
											</strong> 
										</li></p>
									</ul>
								</td>
							</tr>						
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									If you do not have to send a Return, for example because you did not employ anyone, please 
									let me know. This will stop further reminders and penalties.
								 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									We charge interest on late PAYE payments, so please pay any outstanding amounts now. 
									For details of how to pay, or if no payment is due, please see 
									<strong>
										<xsl:element name="a">
										<xsl:attribute name="href"><xsl:value-of select="$hmrc_paye_howtopay_URL"/></xsl:attribute>
										<xsl:value-of select="substring($hmrc_paye_howtopay_URL, 8)"/></xsl:element>
									</strong>  
								 </td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
						</xsl:if>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<hr width="97%" align="center"/>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
					</table>
				</xsl:for-each>
				<xsl:for-each select="/one:DPSdata/three:ReminderARmn">
					<xsl:if test="./@FormType='AR2mn'">
						<table width="93%" border="0">
							<tr>
								<td width="15%">
									<xsl:element name="img">
										<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
										<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
									</xsl:element>
								</td>
								<td colspan="5" valign="top">
									<div align="right">
										<xsl:element name="img">
											<xsl:attribute name="alt">Reminder B</xsl:attribute>
											<xsl:attribute name="src"><xsl:value-of select="$reminder_b_image_URI"/></xsl:attribute>
										</xsl:element>
									</div>
								</td>
							</tr>
							<tr>
								<td width="15%" height="22">&#160;</td>
								<td width="10%" height="22">&#160;</td>
								<td width="20%" height="22">&#160;</td>
								<td width="26%" height="22">&#160;</td>
								<td colspan="2" height="22" width="29%">&#160;</td>
							</tr>
							<tr>
								<td colspan="4">
									<div align="right">
										<font face="Tahoma" size="2">
											<b>Date of Issue</b>
										</font>
									</div>
								</td>
								<td colspan="2" width="29%">
									<xsl:value-of select="substring(./@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 1, 4)"/>
								</td>
							</tr>
							<tr>
								<td colspan="3" valign="top">&#160;</td>
								<td colspan="3" valign="top" height="4">&#160;</td>
							</tr>
							<tr>
								<td colspan="3" valign="top">
									<table width="100%" border="0" name="AddressTable">
										<xsl:if test="not(./three:EmployerDetails/three:AgentDetails/three:Address/three:Line[1])">
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Name"/>
												</td>
											</tr>
											<xsl:for-each select="./three:EmployerDetails/three:Address/three:Line">
												<tr>
													<td>
														<xsl:value-of select="."/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Address/three:PostCode"/>
												</td>
											</tr>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Address/three:Country"/>
												</td>
											</tr>
											<tr>
												<td>&#160;</td>
											</tr>
										</xsl:if>
										<xsl:if test="./three:EmployerDetails/three:AgentDetails/three:Address/three:Line[1]">
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Name"/>
												</td>
											</tr>
											<xsl:for-each select="./three:EmployerDetails/three:AgentDetails/three:Address/three:Line">
												<tr>
													<td>
														<xsl:value-of select="."/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Address/three:PostCode"/>
												</td>
											</tr>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Address/three:Country"/>
												</td>
											</tr>
											<tr>
												<td>&#160;</td>
											</tr>
										</xsl:if>
									</table>
								</td>
								<td colspan="3" valign="top">
									<div align="right">
										<font face="Tahoma" size="2"/>
									</div>
									<table width="100%" border="0" name="IssuingAddressTable">
										<tr>
											<td height="23" valign="top" colspan="2">
												<div align="center">
													<i>Please use this reference if you write or call.<br/>
													 It will help to avoid delay. </i>
												</div>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top" width="47%">
												<div align="right">
													<b>
														<font face="Tahoma" size="2">Employer Reference</font>
													</b>
												</div>
											</td>
											<td height="23" width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:EmployerRef"/>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top" width="47%">
												<div align="right">
													<b>
														<font face="Tahoma" size="2">Accounts Office Reference</font>
													</b>
												</div>
											</td>
											<td height="23" width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:AORef"/>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top" width="47%">
												<div align="right">
													<b>
														<font face="Tahoma" size="2">Employer Name</font>
													</b>
												</div>
											</td>
											<td height="23" width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:Name"/>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top" width="47%">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Issued By</b>
													</font>
												</div>
											</td>
											<td height="23" width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./three:EmployerDetails/three:HMRCoffice/three:Address/three:Line">
											<tr>
												<td width="47%">&#160;</td>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td width="47%">&#160;</td>
											<td width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Address/three:PostCode"/>
											</td>
										</tr>
										<tr>
											<td width="47%">&#160;</td>
											<td width="53%"/>
										</tr>
										<tr>
											<td width="47%">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Tax Office Number</b>
													</font>
												</div>
											</td>
											<td width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Number"/> / <xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Reference"/>
											</td>
										</tr>
										<tr>
											<td width="47%">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Telephone Number</b>
													</font>
												</div>
											</td>
											<td width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Telephone/three:Number"/>
											</td>
										</tr>
										<tr>
											<td width="47%">
												<div align="right">
													<font face="Tahoma" size="2"/>
												</div>
											</td>
											<td width="53%">
												<font face="Tahoma" size="2">
													<b>
													<xsl:element name="a">
														<xsl:attribute name="href"><xsl:value-of select="$outgoing_helpline_numbers_htm_URI"/></xsl:attribute>
														Helpline Numbers</xsl:element>
													</b>
												</font>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6" valign="top">
									<br/>
										<b>
											<font face="Tahoma" size="4">Employer Annual Return (P35 and P14s) tax year 
												<xsl:value-of select="./@TaxYearEnd -1"/>/<xsl:value-of select="substring(./@TaxYearEnd,3)"/>
											</font>
										</b>
								</td>
							</tr>
							<tr>
								<td colspan="6" valign="top">&#160;</td>
							</tr>
						</table>
						<table width="93%" border="0">
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6" height="5">
									Your Annual Return, which was due by 19 May, is late. If you have sent yours within the last few days, thank you and please ignore this reminder.
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									It is important that you send your Return now, as we charge penalties of &#163;<xsl:value-of select="$annual_returns_late_penalty"/>  per group of 50 employees per month, or part month your Return is late. We will also charge an additional penalty of up to £3,000, if we have told you to file your Return online but you fail to do so.
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									You can find help with completing your return, and online filing at <br/>
									<ul>
										<p><li>your Employer CD-ROM,
										</li></p>
										<p><li>
											<strong>
												<xsl:element name="a">
												<xsl:attribute name="href"><xsl:value-of select="$sending_paye_online_URL"/></xsl:attribute>
												<xsl:value-of select="substring($sending_paye_online_URL, 8)"/></xsl:element>
											</strong> 
										</li></p>
									</ul>
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									If you do not have to send a Return, for example because you did not employ anyone, please let me know. This will stop further reminders and penalties.
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									We charge interest on late PAYE payments, so please pay any outstanding amounts now. For details of how to pay, or if no payment is due, 
									please see 
									<strong>
										<xsl:element name="a">
										<xsl:attribute name="href"><xsl:value-of select="$hmrc_paye_howtopay_URL"/></xsl:attribute>
										<xsl:value-of select="substring($hmrc_paye_howtopay_URL, 8)"/></xsl:element>
									</strong>  
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									<hr width="97%" align="center"/>
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
						</table>
					</xsl:if>
					<xsl:if test="./@FormType='AR1mn'">
						<table width="93%" border="0">
							<tr>
								<td width="15%">
									<xsl:element name="img">
										<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
										<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
									</xsl:element>
								</td>
								<td colspan="5" valign="top">
									<div align="right">
										<xsl:element name="img">
											<xsl:attribute name="alt">Reminder B</xsl:attribute>
											<xsl:attribute name="src"><xsl:value-of select="$reminder_b_image_URI"/></xsl:attribute>
										</xsl:element>
									</div>
								</td>
							</tr>
							<tr>
								<td width="15%" height="22">&#160;</td>
								<td width="10%" height="22">&#160;</td>
								<td width="20%" height="22">&#160;</td>
								<td width="26%" height="22">&#160;</td>
								<td colspan="2" height="22" width="29%">&#160;</td>
							</tr>
							<tr>
								<td colspan="4">
									<div align="right">
										<font face="Tahoma" size="2">
											<b>Date of Issue</b>
										</font>
									</div>
								</td>
								<td colspan="2" width="29%">
									<xsl:value-of select="substring(./@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 1, 4)"/>
								</td>
							</tr>
							<tr>
								<td colspan="3" valign="top">&#160;</td>
								<td colspan="3" valign="top" height="4">&#160;</td>
							</tr>
							<tr>
								<td colspan="3" valign="top">
									<table width="100%" border="0" name="AddressTable">
										<xsl:if test="not(./three:EmployerDetails/three:AgentDetails/three:Address/three:Line[1])">
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Name"/>
												</td>
											</tr>
											<xsl:for-each select="./three:EmployerDetails/three:Address/three:Line">
												<tr>
													<td>
														<xsl:value-of select="."/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Address/three:PostCode"/>
												</td>
											</tr>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Address/three:Country"/>
												</td>
											</tr>
											<tr>
												<td>&#160;</td>
											</tr>
										</xsl:if>
										<xsl:if test="./three:EmployerDetails/three:AgentDetails/three:Address/three:Line[1]">
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Name"/>
												</td>
											</tr>
											<xsl:for-each select="./three:EmployerDetails/three:AgentDetails/three:Address/three:Line">
												<tr>
													<td>
														<xsl:value-of select="."/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Address/three:PostCode"/>
												</td>
											</tr>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Address/three:Country"/>
												</td>
											</tr>
											<tr>
												<td>&#160;</td>
											</tr>
										</xsl:if>
									</table>
								</td>
								<td colspan="3" valign="top">
									<div align="right">
										<font face="Tahoma" size="2"/>
									</div>
									<table width="100%" border="0" name="IssuingAddressTable">
										<tr>
											<td height="23" valign="top" colspan="2">
												<div align="center">
													<i>Please use this reference if you write or call.<br/>
													 It will help to avoid delay. </i>
												</div>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top" width="47%">
												<div align="right">
													<b>
														<font face="Tahoma" size="2">Employer Reference</font>
													</b>
												</div>
											</td>
											<td height="23" width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:EmployerRef"/>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top" width="47%">
												<div align="right">
													<b>
														<font face="Tahoma" size="2">Accounts Office Reference</font>
													</b>
												</div>
											</td>
											<td height="23" width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:AORef"/>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top" width="47%">
												<div align="right">
													<b>
														<font face="Tahoma" size="2">Employer Name</font>
													</b>
												</div>
											</td>
											<td height="23" width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:Name"/>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top" width="47%">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Issued By</b>
													</font>
												</div>
											</td>
											<td height="23" width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./three:EmployerDetails/three:HMRCoffice/three:Address/three:Line">
											<tr>
												<td width="47%">&#160;</td>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td width="47%">&#160;</td>
											<td width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Address/three:PostCode"/>
											</td>
										</tr>
										<tr>
											<td width="47%">&#160;</td>
											<td width="53%"/>
										</tr>
										<tr>
											<td width="47%">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Tax Office Number</b>
													</font>
												</div>
											</td>
											<td width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Number"/> / <xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Reference"/>
											</td>
										</tr>
										<tr>
											<td width="47%">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Telephone Number</b>
													</font>
												</div>
											</td>
											<td width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Telephone/three:Number"/>
											</td>
										</tr>
										<tr>
											<td width="47%">
												<div align="right">
													<font face="Tahoma" size="2"/>
												</div>
											</td>
											<td width="53%">
												<font face="Tahoma" size="2">
													<b>
													<xsl:element name="a">
														<xsl:attribute name="href"><xsl:value-of select="$outgoing_helpline_numbers_htm_URI"/></xsl:attribute>
														Helpline Numbers</xsl:element>
													</b>
												</font>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr/>
							<tr/>							
							<tr>
								<td colspan="6" valign="top">
									<br/>
										<b>
											<font face="Tahoma" size="4">Employer Annual Return (P35 and P14s) tax year 
											<xsl:value-of select="./@TaxYearEnd -1"/>/<xsl:value-of select="substring(./@TaxYearEnd,3)"/>
											</font>
										</b>
								</td>
							</tr>
							<tr>
								<td colspan="6" valign="top">&#160;</td>
							</tr>
						</table>
						<table width="93%" border="0">

							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									<b>19 May</b> is the date your Return is due.
								 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									<b>Already sent yours?</b>  Thank you and please ignore this reminder.
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6"><b>Do not have to send one,</b> for example because you did not employ anyone? Please let me know, this will stop unnecessary reminders and penalties.
								</td>
							</tr>

							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									<b>Not yet sent your Return?</b> Please do so now. We charge penalties of &#163;<xsl:value-of select="$annual_returns_late_penalty"/> per group of 50 employees per month, 
									or part month your Return is late. We also will charge an additional penalty of up to £3,000, 
									if we have told you to file your Return online but you fail to do so.
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									 You can find help with completing your return, and online filing at <br/>
									<ul>
										<p><li>your Employer CD-ROM,
										</li></p>
										<p><li>
											<strong>
												<xsl:element name="a">
												<xsl:attribute name="href"><xsl:value-of select="$sending_paye_online_URL"/></xsl:attribute>
												<xsl:value-of select="substring($sending_paye_online_URL, 8)"/></xsl:element>
											</strong> 
										</li></p>
									</ul>
								 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">We charge interest on late PAYE payments, so please pay any outstanding amounts now. For details of how to pay, or if no payment is due, 
								please see
								<strong>
									<xsl:element name="a">
									<xsl:attribute name="href"><xsl:value-of select="$hmrc_paye_howtopay_URL"/></xsl:attribute>
									<xsl:value-of select="substring($hmrc_paye_howtopay_URL, 8)"/></xsl:element>
								</strong>  
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									<hr width="97%" align="center"/>
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
						</table>
					</xsl:if>
				</xsl:for-each>
				<table width="100%" border="0">
					<tr>
						<td colspan="2">
							<font face="Tahoma" size="2"/>
							<div align="right">
								<a style="text-decoration: none" href="javascript:window.close()">
									<b>
										<font size="2" face="Tahoma">Close Window</font>
									</b>
								</a>
							</div>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
