<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:one="http://www.govtalk.gov.uk/taxation/DPSwrapper/1" xmlns:two="http://www.govtalk.gov.uk/taxation/ReminderAR/2" xmlns:three="http://www.govtalk.gov.uk/taxation/ReminderARmn/2">
    <xsl:import href='dps_variables.xsl'/>
    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:variable name="FBIGGISVersion">
 /**
 *
 * Program Name:            reminders_dps_stylesheets_2006.xsl 
 *
 * Description:             Outgoing Forms - rendering stylesheet for Reminders: AR1n, AR2n, AR6, AR2mn
 *
 * Amendment History:
 *
 * Date       Author        Release   Description
 * 18/01/2006 J Head        56RJ      2006 version created for 56RJ project (re-writing secure mail).
 * 02/02/2006 J Head:       All DPS form stylesheets now import another stylesheet, dps_variables.xsl. Variables that may change between
 *                          environments, such as image and help page URIs and URLs, are set in dps_variables.xsl and referenced
 *                          in the DPS form stylesheets. This facilitates making the stylesheets environment specific without the need to
 *                          change hard coded variables in each and every DPS stylesheet as only dps_variables.xsl needs to be changed.
*/
    </xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
				<title>Reminders</title>
			</head>
			<body bgcolor="#FFFFFF">
				<xsl:for-each select="/one:DPSdata/two:ReminderAR">
					<table width="95%" border="0">
						<tr>
							<td>
								<xsl:element name="img">
									<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
									<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
								</xsl:element>
							</td>
							<td colspan="4" valign="top">
								<xsl:choose>
									<xsl:when test="./@FormType='AR6'">
										<div align="right">
											<xsl:element name="img">
												<xsl:attribute name="alt">Reminder</xsl:attribute>
												<xsl:attribute name="src"><xsl:value-of select="$reminder_image_URI"/></xsl:attribute>
											</xsl:element>
										</div>
									</xsl:when>
									<xsl:otherwise>
										<div align="right">
											<xsl:element name="img">
												<xsl:attribute name="alt">Reminder B</xsl:attribute>
												<xsl:attribute name="src"><xsl:value-of select="$reminder_b_image_URI"/></xsl:attribute>
											</xsl:element>
										</div>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
						<tr>
							<td width="20%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
						</tr>
						<tr>
							<td colspan="5" align="right">
							</td>
						</tr>
						<tr>
							<td colspan="3" valign="top">&#160;</td>
							<td colspan="2" valign="top" height="4">&#160;</td>
						</tr>
						<tr>
							<td colspan="2" valign="top">
								<table border="0" name="AddressTable">
									<xsl:if test="not(./two:EmployerDetails/two:AgentDetails/two:Address/two:Line[1])">
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./two:EmployerDetails/two:Address/two:Line">
											<tr>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:Address/two:PostCode"/>
											</td>
										</tr>
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:Address/two:Country"/>
											</td>
										</tr>
										<tr>
											<td>&#160;</td>
										</tr>
									</xsl:if>
									<xsl:if test="./two:EmployerDetails/two:AgentDetails/two:Address/two:Line[1]">
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:AgentDetails/two:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./two:EmployerDetails/two:AgentDetails/two:Address/two:Line">
											<tr>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:AgentDetails/two:Address/two:PostCode"/>
											</td>
										</tr>
										<tr>
											<td>
												<xsl:value-of select="./two:EmployerDetails/two:AgentDetails/two:Address/two:Country"/>
											</td>
										</tr>
										<tr>
											<td>&#160;</td>
										</tr>
									</xsl:if>
								</table>
							</td>
							<td colspan="3" valign="top" height="4">
								<table border="0" name="IssuingAddressTable" align="right">
									<tr>
									<td align="right">
									<font face="Tahoma" size="2">
										<b>Date of Issue</b>
									</font>
									</td>
									<td>
									<xsl:value-of select="substring(./@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 1, 4)"/>
									</td>									
									</tr>
									<tr>
									<td colspan="2">&#160;</td>
									</tr>								
									<tr>
										<td height="23" valign="top" colspan="2">
											<div align="center">
												<i>Please use this reference if you write or call.<br/>
 It will help to avoid delay. </i>
											</div>
										</td>
									</tr>
									<tr>
										<td height="23" valign="top">
											<div align="right">
												<b>
													<font face="Tahoma" size="2">Employer Reference</font>
												</b>
											</div>
										</td>
										<td height="23" >
											<xsl:value-of select="./two:EmployerDetails/two:EmployerRef"/>
										</td>
									</tr>
									<tr>
										<td height="23" valign="top" >
											<div align="right">
												<font face="Tahoma" size="2">
													<b>Issued By</b>
												</font>
											</div>
										</td>
										<td height="23" >
											<xsl:value-of select="./two:EmployerDetails/two:HMRCoffice/two:Name"/>
										</td>
									</tr>
									<xsl:for-each select="./two:EmployerDetails/two:HMRCoffice/two:Address/two:Line">
										<tr>
											<td >&#160;</td>
											<td>
												<xsl:value-of select="."/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td >&#160;</td>
										<td >
											<xsl:value-of select="./two:EmployerDetails/two:HMRCoffice/two:Address/two:PostCode"/>
										</td>
									</tr>
									<tr>
										<td>&#160;</td>
										<td/>
									</tr>
									<tr>
										<td >
											<div align="right">
												<font face="Tahoma" size="2">
													<b>Tax Office Number</b>
												</font>
											</div>
										</td>
										<td >
											<xsl:value-of select="./two:EmployerDetails/two:HMRCoffice/two:Number"/> / <xsl:value-of select="./two:EmployerDetails/two:HMRCoffice/two:Reference"/>
										</td>
									</tr>
									<tr>
										<td >
											<div align="right">
												<font face="Tahoma" size="2">
													<b>Telephone Number</b>
												</font>
											</div>
										</td>
										<td >
											<xsl:value-of select="./two:EmployerDetails/two:HMRCoffice/two:Telephone/two:Number"/>
										</td>
									</tr>
									<tr>
										<td >
											<div align="right">
												<font face="Tahoma" size="2"/>
											</div>
										</td>
										<td >
											<font face="Tahoma" size="2">
												<b>
													<xsl:element name="a">
														<xsl:attribute name="href"><xsl:value-of select="$outgoing_helpline_numbers_htm_URI"/></xsl:attribute>
														Helpline Numbers</xsl:element></b>
											</font>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td colspan="5" >&#160;</td>
						</tr>
						<tr>
							<td colspan="5" valign="top">
								<p/>
								<b>
									<font face="Tahoma" size="4">Employer and Contractor Annual Returns<br/></font>
									<font face="Tahoma" size="2">Income Tax year <xsl:value-of select="./@TaxYearEnd -1"/> / <xsl:value-of select="./@TaxYearEnd"/></font>
								</b>
							</td>
						</tr>
						<tr>
							<td colspan="5" valign="top">&#160;</td>
						</tr>
					</table>
					<table width="95%" border="0">
						<xsl:for-each select="./two:EmployerDetails/two:LiabilityType">
							<tr>
								<td colspan="6">
									<xsl:value-of select="."/>
								</td>
							</tr>
						</xsl:for-each>
						<tr>
							<td colspan="6" height="5">&#160;</td>
						</tr>
						<xsl:if test="./@FormType='AR1n'">
							<tr>
								<td colspan="6" height="5">
 Your annual return(s) must reach me by 19 May. Please note that your return is made <br/>
 up of your P35 and P14s (for all your employees and any directors) and CIS 36 <br/>
 (if appropriate). You can send your P35 and P14s online, and you may receive a tax free <br/>
 payment if you do so. Please see
							<b><xsl:element name="a">
								<xsl:attribute name="href"><xsl:value-of select="$paye_online_URL"/></xsl:attribute>
								<xsl:value-of select="substring($paye_online_URL, 8)"/></xsl:element></b>for details.</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 If you are having difficulty in completing your return, or believe that one is not due <br/>
 please get in touch immediately.
 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 You may have to pay a penalty if your return is late. The penalty is &#163;<xsl:value-of select="$annual_returns_late_penalty"/> (for each group <br/>
 of 50 employees or subcontractors) for every month, or part month, your return is late.
 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 If you have been advised that you must file your P35 and P14s online, then failure to do <br/>
 so will lead to a penalty of up to &#163;3,000.
 </td>
							</tr>
						</xsl:if>
						<xsl:if test="./@FormType='AR2n'">
							<tr>
								<td colspan="6" height="5">
									<b>
										<font face="Tahoma" size="2">
 Penalties are running from 20 May If a Return is due.
 </font>
									</b>
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 Your annual return(s) are overdue. Please note that until we have your P35 and your <br/>
 P14s (for all your employees and any directors), and CIS 36 if appropriate, then you<br/>
 have not completed your return.
 </td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 If you have not done so within the last few days, will you please send your return(s)<br/>
 immediately. If you believe that a return is not due, please let me know.
 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 Because your return(s) were due on 19 May, you will be charged a penalty of &#163;<xsl:value-of select="$annual_returns_late_penalty"/><br/>
 (for each group of 50 employees or subcontractors) for every month, or part month,<br/>
 your return is late.
 </td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 You can send your P35 and P14s online, please see 
  							<b><xsl:element name="a">
 								<xsl:attribute name="href"><xsl:value-of select="$paye_online_URL"/></xsl:attribute>
								<xsl:value-of select="substring($paye_online_URL, 8)"/></xsl:element></b><br/>
 for details. If you have been advised that you must file your P35 and P14s<br/>
 online, failure to do so will lead to a further penalty of up to &#163;3,000.
 </td>
							</tr>
						</xsl:if>
						<xsl:if test="./@FormType='AR6'">
							<tr>
								<td colspan="6" height="5">
									<b>
										<font face="Tahoma" size="2">
 Your annual return(s) are overdue, they should have been received by 19 May.
 </font>
									</b>
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6" height="5">
 Please note that until we have your P35 and your P14s (for all your employees and<br/>
 any directors), and CIS 36 if appropriate, then you have not completed your return.
 </td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 If you have not done so within the last few days, will you please send your return(s)<br/>
 immediately. If you believe that a return is not due, please let me know.
 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 Your continued failure to send in your full return(s) will lead to further action being<br/>
 taken. And because your return(s) were due on 19 May, you will be charged a<br/>
 penalty of &#163;<xsl:value-of select="$annual_returns_late_penalty"/> (for each group of 50 employees or subcontractors) for every<br/>
 month, or part month, your return is late.
 </td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 You can send your P35 and P14s online, please see
   							<b><xsl:element name="a">
  								<xsl:attribute name="href"><xsl:value-of select="$paye_online_URL"/></xsl:attribute>
 								<xsl:value-of select="substring($paye_online_URL, 8)"/></xsl:element></b><br/>
 for details. If you have been advised that you must fill your P35 and<br/>
 P14s online, failure to do so will lead to a further penalty of up to &#163;3,000.
 </td>
							</tr>
						</xsl:if>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<hr width="95%" align="center"/>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
					</table>
				</xsl:for-each>
				<xsl:for-each select="/one:DPSdata/three:ReminderARmn">
					<xsl:if test="./@FormType='AR2mn'">
						<table width="95%" border="0">
							<tr>
								<td>
									<xsl:element name="img">
										<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
										<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
									</xsl:element>
								</td>
								<td colspan="5" valign="top">
									<div align="right">
										<xsl:element name="img">
											<xsl:attribute name="alt">Reminder B</xsl:attribute>
											<xsl:attribute name="src"><xsl:value-of select="$reminder_b_image_URI"/></xsl:attribute>
										</xsl:element>
									</div>
								</td>
							</tr>
							<tr>
								<td width="20%" height="22">&#160;</td>
								<td width="20%" height="22">&#160;</td>
								<td width="20%" height="22">&#160;</td>
								<td width="20%" height="22">&#160;</td>
								<td height="22" width="20%">&#160;</td>
							</tr>
							<tr>
								<td colspan="2" valign="top">
									<table width="100%" border="0" name="AddressTable">
										<xsl:if test="not(./three:EmployerDetails/three:AgentDetails/three:Address/three:Line[1])">
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Name"/>
												</td>
											</tr>
											<xsl:for-each select="./three:EmployerDetails/three:Address/three:Line">
												<tr>
													<td>
														<xsl:value-of select="."/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Address/three:PostCode"/>
												</td>
											</tr>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Address/three:Country"/>
												</td>
											</tr>
											<tr>
												<td>&#160;</td>
											</tr>
										</xsl:if>
										<xsl:if test="./three:EmployerDetails/three:AgentDetails/three:Address/three:Line[1]">
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Name"/>
												</td>
											</tr>
											<xsl:for-each select="./three:EmployerDetails/three:AgentDetails/three:Address/three:Line">
												<tr>
													<td>
														<xsl:value-of select="."/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Address/three:PostCode"/>
												</td>
											</tr>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Address/three:Country"/>
												</td>
											</tr>
											<tr>
												<td>&#160;</td>
											</tr>
										</xsl:if>
									</table>
								</td>
								<td colspan="3" valign="top" height="4">
									<table align="right" border="0" name="IssuingAddressTable">
										<tr>
											<td align="right">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Date of Issue</b>
													</font>
												</div>
											</td>
											<td>
												<xsl:value-of select="substring(./@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 1, 4)"/>
											</td>
										</tr>									
										<tr>
											<td colspan="2">&#160;</td>
										</tr>
										<tr>
											<td height="23" valign="top" colspan="2">
												<div align="center">
													<i>Please use this reference if you write or call.<br/>
 It will help to avoid delay. </i>
												</div>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top">
												<div align="right">
													<b>
														<font face="Tahoma" size="2">Employer Reference</font>
													</b>
												</div>
											</td>
											<td height="23">
												<xsl:value-of select="./three:EmployerDetails/three:EmployerRef"/>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Issued By</b>
													</font>
												</div>
											</td>
											<td height="23">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./three:EmployerDetails/three:HMRCoffice/three:Address/three:Line">
											<tr>
												<td>&#160;</td>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td>&#160;</td>
											<td>
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Address/three:PostCode"/>
											</td>
										</tr>
										<tr>
											<td>&#160;</td>
											<td/>
										</tr>
										<tr>
											<td>
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Tax Office Number</b>
													</font>
												</div>
											</td>
											<td>
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Number"/> / <xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Reference"/>
											</td>
										</tr>
										<tr>
											<td>
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Telephone Number</b>
													</font>
												</div>
											</td>
											<td>
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Telephone/three:Number"/>
											</td>
										</tr>
										<tr>
											<td>
												<div align="right">
													<font face="Tahoma" size="2"/>
												</div>
											</td>
											<td>
												<font face="Tahoma" size="2">
													<b>
													<xsl:element name="a">
														<xsl:attribute name="href"><xsl:value-of select="$outgoing_helpline_numbers_htm_URI"/></xsl:attribute>
														Helpline Numbers</xsl:element>
													</b>
												</font>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td colspan="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="5" valign="top">
									<p/>
										<b>
											<font face="Tahoma" size="4">Employer and Contractor Annual Returns<br/></font>
											<font face="Tahoma" size="2">Income Tax year <xsl:value-of select="./@TaxYearEnd -1"/> / <xsl:value-of select="./@TaxYearEnd"/></font>
										</b>
								</td>
							</tr>
							<tr>
								<td colspan="5" valign="top">&#160;</td>
							</tr>
						</table>
						<table width="95%" border="0">
							<xsl:for-each select="./three:EmployerDetails/three:LiabilityType">
								<tr>
									<td colspan="6">
										<xsl:value-of select="."/>
									</td>
								</tr>
							</xsl:for-each>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6" height="5">
									<b>
										<font face="Tahoma" size="2">
 Penalties are running from 20 May if a Return is due.
 </font>
									</b>
								</td>
							</tr>
							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 Your annual return(s) are overdue. Please note that until we have your P35 and your<br/>
 P14s (for all your employees and any directors), and CIS 36 if appropriate, then you<br/>
 have not completed your return. If you have not done so within the last few days, will<br/>
 you please send your return(s) immediately. If you believe that a return is not due,<br/>
 please let me know.
 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 Because your return(s) were due on 19 May, you will be charged a penalty of &#163;<xsl:value-of select="$annual_returns_late_penalty"/> 
<br/>
 (for each group of 50 employees or subcontractors) for every month, or part month,<br/>
 your return is late. You can send your P35 and P14s online, please see<br/>
    							<b><xsl:element name="a">
  								<xsl:attribute name="href"><xsl:value-of select="$paye_online_URL"/></xsl:attribute>
 								<xsl:value-of select="substring($paye_online_URL, 8)"/></xsl:element></b>
 for details. If you have been advised that you<br/>
 must file your P35 and P14s online, failure to do so will lead to a further penalty of up<br/>
 to &#163;<xsl:value-of select="$annual_returns_max_late_penalty"/>.
 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 You also appear to be late paying PAYE for the 
 <xsl:value-of select="./@TaxYearEnd -1"/>/<xsl:value-of select="./@TaxYearEnd"/>
 tax year. Please pay any<br/>
 amounts due immediately. Interest will be charged daily until payment is made. Please<br/>
 contact your Accounts Office with any payment queries.
 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									<hr width="95%" align="center"/>
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
						</table>
					</xsl:if>
					<xsl:if test="./@FormType='AR1mn'">
						<table width="95%" border="0">
							<tr>
								<td width="15%">
									<xsl:element name="img">
										<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
										<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
									</xsl:element>
								</td>
								<td colspan="5" valign="top">
									<div align="right">
										<xsl:element name="img">
											<xsl:attribute name="alt">Reminder B</xsl:attribute>
											<xsl:attribute name="src"><xsl:value-of select="$reminder_b_image_URI"/></xsl:attribute>
										</xsl:element>
									</div>
								</td>
							</tr>
							<tr>
								<td width="15%" height="22">&#160;</td>
								<td width="10%" height="22">&#160;</td>
								<td width="20%" height="22">&#160;</td>
								<td width="26%" height="22">&#160;</td>
								<td colspan="2" height="22" width="29%">&#160;</td>
							</tr>
							<tr>
								<td colspan="4">
									<div align="right">
										<font face="Tahoma" size="2">
											<b>Date of Issue</b>
										</font>
									</div>
								</td>
								<td colspan="2" width="29%">
									<xsl:value-of select="substring(./@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 1, 4)"/>
								</td>
							</tr>
							<tr>
								<td colspan="3" valign="top">&#160;</td>
								<td colspan="3" valign="top" height="4">&#160;</td>
							</tr>
							<tr>
								<td colspan="3" valign="top">
									<table width="100%" border="0" name="AddressTable">
										<xsl:if test="not(./three:EmployerDetails/three:AgentDetails/three:Address/three:Line[1])">
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Name"/>
												</td>
											</tr>
											<xsl:for-each select="./three:EmployerDetails/three:Address/three:Line">
												<tr>
													<td>
														<xsl:value-of select="."/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Address/three:PostCode"/>
												</td>
											</tr>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:Address/three:Country"/>
												</td>
											</tr>
											<tr>
												<td>&#160;</td>
											</tr>
										</xsl:if>
										<xsl:if test="./three:EmployerDetails/three:AgentDetails/three:Address/three:Line[1]">
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Name"/>
												</td>
											</tr>
											<xsl:for-each select="./three:EmployerDetails/three:AgentDetails/three:Address/three:Line">
												<tr>
													<td>
														<xsl:value-of select="."/>
													</td>
												</tr>
											</xsl:for-each>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Address/three:PostCode"/>
												</td>
											</tr>
											<tr>
												<td>
													<xsl:value-of select="./three:EmployerDetails/three:AgentDetails/three:Address/three:Country"/>
												</td>
											</tr>
											<tr>
												<td>&#160;</td>
											</tr>
										</xsl:if>
									</table>
								</td>
								<td colspan="3" valign="top" height="4">
									<div align="right">
										<font face="Tahoma" size="2"/>
									</div>
									<table width="100%" border="0" name="IssuingAddressTable">
										<tr>
											<td height="23" valign="top" colspan="2">
												<div align="center">
													<i>Please use this reference if you write or call.<br/>
 It will help to avoid delay. </i>
												</div>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top" width="47%">
												<div align="right">
													<b>
														<font face="Tahoma" size="2">Employer Reference</font>
													</b>
												</div>
											</td>
											<td height="23" width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:EmployerRef"/>
											</td>
										</tr>
										<tr>
											<td height="23" valign="top" width="47%">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Issued By</b>
													</font>
												</div>
											</td>
											<td height="23" width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./three:EmployerDetails/three:HMRCoffice/three:Address/three:Line">
											<tr>
												<td width="47%">&#160;</td>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td width="47%">&#160;</td>
											<td width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Address/three:PostCode"/>
											</td>
										</tr>
										<tr>
											<td width="47%">&#160;</td>
											<td width="53%"/>
										</tr>
										<tr>
											<td width="47%">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Tax Office Number</b>
													</font>
												</div>
											</td>
											<td width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Number"/> / <xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Reference"/>
											</td>
										</tr>
										<tr>
											<td width="47%">
												<div align="right">
													<font face="Tahoma" size="2">
														<b>Telephone Number</b>
													</font>
												</div>
											</td>
											<td width="53%">
												<xsl:value-of select="./three:EmployerDetails/three:HMRCoffice/three:Telephone/three:Number"/>
											</td>
										</tr>
										<tr>
											<td width="47%">
												<div align="right">
													<font face="Tahoma" size="2"/>
												</div>
											</td>
											<td width="53%">
												<font face="Tahoma" size="2">
													<b>
													<xsl:element name="a">
														<xsl:attribute name="href"><xsl:value-of select="$outgoing_helpline_numbers_htm_URI"/></xsl:attribute>
														Helpline Numbers</xsl:element>
													</b>
												</font>
											</td>
										</tr>
									</table>
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6" valign="top">
									<p/>
										<b>
											<font face="Tahoma" size="4">Employer and Contractor Annual Returns<br/></font>
											<font face="Tahoma" size="2">Income Tax year <xsl:value-of select="./@TaxYearEnd -1"/> / <xsl:value-of select="./@TaxYearEnd"/></font>
										</b>
								</td>
							</tr>
							<tr>
								<td colspan="6" valign="top">&#160;</td>
							</tr>
						</table>
						<table width="95%" border="0">

							<tr>
								<td colspan="6" height="5">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 Your annual return(s) must reach me by 19 May. Please note that your return is made<br/>
 up of your P35 and your P14s (for all your employees and any directors), and CIS 36<br/>
 if appropriate
  </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
<b>If you have already sent your return</b>, thank you and please ignore this letter.<br/>
 If you believe that a return is not due, or need help in completing a return, please let<br/>
 me know.
 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 If your return is late you will be charged a penalty of &#163;<xsl:value-of select="$annual_returns_late_penalty"/> (for each group of 50<br/>
 employees or subcontractors) for every month, or part month, your return is late. You<br/>
 can send your P35 and P14s online, see<b><xsl:element name="a">
  					    <xsl:attribute name="href"><xsl:value-of select="$paye_online_URL"/></xsl:attribute>
 					      <xsl:value-of select="substring($paye_online_URL, 8)"/>
 					  </xsl:element></b>for details.<br/>
 If you have been advised that you must file your P35 and P14s online, failure to do so<br/>
 will lead to a further penalty of up to &#163;3,000.
 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
 You also appear to be late paying Tax and National Insurance contributions for the<br/>
 <xsl:value-of select="./@TaxYearEnd -1"/>/<xsl:value-of select="./@TaxYearEnd"/>
 tax year. Please pay any amounts due immediately. Interest will be charged<br/>
 daily until payment is made.
 </td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">
									<hr width="95%" align="center"/>
								</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
							<tr>
								<td colspan="6">&#160;</td>
							</tr>
						</table>
					</xsl:if>
				</xsl:for-each>
				<table width="95%" border="0">
					<tr>
						<td colspan="2">
							<font face="Tahoma" size="2"/>
							<div align="right">
								<a style="text-decoration: none" href="javascript:window.close()">
									<b>
										<font size="2" face="Tahoma">Close Window</font>
									</b>
								</a>
							</div>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
