<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:dps="http://www.govtalk.gov.uk/taxation/DPSwrapper/1" xmlns:p9="http://www.govtalk.gov.uk/taxation/CodingNoticeP9/2">
    <xsl:import href='dps_variables.xsl'/>
    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:variable name="FBIGGISVersion">
 /**
 *
 *  Program Name:       p9_dps_2007.xsl
 *
 *  Description:        Outgoing Forms - rendering stylesheet for P9
 *
 *  Author:             Paul Dicken
 *
 *	Amendment History:
 *
 * Date       Author        Release   Description
 * 17/01/2003 R Chahal      CP50026   Changed wording.
 * 18/01/2006 J Head        56RJ      2007 version created for 56RJ project (re-writing secure mail).
 * 02/02/2006 J Head:       All DPS form stylesheets now import another stylesheet, dps_variables.xsl. Variables that may change between
 *                          environments, such as image and help page URIs and URLs, are set in dps_variables.xsl and referenced
 *                          in the DPS form stylesheets. This facilitates making the stylesheets environment specific without the need to
 *                          change hard coded variables in each and every DPS stylesheet as only dps_variables.xsl needs to be changed.
 * 23/02/2006 J Head        Changes made in response to email received by SDSTeam on 21/02/2006: -
 *                              1. Borders are used on all tabular stylesheets now for both single and multiple employers for clarity and consistency.
 *                              2. Date of Issue is now included in the table rows for single employers and not at the top of the page.
 *  03/08/2009 R Videla	Changes made as per the instructions in 8523046
 * 24/11/2014 D Joss		Added TaxRegime attribute
*/
    </xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<title>Notice of Coding: P9</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			</head>
			<body bgcolor="#FFFFFF">
				<table width="100%" border="0">
					<tr valign="top">
						<td>
							<xsl:element name="img">
								<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
								<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
							</xsl:element>
						</td>
						<td colspan="5">
							<div align="right">
								<b>
									<i>
										<font size="5"> Notice of Tax Codes 
				P9 for the Year to 05-04-<xsl:value-of select="/dps:DPSdata/p9:CodingNoticeP9/@TaxYearEnd"/>
										</font>
									</i>
								</b>
							</div>
						</td>
					</tr>
					<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td width="30%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="21%" height="22">&#160;</td>
							<td width="18%" height="22">
								<font face="Tahoma" size="2">
									<b>Employer PAYE reference</b>
								</font>
							</td>
							<td colspan="2" height="22">
								<xsl:value-of select="/dps:DPSdata/p9:CodingNoticeP9/p9:EmployerRef"/>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
					</xsl:if>
					<tr>
						<td colspan="6">&#160;</td>
					</tr>
					<tr>
						<td width="30%">&#160;</td>
						<td width="20%">&#160;</td>
						<td width="21%">&#160;</td>
						<td colspan="3">
							<font face="Tahoma" size="2">
								<b>
									<xsl:element name="a">
										<xsl:attribute name="href"><xsl:value-of select="$p9_instructions_htm_URI"/></xsl:attribute>
										Instructions for the employer</xsl:element>
								</b>
							</font>
						</td>
					</tr>
					<tr>
						<td width="13%">&#160;</td>
						<td width="20%">&#160;</td>
						<td width="21%">&#160;</td>
						<td colspan="3">
							<font face="Tahoma" size="2">
								<b>
									<xsl:element name="a">
										<xsl:attribute name="href"><xsl:value-of select="$outgoing_helpline_numbers_htm_URI"/></xsl:attribute>
										Helpline Numbers</xsl:element>
								</b>
							</font>
						</td>
					</tr>
					<tr>
						<td colspan="6">&#160;</td>
					</tr>
					<tr>
						<td colspan="6">&#160;</td>
					</tr>
					<tr>
						<td colspan="6">&#160;</td>
					</tr>
					<tr>
						<td colspan="6">
							<div align="center">
								<b>
									<font size="4" face="Tahoma">
										<xsl:if test="count(/dps:DPSdata/p9:CodingNoticeP9) > 1">
      		PAYE - Notice to employer of employees' tax codes
      	</xsl:if>
										<xsl:if test="count(/dps:DPSdata/p9:CodingNoticeP9) = 1">
      		PAYE - Notice to employer of employee's tax code
      	</xsl:if>
									</font>
								</b>
							</div>
						</td>
					</tr>
					<tr>
						<td colspan="6">&#160;</td>
					</tr>
					<tr>
						<td colspan="6">
							<xsl:if test="count(/dps:DPSdata/p9:CodingNoticeP9)='1'"/>
							<xsl:if test="count(/dps:DPSdata/p9:CodingNoticeP9) > '1'">
								<p>Notices of coding included in this message = <xsl:value-of select="count(/dps:DPSdata/p9:CodingNoticeP9)"/>
								</p>
							</xsl:if>
						</td>
					</tr>
					<tr>
						<td colspan="6">
							<div>
								<xsl:if test="count(/dps:DPSdata/p9:CodingNoticeP9) > 1">
					Please use these tax codes for the tax year to 05-04-<xsl:value-of select="/dps:DPSdata/p9:CodingNoticeP9/@TaxYearEnd"/>
								</xsl:if>
								<xsl:if test="count(/dps:DPSdata/p9:CodingNoticeP9) = 1">
					Please use this tax code for the tax year to 05-04-<xsl:value-of select="/dps:DPSdata/p9:CodingNoticeP9/@TaxYearEnd"/>
								</xsl:if>
							</div>
						</td>
					</tr>
					<tr>
						<td width="13%">&#160;</td>
						<td width="20%">&#160;</td>
						<td width="21%">&#160;</td>
						<td width="18%">&#160;</td>
						<td width="6%">&#160;</td>
						<td width="22%">&#160;</td>
					</tr>
				</table>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
					<center>
					<table width="99%" border="1">
						<tr align='center'>
							<td>
								<font face="Tahoma" size="2">
									<b>Employee Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>National Insurance Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Works / Payroll Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Date of Issue</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Tax Code</b>
								</font>
							</td>
						</tr>
						<xsl:for-each select="/dps:DPSdata/p9:CodingNoticeP9/p9:NINO">
							<xsl:sort select="." order="ascending" data-type="text"/>
							<tr align='center'>
								<td width="13%">
									<xsl:value-of select="concat(../p9:Name/p9:Forename[1], ' ', ../p9:Name/p9:Surname)"/>
								</td>
                                 <xsl:choose>
											<xsl:when test="../p9:NINO!=''">
												<td width="13%">
													<xsl:value-of select="../p9:NINO"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td width="13%">
													&#160;
												</td>
											</xsl:otherwise>
								</xsl:choose>

                                 <xsl:choose>
											<xsl:when test="../p9:WorksNumber!=''">
												<td width="13%">
													<xsl:value-of select="../p9:WorksNumber"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td width="13%">
													&#160;
												</td>
											</xsl:otherwise>
								</xsl:choose>
								<td width="13%">
									<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
								</td>
								<td width="13%">
								    <xsl:variable name="TaxCode" select="../p9:CodingUpdate/p9:TaxCode"/>
								    <xsl:variable name="TaxRegime" select="../p9:CodingUpdate/p9:TaxCode/@TaxRegime"/>
								    <xsl:variable name="W1M1">
										<xsl:choose>
											<xsl:when test="../p9:CodingUpdate/p9:TaxCode/@Week1Month1Indicator='X'"> W1/M1</xsl:when>
											<xsl:otherwise></xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:value-of select="concat($TaxRegime, $TaxCode, $W1M1)"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
					</center>
				</xsl:if>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity=''">
				<center>
					<table width="99%" border="1">
						<tr align='center'>
							<td>
								<font face="Tahoma" size="2">
									<b>Employee Name</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Employer Reference</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>National Insurance Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Works / Payroll Number</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Date of Issue</b>
								</font>
							</td>
							<td>
								<font face="Tahoma" size="2">
									<b>Tax Code</b>
								</font>
							</td>
						</tr>
						<xsl:for-each select="/dps:DPSdata/p9:CodingNoticeP9/p9:NINO">
							<xsl:sort select="." order="ascending" data-type="text"/>
							<tr align='center'>
								<td width="13%">
									<xsl:value-of select="concat(../p9:Name/p9:Forename[1], ' ', ../p9:Name/p9:Surname)"/>
								</td>
								<td width="13%">
									<xsl:value-of select="../p9:EmployerRef"/>
								</td>
                                   <xsl:choose>
											<xsl:when test="../p9:NINO!=''">
												<td width="13%">
													<xsl:value-of select="../p9:NINO"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td width="13%">
													&#160;
												</td>
											</xsl:otherwise>
									</xsl:choose>
								
                                   <xsl:choose>
											<xsl:when test="../p9:WorksNumber!=''">
												<td width="13%">
													<xsl:value-of select="../p9:WorksNumber"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td width="13%">
													&#160;
												</td>
											</xsl:otherwise>
									</xsl:choose>
								<td width="13%">
									<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
								</td>
								<td width="13%">
								    <xsl:variable name="TaxCode" select="../p9:CodingUpdate/p9:TaxCode"/>
								    <xsl:variable name="TaxRegime" select="../p9:CodingUpdate/p9:TaxCode/@TaxRegime"/>
								    <xsl:variable name="W1M1">
										<xsl:choose>
											<xsl:when test="../p9:CodingUpdate/p9:TaxCode/@Week1Month1Indicator='X'"> W1/M1</xsl:when>
											<xsl:otherwise></xsl:otherwise>
										</xsl:choose>
									</xsl:variable>
									<xsl:value-of select="concat($TaxRegime, $TaxCode, $W1M1)"/>
								</td>
							</tr>
						</xsl:for-each>
					</table>
					</center>
				</xsl:if>
				<br/>
				<table width="100%" border="0">
					<tr>
						<td>
							<font face="Tahoma" size="2">
								<b>End of List</b>
							</font>
						</td>
						<td>
							<div align="right">
								<a href="javascript:window.close()">
									<b>
										<font size="2" face="Tahoma">Close Window</font>
									</b>
								</a>
							</div>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
