<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:dps="http://www.govtalk.gov.uk/taxation/DPSwrapper/1" xmlns:p6="http://www.govtalk.gov.uk/taxation/CodingNoticesP6P6B/2">
    <xsl:import href='dps_variables.xsl'/>
    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:variable name="FBIGGISVersion">
 /**
 *
 * Program Name:            p6_dps_2007.xsl
 *
 * Description:             Outgoing Forms - rendering stylesheet for P6 and P6B
 *
 * Author:                  Paul Dicken
 *
 * Amendment History:
 *
 * Date       Author        Release   Description
 * 17/01/2003 R Chahal      CP50026   Changed wording.
 * 18/01/2006 J Head        56RJ      2007 version created for 56RJ project (re-writing secure mail).
 * 02/02/2006 J Head:       All DPS form stylesheets now import another stylesheet, dps_variables.xsl. Variables that may change between
 *                          environments, such as image and help page URIs and URLs, are set in dps_variables.xsl and referenced
 *                          in the DPS form stylesheets. This facilitates making the stylesheets environment specific without the need to
 *                          change hard coded variables in each and every DPS stylesheet as only dps_variables.xsl needs to be changed.
 * 23/02/2006 J Head        Changes made in response to email received by SDSTeam on 21/02/2006: -
 *                              1. Borders are used on all tabular stylesheets now for both single and multiple employers for clarity and consistency.
 *                              2. Date of Issue is now included in the table rows for single employers and not at the top of the page.
 * 26/02/2007 K.Hutchinson         The stylesheet did not allow for week1/month1to be shown. Amended to allow for this  
*/
    </xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<title>Notice of Coding: P6</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			</head>
			<body bgcolor="#FFFFFF">
				<xsl:variable name="P6">
					<xsl:for-each select="/dps:DPSdata/p6:CodingNoticesP6P6B/@FormType[.='P6']">Y</xsl:for-each>
				</xsl:variable>
				<xsl:variable name="P6B">
					<xsl:for-each select="/dps:DPSdata/p6:CodingNoticesP6P6B/@FormType[.='P6B']">Y</xsl:for-each>
				</xsl:variable>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity!=''">
					<table width="99%" border="0">
						<tr valign="top">
							<td>
								<xsl:element name="img">
									<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
									<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
								</xsl:element>
							</td>
							<td colspan="5">
								<div align="right">
									<b>
										<i>
											<font size="5"> Notice of Tax Codes 
 P6 for the Year to 05-04-<xsl:value-of select="/dps:DPSdata/p6:CodingNoticesP6P6B/@TaxYearEnd"/>
											</font>
										</i>
									</b>
								</div>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td width="30%" height="22">&#160;</td>
							<td width="20%" height="22">&#160;</td>
							<td width="21%" height="22">&#160;</td>
							<td width="18%" height="22">
								<font face="Tahoma" size="2">
									<b>Employer PAYE reference</b>
								</font>
							</td>
							<td colsan="2" height="22">
								<xsl:value-of select="/dps:DPSdata/p6:CodingNoticesP6P6B/p6:EmployerRef"/>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="3">&#160;</td>
							<td colspan="3">
								<font face="Tahoma" size="2">
									<b>
										<xsl:element name="a">
											<xsl:attribute name="href"><xsl:value-of select="$p6_instructions_htm_URI"/></xsl:attribute>
											Instructions for the employer</xsl:element>
									</b>
								</font>
							</td>
						</tr>
						<tr>
							<td colspan="3">&#160;</td>
							<td colspan="3">
								<font face="Tahoma" size="2">
									<b>
										<xsl:element name="a">
											<xsl:attribute name="href"><xsl:value-of select="$outgoing_helpline_numbers_htm_URI"/></xsl:attribute>
											Helpline Numbers</xsl:element>
									</b>
								</font>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<div align="center">
									<b>
										<font size="4" face="Tahoma">
											<xsl:if test="count(/dps:DPSdata/p6:CodingNoticesP6P6B) > 1">
 PAYE - Notice to employer of employees' tax codes (or amended codes) and previous pay and tax
 </xsl:if>
											<xsl:if test="count(/dps:DPSdata/p6:CodingNoticesP6P6B) = 1">
 PAYE - Notice to employer of employee's tax code (or amended code) and previous pay and tax
 </xsl:if>
										</font>
									</b>
								</div>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<xsl:if test="count(/dps:DPSdata/p6:CodingNoticesP6P6B)='1'"/>
								<xsl:if test="count(/dps:DPSdata/p6:CodingNoticesP6P6B) > '1'">
									<p>Notices of coding included in this message = <xsl:value-of select="count(/dps:DPSdata/p6:CodingNoticesP6P6B)"/>
									</p>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
					</table>
					<xsl:if test="$P6!=''">
								<p>Please use these tax codes from the next pay day for the year to 05-04-<xsl:value-of select="/dps:DPSdata/p6:CodingNoticesP6P6B/@TaxYearEnd"/>
								</p>
						<table width="99%" border="1">
							<tr align='center'>
								<td>
									<font face="Tahoma" size="2">
										<b>Date of Issue</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Employee Name</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>National Insurance Number</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Works / Payroll Number</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Effective Date</b>
									</font>
								</td>								
								<td>
									<font face="Tahoma" size="2">
										<b>TaxCode</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Previous Pay</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Previous Tax</b>
									</font>
								</td>
							</tr>
							<xsl:for-each select="/dps:DPSdata/p6:CodingNoticesP6P6B/p6:NINO">
								<xsl:sort select="." order="ascending" data-type="text"/>
								<xsl:if test="../@FormType='P6'">
									<tr align='center'>
										<td>
											<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
										</td>
										<td width="18%">
											<xsl:value-of select="concat(../p6:Name/p6:Forename[1], ' ', ../p6:Name/p6:Surname)"/>
										</td>
										<td width="18%">
											<xsl:value-of select="../p6:NINO"/>
										</td>
										<td width="18%">
											<xsl:value-of select="../p6:WorksNumber"/>
										</td>
										<td>
											<xsl:value-of select="substring(../p6:EffectiveDate, 9, 2)"/>-<xsl:value-of select="substring(../p6:EffectiveDate, 6, 2)"/>-<xsl:value-of select="substring(../p6:EffectiveDate, 1, 4)"/>
										</td>										
										<td>
											<xsl:choose>
												<xsl:when test="../p6:CodingUpdate/p6:TaxCode/@Week1Month1Indicator='X'">
													<xsl:value-of select="concat(../p6:CodingUpdate/p6:TaxCode, ' ', 'W1/M1')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../p6:CodingUpdate/p6:TaxCode"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<xsl:choose>
											<xsl:when test="../p6:CodingUpdate/p6:TotalPreviousPay > 0">
												<td>
													<xsl:value-of select="round(../p6:CodingUpdate/p6:TotalPreviousPay)"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td>&#160;</td>
											</xsl:otherwise>
										</xsl:choose>
										<td>
											<xsl:value-of select="../p6:CodingUpdate/p6:TotalPreviousTax"/>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>
						</table>
						<br/>
						<br/>
					</xsl:if>
					<xsl:if test="$P6B!=''">
						<p>Please use these tax codes from the next pay day after <xsl:value-of select="substring(/dps:DPSdata/p6:CodingNoticesP6P6B/p6:EffectiveDate, 9, 2)"/>-<xsl:value-of select="substring(/dps:DPSdata/p6:CodingNoticesP6P6B/p6:EffectiveDate, 6, 2)"/>-<xsl:value-of select="substring(/dps:DPSdata/p6:CodingNoticesP6P6B/p6:EffectiveDate, 1, 4)"/>
						</p>
						<table width="99%" border="1">
							<tr align='center'>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>Date of Issue</b>
									</font>
								</td>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>Employee Name</b>
									</font>
								</td>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>National Insurance Number</b>
									</font>
								</td>
								<td width="20%">
									<font face="Tahoma" size="2">
										<b>Works / Payroll Number</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>TaxCode</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Previous Pay</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Previous Tax</b>
									</font>
								</td>
							</tr>
							<xsl:for-each select="/dps:DPSdata/p6:CodingNoticesP6P6B/p6:NINO">
								<xsl:sort select="." order="ascending" data-type="text"/>
								<xsl:if test="../@FormType='P6B'">
									<tr align='center'>
										<td>
											<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
										</td>
										<td width="22%">
											<xsl:value-of select="concat(../p6:Name/p6:Forename[1], ' ', ../p6:Name/p6:Surname)"/>
										</td>
										<td width="22%">
											<xsl:value-of select="../p6:NINO"/>
										</td>
										<td width="20%">
											<xsl:value-of select="../p6:WorksNumber"/>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="../p6:CodingUpdate/p6:TaxCode/@Week1Month1Indicator='X'">
													<xsl:value-of select="concat(../p6:CodingUpdate/p6:TaxCode, ' ', 'W1/M1')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../p6:CodingUpdate/p6:TaxCode"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<xsl:choose>
											<xsl:when test="../p6:CodingUpdate/p6:TotalPreviousPay > 0">
												<td>
													<xsl:value-of select="round(../p6:CodingUpdate/p6:TotalPreviousPay)"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td>&#160;</td>
											</xsl:otherwise>
										</xsl:choose>
										<td>
											<xsl:value-of select="../p6:CodingUpdate/p6:TotalPreviousTax"/>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>
						</table>
					</xsl:if>
				</xsl:if>
				<xsl:if test="/dps:DPSdata/dps:DPSheader/dps:Entity=''">
					<table width="99%" border="0">
						<tr valign="top">
							<td>
								<xsl:element name="img">
									<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
									<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
								</xsl:element>
							</td>
							<td colspan="5">
								<div align="right">
									<b>
										<i>
											<font size="5"> Notice of Tax Codes 
 P6 for the Year to 05-04-<xsl:value-of select="/dps:DPSdata/p6:CodingNoticesP6P6B/@TaxYearEnd"/>
											</font>
										</i>
									</b>
								</div>
							</td>
						</tr>
					</table>
					<table width="99%" border="0">
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="3" width="70%">&#160;</td>
							<td colspan="3">
								<font face="Tahoma" size="2">
									<b>
									<xsl:element name="a">
										<xsl:attribute name="href"><xsl:value-of select="$p6_instructions_htm_URI"/></xsl:attribute>
										Instructions for the employer</xsl:element>
									</b>
								</font>
							</td>
						</tr>
						<tr>
							<td colspan="3">&#160;</td>
							<td colspan="3">
								<font face="Tahoma" size="2">
									<b>
										<xsl:element name="a">
											<xsl:attribute name="href"><xsl:value-of select="$outgoing_helpline_numbers_htm_URI"/></xsl:attribute>
											Helpline Numbers</xsl:element>
									</b>
								</font>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<div align="center">
									<b>
										<font size="4" face="Tahoma">
											<xsl:if test="count(/dps:DPSdata/p6:CodingNoticesP6P6B) > 1">
 PAYE - Notice to employer of employees' tax codes (or amended codes) and previous pay and tax
 </xsl:if>
											<xsl:if test="count(/dps:DPSdata/p6:CodingNoticesP6P6B) = 1">
 PAYE - Notice to employer of employee's tax code (or amended code) and previous pay and tax
 </xsl:if>
										</font>
									</b>
								</div>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<xsl:if test="count(/dps:DPSdata/p6:CodingNoticesP6P6B)='1'"/>
								<xsl:if test="count(/dps:DPSdata/p6:CodingNoticesP6P6B) > '1'">
									<p>Notices of coding included in this message = <xsl:value-of select="count(/dps:DPSdata/p6:CodingNoticesP6P6B)"/>
									</p>
								</xsl:if>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
					</table>
					<xsl:if test="$P6!=''">
						<p>Please use these tax codes from the next pay day for the year to 05-04-<xsl:value-of select="/dps:DPSdata/p6:CodingNoticesP6P6B/@TaxYearEnd"/>
						</p>
						<table width="99%" border="1">
							<tr align="center">
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>Date of Issue</b>
									</font>
								</td>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>Employee Name</b>
									</font>
								</td>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>Employer Reference</b>
									</font>
								</td>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>National Insurance Number</b>
									</font>
								</td>
								<td width="20%">
									<font face="Tahoma" size="2">
										<b>Works / Payroll Number</b>
									</font>
								</td>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>Effective Date</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>TaxCode</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Previous Pay</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Previous Tax</b>
									</font>
								</td>
							</tr>
							<xsl:for-each select="/dps:DPSdata/p6:CodingNoticesP6P6B/p6:NINO">
								<xsl:sort select="." order="ascending" data-type="text"/>
								<xsl:if test="../@FormType='P6'">
									<tr align="center">
										<td>
											<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
										</td>
										<td width="18%">
											<xsl:value-of select="concat(../p6:Name/p6:Forename[1], ' ', ../p6:Name/p6:Surname)"/>
										</td>
										<td width="18%">
											<xsl:value-of select="../p6:EmployerRef"/>
										</td>
										<td width="18%">
											<xsl:value-of select="../p6:NINO"/>
										</td>
										<td width="18%">
											<xsl:value-of select="../p6:WorksNumber"/>
										</td>
										<td nowrap="true">
											<xsl:value-of select="substring(../p6:EffectiveDate, 9, 2)"/>-<xsl:value-of select="substring(../p6:EffectiveDate, 6, 2)"/>-<xsl:value-of select="substring(../p6:EffectiveDate, 1, 4)"/>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="../p6:CodingUpdate/p6:TaxCode/@Week1Month1Indicator='X'">
													<xsl:value-of select="concat(../p6:CodingUpdate/p6:TaxCode, ' ', 'W1/M1')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../p6:CodingUpdate/p6:TaxCode"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<xsl:choose>
											<xsl:when test="../p6:CodingUpdate/p6:TotalPreviousPay > 0">
												<td>
													<xsl:value-of select="round(../p6:CodingUpdate/p6:TotalPreviousPay)"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td>&#160;</td>
											</xsl:otherwise>
										</xsl:choose>
										<td>
											<xsl:value-of select="../p6:CodingUpdate/p6:TotalPreviousTax"/>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>
						</table>
						<br/>
						<br/>
					</xsl:if>
					<xsl:if test="$P6B!=''">
						<p>Please use these tax codes from the next pay day after the Effective Date</p>
						<table width="99%" border="1">
							<tr align="center">
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>Date of Issue</b>
									</font>
								</td>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>Employee Name</b>
									</font>
								</td>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>Employer Reference</b>
									</font>
								</td>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>National Insurance Number</b>
									</font>
								</td>
								<td width="20%">
									<font face="Tahoma" size="2">
										<b>Works / Payroll Number</b>
									</font>
								</td>
								<td width="22%">
									<font face="Tahoma" size="2">
										<b>Effective Date</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>TaxCode</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Previous Pay</b>
									</font>
								</td>
								<td>
									<font face="Tahoma" size="2">
										<b>Previous Tax</b>
									</font>
								</td>
							</tr>
							<xsl:for-each select="/dps:DPSdata/p6:CodingNoticesP6P6B/p6:NINO">
								<xsl:sort select="." order="ascending" data-type="text"/>
								<xsl:if test="../@FormType='P6B'">
									<tr align="center">
										<td>
											<xsl:value-of select="substring(../@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(../@IssueDate, 1, 4)"/>
										</td>
										<td width="18%">
											<xsl:value-of select="concat(../p6:Name/p6:Forename[1], ' ', ../p6:Name/p6:Surname)"/>
										</td>
										<td width="18%">
											<xsl:value-of select="../p6:EmployerRef"/>
										</td>
										<td width="18%">
											<xsl:value-of select="../p6:NINO"/>
										</td>
										<td width="18%">
											<xsl:value-of select="../p6:WorksNumber"/>
										</td>
										<td nowrap="true">
											<xsl:value-of select="substring(../p6:EffectiveDate, 9, 2)"/>-<xsl:value-of select="substring(../p6:EffectiveDate, 6, 2)"/>-<xsl:value-of select="substring(../p6:EffectiveDate, 1, 4)"/>
										</td>
										<td>
											<xsl:choose>
												<xsl:when test="../p6:CodingUpdate/p6:TaxCode/@Week1Month1Indicator='X'">
													<xsl:value-of select="concat(../p6:CodingUpdate/p6:TaxCode, ' ', 'W1/M1')"/>
												</xsl:when>
												<xsl:otherwise>
													<xsl:value-of select="../p6:CodingUpdate/p6:TaxCode"/>
												</xsl:otherwise>
											</xsl:choose>
										</td>
										<xsl:choose>
											<xsl:when test="../p6:CodingUpdate/p6:TotalPreviousPay > 0">
												<td>
													<xsl:value-of select="round(../p6:CodingUpdate/p6:TotalPreviousPay)"/>
												</td>
											</xsl:when>
											<xsl:otherwise>
												<td>&#160;</td>
											</xsl:otherwise>
										</xsl:choose>
										<td>
											<xsl:value-of select="../p6:CodingUpdate/p6:TotalPreviousTax"/>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>
						</table>
						<br/>
					</xsl:if>
				</xsl:if>
				<table width="99%" border="0">
					<tr>
						<td>
							<font face="Tahoma" size="2">
								<b>End of List</b>
							</font>
						</td>
						<td>
							<div align="right">
								<a href="javascript:window.close()">
									<b>
										<font size="2" face="Tahoma">Close Window</font>
									</b>
								</a>
							</div>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
