<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance" xmlns:dps="http://www.govtalk.gov.uk/taxation/DPSwrapper/1" xmlns:p11db="http://www.govtalk.gov.uk/taxation/P11DbNotif/2" xmlns:p35="http://www.govtalk.gov.uk/taxation/P35Notif/2" xmlns:incentive="http://www.govtalk.gov.uk/taxation/Incentive/2">
    <xsl:import href='dps_variables.xsl'/>
    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:variable name="FBIGGISVersion">
 /**
 *
 * Program Name:            notifications_dps_stylesheets_2006.xsl 
 *
 * Description:             Outgoing Forms - rendering stylesheet for Notifications: P11Db, P35, ILEA, ILEB, ILEC, ILED
 *
 * Amendment History:
 *
 * Date       Author        Release   Description
 * 18/01/2006 J Head        56RJ      2006 version created for 56RJ project (re-writing secure mail).
 * 02/02/2006 J Head:       All DPS form stylesheets now import another stylesheet, dps_variables.xsl. Variables that may change between
 *                          environments, such as image and help page URIs and URLs, are set in dps_variables.xsl and referenced
 *                          in the DPS form stylesheets. This facilitates making the stylesheets environment specific without the need to
 *                          change hard coded variables in each and every DPS stylesheet as only dps_variables.xsl needs to be changed.
 * 05/02/2007 S Chinabu   56RJ      P35 Notice text modified as per the change request - CR50.
 * 06/02/2007 S Chinabu   56RJ      Modified the logic to display Employer Name for P35.
 * 07/02/2007 S Chinabu   56RJ      Removed the duplicate Employer's Paye reference and Tax Year from P35.
 * 13/11/2007 D Patel	    CR 07/08-116 Changes to DPS Proxy stylesheets re forms SL2, ILEA, ILEB, ILEC, ILED, AR2MN
 *				1. Account office numbers are updated.
 * 13/11/2007 D Patel	    Fix for EARS00007217424:Incentive Letter Shows Wrong Dates. (Tax years)
 * 08/08/2008 D Patel		CR 08/09-025 - Text rewriting, AR1N, AR2N, AR1MN, AR2MN, AR6.
 * 11/08/2008 S Marni	CR 08/09-025 - Modified the Year formats.
*/
    </xsl:variable>
	<xsl:template match="/">
		<html>
			<head>
				<META http-equiv="Content-Type" content="text/html"/>
				<title>Notifications</title>
				<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			</head>
			<body bgcolor="#FFFFFF">
				<!--START: P11DB Section-->
				<xsl:for-each select="/dps:DPSdata/p11db:P11DbNotif">
					<table width="95%" border="0">
						<tr>
							<td valign="top">
								<xsl:element name="img">
									<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
									<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
								</xsl:element>
							</td>
							<td colspan="5" valign="top">
								<div align="right">
									<b>
										<i>
											<font size="5"/>
											<font size="5">Return
        of Class 1A National Insurance contributions due<br/>
        Return of expenses and benefits for <xsl:value-of select="./@TaxYearEnd"/>
											</font>
										</i>
									</b>
								</div>
							</td>
						</tr>
						<tr>
							<td width="15%">&#160;</td>
							<td width="06%">&#160;</td>
							<td width="24%">&#160;</td>
							<td width="15%">&#160;</td>
							<td width="15%">&#160;</td>
							<td width="15%">&#160;</td>
						</tr>
						<tr>
							<td colspan="5">
								<div align="right">
									<font face="Tahoma" size="2">
										<b>Date of Issue</b>
									</font>
								</div>
							</td>
							<td colspan="1" style="margin-left:2px">
								<xsl:value-of select="substring(./@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 1, 4)"/>
							</td>
						</tr>
						<tr> 
							<td colspan="4" valign="top">
								<table width="100%" border="0" name="AddressTable">
									<xsl:if test="not(./p11db:EmployerDetails/p11db:AgentDetails/p11db:Address/p11db:Line[1])">
										<tr>
											<td>
												<xsl:value-of select="./p11db:EmployerDetails/p11db:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./p11db:EmployerDetails/p11db:Address/p11db:Line">
											<tr>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td>
												<xsl:value-of select="./p11db:EmployerDetails/p11db:Address/p11db:PostCode"/>
											</td>
										</tr>
										<tr>
											<td>
												<xsl:value-of select="./p11db:EmployerDetails/p11db:Address/p11db:Country"/>
											</td>
										</tr>
										<tr>
											<td>&#160;</td>
										</tr>
									</xsl:if>
									<xsl:if test="./p11db:EmployerDetails/p11db:AgentDetails/p11db:Address/p11db:Line[1]">
										<tr>
											<td>
												<xsl:value-of select="./p11db:EmployerDetails/p11db:AgentDetails/p11db:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./p11db:EmployerDetails/p11db:AgentDetails/p11db:Address/p11db:Line">
											<tr>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
										<tr>
											<td>
												<xsl:value-of select="./p11db:EmployerDetails/p11db:AgentDetails/p11db:Address/p11db:PostCode"/>
											</td>
										</tr>
										<tr>
											<td>
												<xsl:value-of select="./p11db:EmployerDetails/p11db:AgentDetails/p11db:Address/p11db:Country"/>
											</td>
										</tr>
										<tr>
											<td>&#160;</td>
										</tr>
									</xsl:if>
								</table>
							</td>
							<td colspan="2" valign="top" height="4">
								<div align="right">
									<font face="Tahoma" size="2"/>
								</div>
								<table width="100%" border="0" name="IssuingAddressTable">
									<tr>
										<td height="23" valign="top" width="53%">
											<div align="right" style="margin-right:2px">
												<font face="Tahoma" size="2">
													<b>Issued By</b>
												</font>
											</div>
										</td>
										<td height="23" width="47%">
											<xsl:value-of select="./p11db:EmployerDetails/p11db:HMRCoffice/p11db:Name"/>
										</td>
									</tr>
									<xsl:for-each select="./p11db:EmployerDetails/p11db:HMRCoffice/p11db:Address/p11db:Line">
										<tr>
											<td>&#160;</td>
											<td>
												<xsl:value-of select="."/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td>&#160;</td>
										<td>
											<xsl:value-of select="./p11db:EmployerDetails/p11db:HMRCoffice/p11db:Address/p11db:PostCode"/>
										</td>
									</tr>
									<tr>
										<td height="23" valign="top">
											<div align="right" style="margin-right:2px">
												<font face="Tahoma" size="2">
													<b>Tax Office Number</b>
												</font>
											</div>
										</td>
										<td height="23">
											<xsl:value-of select="./p11db:EmployerDetails/p11db:HMRCoffice/p11db:Number"/> / <xsl:value-of select="./p11db:EmployerDetails/p11db:HMRCoffice/p11db:Reference"/>
										</td>
									</tr>
								</table>
							</td>
						</tr>
						<tr>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
						</tr>
						<tr>
							<td height="22" colspan="2">
								<div align="left">
									<b>
										<font face="Tahoma" size="2">
											<b>Employer Reference</b>
										</font>
									</b>
								</div>
							</td>
							<td height="22" colspan="4">
								<xsl:value-of select="./p11db:EmployerDetails/p11db:EmployerRef"/>
							</td>
						</tr>
						<tr>
							<td  height="25" colspan="2">
								<div align="left">
									<b>
										<font face="Tahoma" size="2">
											<b>Inland Revenue office
        telephone no. </b>
										</font>
									</b>
								</div>
							</td>
							<td height="25">
								<xsl:value-of select="./p11db:EmployerDetails/p11db:HMRCoffice/p11db:Telephone/p11db:Number"/>
							</td>
							<td height="25" colspan="2">
								<div align="right">
									<b>
										<font face="Tahoma" size="2">Accounts Office reference</font>
									</b>
								</div>
							</td>
							<td height="25">
								<xsl:value-of select="./p11db:EmployerDetails/p11db:AORef"/>
							</td>
						</tr>
						<tr>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<hr width="95%" align="center"/>
							</td>
						</tr>
						<tr>
							<td colspan="6" valign="top">
								<b>
									<font face="Tahoma" size="4">Employer's Notification to Complete a Return
      of Class 1A National Insurance contributions and expenses and benefits forms
      P11D</font>
								</b>
							</td>
						</tr>
						<tr>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
						</tr>
					</table>
					<table width="95%" border="0">
						<tr>
							<td colspan="6">
								<p>According to my records you did not use our paper Return of Class 1A
        National Insurance contributions and expenses and benefits last year.
        Instead you sent your return over the Internet. I assume you wish to do
        so again, so this year I am not sending you a paper Return of Class 1A
        National Insurance contributions and expenses and benefits. Instead I
        am sending you this Notification. This Notification is to advise that you are
        required by law to send me a PAYE Annual Tax Return for the year ending
        5 April <xsl:value-of select="./@TaxYearEnd"/>. </p>
								<p>You can do this by using one of the following methods: </p>
							</td>
						</tr>
						<tr>
							<td colspan="6" height="42">
								<ul>
									<li>our Inland Revenue Online Service for P11D(b) Return of Class 1A National Insurance
          contributions and expenses and benefits </li>
									<li>an approved substitute Inland Revenue Online Service Return of Class 1A National
          Insurance contributions and expenses and benefits. </li>
								</ul>
							</td>
						</tr>
						<tr>
							<td colspan="6">
								<xsl:element name="a">
									<xsl:attribute name="href"><xsl:value-of select="$p11d_notes_htm_URI"/></xsl:attribute>
									Click here</xsl:element>
								for more information
      on these methods, and where to go if you need help. Alternatively you may
      use our paper P11D(b) Return. If you decide to do this please telephone
      the above number and we will arrange to send you one. </td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<font face="Tahoma" size="3">
									<b>When to send your return</b>
								</font>
							</td>
						</tr>
						<tr>
							<td colspan="6">Make sure your Return <i>(including enclosures)</i> reaches
      me by 6 July <xsl:value-of select="./@TaxYearEnd"/>. Penalties are chargeable where a Return is late.</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<hr width="95%" align="center"/>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
					</table>
				</xsl:for-each>
				<!--END: P11DB Section-->
				<!--START: P35 Section-->
				<xsl:for-each select="/dps:DPSdata/p35:P35Notif">
					<table width="93%" border="0">
					
						<tr valign="top">
							<td >
								<xsl:element name="img">
									<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
									<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
								</xsl:element>
							</td>
							<td colspan="5" valign="top" >
								<div align="right">
									<b>
										<i>
											<font size="5"> </font>
											<font size="5">P35 - Employer's Annual Return for <xsl:value-of select="substring(./@TaxYearEnd, 1, 4)"/>
											</font>
										</i>
									</b>
								</div>
							</td>
						</tr>
						<tr>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
						</tr>
						<tr>
							<td colspan="3" valign="top">
								<table width="100%" border="0" name="AddressTable">
									<!-- xsl:if test="not(./p35:EmployerDetails/p35:Address/p35:Line[1])" -->
									<xsl:if test="not(./p35:EmployerDetails/p35:AgentDetails)">
										<tr>
											<td>
												<xsl:value-of select="./p35:EmployerDetails/p35:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./p35:EmployerDetails/p35:Address/p35:Line">
											<tr>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
									</xsl:if>
									<xsl:if test="./p35:EmployerDetails/p35:AgentDetails">
										<tr>
											<td>
												<xsl:value-of select="./p35:EmployerDetails/p35:AgentDetails/p35:Name"/>
											</td>
										</tr>
										<xsl:for-each select="./p35:EmployerDetails/p35:AgentDetails/p35:Address/p35:Line">
											<tr>
												<td>
													<xsl:value-of select="."/>
												</td>
											</tr>
										</xsl:for-each>
									</xsl:if>
									<tr>
										<td>
											<xsl:value-of select="./p35:EmployerDetails/p35:AgentDetails/p35:Address/p35:PostCode"/>
										</td>
									</tr>
									<tr>
										<td>
											<xsl:value-of select="./p35:EmployerDetails/p35:AgentDetails/p35:Address/p35:Country"/>
										</td>
									</tr>
								</table>
							</td>
							<td colspan="3" valign="top" align="right">
								<div align="right">
									<font face="Tahoma" size="2"> </font>
								</div>
								<table width="100%" border="0" name="IssuingAddressTable">
									<tr>
										<td >
											<div align="right" style="margin-right:2px">
												<font face="Tahoma" size="2">
													<b>Date of Issue</b>
												</font>
											</div>
										</td>
										<td  width="29%">
											<xsl:value-of select="substring(./@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 1, 4)"/>
										</td>
									</tr>								
									<tr>
										<td valign="top" width="47%">
											<div align="right" style="margin-right:2px">
												<font face="Tahoma" size="2">
													<b>Issued By</b>
												</font>
											</div>
										</td>
										<td width="53%">
											<xsl:value-of select="./p35:EmployerDetails/p35:HMRCoffice/p35:Name"/>
										</td>
									</tr>
									<xsl:for-each select="./p35:EmployerDetails/p35:HMRCoffice/p35:Address/p35:Line">
										<tr>
											<td width="47%">&#160;</td>
											<td>
												<xsl:value-of select="."/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td width="47%">&#160;</td>
										<td width="53%">
											<xsl:value-of select="./p35:EmployerDetails/p35:HMRCoffice/p35:Address/p35:PostCode"/>
										</td>
									</tr>
									<tr>
										<td width="47%">&#160;</td>
										<td width="53%">
											<xsl:value-of select="./p35:EmployerDetails/p35:HMRCoffice/p35:Address/p35:Country"/>
										</td>
									</tr>
								</table>
							</td>
						</tr>						
						<tr>
							<td >
								<div align="left">
									<b>
										<font face="Tahoma" size="2">
										<xsl:if test="./p35:EmployerDetails/p35:AgentDetails">
											<b>Employer's Name</b>
										</xsl:if>
										</font>
									</b>
								</div>
							</td>
							<td >
								<xsl:if test="./p35:EmployerDetails/p35:AgentDetails">
									<xsl:value-of select="./p35:EmployerDetails/p35:Name"/>
								</xsl:if>
							</td>
							<td colspan="4" >&#160;</td>
						</tr>
						<tr>
							<td>
								<div align="left">
									<b>
										<font face="Tahoma" size="2">
											<b>Employer's PAYE reference</b>
										</font>
									</b>
								</div>
							</td>
							<td colspan="1">
								<xsl:value-of select="./p35:EmployerDetails/p35:EmployerRef"/>
							</td>
							<td colspan="4">&#160;</td>
						</tr>
						<tr>
							<td >
								<div align="left">
									<b>
										<font face="Tahoma" size="2">
											<b>HMRC office telephone no. </b>
										</font>
									</b>
								</div>
							</td>
							<td colspan="1">
								<xsl:value-of select="./p35:EmployerDetails/p35:HMRCoffice/p35:Telephone/p35:Number"/>
							</td>
							<td colspan="3">
								<div align="right" style="margin-right:2px">
									<b>
										<font face="Tahoma" size="2">Accounts Office reference</font>
									</b>
								</div>
							</td>
							<td>
								<xsl:value-of select="./p35:EmployerDetails/p35:AORef"/>
							</td>
						</tr>
						<tr>
							<td colspan="6" valign="top">&#160;</td>
						</tr>
						<tr>
							<td colspan="6" valign="top">
								<hr  align="center"/>
							</td>
						</tr>
						
						<tr>
							<td colspan="6">
								<b>
									<font face="Tahoma" size="4">Employer Notification to complete a P35 - Employer's Annual Return</font>
								</b>
							</td>							
						</tr>
						<tr>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
							<td valign="top">&#160;</td>
						</tr>						
					</table>
					<table width="93%" border="0">
						<tr>
							<td colspan="6" height="0">
								Employer Notification to complete a P35 - Employer's Annual Return
							</td>							
						</tr>					
						<tr>
							<td colspan="6">
							<P>According to my records you did not use our paper P35 last year, sending your return online instead. As a result, we are not sending you a paper P35 this year.</P>
							</td>
						</tr>
						<tr>
							<td colspan="6">
								<p>This Notification is to advise you that you are required by law to send me a P35 along with a P14 for each employee for whom you were required to complete a P11 Deductions Working Sheet (or equivalent record) during the year ending 5 April <xsl:value-of select="substring(./@TaxYearEnd, 1, 4)"/>. </p>
								<p>You can do this by using one of the following methods:</p>
							</td>
						</tr>
						<tr>
							<td colspan="6" height="5">
								<ul>
									<li>our HMRC PAYE Online Service for Employers</li>
									<li>an approved substitute HMRC PAYE Online Service</li>
								</ul>
							</td>
						</tr>
						<tr>
							<td colspan="6" height="5">
							Further information is available on our website.
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<font size="3">
									<b>
										<font face="Tahoma">When to send your return</font>
									</b>
								</font>
							</td>
						</tr>
						<tr>
							<td colspan="6" height="5">
Make sure your P35 and P14s reach us by 19 May <xsl:value-of select="substring(./@TaxYearEnd, 1, 4)"/>.<br/>
Penalties are chargeable where any part of your return is received late
							</td>
						</tr>						
						<tr>
							<td colspan="6" height="5">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<font size="3">
									<b>
										<font face="Tahoma">If you do not have to make a return</font>
									</b>
								</font>
							</td>
						</tr>
						<tr>
						    <td colspan="6">Where you do not need to make a return, you must tell us. You will have to contact your HMRC office to say no return is needed. This will ensure we do not issue a penalty notice to you for not filing your return. You cannot tell us this online.</td>							
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">
								<hr  align="center"/>
							</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
						<tr>
							<td colspan="6">&#160;</td>
						</tr>
					</table>
				</xsl:for-each>
				<!--END: P35 Section-->
				<!--START: Incentive Letter Section-->
				<xsl:for-each select="/dps:DPSdata/incentive:IncentiveLetter">
					<xsl:variable name="OfficeCode">
						<xsl:choose>
							<xsl:when test="./@FormType = 'ILEA' or
./@FormType = 'ILEB'">Shipley</xsl:when>
							<xsl:when test="./@FormType = 'ILEC' or
./@FormType = 'ILED'">C</xsl:when>
							<xsl:otherwise/>
						</xsl:choose>
					</xsl:variable>
					<table class="mainDetails" width="95%" cellpadding="0" cellspacing="0">
						<tr valign="top">
							<td style="width:50%">
								<!-- START OF
RECIPIENT DETAILS TABLE -->
								<table class="recipientDetails" border="0" width="100%">
									<tr>
										<td>
											<xsl:element name="img">
												<xsl:attribute name="alt">HMRC Logo</xsl:attribute>
												<xsl:attribute name="src"><xsl:value-of select="$hmrc_logo_image_URI"/></xsl:attribute>
											</xsl:element>
										</td>
									</tr>
									<xsl:for-each select="./incentive:EmployerDetails/incentive:Name">
										<tr>
											<td class="employerNameAddress">
												<xsl:value-of select="."/>
											</td>
										</tr>
									</xsl:for-each>
									<xsl:for-each select="./incentive:EmployerDetails/incentive:Address/incentive:Line">
										<tr>
											<td class="employerNameAddress">
												<xsl:value-of select="."/>
											</td>
										</tr>
									</xsl:for-each>
									<tr>
										<td class="employerNameAddress">
											<xsl:choose>
												<xsl:when test="./incentive:EmployerDetails/incentive:Address/incentive:PostCode">
													<xsl:value-of select="./incentive:EmployerDetails/incentive:Address/incentive:PostCode"/>
												</xsl:when>
												<xsl:otherwise>&#160;</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
									<!-- start 1
blank row -->
									<tr>
										<td>&#160;</td>
									</tr>
									<!-- end 1
blank row -->
									<!-- when
there is NOT a second line of Business name info, put a blank row before the
first line -->
									<xsl:if test="not(./incentive:EmployerDetails/incentive:BusinessName2)">
										<tr>
											<td>&#160;</td>
										</tr>
									</xsl:if>
									<!-- if
there is no business name 1 then print a blank row -->
									<tr>
										<td>
											<xsl:choose>
												<xsl:when test="./incentive:EmployerDetails/incentive:BusinessName1">
													<xsl:value-of select="./incentive:EmployerDetails/incentive:BusinessName1"/>
												</xsl:when>
												<xsl:otherwise>&#160;</xsl:otherwise>
											</xsl:choose>
										</td>
									</tr>
									<!-- only
print a row if there is business name 2 -->
									<xsl:if test="./incentive:EmployerDetails/incentive:BusinessName2">
										<tr>
											<td>
												<xsl:value-of select="./incentive:EmployerDetails/incentive:BusinessName2"/>
											</td>
										</tr>
									</xsl:if>
									<tr>
										<td>&#160;</td>
									</tr>
									<tr>
										<td>
											<span>
												<b>Date</b>
											</span>&#160;<xsl:value-of select="substring(./@IssueDate, 9, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 6, 2)"/>-<xsl:value-of select="substring(./@IssueDate, 1, 4)"/>
										</td>
									</tr>
									<tr>
										<td>
											<span>
												<b>Accounts&#160;Office&#160;Reference</b>
											</span>&#160;<xsl:value-of select="./incentive:EmployerDetails/incentive:PAYERef"/>
										</td>
									</tr>
								</table>
								<!-- END OF
RECIPIENT DETAILS TABLE -->
							</td>
							<!-- end of first cell in
main details table -->
							<!-- start of second cell in
main details table -->
							<td align="right">
								<!-- START OF SENDER DETAILS TABLE -->
								<table class="senderDetails" border="0">
									<tr>
										<td colspan="2" class="pageHeading" align="left">
											<xsl:element name="img">
												<xsl:attribute name="alt">Online Filing tax-free payment</xsl:attribute>
												<xsl:attribute name="src"><xsl:value-of select="$online_filing_image_URI"/></xsl:attribute>
											</xsl:element>
										</td>
									</tr>
									<xsl:call-template name="accountsOfficeDetails">
										<xsl:with-param name="office" select="$OfficeCode"/>
									</xsl:call-template>
								</table>
								<!-- END OF SENDER
DETAILS TABLE -->
							</td>
						</tr>
					</table>
					<!-- END MAIN DETAILS TABLE -->
					<!-- START MAIN CONTENT TABLE -->
					<table class="mainContent" width="95%" border="0">
						<!-- start blank rows separating
details from main content -->
						<!--<xsl:if
test="($shipCeasedEmployer or $cumbCeasedEmployer)">-->
						<xsl:variable name="firstTaxYear" select="number(./@FirstTaxYear)"/>
						<xsl:variable name="secondTaxYear" select="number(./@SecondTaxYear)"/>
						<xsl:variable name="taxYearRange" select="concat((number($firstTaxYear)-1), '-', substring($firstTaxYear, 3, 2) )"/>
						<xsl:variable name="nextTaxYearRange" select="concat((number($secondTaxYear)-1), '/', substring($secondTaxYear, 3, 2) )"/>
						<xsl:if test="./@FormType = 'ILEB' or ./@FormType = 'ILED'">
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<th align="left" class="mainContentHeader">&#163;<xsl:value-of select="format-number(number(./incentive:IncentiveAmount), '#.00')"/> for
online filing - tax year <xsl:value-of select="translate($taxYearRange, '-',
'-')"/>
								</th>
							</tr>
							<!-- blank line follows -->
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>Thank you for sending us your&#160;<xsl:value-of select="$taxYearRange"/>&#160;Employer Annual Return. Because you sent this online, we have added a tax-free payment award of &#163;<xsl:value-of select="format-number(number(./incentive:IncentiveAmount),'#.00')"/> to your PAYE payment record.
                                 </td>
							</tr>
							<!-- blank line follows -->
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>
									Our records show that you stopped being an employer during the <xsl:value-of select="$nextTaxYearRange"/> tax year. Provided that you have sent us all your PAYE Employer Annual Returns, we will arrange to pay you the balance of the tax-free payment after taking off anything you owe.
								</td>
							</tr>
							<!-- blank line follows -->
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>
									Because of the large number of cases we have, we may not be able to send you a cheque as quickly as we would wish.
								</td>
							</tr>
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>
									The tax-free payment is not taxable. Do not include it in the taxable income for your business. For accounting and tax purposes
								</td>
							</tr>

							<tr>
								<td><br/>
									<p><li>
										the PAYE payments shown in the company accounts should not be reduced by this tax-free payment, and
										</li></p>
									<p><li>this payment does not have to be included in your VAT returns.
									</li></p>
								</td>
							</tr>
						</xsl:if>
						<!--<xsl:if
test="($cumbStillEmployer or $shipStillEmployer)">-->
						<xsl:if test="./@FormType = 'ILEA' or ./@FormType = 'ILEC'">
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<th align="left" class="mainContentHeader">&#163;<xsl:value-of select="format-number(number(./incentive:IncentiveAmount), '#.00')"/> for
online filing - tax year <xsl:value-of select="translate($taxYearRange, '-',
'-')"/></th>
							</tr>
							<!-- blank line follows -->
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>Thank you for sending us your&#160;<xsl:value-of select="$taxYearRange"/>&#160;Employer Annual Return. Because you sent this online, we have added a tax-free payment award of &#163;<xsl:value-of select="format-number(number(./incentive:IncentiveAmount),'#.00')"/>&#160;to your PAYE payment record.  Please deduct this amount from your next PAYE payment for the current tax year.
                                </td>
							</tr>
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>
									If this results in no payment being due, you must advise your Accounts Office, so that we can stop any unnecessary reminders. 
									Please see 
									<strong>
									<xsl:element name="a">
	 								<xsl:attribute name="href"><xsl:value-of select="$hmrc_paye_nil_URL"/></xsl:attribute>
									<xsl:value-of select="substring($hmrc_paye_nil_URL, 8)"/></xsl:element>
									</strong>																		
								</td>
							</tr>
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>
									You can request the tax-free payment to be paid to you direct, but only if you
								</td>
							</tr>
							<tr>
								<td><br/>
									 <ul>
											<p><li>have sent us all your PAYE Employer Annual Returns. If you have not, please send the Returns to us now.
											</li></p>
											<p><li>are up to date with your PAYE payments. If you are not, we will take off anything you owe before paying the balance to you.
											</li></p>
									</ul>
								</td>
							</tr>
							<tr>
								<td>
									 If you would like us to send you a cheque, 
									 please use our email service at 
									 <strong>
									<xsl:element name="a">
	 								<xsl:attribute name="href"><xsl:value-of select="$sending_paye_online_URL"/></xsl:attribute>
									<xsl:value-of select="substring($sending_paye_online_URL, 8)"/></xsl:element>
									</strong> 
									 Or write to us at the office shown above. Because of the large number of requests we have, we may not be able to send you a cheque as quickly as we would wish.
								</td>
							</tr>
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>&#160;</td>
							</tr>
							<tr>
								<td>The tax-free payment is not taxable. Do not include it in the taxable income for your business.  For accounting and tax purposes
								</td>
							</tr>
							<tr>
								<td><br/>
									 <ul>
											<p><li>the PAYE payments shown in the company accounts should not be reduced by this tax-free payment, and
											</li></p>
											<p><li>this payment does not have to be included in your VAT returns.
											</li></p>
									</ul>
								</td>
							</tr>
							<tr>
								<td>
									For more information about online filing and tax-free payments, please go to
									<strong>
									<xsl:element name="a">
	 								<xsl:attribute name="href"><xsl:value-of select="$sending_paye_online_URL"/></xsl:attribute>
									<xsl:value-of select="substring($sending_paye_online_URL, 8)"/></xsl:element>
									</strong>
								</td>
							</tr>							
						</xsl:if>
						<tr>
							<td>&#160;</td>
						</tr>
						<tr>
							<td>&#160;</td>
						</tr>
						<tr>
							<td>
								<hr width="97%" align="center"/>
							</td>
						</tr>
						<tr>
							<td>&#160;</td>
						</tr>
					</table>
				</xsl:for-each>
				<!--END: Incentive Letter Section-->
				<!-- END MAIN CONTENT TABLE -->
				<table width="100%" border="0">
					<tr align="right">
						<td colspan="6" align="right">
							<div align="right">
								<a style="text-decoration: none" href="javascript:window.close()">
									<b>
										<font size="2" face="Tahoma">Close
        Window</font>
									</b>
								</a>
							</div>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<!--START: Extra Template For Incentive Letter Section-->
	<xsl:template name="accountsOfficeDetails">
		<xsl:param name="office"/>
		<!-- assume all offices called 'Collector of Taxes' -->
		<tr align="left">
			<td colspan="2">Issued by</td>
		</tr>
		<tr align="left">
			<td colspan="2">Collector of Taxes</td>
		</tr>
		<xsl:choose>
			<!-- START CUMBERNAULD DETAILS -->
			<xsl:when test="$office = 'C'">
				<tr align="left">
					<td colspan="2">Accounts Office
Cumbernauld</td>
				</tr>
				<tr align="left">
					<td colspan="2">Cumbernauld</td>
				</tr>
				<tr align="left">
					<td colspan="2">GLASGOW G67 1YZ</td>
				</tr>
				<tr>
					<td colspan="2">&#160;</td>
				</tr>
				<tr>
					<td colspan="2">&#160;</td>
				</tr>
				<tr align="left" valign="top">
					<td class="label">Telephone</td>
					<td>0845 3667816</td>
				</tr>
			</xsl:when>
			<!-- END CUMBERNAULD DETAILS -->
			<!-- START SHIPLEY DETAILS -->
			<xsl:when test="$office = 'Shipley'">
				<tr align="left">
					<td colspan="2">Accounts Office
Shipley</td>
				</tr>
				<tr align="left">
					<td colspan="2">BRADFORD</td>
				</tr>
				<tr align="left">
					<td colspan="2">West Yorkshire BD98
8AA</td>
				</tr>
				<tr>
					<td colspan="2">&#160;</td>
				</tr>
				<tr>
					<td colspan="2">&#160;</td>
				</tr>
				<tr align="left" valign="top">
					<td>
						<b>Telephone</b>
					</td>
					<td>0845 3667816</td>
				</tr>
			</xsl:when>
			<!-- END SHIPLEY DETAILS -->
		</xsl:choose>
		<!-- assume all opening hours are the same -->
		<tr align="left" valign="top">
			<td>
				<b>Opening&#160;hours</b></td>
			<td>&#160;</td>
		</tr>
		<tr>
			<td colspan="2">
			Monday&#160;to&#160;Friday 08:00 - 20:00 <br/>
			Saturday 08:00 - 16:00
			</td>
		</tr>
		<!-- blank row -->
		<tr>
			<td colspan="2">&#160;</td>
		</tr>
		<tr align="left">
			<td colspan="2">
				<strong>
					<xsl:element name="a">
						<xsl:attribute name="href"><xsl:value-of select="$hmrc_online_URL"/></xsl:attribute>
						<xsl:value-of select="substring($hmrc_online_URL, 8)"/></xsl:element>
				</strong>
			</td>
		</tr>
	</xsl:template>
	<!--END: Extra Template For Incentive Letter Section-->
</xsl:stylesheet>
