/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WeakCollection<MemberType>
implements Collection<MemberType> {
    ReferenceQueue<Object> garbageQueue = new ReferenceQueue();
    Set<CallBackReference<MemberType>> set = new HashSet<CallBackReference<MemberType>>();

    private void cleanup() {
        Reference<Object> reference;
        while ((reference = this.garbageQueue.poll()) != null) {
            this.set.remove(reference);
        }
    }

    @Override
    public int size() {
        this.cleanup();
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        this.cleanup();
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.cleanup();
        return this.set.contains(new CallBackReference<Object>(o, this.garbageQueue));
    }

    @Override
    public Iterator<MemberType> iterator() {
        this.cleanup();
        return new Iterator<MemberType>(){
            Iterator<CallBackReference<MemberType>> it;
            MemberType head;
            {
                this.it = new HashSet(WeakCollection.this.set).iterator();
                this.head = this.nextHead();
            }

            @Override
            public boolean hasNext() {
                return this.head != null;
            }

            @Override
            public MemberType next() {
                try {
                    Object MemberType = this.head;
                    return MemberType;
                }
                finally {
                    this.head = this.nextHead();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private MemberType nextHead() {
                Object result = null;
                while (result == null && this.it.hasNext()) {
                    result = this.it.next().get();
                }
                return result;
            }
        };
    }

    @Override
    public Object[] toArray() {
        this.cleanup();
        return this.toArray(new Object[this.set.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.cleanup();
        ArrayList<MemberType> list = new ArrayList<MemberType>(this.set.size());
        for (MemberType member : this) {
            list.add(member);
        }
        return list.toArray(a);
    }

    @Override
    public boolean add(MemberType member) {
        this.cleanup();
        return this.set.add(new CallBackReference<Object>(member, this.garbageQueue));
    }

    @Override
    public boolean remove(Object o) {
        this.cleanup();
        return this.set.remove(new CallBackReference<Object>(o, this.garbageQueue));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.cleanup();
        ArrayList<CallBackReference<Object>> list = new ArrayList<CallBackReference<Object>>(c.size());
        for (Object o : c) {
            list.add(new CallBackReference<Object>(o, this.garbageQueue));
        }
        return this.set.containsAll(list);
    }

    @Override
    public boolean addAll(Collection<? extends MemberType> c) {
        this.cleanup();
        boolean result = false;
        for (MemberType member : c) {
            if (!this.add(member)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.cleanup();
        boolean result = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            result = true;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.cleanup();
        ArrayList<CallBackReference<Object>> list = new ArrayList<CallBackReference<Object>>(c.size());
        for (Object o : c) {
            list.add(new CallBackReference<Object>(o, this.garbageQueue));
        }
        return this.set.retainAll(list);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    static class CallBackReference<MemberType>
    extends WeakReference<MemberType> {
        int hashCode;

        public CallBackReference(MemberType member, ReferenceQueue<? super MemberType> referenceQueue) {
            super(member, referenceQueue);
            this.hashCode = member.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CallBackReference) {
                CallBackReference other = (CallBackReference)obj;
                return other.get() == this.get();
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

