/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.util;

import com.selima.help.util.LineAndColumnNumberReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public abstract class HTMLParserHelper {
    protected WrongHTMLException parseException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse(HTMLParserTemplatePlugin callback, InputStream in) throws IOException {
        this.parseException = null;
        try (LineAndColumnNumberReader reader = new LineAndColumnNumberReader(new InputStreamReader(in, "UTF-8"));){
            new ParserDelegator().parse(reader, new ContentHandler(callback, reader), false);
        }
        if (this.parseException != null) {
            IOException e = new IOException(this.parseException.getMessage());
            e.initCause(this.parseException);
            throw e;
        }
    }

    protected static AttributeSet produceInsensitiveAttributeSet(AttributeSet set) {
        return (AttributeSet)Proxy.newProxyInstance(HTMLParserHelper.class.getClassLoader(), new Class[]{MutableAttributeSet.class}, (InvocationHandler)new InsensitiveAttributeHandler(set));
    }

    public class WrongHTMLException
    extends RuntimeException {
        WrongHTMLException(IOException e, String place, int line, int col) {
            super("'" + e.getMessage() + "' near '" + place + "' line:" + line + " col:" + col);
            this.setStackTrace(e.getStackTrace());
            HTMLParserHelper.this.parseException = this;
        }
    }

    public class ContentHandler
    extends HTMLEditorKit.ParserCallback {
        LineAndColumnNumberReader reader;
        HTMLParserTemplatePlugin templateBuilder;

        ContentHandler(HTMLParserTemplatePlugin templateBuilder, LineAndColumnNumberReader reader) {
            this.templateBuilder = templateBuilder;
            this.reader = reader;
        }

        @Override
        public void handleSimpleTag(HTML.Tag t, MutableAttributeSet attrs, int pos) {
            boolean endTag = Boolean.parseBoolean((String)attrs.getAttribute(HTML.Attribute.ENDTAG));
            try {
                if (endTag) {
                    this.templateBuilder.endElement(t.toString());
                } else {
                    this.templateBuilder.startElement(t.toString(), HTMLParserHelper.produceInsensitiveAttributeSet(attrs), true);
                }
            }
            catch (IOException e) {
                throw new WrongHTMLException(e, endTag ? "</" + t.toString() + ">" : "<" + t.toString() + ">", this.reader.getLineNumber(), this.reader.getColumnNumber());
            }
        }

        @Override
        public void handleStartTag(HTML.Tag t, MutableAttributeSet attrs, int pos) {
            try {
                this.templateBuilder.startElement(t.toString(), HTMLParserHelper.produceInsensitiveAttributeSet(attrs), false);
            }
            catch (IOException e) {
                throw new WrongHTMLException(e, "<" + t.toString() + ">", this.reader.getLineNumber(), this.reader.getColumnNumber());
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            this.templateBuilder.characters(data);
        }

        @Override
        public void handleEndTag(HTML.Tag t, int pos) {
            try {
                this.templateBuilder.endElement(t.toString());
            }
            catch (IOException e) {
                throw new WrongHTMLException(e, "</" + t.toString() + ">", this.reader.getLineNumber(), this.reader.getColumnNumber());
            }
        }
    }

    protected static class InsensitiveAttributeHandler
    implements InvocationHandler {
        AttributeSet originalSet;

        InsensitiveAttributeHandler(AttributeSet originalSet) {
            this.originalSet = originalSet.copyAttributes();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String name = method.getName();
            if ("isDefined".equals(name) || "getAttribute".equals(method.getName()) || "containsAttribute".equals(method.getName())) {
                HTML.Attribute attr;
                if (args[0] instanceof String && (attr = HTML.getAttributeKey((String)args[0])) != null) {
                    args[0] = attr;
                }
                return method.invoke((Object)this.originalSet, args);
            }
            if ("getAttributeNames".equals(name)) {
                return new Enumeration(){
                    Enumeration original;
                    {
                        this.original = originalSet.getAttributeNames();
                    }

                    @Override
                    public boolean hasMoreElements() {
                        return this.original.hasMoreElements();
                    }

                    public Object nextElement() {
                        Object result = this.original.nextElement();
                        return result instanceof String ? result : String.valueOf(result);
                    }
                };
            }
            if ("containsAttributes".equals(name)) {
                throw new UnsupportedOperationException(name);
            }
            return method.invoke((Object)this.originalSet, args);
        }

        public String toString() {
            return this.originalSet.toString();
        }
    }

    protected static interface HTMLParserTemplatePlugin {
        public void startElement(String var1, AttributeSet var2, boolean var3) throws IOException;

        public void characters(char[] var1);

        public void endElement(String var1) throws IOException;
    }
}

