/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.ui;

import com.selima.framework.util.logging.LogAPI;
import com.sun.java.help.impl.JHelpPrintHandler;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.help.JHelpNavigator;
import javax.help.SecondaryWindow;
import javax.help.TextHelpModel;
import javax.help.WindowPresentation;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpSetListener;
import javax.help.plaf.basic.BasicHelpUI;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;

public class PatchedBasicHelpUI
extends BasicHelpUI {
    MemoryReclaimer memoryCleaner = new MemoryReclaimer();
    Set<JHelpNavigator> navigators = new HashSet<JHelpNavigator>();
    JHelpPrintHandler printHandler;

    public PatchedBasicHelpUI(JHelp help) {
        super(help);
    }

    public static ComponentUI createUI(JComponent x) {
        return new PatchedBasicHelpUI((JHelp)x);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        TextHelpModel model = this.help.getModel();
        this.help.getHistoryModel().idChanged(new HelpModelEvent((Object)model, model.getCurrentID(), model.getCurrentURL(), null, null));
        this.help.addAncestorListener((AncestorListener)this.memoryCleaner);
    }

    public void uninstallUI(JComponent c) {
        this.help.removeAncestorListener((AncestorListener)this.memoryCleaner);
        super.uninstallUI(c);
    }

    public void addNavigator(JHelpNavigator nav) {
        super.addNavigator(nav);
        this.navigators.add(nav);
    }

    public void removeNavigator(JHelpNavigator nav) {
        super.removeNavigator(nav);
        this.navigators.remove(nav);
    }

    void enableHelpSetListeners(boolean state) {
        HelpSet helpSet;
        TextHelpModel model = this.help.getModel();
        if (model != null && (helpSet = model.getHelpSet()) != null) {
            if (state) {
                helpSet.addHelpSetListener((HelpSetListener)this.help);
            } else {
                helpSet.removeHelpSetListener((HelpSetListener)this.help);
            }
            for (JHelpNavigator nav : this.navigators) {
                if (!(nav.getUI() instanceof HelpSetListener)) continue;
                if (state) {
                    helpSet.addHelpSetListener((HelpSetListener)nav.getUI());
                    continue;
                }
                helpSet.removeHelpSetListener((HelpSetListener)nav.getUI());
            }
        }
    }

    void enableJHelpPrintHandlers(boolean state) {
        Map<JHelp, JHelpPrintHandler> helpPrintHandlerMap = this.getJHelpPrintHandlerMap();
        if (helpPrintHandlerMap == null) {
            return;
        }
        if (state) {
            if (this.printHandler != null) {
                helpPrintHandlerMap.put(this.help, this.printHandler);
            }
        } else {
            this.printHandler = helpPrintHandlerMap.remove(this.help);
        }
    }

    void disableBuggyWindowListeners(Window window) {
        for (WindowListener listener : new ArrayList<WindowListener>(Arrays.asList(window.getWindowListeners()))) {
            if (!(WindowPresentation.class.getName() + "$2").equals(listener.getClass().getName())) continue;
            window.removeWindowListener(listener);
            window.addWindowListener(new StupidityProofWindowListener(listener));
        }
    }

    Map<JHelp, JHelpPrintHandler> getJHelpPrintHandlerMap() {
        try {
            Field field = JHelpPrintHandler.class.getDeclaredField("handlers");
            field.setAccessible(true);
            Map map = (Map)field.get(null);
            return map;
        }
        catch (SecurityException e) {
            LogAPI.logSevere((Throwable)e);
            LogAPI.logWarning((String)"We are going to have memory leaks");
            return new HashMap<JHelp, JHelpPrintHandler>();
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class StupidityProofWindowListener
    implements WindowListener {
        private final WindowListener listener;

        private StupidityProofWindowListener(WindowListener listener) {
            this.listener = listener;
        }

        @Override
        public void windowActivated(WindowEvent e) {
            this.listener.windowActivated(e);
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            SecondaryWindow presentation = SecondaryWindow.getPresentation((String)"Popup");
            if (presentation != null && e.getWindow() == presentation.getHelpWindow()) {
                e.getWindow().dispose();
            }
            this.listener.windowClosing(e);
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            this.listener.windowDeactivated(e);
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            this.listener.windowDeactivated(e);
        }

        @Override
        public void windowIconified(WindowEvent e) {
            this.listener.windowIconified(e);
        }

        @Override
        public void windowOpened(WindowEvent e) {
            this.listener.windowOpened(e);
        }
    }

    class MemoryReclaimer
    implements AncestorListener {
        boolean firstTime = true;

        MemoryReclaimer() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            if (!this.firstTime) {
                PatchedBasicHelpUI.this.enableHelpSetListeners(true);
                PatchedBasicHelpUI.this.enableJHelpPrintHandlers(true);
            } else {
                PatchedBasicHelpUI.this.disableBuggyWindowListeners(SwingUtilities.getWindowAncestor(event.getComponent()));
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            PatchedBasicHelpUI.this.enableJHelpPrintHandlers(false);
            PatchedBasicHelpUI.this.enableHelpSetListeners(false);
            this.firstTime = false;
        }
    }
}

