/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.ui;

import com.selima.framework.util.logging.LogAPI;
import com.selima.help.ui.HelpInitializer;
import com.selima.help.ui.PatchedBasicContentViewerUI;
import com.selima.help.ui.PatchedBasicHelpUI;
import com.sun.java.help.impl.JHelpPrintHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.HelpBroker;
import javax.help.JHelp;
import javax.help.SecondaryWindow;
import javax.help.SwingHelpUtilities;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Style;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;

public class HelpUtil {
    static final Pattern FONTSIZE_PATTERN = Pattern.compile("(\\d+)px");

    public static void enableHelp(final HelpInitializer hi, final JMenuItem item, final String helpid) {
        if (hi == null) {
            return;
        }
        hi.insertHelp(new HelpInitializer.HelpLoadedCallBack(){
            {
                item.putClientProperty("HelpInitializer.HelpLoadedCallBack", this);
            }

            @Override
            public void helpLoaded(HelpBroker broker) {
                broker.enableHelp((Component)item, helpid, broker.getHelpSet());
            }

            @Override
            public void helpFailed(Exception e) {
            }
        });
        item.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyPressed(MenuKeyEvent evt) {
                if (evt.getKeyCode() == 112) {
                    MenuElement[] path = evt.getMenuSelectionManager().getSelectedPath();
                    JMenuItem activeItem = null;
                    activeItem = path[path.length - 1] instanceof JPopupMenu ? (JMenuItem)path[path.length - 2] : (JMenuItem)path[path.length - 1];
                    if (activeItem != item) {
                        return;
                    }
                    HelpBroker broker = hi.getHelpBroker();
                    if (broker != null) {
                        broker.showID(helpid, "javax.help.SecondaryWindow", "Popup");
                    }
                }
            }

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyTyped(MenuKeyEvent evt) {
            }
        });
    }

    public static void patchHelpUI() {
        SwingHelpUtilities.setContentViewerUI((String)PatchedBasicContentViewerUI.class.getName());
        UIManager.getDefaults().put("HelpUI", PatchedBasicHelpUI.class.getName());
    }

    public static void configureFavoritesIcon(Icon favIcon, Icon addIcon) {
        UIManager.getDefaults().put("FavoritesAction.icon", favIcon);
        UIManager.getDefaults().put("FavoritesNav.icon", addIcon);
    }

    public static void uninstallHelp(HelpBroker helpBroker) {
        for (PropertyChangeListener listener : UIManager.getPropertyChangeListeners()) {
            if (!(listener instanceof SwingHelpUtilities)) continue;
            UIManager.removePropertyChangeListener(listener);
        }
        SecondaryWindow presention = SecondaryWindow.getPresentation((String)"Popup");
        if (presention != null && presention.isDisplayed()) {
            presention.setDisplayed(false);
        }
        if (helpBroker != null) {
            helpBroker.setDisplayed(false);
        }
        block6: for (Frame frame : Frame.getFrames()) {
            LinkedList<Frame> components = new LinkedList<Frame>(Collections.singleton(frame));
            while (!components.isEmpty()) {
                Component component = (Component)components.remove();
                if (component instanceof JHelp) {
                    frame.dispose();
                    break block6;
                }
                if (!(component instanceof Container)) continue;
                components.addAll(Arrays.asList(((Container)component).getComponents()));
            }
        }
        try {
            Field declaredField = JHelpPrintHandler.class.getDeclaredField("handlers");
            declaredField.setAccessible(true);
            Map map = (Map)declaredField.get(null);
            if (map != null) {
                map.clear();
            }
        }
        catch (SecurityException e) {
            LogAPI.logSevere((Throwable)e);
        }
        catch (NoSuchFieldException e) {
            LogAPI.logSevere((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LogAPI.logSevere((Throwable)e);
        }
        catch (IllegalAccessException e) {
            LogAPI.logSevere((Throwable)e);
        }
    }

    public static void setFontSize(HTMLDocument htmlDocument, Style style, int fontSize) {
        htmlDocument.getStyleSheet().addCSSAttribute(style, CSS.Attribute.FONT_SIZE, fontSize + "px");
    }

    public static Integer getFontSize(Style style) {
        return HelpUtil.getAttribute(style, CSS.Attribute.FONT_SIZE);
    }

    private static Integer getAttribute(Style style, CSS.Attribute attribute) {
        AttributeSet attrs = style;
        do {
            if (!attrs.isDefined(attribute)) continue;
            Object value = attrs.getAttribute(attribute);
            Matcher matcher = FONTSIZE_PATTERN.matcher(value.toString());
            if (!matcher.matches()) break;
            return Integer.parseInt(matcher.group(1));
        } while ((attrs = attrs.getResolveParent()) != null);
        return null;
    }
}

