/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.ui;

import com.selima.help.ui.HelpUtil;
import com.selima.help.ui.IHelpSetLocator;
import com.selima.help.util.WeakCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.SwingUtilities;

public class HelpInitializer {
    private WeakCollection<HelpLoadedCallBack> weakList = new WeakCollection();
    private Collection<HelpLoadedCallBack> strongList = new HashSet<HelpLoadedCallBack>();
    private IHelpSetLocator helpSetLocator;
    private volatile boolean loaded;
    private HelpBroker helpBroker;
    private Exception exception;

    public HelpInitializer(IHelpSetLocator locator) {
        this.helpSetLocator = locator;
    }

    public void loadHelp(String helpSetPath) {
        try {
            this.setException(null);
            this.setHelpBroker(null);
            HelpSet helpSet = this.helpSetLocator.getHelpSet(helpSetPath);
            if (helpSet == null) {
                throw new HelpSetException("'" + helpSetPath + "' not found");
            }
            this.setHelpBroker(helpSet.createHelpBroker());
        }
        catch (Exception e) {
            this.setException(e);
        }
        this.loaded = true;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WeakCollection weakCollection = HelpInitializer.this.weakList;
                synchronized (weakCollection) {
                    for (HelpLoadedCallBack callback : HelpInitializer.this.join(HelpInitializer.this.weakList, HelpInitializer.this.strongList)) {
                        if (HelpInitializer.this.exception != null) {
                            callback.helpFailed(HelpInitializer.this.getException());
                            continue;
                        }
                        callback.helpLoaded(HelpInitializer.this.getHelpBroker());
                    }
                }
            }
        });
    }

    public void insertHelp(HelpLoadedCallBack callback) {
        this.insertInternal(callback, this.weakList);
    }

    public void insertPermanentHelp(HelpLoadedCallBack callback) {
        this.insertInternal(callback, this.strongList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertInternal(HelpLoadedCallBack callback, Collection<HelpLoadedCallBack> collection) {
        Collection<HelpLoadedCallBack> collection2 = collection;
        synchronized (collection2) {
            collection.add(callback);
            if (!this.loaded) {
                return;
            }
        }
        if (this.getException() != null) {
            callback.helpFailed(this.getException());
        } else {
            callback.helpLoaded(this.getHelpBroker());
        }
    }

    public synchronized HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    protected synchronized void setHelpBroker(HelpBroker helpBroker) {
        this.helpBroker = helpBroker;
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    protected synchronized void setException(Exception e) {
        this.exception = e;
    }

    private <T> Iterable<T> join(Collection<T> collection1, Collection<T> collection2) {
        final ArrayList<T> list = new ArrayList<T>();
        list.addAll(collection1);
        list.addAll(collection2);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return list.iterator();
            }
        };
    }

    static {
        HelpUtil.patchHelpUI();
    }

    public static interface HelpLoadedCallBack {
        public void helpLoaded(HelpBroker var1);

        public void helpFailed(Exception var1);
    }
}

