/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.toc;

import com.selima.help.authoring.ContentLocator;
import com.selima.help.authoring.toc.ITocChapterItem;
import com.selima.help.authoring.toc.ITocInfo;
import com.selima.help.authoring.toc.ITocInfoParser;
import com.selima.help.authoring.toc.ITocItem;
import com.selima.help.authoring.toc.ITocPageItem;
import com.selima.help.authoring.toc.TocChapterItemImpl;
import com.selima.help.authoring.toc.TocFileContentHandler;
import com.selima.help.authoring.toc.TocInfoImpl;
import com.selima.help.authoring.toc.TocPageItemImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class TocInfoParser
implements ITocInfoParser {
    File file;
    ContentLocator locator;
    SAXParserFactory factory;

    TocInfoParser(ContentLocator locator) {
        this.locator = locator;
        URL url = TocInfoImpl.class.getClassLoader().getResource("com/selima/help/authoring/toc.xsd");
        if (url == null) {
            throw new NullPointerException("xml schema not found");
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = schemaFactory.newSchema(url);
            this.factory = SAXParserFactory.newInstance();
            this.factory.setNamespaceAware(false);
            this.factory.setSchema(schema);
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public synchronized ITocInfo parse(File file) throws IOException, SAXException {
        this.file = file;
        TocFileContentHandler handler = new TocFileContentHandler();
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            this.factory.newSAXParser().parse((InputStream)inputStream, (DefaultHandler)handler);
            TocInfoImpl tocInfoImpl = new TocInfoImpl(this.toTocItem(handler.getItem()), this.toTocItems(handler.getContent()));
            return tocInfoImpl;
        }
    }

    List<ITocItem> toTocItems(List<TocFileContentHandler.TocItemStruct> content) throws IOException {
        LinkedList<ITocItem> result = new LinkedList<ITocItem>();
        for (TocFileContentHandler.TocItemStruct struct : content) {
            if (struct instanceof TocFileContentHandler.TocChapterStruct) {
                result.add(this.toTocItem((TocFileContentHandler.TocChapterStruct)struct));
                continue;
            }
            result.add(this.toTocItem((TocFileContentHandler.TocPageStruct)struct));
        }
        return result;
    }

    ITocPageItem toTocItem(TocFileContentHandler.TocPageStruct item) throws IOException {
        return new TocPageItemImpl(item.name, this.helpId(item.file), this.helpId(item.image));
    }

    ITocChapterItem toTocItem(TocFileContentHandler.TocChapterStruct item) throws IOException {
        File target = new File(this.file.getParentFile(), item.outline);
        target = target.getCanonicalFile();
        return new TocChapterItemImpl(target);
    }

    String helpId(String path) throws IOException {
        if (path == null) {
            return null;
        }
        File target = new File(this.file.getParentFile(), path);
        return this.locator.getHelpId(target);
    }
}

