/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.index;

import java.util.HashMap;

class Term {
    String text;
    String[] parts;
    static HashMap<Character, Character> normativeFormMap = new HashMap();
    static HashMap<String, HashMap<String, Integer>> wordDiffMap = new HashMap();

    Term(String text) {
        this.text = text;
        this.parts = text.split("\\s");
        if (this.parts.length == 0) {
            throw new IllegalArgumentException("Wrong phrase '" + text + "'");
        }
    }

    double difference(Term other) {
        return Term.termDifference(this.parts, other.parts);
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Term) {
            return this.text.equals(((Term)other).text);
        }
        return false;
    }

    public boolean equalsIgnoreCase(Object other) {
        if (other instanceof Term) {
            return this.text.equalsIgnoreCase(((Term)other).text);
        }
        return false;
    }

    public String toString() {
        return "'" + this.text + "'";
    }

    static double termDifference(String[] term1, String[] term2) {
        int[] indexes;
        String[] shorterTerm;
        String[] longerTerm;
        if (term1.length > term2.length) {
            longerTerm = term1;
            shorterTerm = term2;
        } else {
            longerTerm = term2;
            shorterTerm = term1;
        }
        double result = Double.MAX_VALUE;
        class OrderedCombination {
            int n;
            int k;
            int[] combination;

            OrderedCombination(int n, int k) {
                this.n = n;
                this.k = k;
            }

            int[] next() {
                if (this.combination == null) {
                    this.combination = new int[this.k];
                    for (int i = 0; i < this.k; ++i) {
                        this.combination[i] = i;
                    }
                    return this.combination;
                }
                for (int i = this.k - 1; i >= 0; --i) {
                    if (!this.canMoveIndex(i)) continue;
                    this.moveIndex(i);
                    return this.combination;
                }
                return null;
            }

            private boolean canMoveIndex(int pivot) {
                return this.n - this.combination[pivot] > this.combination.length - pivot;
            }

            private void moveIndex(int pivot) {
                int value = this.combination[pivot] + 1;
                for (int i = pivot; i < this.k; ++i) {
                    this.combination[i] = value++;
                }
            }
        }
        OrderedCombination combination = new OrderedCombination(longerTerm.length, shorterTerm.length);
        while ((indexes = combination.next()) != null) {
            int value = 0;
            for (int i = 0; i < indexes.length; ++i) {
                value += Term.cachedWordDifference(shorterTerm[i], longerTerm[indexes[i]]);
            }
            if (!((double)value < result)) continue;
            result = value;
        }
        return 4.0 * result / (double)(longerTerm.length + shorterTerm.length) + (double)(longerTerm.length / shorterTerm.length - 1);
    }

    static int cachedWordDifference(String word1, String word2) {
        Integer result;
        String shorterWord;
        String longerWord;
        word1 = word1.toUpperCase();
        word2 = word2.toUpperCase();
        if (word1.length() > word2.length()) {
            longerWord = word1;
            shorterWord = word2;
        } else {
            longerWord = word2;
            shorterWord = word1;
        }
        HashMap<String, Integer> map = wordDiffMap.get(shorterWord);
        if (map == null) {
            map = new HashMap();
            wordDiffMap.put(shorterWord, map);
        }
        if ((result = map.get(longerWord)) == null) {
            result = Term.wordDifference(longerWord, shorterWord);
            map.put(longerWord, result);
        }
        return result;
    }

    static double uncachedWordDifference(String word1, String word2) {
        String shorterWord;
        String longerWord;
        word1 = word1.toUpperCase();
        word2 = word2.toUpperCase();
        if (word1.length() > word2.length()) {
            longerWord = word1;
            shorterWord = word2;
        } else {
            longerWord = word2;
            shorterWord = word1;
        }
        return Term.wordDifference(longerWord, shorterWord);
    }

    static int wordDifference(String s, String t) {
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        int i = 0;
        while (i <= n) {
            d[i][0] = i++;
        }
        int j = 1;
        while (j <= m) {
            d[0][j] = j++;
        }
        for (i = 1; i <= n; ++i) {
            char sc = s.charAt(i - 1);
            for (int j2 = 1; j2 <= m; ++j2) {
                int v = d[i - 1][j2 - 1];
                if (t.charAt(j2 - 1) != sc) {
                    ++v;
                }
                d[i][j2] = Math.min(Math.min(d[i - 1][j2] + 1, d[i][j2 - 1] + 1), v);
            }
        }
        return d[n][m];
    }
}

