/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.index;

import com.selima.help.authoring.AuthoringException;
import com.selima.help.authoring.index.JavaHelpEntityResolver;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MapInfo {
    private Map<String, String> toURLMap = new HashMap<String, String>();

    MapInfo(File mapFile, String fileTypes) throws AuthoringException {
        try {
            this.parse(mapFile, fileTypes);
        }
        catch (IOException e) {
            throw new AuthoringException(e);
        }
        catch (ParserConfigurationException e) {
            throw new AuthoringException(e);
        }
        catch (SAXException e) {
            throw new AuthoringException(e);
        }
    }

    String[] helpIds() {
        return this.toURLMap.keySet().toArray(new String[this.toURLMap.size()]);
    }

    String getFilePath(String helpid) {
        return this.toURLMap.get(helpid);
    }

    private void parse(File mapFile, String fileTypes) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        parser.parse(mapFile, (DefaultHandler)new MapContentHandler(fileTypes.split(",")));
    }

    class MapContentHandler
    extends DefaultHandler {
        private String[] extensions;

        MapContentHandler(String[] extensions) {
            Arrays.sort(extensions);
            this.extensions = extensions;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            try {
                return JavaHelpEntityResolver.getInstance().resolveEntity(publicId, systemId);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("mapID".equals(qName)) {
                String target = attributes.getValue("target");
                String url = attributes.getValue("url");
                if (this.accepted(url)) {
                    MapInfo.this.toURLMap.put(target, url);
                }
            }
        }

        private boolean accepted(String url) {
            boolean result = Arrays.binarySearch(this.extensions, url.substring(url.lastIndexOf(46) + 1)) >= 0;
            return result;
        }
    }
}

