/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.index;

import com.selima.framework.util.logging.LogAPI;
import com.selima.help.authoring.AuthoringException;
import com.selima.help.authoring.index.IndexEntry;
import com.selima.help.authoring.index.SeparateLogger;
import com.selima.help.authoring.index.TermGroup;
import com.selima.help.authoring.index.TermGroupList;
import java.util.SortedSet;
import java.util.logging.Level;

class IndexingAlgorithm {
    TermGroupList termGroupList = new TermGroupList();
    static Double DIFFERENCE_LIMIT = 1.1;

    IndexingAlgorithm() {
    }

    public void add(String term, String helpId) {
        this.termGroupList.add(new TermGroup(term, helpId));
    }

    public SortedSet<IndexEntry> process(int indexSize) throws AuthoringException {
        int entryCount;
        LogAPI.logInfo((String)("Indexing started with " + this.termGroupList.statistic()));
        while ((entryCount = this.termGroupList.entryCount()) > indexSize) {
            Double d;
            Double difference = this.termGroupList.minimumDifference();
            if (!(d < DIFFERENCE_LIMIT)) break;
            this.termGroupList.collapseMostSimilarGroups();
        }
        LogAPI.logInfo((String)("Similarity filter reduced number of phrases to " + this.termGroupList.statistic()));
        SeparateLogger.getInstance().log(Level.INFO, "Merging results:\n{0}", this.termGroupList);
        this.termGroupList.filterNonFrequentWords(2, 20);
        LogAPI.logInfo((String)("Non-frequent words filter reduced number of phrases to " + this.termGroupList.statistic()));
        while ((entryCount = this.termGroupList.entryCount()) > indexSize) {
            this.termGroupList.removeLightestGroup();
        }
        LogAPI.logInfo((String)("Term weight filter reduced number of phrases to " + this.termGroupList.statistic()));
        return this.termGroupList.getEntries();
    }
}

