/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring.fulltext;

import com.selima.framework.util.Util;
import com.selima.help.authoring.AuthoringException;
import com.sun.java.help.search.HTMLIndexerKit;
import com.sun.java.help.search.Indexer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Locale;
import javax.help.search.ConfigFile;
import javax.help.search.IndexBuilder;
import javax.help.search.IndexerKit;

public class FulltextGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFulltext(File htmlRoot) throws AuthoringException {
        File file = new File("fulltext.cfg");
        try {
            try (PrintWriter printer = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
                printer.print("IndexRemove ");
                printer.println(htmlRoot.getCanonicalFile().getParent().replace(File.separatorChar, '/') + '/');
                this.addFileList(printer, htmlRoot);
            }
            File dbFile = new File(htmlRoot.getParentFile(), "JavaHelpSearch");
            Util.makeDir((File)dbFile);
            String[] args = new String[]{"-locale", "en_UK", "-c", file.getName(), "-db", dbFile.getPath()};
            Indexer indexer = new Indexer();
            indexer.compile(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AuthoringException(e);
        }
        finally {
            System.gc();
            System.runFinalization();
            file.delete();
        }
    }

    private void addFileList(PrintWriter printer, File dir) throws IOException {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() || pathname.getName().endsWith(".html");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addFileList(printer, files[i]);
                continue;
            }
            printer.print("File ");
            printer.println(files[i].getCanonicalPath().replace(File.separatorChar, '/'));
        }
    }

    public static void main(String[] args) throws AuthoringException {
        new FulltextGenerator().generateFulltext(new File("doc"));
    }

    static {
        Indexer.registerIndexerKitForContentType((String)"text/html", (String)PatchedHTMLIndexerKit.class.getName(), (ClassLoader)FulltextGenerator.class.getClassLoader());
    }

    public static class PatchedHTMLIndexerKit
    extends HTMLIndexerKit {
        static ThreadLocal<IndexerKit> kitRef = new ThreadLocal();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void parse(Reader reader, String s, boolean flag, IndexBuilder indexbuilder, ConfigFile configfile) throws IOException {
            kitRef.set((IndexerKit)this);
            try {
                super.parse(reader, s, flag, indexbuilder, configfile);
            }
            finally {
                reader.close();
            }
        }

        public Object clone() {
            return new PatchedHTMLIndexerKit();
        }

        public HTMLIndexerKit.HTMLParserCallback getParserCallback(IndexerKit indexerkit) {
            return new HTMLIndexerKit.HTMLParserCallback((HTMLIndexerKit)this, new IndexerKit(){

                public Locale getLocale() {
                    IndexerKit kit = kitRef.get();
                    return kit.getLocale();
                }

                public void setLocale(Locale locale1) {
                    IndexerKit kit = kitRef.get();
                    kit.setLocale(locale1);
                }

                public void setLocale(String s) {
                    IndexerKit kit = kitRef.get();
                    kit.setLocale(s);
                }

                public Object clone() {
                    throw new UnsupportedOperationException();
                }

                protected void endStoreDocument() throws Exception {
                    throw new UnsupportedOperationException();
                }

                public String getContentType() {
                    IndexerKit kit = kitRef.get();
                    return kit.getContentType();
                }

                public void parse(Reader reader, String s, boolean flag, IndexBuilder indexbuilder, ConfigFile configfile) throws IOException {
                    IndexerKit kit = kitRef.get();
                    kit.parse(reader, s, flag, indexbuilder, configfile);
                }

                public int parseIntoTokens(String s, int i) {
                    IndexerKit kit = kitRef.get();
                    return kit.parseIntoTokens(s, i);
                }

                protected void startStoreDocument(String s) throws Exception {
                    throw new UnsupportedOperationException();
                }

                protected void storeTitle(String s) throws Exception {
                    throw new UnsupportedOperationException();
                }

                protected void storeToken(String s, int i) throws Exception {
                    throw new UnsupportedOperationException();
                }
            });
        }
    }
}

