/*
 * Decompiled with CFR 0.152.
 */
package com.selima.help.authoring;

import java.io.File;
import java.io.IOException;

public class ContentLocator {
    private String dirPrefix;

    public ContentLocator(File htmlRoot) throws IOException {
        this.dirPrefix = htmlRoot.getCanonicalFile().getParent();
    }

    public String getHelpId(File file) throws IOException {
        String result = this.getURL(file);
        if (result.lastIndexOf(46) != -1) {
            result = result.substring(0, result.lastIndexOf(46));
        }
        result = result.replace('/', '.');
        return result;
    }

    public String getURL(File file) throws IOException {
        String result = file.getCanonicalPath().substring(this.dirPrefix.length() + 1);
        if (File.separatorChar != '/') {
            result = result.replace(File.separatorChar, '/');
        }
        return result;
    }

    public static String formatAnchor(String anchor) {
        return anchor.replace(':', '.');
    }

    public String getHelpId(File file, String anchor) throws IOException {
        return this.getHelpId(file) + "#" + ContentLocator.formatAnchor(anchor);
    }

    public String getURL(File file, String anchor) throws IOException {
        return this.getURL(file) + "#" + ContentLocator.formatAnchor(anchor);
    }

    public boolean isAnchorHelpId(String helpId) {
        return helpId.lastIndexOf(35) != -1;
    }
}

